/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TETL1GenCfgCmdFactory {
    private static TETL1GenCfgCmdFactory instance = null;
    private HashMap funCmdMap = null;
    private HashMap tl1CmdMap = new HashMap();

    private TETL1GenCfgCmdFactory() {
    }

    public static synchronized TETL1GenCfgCmdFactory getInstance() {
        if (null == instance) {
            instance = new TETL1GenCfgCmdFactory();
        }
        return instance;
    }

    public TETL1GenCfgFunCmd getFunCmd(String path) {
        TETL1GenCfgFunCmd funCmd = null;
        if (null == this.funCmdMap) {
            this.funCmdMap = new HashMap();
        }
        if (null == (funCmd = (TETL1GenCfgFunCmd)this.funCmdMap.get(path)) && null != (funCmd = this.parseGenCfgCmdXML(path))) {
            this.funCmdMap.put(path, funCmd);
        }
        return funCmd;
    }

    public String getTL1DescMod2(String mod2) {
        String _mod2 = (String)this.tl1CmdMap.get(mod2);
        if (_mod2 == null) {
            return mod2;
        }
        return _mod2;
    }

    private TETL1GenCfgFunCmd parseGenCfgCmdXML(String path) {
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.tl1ngwdm", path);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse file is error,bundle name is com.huawei.weblct.tl1ngwdm, file name is " + path);
        }
        if (null == doc) {
            return null;
        }
        TETL1GenCfgFunCmd obj = new TETL1GenCfgFunCmd();
        NodeList nodelist = doc.getElementsByTagName("group_define");
        HashMap groupMap = new HashMap();
        HashMap modifierMap = new HashMap();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            this.handleGroupNode(nodelist.item(i), groupMap, modifierMap);
        }
        nodelist = doc.getElementsByTagName("attr_rspparaname");
        HashMap paramMap = new HashMap();
        int len2 = nodelist.getLength();
        for (int i = 0; i < len2; ++i) {
            this.handleParamPair(nodelist.item(i), paramMap);
        }
        obj.setParamMap(paramMap);
        nodelist = doc.getElementsByTagName("action");
        Element action = null;
        ArrayList qxlist = null;
        String actionName = "";
        int len3 = nodelist.getLength();
        for (int i = 0; i < len3; ++i) {
            action = (Element)nodelist.item(i);
            actionName = action.getAttribute("name");
            qxlist = this.handleActionNode(action, groupMap, modifierMap);
            if (null == qxlist) continue;
            if (actionName.equalsIgnoreCase("QueryFromNE")) {
                obj.setQueryTL1List(qxlist);
                continue;
            }
            if (!actionName.equalsIgnoreCase("SET")) continue;
            obj.setSetTL1List(qxlist);
        }
        return obj;
    }

    private void handleGroupNode(Node groupNode, HashMap groupMap, HashMap modifierMap) {
        NodeList itemNodeList = ((Element)groupNode).getElementsByTagName("item");
        Element itemEle = null;
        Integer groupId = null;
        ArrayList groupAttrList = null;
        ArrayList modifierAttrList = null;
        int len = itemNodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String mode2;
            itemEle = (Element)itemNodeList.item(i);
            groupId = Integer.valueOf(itemEle.getAttribute("groupID"));
            groupAttrList = TEParseXMLFile.splitFromChar(itemEle.getAttribute("attrID"), ',');
            if (null != groupAttrList) {
                groupMap.put(groupId, groupAttrList);
            }
            if (null != (modifierAttrList = TEParseXMLFile.splitFromChar(itemEle.getAttribute("modifierList"), ','))) {
                modifierMap.put(groupId, modifierAttrList);
            }
            if ((mode2 = itemEle.getAttribute("mode2")) == null) continue;
            int size = modifierAttrList.size();
            for (int j = 0; j < size; ++j) {
                String modifier = (String)modifierAttrList.get(j);
                String tempMod2 = (String)this.tl1CmdMap.get(modifier);
                if (tempMod2 != null || mode2.equals("")) continue;
                this.tl1CmdMap.put(modifier, mode2);
            }
        }
    }

    private void handleParamPair(Node paramNode, HashMap paramMap) {
        NodeList itemNodeList = ((Element)paramNode).getElementsByTagName("item");
        Element itemEle = null;
        String attrID = null;
        String paraName = null;
        int len = itemNodeList.getLength();
        for (int i = 0; i < len; ++i) {
            itemEle = (Element)itemNodeList.item(i);
            attrID = itemEle.getAttribute("attrID");
            paraName = itemEle.getAttribute("paraname");
            paramMap.put(paraName, attrID);
        }
    }

    private ArrayList handleActionNode(Element action, HashMap groupMap, HashMap modifierMap) {
        ArrayList<TETL1GenCfgFunAttr> attrList = new ArrayList<TETL1GenCfgFunAttr>();
        NodeList nodelist = action.getElementsByTagName("attr");
        NodeList cmdlist = null;
        NodeList tmp = null;
        Element attrElement = null;
        TETL1GenCfgFunAttr funAttr = null;
        Integer groupId = null;
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            attrElement = (Element)nodelist.item(i);
            cmdlist = attrElement.getElementsByTagName("tl1_req_cmd_param");
            if (cmdlist.getLength() <= 0) continue;
            funAttr = new TETL1GenCfgFunAttr();
            funAttr.setAttrId(attrElement.getAttribute("id"));
            tmp = attrElement.getElementsByTagName("tl1cmdcode");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setTl1cmdcode("");
            } else {
                funAttr.setTl1cmdcode(((Element)tmp.item(0)).getAttribute("cmdcode"));
            }
            tmp = attrElement.getElementsByTagName("object_type");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setObjectType("");
            } else {
                funAttr.setObjectType(((Element)tmp.item(0)).getAttribute("id"));
            }
            tmp = attrElement.getElementsByTagName("modifier");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setMod("");
            } else if (((Element)tmp.item(0)).getAttribute("type").equals("ID_VALUE")) {
                funAttr.setMod(((Element)tmp.item(0)).getAttribute("value"));
            } else {
                funAttr.setMod("mod2");
            }
            tmp = attrElement.getElementsByTagName("recordGroup");
            if (null != tmp && tmp.getLength() != 0) {
                groupId = Integer.valueOf(((Element)tmp.item(0)).getAttribute("groupID"));
                funAttr.setGroupAttrList((ArrayList)groupMap.get(groupId));
                funAttr.setModifierList((ArrayList)modifierMap.get(groupId));
            }
            attrList.add(funAttr);
        }
        return attrList;
    }

    public static void main(String[] args) {
        String path = "D:\\Code\\WebLCT_R8View\\NGLCT_VOB\\NG_LCT\\nemgr\\tl1ngwdm\\conf\\gencfg\\wdminterfacetl1.xml";
        TETL1GenCfgCmdFactory.getInstance().getFunCmd(path);
    }
}

