/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.gencfg.frame.attrvaluernge.TEGnlAttrRangeMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import org.slf4j.Logger;

public class TETL1GenCfgAttrBean
implements TENEMgrInterface {
    protected Datainterface outputData = null;
    private Logger log = TELogFactory.getNormalLogger();

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        ArrayList supportAttrList = new ArrayList();
        Vector<TEBoard> boardList = new Vector<TEBoard>();
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null != neObj) {
            int neType = neObj.getNEType();
            String neVersion = neObj.getShowNEVersion();
            TELogFactory.getNormalLogger().debug("Get Support GenCfg AttrList,The neType=" + neType + " neVersion=" + neVersion);
            XMLEquipmentInfo equipInfo = new XMLEquipmentInfo();
            equipInfo.m_neID = neid;
            equipInfo.m_neType = TEGetNEDomainVersion.getInstance().getDevType(neType);
            equipInfo.m_neVer = Integer.parseInt(neVersion.replace(".", ""));
            TEBoard boardObj = null;
            TEGenCfgModel genCfgModel = null;
            Param slotidParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "slotid");
            Param boardTypeParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "boardType");
            int slotid = 0;
            int boardType = 0;
            if (null != slotidParam && boardTypeParam != null) {
                try {
                    slotid = Integer.parseInt(slotidParam.getValue());
                    boardType = Integer.parseInt(boardTypeParam.getValue());
                }
                catch (NumberFormatException e) {
                    slotid = 0;
                    boardType = 0;
                }
            }
            if (slotid < 1 || boardType < 1) {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596479));
                return this.outputData;
            }
            TEBoard board = neObj.getBoard(slotid);
            if (board == null || board.getBoardType() != boardType) {
                if (board == null) {
                    TELogFactory.getNormalLogger().debug("Board is Null.");
                } else {
                    TELogFactory.getNormalLogger().debug("boardType = " + board.getBoardType());
                }
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596479));
                return this.outputData;
            }
            boardList.add(board);
            ArrayList supportAttrLis = null;
            int len = boardList.size();
            for (int i = 0; i < len; ++i) {
                boardObj = (TEBoard)boardList.get(i);
                if (null != boardObj) {
                    genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType());
                    if (null == genCfgModel || null == (supportAttrLis = genCfgModel.getSupportAttrList(neType, neVersion)) || supportAttrLis.isEmpty()) continue;
                    supportAttrList.addAll(supportAttrLis);
                    continue;
                }
                this.log.error("board object not exist!");
            }
            this.convertToOutPutData(supportAttrList, boardList, equipInfo);
        } else {
            this.log.error("NE object not exist!");
        }
        return this.outputData;
    }

    public void convertToOutPutData(ArrayList supportAttrList, Vector boardList, XMLEquipmentInfo equipInfo) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        if (null == supportAttrList) {
            return;
        }
        TEGnlVar varInstance = TEGnlVar.getInstance();
        TEGnlAttrMgr gnlAttrMgr = TEGnlAttrMgr.getInstance();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowparams = null;
        TEGenCfgAttribute genCfgAttrObj = null;
        String attrId = null;
        String attrAccess = null;
        ArrayList domain_list = null;
        HashSet<String> attrSet = new HashSet<String>();
        int len = supportAttrList.size();
        for (int i = 0; i < len; ++i) {
            int attrAcc;
            rowparams = new RowParams();
            genCfgAttrObj = (TEGenCfgAttribute)supportAttrList.get(i);
            attrId = genCfgAttrObj.getAttrId();
            int attrIntId = varInstance.getGnlVar(attrId);
            if (attrIntId != -1 && attrIntId != 0 && 2 == (attrAcc = gnlAttrMgr.getAttrAccess(attrIntId, equipInfo)) || attrSet.contains(attrId)) continue;
            attrSet.add(attrId);
            attrAccess = genCfgAttrObj.getAccType();
            domain_list = genCfgAttrObj.getDomainList();
            rowparams.addParam("attrId", attrId);
            rowparams.addParam("attrAccess", attrAccess);
            Param param = new Param("domain_list", "");
            if (null != domain_list) {
                int size = domain_list.size();
                for (int index = 0; index < size; ++index) {
                    param.addOption(new Option(((Integer)domain_list.get(index)).toString()));
                }
            }
            rowparams.addParam(param);
            rowparams.addParam("attrRange", TEGnlAttrRangeMgr.getInstance().getAttrRangeJSON(equipInfo.m_neID, attrId, boardList));
            if (null != genCfgAttrObj.getMinvalue()) {
                param = new Param("minValue", genCfgAttrObj.getMinvalue());
                rowparams.addParam(param);
                param = new Param("maxValue", genCfgAttrObj.getMaxvalue());
                rowparams.addParam(param);
            }
            rowparams.addParam(param);
            bussinessParams.addRowParams(rowparams);
        }
        this.outputData.setBussinessParams(bussinessParams);
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }
}

