/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame.dao;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.po.TEBoardAttrib;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.po.TEPortAttrib;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEGnlCfgDao {
    private static final String OPERATION_SUCCESS = "0";

    public static int updateObjAttr(int neid, Map<TEGenKey, TEGenValue> result) {
        if (result == null || result.isEmpty()) {
            return 0;
        }
        List oldData = TEGnlCfgDao.getAllBoardData(neid);
        Iterator<Map.Entry<TEGenKey, TEGenValue>> iter = result.entrySet().iterator();
        Map.Entry<TEGenKey, TEGenValue> entry = null;
        TEGenValue value = null;
        while (iter.hasNext()) {
            entry = iter.next();
            value = entry.getValue();
            TEOmniAttrib attrPO = TEGnlCfgDao.getPO(entry);
            if (attrPO == null) continue;
            if (!value.bValid || value.errCode != 0) {
                if (oldData.contains(attrPO)) continue;
                TEGnlCfgDao.saveOneAttr(attrPO);
                continue;
            }
            if (oldData.contains(attrPO)) {
                TEGnlCfgDao.delOneAttr(attrPO);
                TEGnlCfgDao.saveOneAttr(attrPO);
                continue;
            }
            TEGnlCfgDao.saveOneAttr(attrPO);
        }
        return 0;
    }

    public static void saveOneAttr(TEOmniAttrib attrPO) {
        try {
            CommonDaoService.save(attrPO);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.saveOneAttr() fail!", (Throwable)e);
        }
    }

    public static void delOneAttr(TEOmniAttrib attrPO) {
        try {
            CommonDaoService.delete(attrPO);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.delOneAttr() fail!", (Throwable)e);
        }
    }

    public static void deleteOldData(int neid) {
        String boardHql = "delete TEBoardAttrib where cLogicNeId=:cLogicNeId";
        String portHql = "delete TEPortAttrib where cLogicNeId=:cLogicNeId";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        try {
            CommonDaoService.deleteByHql(boardHql, map);
            CommonDaoService.deleteByHql(portHql, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.deleteOldData() fail!", (Throwable)e);
        }
    }

    public static List getAllBoardData(int neid) {
        String boardHql = "from TEBoardAttrib where cLogicNeId=:cLogicNeId";
        String portHql = "from TEPortAttrib where cLogicNeId=:cLogicNeId";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        try {
            List boardDataList = CommonDaoService.getListByHql(boardHql, map);
            List portDataList = CommonDaoService.getListByHql(portHql, map);
            boardDataList.addAll(portDataList);
            return boardDataList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.getAllBoardData() fail!", (Throwable)e);
            return null;
        }
    }

    public static List getAllPortData(int neid, int slotid) {
        String boardHql = "from TEBoardAttrib where cLogicNeId=:cLogicNeId and cSlotID=:cSlotID";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        map.put("cSlotID", slotid);
        try {
            return CommonDaoService.getListByHql(boardHql, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.getAllPortData() fail!", (Throwable)e);
            return null;
        }
    }

    public static List getOneAttr(int neid, int slotid, int port, int path, int attrID) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("cLogicNeId", neid);
        map.put("cSlotID", slotid);
        map.put("cAttribID", attrID);
        String hqlStr = "";
        if (port == -1) {
            hqlStr = "from TEBoardAttrib where cLogicNeId=:cLogicNeId and cSlotID=:cSlotID and cAttribID=:cAttribID";
        } else {
            map.put("cPortNo", port);
            hqlStr = "from TEPortAttrib where cLogicNeId=:cLogicNeId and cSlotID=:cSlotID and cPortNo=:cPortNo and cAttribID=:cAttribID";
            if (path != -1) {
                map.put("cIndex1", path);
                hqlStr = "from TEPortAttrib where cLogicNeId=:cLogicNeId and cSlotID=:cSlotID and cPortNo=:cPortNo and cIndex1=:cIndex1 and cAttribID=:cAttribID";
            }
        }
        try {
            return CommonDaoService.getListByHql(hqlStr, map);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.getOneAttr() fail!", (Throwable)e);
            return null;
        }
    }

    public static void updateOneAttr(TEOmniAttrib obj) {
        try {
            CommonDaoService.update(obj);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlCfgDao.updateOneAttr() fail!", (Throwable)e);
        }
    }

    public static TEOmniAttrib getPO(Map.Entry<TEGenKey, TEGenValue> entry) {
        TEGenKey key = entry.getKey();
        TEGenValue value = entry.getValue();
        TEObjectID objectID = key.objectID;
        int objType = objectID.getObjType();
        int neid = objectID.getNeId();
        int slotid = objectID.getSlotId();
        int port = objectID.getPortId();
        int path = objectID.getPathId();
        int attribId = key.attrID;
        port = TEConfigurationDataMgr.getAbsolutPort(1, port);
        return TEGnlCfgDao.getPO(neid, slotid, port, path, attribId, objType, value.sValue);
    }

    public static TEOmniAttrib getPO(int neid, int slotid, int port, int path, int attribId, int objType, String attrVlaue) {
        TEOmniAttrib attrPO = null;
        switch (objType) {
            case 61442: {
                attrPO = new TEBoardAttrib();
                attrPO.setAttribId(attribId);
                ((TEBoardAttrib)attrPO).setSlotId(slotid);
                break;
            }
            case 61443: {
                attrPO = new TEPortAttrib();
                attrPO.setAttribId(attribId);
                ((TEPortAttrib)attrPO).setSlotId(slotid);
                ((TEPortAttrib)attrPO).setPortNo(port);
                break;
            }
            case 61445: 
            case 61446: 
            case 61447: {
                attrPO = new TEPortAttrib();
                attrPO.setAttribId(attribId);
                ((TEPortAttrib)attrPO).setSlotId(slotid);
                ((TEPortAttrib)attrPO).setPortNo(port);
                attrPO.setIndex1(path);
                break;
            }
            default: {
                return null;
            }
        }
        attrPO.setLogicNeId(neid);
        attrPO.setValue(attrVlaue);
        return attrPO;
    }

    private static void getAttrEntry(Part[] partAttr) {
    }
}

