/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame.attrvaluernge;

import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.attrvaluernge.AttrValueRangeConditions;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.ArrayList;
import java.util.List;

public class TEGnlAttrRangeMgr {
    private static TEGnlAttrRangeMgr instance;
    private final List<String> NOSUPPORTJSON = new ArrayList<String>();

    private TEGnlAttrRangeMgr() {
        this.NOSUPPORTJSON.add("W32PORT_ATTR_ST_SERVICETYPE");
        this.NOSUPPORTJSON.add("SERIVCE_TYPE");
        this.NOSUPPORTJSON.add("DWDMTL1_ATTRPORT_CLNTPLDTYPE");
        this.NOSUPPORTJSON.add("DWDMTL1_ATTRPORT_PLDTYPE");
        this.NOSUPPORTJSON.add("DWDMTL1_ATTRPORT_CLIENTPRO");
    }

    public static synchronized TEGnlAttrRangeMgr getInstance() {
        if (instance == null) {
            instance = new TEGnlAttrRangeMgr();
        }
        return instance;
    }

    public boolean isContainAttrID(String attrID) {
        List<AttrValueRangeConditions> conditions = TEGnlAttrMgr.getInstance().getAttrValueRangeConditions(attrID);
        return conditions != null && !conditions.isEmpty();
    }

    public List getAttrValueRage(String attrID, MatchData data) {
        List<AttrValueRangeConditions> attrValueRangeConditions = TEGnlAttrMgr.getInstance().getAttrValueRangeConditions(attrID);
        if (attrValueRangeConditions != null) {
            int length = attrValueRangeConditions.size();
            for (int i = 0; i < length; ++i) {
                if (!attrValueRangeConditions.get(i).isMatchCondition(data) || attrValueRangeConditions.get(i).getValueType() != 0) continue;
                return attrValueRangeConditions.get(i).getAttrValueRange();
            }
        }
        return null;
    }

    public AttrValueRangeConditions getAttrValueRageCondition(String attrID, MatchData data) {
        List<AttrValueRangeConditions> attrValueRangeConditions = TEGnlAttrMgr.getInstance().getAttrValueRangeConditions(attrID);
        if (attrValueRangeConditions != null) {
            int length = attrValueRangeConditions.size();
            for (int i = 0; i < length; ++i) {
                if (!attrValueRangeConditions.get(i).isMatchCondition(data)) continue;
                return attrValueRangeConditions.get(i);
            }
        }
        return null;
    }

    public List<Integer> getAttrValueRageByList(String attrID, MatchData data) {
        List intList = this.getAttrValueRage(attrID, data);
        if (intList == null) {
            return null;
        }
        int length = intList.size();
        ArrayList<Integer> list = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            try {
                list.add(Integer.valueOf((String)intList.get(i)));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return list;
    }

    public String getAttrRangeJSON(String neversion, int neType, int shelfType, String attrId, List<TEBoard> boardlist) {
        if (this.NOSUPPORTJSON.contains(attrId)) {
            return "";
        }
        String js = "";
        boolean isContain = TEGnlAttrRangeMgr.getInstance().isContainAttrID(attrId);
        if (isContain) {
            long version = Long.parseLong(neversion.replace(".", ""));
            TEBoard board = null;
            MatchData data = null;
            StringBuffer sb = new StringBuffer();
            String temp = "";
            int len = boardlist.size();
            for (int i = 0; i < len; ++i) {
                board = boardlist.get(i);
                data = new MatchData();
                data.setBoardType(board.getBoardType());
                data.setNeType(neType);
                data.setShelfType(shelfType);
                data.setNeVersion(version);
                temp = this.getAttrBoardRangeJSON(attrId, data, board.getSlotID());
                if (temp == null || temp.equals("")) continue;
                sb.append(temp).append(',');
            }
            if (sb.length() > 0) {
                js = "[" + sb.substring(0, sb.length() - 1) + "]";
            }
        }
        return js;
    }

    public String getAttrRangeJSON(int neID, String attrId, List<TEBoard> boardlist) {
        if (this.NOSUPPORTJSON.contains(attrId)) {
            return "";
        }
        String js = "";
        boolean isContain = TEGnlAttrRangeMgr.getInstance().isContainAttrID(attrId);
        if (isContain) {
            TENE neObj = TENEListMgr.getInstance().getNE(neID);
            long version = Long.parseLong(neObj.getHostVersion().replace(".", ""));
            int neType = TEGetNEDomainVersion.getInstance().getDevType(neObj.getNEType());
            TEBoard board = null;
            MatchData data = null;
            StringBuffer sb = new StringBuffer();
            String temp = "";
            int len = boardlist.size();
            for (int i = 0; i < len; ++i) {
                board = boardlist.get(i);
                data = new MatchData();
                data.setBoardType(board.getBoardType());
                data.setNeType(neType);
                data.setShelfType(neObj.getShelfType());
                data.setNeVersion(version);
                data.addMacthParam("boardmode", String.valueOf(board.getBoardMode()));
                temp = this.getAttrBoardRangeJSON(attrId, data, board.getSlotID());
                if (temp == null || temp.equals("")) continue;
                sb.append(temp).append(',');
            }
            if (sb.length() > 0) {
                js = "[" + sb.substring(0, sb.length() - 1) + "]";
            }
        }
        return js;
    }

    private String getAttrBoardRangeJSON(String attrID, MatchData data, int slotid) {
        String js = "";
        List<AttrValueRangeConditions> attrValueRangeConditions = TEGnlAttrMgr.getInstance().getAttrValueRangeConditions(attrID);
        if (attrValueRangeConditions != null) {
            StringBuilder jsSb = new StringBuilder("");
            AttrValueRangeConditions attrValue = null;
            String temp = "";
            int length = attrValueRangeConditions.size();
            for (int i = 0; i < length; ++i) {
                attrValue = attrValueRangeConditions.get(i);
                if (!attrValue.isMatchCondition(data)) continue;
                jsSb.append("{\"slotid\":").append(slotid);
                temp = attrValue.getConditionJSON();
                if (temp != null && !temp.equals("")) {
                    jsSb.append(',').append(temp);
                }
                if ((temp = attrValue.getRangeJSON()) != null && !temp.equals("")) {
                    jsSb.append(',').append(temp);
                }
                jsSb.append("},");
            }
            js = jsSb.toString();
            if (js.length() > 0) {
                js = js.substring(0, js.length() - 1);
            }
        }
        return js;
    }
}

