/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame.attrvaluernge;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.gencfg.frame.attrvaluernge.ConditionInterface;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import gnu.trove.TIntArrayList;

public class PortAndPathCondition
implements ConditionInterface {
    private TIntArrayList supportPortList = new TIntArrayList();
    private TIntArrayList supportPathList = new TIntArrayList();

    @Override
    public boolean isMatchCondition(MatchData matchData) {
        if (matchData.isAnyPort() || this.supportPortList.isEmpty()) {
            return true;
        }
        if (this.supportPortList.contains(matchData.getPortid())) {
            if (matchData.isAnyPath() || this.supportPathList.isEmpty()) {
                return true;
            }
            return this.supportPathList.contains(matchData.getPathid());
        }
        return false;
    }

    public void setSupportPort(String portListStr) {
        SDXMLInterpreterMgr.getInstance().parseIntList(portListStr, this.supportPortList);
    }

    public void setSupportpatch(String pathListStr) {
        SDXMLInterpreterMgr.getInstance().parseIntList(pathListStr, this.supportPathList);
    }

    public String toString() {
        return "Support port condition=" + this.supportPortList.toString() + " path condition=" + this.supportPathList.toString();
    }

    @Override
    public String getJSON() {
        int i;
        int len;
        StringBuilder portList;
        String js = "";
        if (!this.supportPortList.isEmpty()) {
            js = "\"port\":[";
            portList = new StringBuilder("");
            len = this.supportPortList.size();
            for (i = 0; i < len; ++i) {
                portList.append(this.supportPortList.get(i)).append(',');
            }
            js = js + portList.substring(0, portList.length() - 1) + "]";
        }
        if (!this.supportPathList.isEmpty()) {
            js = js + ",\"path\":[";
            portList = new StringBuilder("");
            len = this.supportPathList.size();
            for (i = 0; i < len; ++i) {
                portList.append(this.supportPathList.get(i)).append(',');
            }
            js = js + portList.substring(0, portList.length() - 1) + "]";
        }
        return js;
    }
}

