/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame.attrvaluernge;

import com.huawei.nglct.gencfg.frame.attrvaluernge.ConditionInterface;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import com.huawei.nglct.gencfg.frame.attrvaluernge.UnConditionInterface;
import java.util.ArrayList;
import java.util.List;

public class AttrValueRangeConditions
implements Comparable {
    public static final int LIST = 0;
    public static final int RANGE = 1;
    private List<ConditionInterface> conditions = new ArrayList<ConditionInterface>();
    private List<String> attrValueRange;
    private int untypeFlag = 0;
    private int valueType = -1;
    private String defaultValue = null;
    private String exclude = null;
    private String step = null;
    private String decimal = null;

    public AttrValueRangeConditions() {
    }

    public AttrValueRangeConditions(List<String> attrValueRange) {
        this.attrValueRange = attrValueRange;
    }

    public void setAttrValueRange(List<String> attrValueRange) {
        this.attrValueRange = attrValueRange;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public boolean isRemoveRange() {
        return this.untypeFlag == -1;
    }

    public void setUntypeFlag(int untypeFlag) {
        this.untypeFlag = untypeFlag;
    }

    public void addCondition(ConditionInterface condition) {
        this.conditions.add(condition);
    }

    public List getAttrValueRange() {
        return this.attrValueRange;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String getStep() {
        return this.step;
    }

    public String getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String decimal) {
        this.decimal = decimal;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public boolean isMatchCondition(MatchData matchData) {
        int length = this.conditions.size();
        for (int i = 0; i < length; ++i) {
            if (this.conditions.get(i).isMatchCondition(matchData)) continue;
            return false;
        }
        return true;
    }

    public String getConditionJSON() {
        StringBuilder jsSb = new StringBuilder("");
        String jstemp = "";
        ConditionInterface condition = null;
        int length = this.conditions.size();
        for (int i = 0; i < length; ++i) {
            condition = this.conditions.get(i);
            jstemp = condition.getJSON();
            if (jstemp == null || jstemp.equals("")) continue;
            jsSb.append(condition.getJSON()).append(',');
        }
        String js = jsSb.toString();
        if (js.length() > 1) {
            js = js.substring(0, js.length() - 1);
        }
        return js;
    }

    public String getRangeJSON() {
        String result = "";
        if (this.attrValueRange != null && !this.attrValueRange.isEmpty()) {
            result = "\"type\":" + this.valueType + ",\"list\":[";
            StringBuilder sb = new StringBuilder("");
            int len = this.attrValueRange.size();
            for (int i = 0; i < len; ++i) {
                sb.append('\"').append(this.attrValueRange.get(i)).append("\",");
            }
            result = result + sb.substring(0, sb.length() - 1) + "]";
            if (this.defaultValue != null && !this.defaultValue.equals("")) {
                result = result + ",\"defaultValue\":\"" + this.defaultValue + "\"";
            }
            if (this.exclude != null && !this.exclude.equals("")) {
                result = result + ",\"exclude\":\"" + this.exclude + "\"";
            }
            if (this.step != null && !this.step.equals("")) {
                result = result + ",\"step\":\"" + this.step + "\"";
            }
            if (this.decimal != null && !this.decimal.equals("")) {
                result = result + ",\"decimal\":\"" + this.decimal + "\"";
            }
        }
        return result;
    }

    public int getParamValue(String att) {
        int value = 0;
        String tempAtt = null;
        int length = this.conditions.size();
        for (int i = 0; i < length; ++i) {
            ConditionInterface inter = this.conditions.get(i);
            if (inter instanceof UnConditionInterface) {
                tempAtt = ((UnConditionInterface)inter).getParamName();
            }
            if (!att.equals(tempAtt)) continue;
            value = ((UnConditionInterface)inter).getParamValue();
        }
        return value;
    }

    public List<Integer> getAttrValueRageByList() {
        if (this.attrValueRange == null) {
            return null;
        }
        ArrayList<Integer> list = null;
        if (this.valueType == 0) {
            int length = this.attrValueRange.size();
            list = new ArrayList<Integer>(length);
            for (int i = 0; i < length; ++i) {
                try {
                    list.add(Integer.valueOf(this.attrValueRange.get(i)));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditions == null ? 0 : ((Object)this.conditions).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttrValueRangeConditions other = (AttrValueRangeConditions)obj;
        return !(this.conditions == null ? other.conditions != null : !((Object)this.conditions).equals(other.conditions));
    }

    public int compareTo(Object arg0) {
        AttrValueRangeConditions other = (AttrValueRangeConditions)arg0;
        return other.conditions.size() - this.conditions.size();
    }
}

