/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEObjectMgr {
    private TIntIntHashMap m_objLevelDefMap = new TIntIntHashMap();
    private static TEObjectMgr instance = null;
    private TIntObjectHashMap<TIntIntHashMap> m_objDefMap = new TIntObjectHashMap();
    private boolean object_definitionLoaded = false;

    private TEObjectMgr() {
    }

    public static synchronized TEObjectMgr getInstance() {
        if (instance == null) {
            instance = new TEObjectMgr();
        }
        return instance;
    }

    private synchronized void loadobjectDefinitionFile() {
        if (this.object_definitionLoaded) {
            return;
        }
        this.parseScript();
        this.object_definitionLoaded = true;
    }

    public boolean initObj(TEObjectID objectID, int objType) {
        this.loadobjectDefinitionFile();
        boolean bSuccess = true;
        if (this.m_objDefMap.containsKey(objType)) {
            objectID.set(0, objType);
        } else {
            bSuccess = false;
        }
        return bSuccess;
    }

    public void getObjLevel(int objType, int[] objLevel) {
        this.loadobjectDefinitionFile();
        objLevel[0] = this.m_objLevelDefMap.contains(objType) ? this.m_objLevelDefMap.get(objType) : -9;
    }

    public void parseScriptSingle() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.parseScript();
        }
    }

    private synchronized void parseScript() {
        this.object_definitionLoaded = true;
        TEGnlScriptFileMgr pGnlFileMgr = TEGnlScriptFileMgr.getInstance();
        Document pRoot = pGnlFileMgr.getScriptDesc(6);
        if (null == pRoot || !pRoot.hasChildNodes()) {
            return;
        }
        NodeList nodeList = pRoot.getElementsByTagName("object_define");
        Node childTag1 = null;
        NodeList secNodeList = null;
        TEGnlVar gnlVar = TEGnlVar.getInstance();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag1 = nodeList.item(i);
            if (!childTag1.hasChildNodes()) {
                return;
            }
            secNodeList = childTag1.getChildNodes();
            Node childTag2 = null;
            int jSize = secNodeList.getLength();
            for (int j = 0; j < jSize; ++j) {
                childTag2 = secNodeList.item(j);
                if (!childTag2.getNodeName().equals("object_type")) continue;
                int objType = -1;
                int level = -1;
                if (!childTag2.hasAttributes()) {
                    return;
                }
                NamedNodeMap nodeMap = childTag2.getAttributes();
                objType = gnlVar.getGnlVar(nodeMap.getNamedItem("name").getNodeValue());
                level = Integer.parseInt(nodeMap.getNamedItem("level").getNodeValue());
                TIntIntHashMap ruleMap = new TIntIntHashMap();
                int number = 0;
                if (!childTag2.hasChildNodes()) {
                    return;
                }
                NodeList thrdNodeList = childTag2.getChildNodes();
                Node childTag3 = null;
                int kSize = thrdNodeList.getLength();
                for (int k = 0; k < kSize; ++k) {
                    childTag3 = thrdNodeList.item(k);
                    if (!childTag3.getNodeName().equals("para")) continue;
                    if (!childTag3.hasAttributes()) {
                        return;
                    }
                    Node tempNode = childTag3.getAttributes().getNamedItem("name");
                    int idType = gnlVar.getGnlVar(tempNode.getNodeValue());
                    ruleMap.put(idType, ++number);
                }
                if (-1 == level) {
                    level = number;
                }
                this.m_objDefMap.put(objType, (Object)ruleMap);
                this.m_objLevelDefMap.put(objType, level);
            }
        }
    }

    public boolean createOperObj(TEObjectID objectID, int objType, int firstID, int ... args) {
        this.loadobjectDefinitionFile();
        boolean bSuccess = true;
        if (this.m_objDefMap.containsKey(objType)) {
            int size = ((TIntIntHashMap)this.m_objDefMap.get(objType)).size();
            objectID.add(objType);
            int currValue = firstID;
            for (int count = 0; currValue != -1 && count < size; ++count) {
                objectID.add(currValue);
                currValue = args[count];
            }
        } else {
            bSuccess = false;
        }
        return bSuccess;
    }

    public boolean createOperObj(TEObjectID objectID, String objType, int firstID, TIntArrayList args) {
        boolean bSuccess = true;
        return bSuccess;
    }

    public boolean isLeadBy(TEObjectID lead, TEObjectID dst) {
        int len1 = lead.size();
        for (int i = 1; i < len1; ++i) {
            if (lead.get(i) == dst.get(i)) continue;
            return false;
        }
        return true;
    }

    public void getLeadObject(TEObjectID dstObject, TEObjectID leadObject, int leadLevel) {
        if (-1 == leadLevel) {
            for (int i = 1; i < dstObject.size(); ++i) {
                leadObject.set(i, dstObject.get(i));
            }
            return;
        }
        if (leadLevel == 1) {
            leadObject.set(0, 62003);
        } else if (leadLevel == 2) {
            leadObject.set(0, 61441);
        } else {
            leadObject.set(0, 61442);
        }
        int iSize = leadLevel;
        if (leadLevel == 1) {
            iSize = leadLevel + 1;
        }
        for (int i = 1; i < iSize; ++i) {
            leadObject.set(i, dstObject.get(i));
        }
    }
}

