/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.gencfg.frame.TEEquipmentMacro;
import com.huawei.nglct.gencfg.frame.TEGnlPortAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEGnlXMLParse;
import com.huawei.nglct.gencfg.frame.TEPortAttribIdx;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import gnu.trove.TIntArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlTPAttrXMLInterpreter {
    public int interpretXMLTag(Document tag) {
        if (!tag.hasChildNodes()) {
            return 0;
        }
        TEEquipmentMacro macro = TEEquipmentMacro.getInstance();
        NodeList nodeList = tag.getElementsByTagName("ne_description");
        Node childTag = null;
        NodeList secNodeList = null;
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            int neType = 255;
            childTag = nodeList.item(i);
            NamedNodeMap nodeMap = childTag.getAttributes();
            Node neTypeNode = nodeMap.getNamedItem("ne_type");
            if (neTypeNode != null) {
                neType = macro.getNeType(neTypeNode.getNodeValue());
                int realDevType = TEGetNEDomainVersion.getInstance().getNeType(neType);
                if (realDevType == neType) continue;
            }
            if (!childTag.hasChildNodes()) continue;
            secNodeList = childTag.getChildNodes();
            int size = secNodeList.getLength();
            for (int j = 0; j < size; ++j) {
                Node grandTag = secNodeList.item(j);
                if (!grandTag.getNodeName().equals("circuitpack")) continue;
                this.interpretCPTag(grandTag, neType);
            }
        }
        return 0;
    }

    public int interpretCPTag(Node tag, int neType) {
        int cpType = 0;
        NamedNodeMap nodeMap = tag.getAttributes();
        Node cpTypeNode = nodeMap.getNamedItem("cp_type");
        if (cpTypeNode != null) {
            String cpTypeName = cpTypeNode.getNodeValue();
            cpType = TEGnlVar.getInstance().getGnlVar(cpTypeName);
        }
        if (!tag.hasChildNodes()) {
            return 0;
        }
        TEPortAttribIdx key = new TEPortAttribIdx();
        key.m_NEType = neType;
        key.m_CPType = cpType;
        boolean bChannel = false;
        TIntArrayList portList = new TIntArrayList();
        TIntArrayList iAttrList = new TIntArrayList();
        TIntArrayList iVec1 = new TIntArrayList();
        TIntArrayList iVec2 = new TIntArrayList();
        int[] from = new int[]{0};
        int[] to = new int[]{-1717986919};
        NodeList nodeList = tag.getChildNodes();
        Node childTag = null;
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.getNodeName().equals("item")) continue;
            portList.clear();
            iAttrList.clear();
            iVec1.clear();
            iVec2.clear();
            from[0] = 0;
            to[0] = -1717986919;
            bChannel = false;
            int fbType = 0;
            int homonymSign = 0;
            NamedNodeMap childNodeMap = childTag.getAttributes();
            Node attrTag = null;
            attrTag = childNodeMap.getNamedItem("attr_id_list");
            if (attrTag != null) {
                TEGnlXMLParse.parseIntListByMarco(attrTag.getNodeValue(), iAttrList);
            }
            if ((attrTag = childNodeMap.getNamedItem("portid_list")) != null) {
                TEGnlXMLParse.strToNumList(attrTag.getNodeValue(), portList);
            }
            if ((attrTag = childNodeMap.getNamedItem("fbtype")) != null) {
                bChannel = true;
                fbType = TEGnlXMLParse.parseInt(attrTag.getNodeValue());
            }
            if ((attrTag = childNodeMap.getNamedItem("fbid1_list")) != null) {
                bChannel = true;
                TEGnlXMLParse.strToNumList(attrTag.getNodeValue(), iVec1);
            }
            if ((attrTag = childNodeMap.getNamedItem("fbid2_list")) != null) {
                bChannel = true;
                TEGnlXMLParse.strToNumList(attrTag.getNodeValue(), iVec2);
            }
            if ((attrTag = childNodeMap.getNamedItem("neVersion")) != null && TEGnlXMLParse.parseVerFromTo(attrTag.getNodeValue(), from, to) != 0) {
                return 1;
            }
            attrTag = childNodeMap.getNamedItem("homonym_Sign");
            if (attrTag != null) {
                homonymSign = Integer.parseInt(attrTag.getNodeValue());
            }
            key.m_MinNEVer = from[0];
            key.m_MaxNEVer = to[0];
            key.m_HomonymSign = homonymSign;
            int size = iAttrList.size();
            for (int j = 0; j < size; ++j) {
                key.m_AttrId = iAttrList.get(j);
                if (!bChannel) {
                    TEGnlPortAttrMgr.getInstance().addRecord(key, portList);
                    continue;
                }
                TEGnlPortAttrMgr.getInstance().addRecord(key, fbType, portList, iVec1, iVec2);
            }
        }
        return 0;
    }
}

