/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.frame.TEFuncEntry;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class TEGnlScriptFileMgr {
    private static TEGnlScriptFileMgr instance = null;
    private HashMap<String, Document> m_fileDescPtrMap = new HashMap();
    private String m_scriptDefaultDir;
    private static Object m_dataMutex = new Object();
    private static TIntObjectHashMap<String> fileNameMap = new TIntObjectHashMap();

    private TEGnlScriptFileMgr() {
        this.initEnv();
    }

    public static synchronized TEGnlScriptFileMgr getInstance() {
        if (null == instance) {
            instance = new TEGnlScriptFileMgr();
        }
        return instance;
    }

    public Document getScriptDesc(int scriptType) {
        return this.getScriptDesc(scriptType, 255, 0);
    }

    public Document getScriptDesc(int scriptType, int devType, int cmdCode) {
        boolean bSavePtr = false;
        String strFileName = this.getScriptDir(devType);
        String fileName = (String)fileNameMap.get(scriptType);
        if ("".equals(fileName)) {
            TEFuncEntry funcEntry = TEGnlVar.getInstance().getXMLCmdEntry(cmdCode);
            if (funcEntry != null) {
                fileName = funcEntry.qxFileName;
            }
        } else if ("specobj_desc.xml".equals(fileName)) {
            bSavePtr = true;
        }
        if (null == fileName) {
            return null;
        }
        if (!this.m_fileDescPtrMap.containsKey(strFileName = strFileName + fileName)) {
            Document pRoot = TEParseXMLFile.parseFile(strFileName);
            if (null != pRoot && bSavePtr) {
                this.m_fileDescPtrMap.put(strFileName, pRoot);
            }
            return pRoot;
        }
        return this.m_fileDescPtrMap.get(strFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getScriptDesc(String fileName, int devType) {
        Document pRoot = null;
        String strFileName = this.getScriptDir(devType) + fileName;
        Object object = m_dataMutex;
        synchronized (object) {
            pRoot = TEParseXMLFile.parseFile(strFileName);
        }
        return pRoot;
    }

    public String getScriptDir() {
        return this.getScriptDir(255);
    }

    public String getScriptDir(int devType) {
        String strDir = this.m_scriptDefaultDir;
        if (devType != 255) {
            String devDir = TEGnlVar.getInstance().getGnlDevPath(devType);
            if (devDir != null) {
                devDir = devDir + File.separator + "gencfg" + File.separator;
            }
            strDir = strDir + devDir;
        } else {
            strDir = strDir + File.separator + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "gencfg" + File.separator;
        }
        return strDir;
    }

    public void initEnv() {
        String strServerDir;
        this.m_scriptDefaultDir = strServerDir = TEResourceManager.getPath();
    }

    public int reLoadQxScript() {
        Map.Entry<String, Document> entry2 = null;
        for (Map.Entry<String, Document> entry2 : this.m_fileDescPtrMap.entrySet()) {
            Document pRoot = TEParseXMLFile.parseFile(entry2.getKey());
            if (null == pRoot) {
                return 1090646455;
            }
            entry2.setValue(pRoot);
        }
        return 0;
    }

    static {
        fileNameMap.put(2, (Object)"global_var.xml");
        fileNameMap.put(13, (Object)"macro_attrib_var.xml");
        fileNameMap.put(3, (Object)"attrib_description.xml");
        fileNameMap.put(9, (Object)"attrib_transition.xml");
        fileNameMap.put(1, (Object)"sysdef.xml");
        fileNameMap.put(8, (Object)"cpattr.xml");
        fileNameMap.put(12, (Object)"neattr.xml");
        fileNameMap.put(10, (Object)"portattr.xml");
        fileNameMap.put(4, (Object)"");
        fileNameMap.put(5, (Object)"cmdcode_entry.xml");
        fileNameMap.put(6, (Object)"object_definition.xml");
        fileNameMap.put(7, (Object)"specobj_desc.xml");
    }
}

