/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlTPAttrXMLInterpreter;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.gencfg.frame.TEPortAttribIdx;
import com.huawei.nglct.gencfg.frame.TETPAttrRecord;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlPortAttrMgr {
    private HashMap<TEPortAttribIdx, TIntArrayList> m_mapPortAttr = new HashMap();
    private HashMap<TEPortAttribIdx, TETPAttrRecord> m_TTPAttrMap = new HashMap();
    private static TEGnlPortAttrMgr instance = null;
    private boolean portattrLoaded = false;

    private TEGnlPortAttrMgr() {
        this.m_mapPortAttr.clear();
        this.m_TTPAttrMap.clear();
    }

    private synchronized void loadportattrFile() {
        if (this.portattrLoaded) {
            return;
        }
        this.initialize();
        this.portattrLoaded = true;
    }

    public static synchronized TEGnlPortAttrMgr getInstance() {
        if (instance == null) {
            instance = new TEGnlPortAttrMgr();
        }
        return instance;
    }

    public void initializeSingle() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.initialize();
        }
    }

    private void initialize() {
        Document pRoot = TEGnlScriptFileMgr.getInstance().getScriptDesc(10);
        ArrayList<Document> rootList = new ArrayList<Document>();
        if (null != pRoot) {
            this.gnlExpandScript(pRoot, rootList);
        }
        TEGnlTPAttrXMLInterpreter pInterpreter = new TEGnlTPAttrXMLInterpreter();
        int size = rootList.size();
        for (int i = 0; i < size; ++i) {
            pInterpreter.interpretXMLTag((Document)rootList.get(i));
        }
    }

    public void addRecord(TEPortAttribIdx key, TIntArrayList portList) {
        this.m_mapPortAttr.put(key, portList);
    }

    public TIntArrayList getPortListByAttr(TEObjectID parent) {
        int neid = parent.getNeId();
        int slotid = parent.getSlotId();
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        int boardType = ne.getBoard(slotid).getBoardType();
        TEPortAttribIdx key = new TEPortAttribIdx();
        key.m_AttrId = parent.get(0);
        key.m_NEType = neType;
        key.m_CPType = boardType;
        return this.m_mapPortAttr.get(key);
    }

    public void addRecord(TEPortAttribIdx key, int fb, TIntArrayList portList, TIntArrayList fbID1List, TIntArrayList fbID2List) {
        if (this.m_TTPAttrMap.containsKey(key)) {
            this.m_TTPAttrMap.get(key).addRecord(fb, portList, fbID1List, fbID2List);
        } else {
            TETPAttrRecord value = new TETPAttrRecord();
            value.addRecord(fb, portList, fbID1List, fbID2List);
            this.m_TTPAttrMap.put(key, value);
        }
    }

    private void gnlExpandScript(Document pRoot, List<Document> rootList) {
        if (pRoot == null || !pRoot.hasChildNodes()) {
            return;
        }
        String strServerDir = TEResourceManager.getPath();
        NodeList nodeList = pRoot.getElementsByTagName("include");
        Node childTag1 = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag1 = nodeList.item(i);
            if (childTag1 == null) continue;
            Node nameNode = childTag1.getAttributes().getNamedItem("name");
            if (nameNode != null) {
                String sValue = nameNode.getNodeValue();
                String strFile = strServerDir + sValue;
                Document subRoot = TEParseXMLFile.parseFile(strFile);
                if (subRoot.hasChildNodes()) {
                    rootList.add(subRoot);
                }
            }
            childTag1 = null;
        }
    }

    public boolean isPortSupportAttr(TENEPO pNE, int cpType, int portID, int attrID) {
        TEPortAttribIdx portAttrIdx = new TEPortAttribIdx();
        portAttrIdx.m_NEType = pNE.getType();
        portAttrIdx.m_CPType = cpType;
        portAttrIdx.m_AttrId = attrID;
        portAttrIdx.m_MinNEVer = pNE.getVersion();
        portAttrIdx.m_MaxNEVer = pNE.getVersion();
        int portNo = portID & 0xFFFF;
        boolean ret = false;
        boolean bfind = false;
        if (this.m_mapPortAttr.containsKey(portAttrIdx)) {
            bfind = true;
        } else {
            portAttrIdx.m_CPType = 0;
            if (this.m_mapPortAttr.containsKey(portAttrIdx)) {
                bfind = true;
            } else {
                portAttrIdx.m_NEType = 255;
                portAttrIdx.m_CPType = cpType;
                if (this.m_mapPortAttr.containsKey(portAttrIdx)) {
                    bfind = true;
                } else {
                    ret = true;
                }
            }
        }
        if (bfind && this.m_mapPortAttr.containsKey(portAttrIdx)) {
            TIntArrayList tempList = this.m_mapPortAttr.get(portAttrIdx);
            ret = tempList.contains(portNo);
        }
        return ret;
    }
}

