/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.bscfg.installcp.TECPDBMgr;
import com.huawei.nglct.gencfg.frame.GetDomainMethodForScriptPtr;
import com.huawei.nglct.gencfg.frame.IGnlModule;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlDataMgrHelper;
import com.huawei.nglct.gencfg.frame.TEGnlPortAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEMACTTPDomainJudger;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.gencfg.frame.dao.TEGnlCfgDao;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEConvertUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEGnlOperIF {
    private static TEGnlOperIF instance = null;
    private TEGnlVar gnlVar = TEGnlVar.getInstance();
    protected Map<Integer, GetDomainMethodForScriptPtr> getDomainForScriptMap = new HashMap<Integer, GetDomainMethodForScriptPtr>();

    private TEGnlOperIF() {
        this.registerGetDomainMethodForScript(1025, new TEMACTTPDomainJudger());
    }

    public static synchronized TEGnlOperIF getInstance() {
        if (null == instance) {
            instance = new TEGnlOperIF();
        }
        return instance;
    }

    public int[] getObjType(TEObjectID objectID, int objClass) {
        int errCode = 0;
        int objType = 255;
        switch (objClass) {
            case 2: {
                TENE ne = TEConfigurationDataMgr.getInstance().getNE(objectID.get(1));
                if (null == ne) {
                    errCode = 1090646020;
                    break;
                }
                objType = ne.getNEType();
                break;
            }
        }
        int[] result = new int[]{errCode, objType};
        return result;
    }

    public int getObjType(TEObjectID objectID, int objClass, int objType) {
        int retType = 255;
        switch (objClass) {
            case 2: {
                int neType = TEConfigurationDataMgr.getInstance().getNE(objectID.get(1)).getNEType();
                retType = TEGetNEDomainVersion.getInstance().getDevType(neType);
                break;
            }
        }
        return retType;
    }

    public int getDevInfo(XMLEquipmentInfo equipInfo, TEObjectID objectID) {
        int len = objectID.size();
        int errCode = this.gnlGetNEInfo(objectID.get(1), equipInfo);
        if (0 != errCode) {
            return errCode;
        }
        if (len > 2) {
            equipInfo.m_slotID = objectID.get(2);
            TECircuitPack pCP = TECPDBMgr.getBoardPO(objectID.get(1), objectID.get(2));
            return this.gnlGetCPInfo(pCP, equipInfo);
        }
        return 0;
    }

    public int gnlGetNEInfo(int neID, XMLEquipmentInfo equipInfo) {
        int errCode = 0;
        equipInfo.m_neID = neID;
        equipInfo.m_slotID = -1;
        equipInfo.m_cpType = -1;
        equipInfo.m_pmuType = 0;
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090646020;
        }
        equipInfo.m_neType = ne.getNEType();
        equipInfo.m_neVer = TEConvertUtil.convertVerStrToInt(ne.getHostVersion());
        return errCode;
    }

    public int gnlGetCPInfo(TECircuitPack pCP, XMLEquipmentInfo equipInfo) {
        if (null == pCP) {
            return 0;
        }
        equipInfo.m_cpType = pCP.getTypeId();
        equipInfo.m_slotID = pCP.getSlotId();
        return 0;
    }

    public boolean isValidAttib(int attrID) {
        return true;
    }

    public int expandObject(TEObjectID objectID, TIntArrayList attrIDList, Map<TEGenKey, TEGenValue> result, IGnlModule pIf) {
        int ret = 0;
        int size = attrIDList.size();
        for (int i = 0; i < size; ++i) {
            ret = this.expandObject(objectID, attrIDList.get(i), result);
            if (0 == ret) continue;
            return ret;
        }
        return 0;
    }

    public int expandObject(TEObjectID objectID, int attrID, Map<TEGenKey, TEGenValue> result) {
        TEGnlAttrMgr pAttrMgr = TEGnlAttrMgr.getInstance();
        TIntArrayList attrObjTypeList = pAttrMgr.getAttrObjType(attrID);
        ArrayList<TEObjectID> objectIDList = new ArrayList<TEObjectID>();
        if (attrObjTypeList.contains(objectID.get(0))) {
            objectIDList.add(objectID);
        } else {
            ArrayList<TEObjectID> childobjectIDList = new ArrayList<TEObjectID>();
            int size = attrObjTypeList.size();
            for (int i = 0; i < size; ++i) {
                childobjectIDList.clear();
                this.cpGetPortObj(objectID, attrID, attrObjTypeList.get(i), childobjectIDList);
                objectIDList.addAll(childobjectIDList);
            }
        }
        int size = objectIDList.size();
        for (int i = 0; i < size; ++i) {
            TEGenValue genValue = new TEGenValue();
            TEGenKey key = new TEGenKey();
            key.attrID = attrID;
            key.objectID = (TEObjectID)objectIDList.get(i);
            result.put(key, genValue);
        }
        return 0;
    }

    public void cpGetPortObj(TEObjectID parent, int attrID, int attrObjType, List<TEObjectID> child) {
        TEGenCfgAttribute attrObj;
        child.clear();
        int neid = parent.getNeId();
        int slotid = parent.getSlotId();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        TEBoard boardObj = neObj.getBoard(slotid);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType());
        if (null == genCfgModel) {
            return;
        }
        String attrName = TEGnlDataMgrHelper.getInstance().getAttrNameByID(attrID);
        if (attrName.equals("")) {
            attrName = this.gnlVar.getAttrNameByID(attrID);
        }
        if (null == (attrObj = genCfgModel.getAttrFromId(attrName))) {
            return;
        }
        ArrayList portList = attrObj.getPortList();
        if (null == portList) {
            portList = new ArrayList();
            this.setDefaultPort(portList);
        }
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            TEObjectID oneChild = new TEObjectID();
            oneChild.add(attrObjType);
            oneChild.add(neid);
            oneChild.add(slotid);
            TEGenCfgPortAttribute portObj = (TEGenCfgPortAttribute)portList.get(i);
            oneChild.add(portObj.getPort());
            if (attrObjType == 61445 || attrObjType == 61446 || attrObjType == 61447) {
                int path = portObj.getPath();
                oneChild.add(path);
            }
            child.add(oneChild);
            parent.set(0, attrObjType);
        }
    }

    private void setDefaultPort(ArrayList portList) {
        TEGenCfgPortAttribute defaultAttr = new TEGenCfgPortAttribute();
        defaultAttr.setPort(255);
        defaultAttr.setPath(255);
        portList.add(defaultAttr);
    }

    public TIntArrayList getPortList(TEObjectID parent) {
        TIntArrayList portList = TEGnlPortAttrMgr.getInstance().getPortListByAttr(parent);
        if (portList == null || portList.isEmpty()) {
            int i;
            portList = new TIntArrayList();
            int neid = parent.getNeId();
            int slotid = parent.getSlotId();
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            ArrayList<Integer> tempList = new ArrayList<Integer>();
            ArrayList portPropertyList = TEConfigurationDataMgr.getInstance().getBoardPortPropertyList(neid, boardType);
            int size = portPropertyList.size();
            for (i = 0; i < size; ++i) {
                TEPortProperty portProperty = (TEPortProperty)portPropertyList.get(i);
                tempList.add(portProperty.getPortNo());
            }
            size = tempList.size();
            for (i = 0; i < size; ++i) {
                portList.add(((Integer)tempList.get(i)).intValue());
            }
        }
        return portList;
    }

    public int getObjAttr(TEObjectID objectID, int attrID, HashMap<TEGenKey, TEGenValue> result, IGnlModule pIf) {
        this.expandObject(objectID, attrID, result);
        this.getObjAttr(objectID, result);
        return 0;
    }

    public int getObjAttr(TEObjectID objectID, int attrID, TIntArrayList attrList) {
        attrList.clear();
        int oid = 0;
        this.getObjOID(objectID, attrID, oid);
        if (0 == oid) {
            return 1;
        }
        return 0;
    }

    public int getObjAttr(TEObjectID objectID, TIntArrayList attrIDList, Map<TEGenKey, TEGenValue> result, IGnlModule pIf) {
        this.expandObject(objectID, attrIDList, result, pIf);
        return this.getObjAttr(objectID, result);
    }

    public int getObjAttr(TEObjectID objectID, Map<TEGenKey, TEGenValue> result) {
        if (result.isEmpty()) {
            return 0;
        }
        int neid = objectID.getNeId();
        int slotid = objectID.getSlotId();
        TEGnlAttrMgr pAttrMgr = TEGnlAttrMgr.getInstance();
        HashMap<TEObjectID, XMLEquipmentInfo> equipMap = new HashMap<TEObjectID, XMLEquipmentInfo>();
        Iterator<Map.Entry<TEGenKey, TEGenValue>> iter = result.entrySet().iterator();
        Map.Entry<TEGenKey, TEGenValue> tempEntry = null;
        while (iter.hasNext()) {
            int path;
            tempEntry = iter.next();
            int attrID = tempEntry.getKey().attrID;
            TEObjectID tempObjectID = tempEntry.getKey().objectID;
            XMLEquipmentInfo equipInfo = null;
            TEObjectID keyID = new TEObjectID();
            keyID.add(tempObjectID.get(1));
            if (tempObjectID.size() > 2) {
                keyID.add(tempObjectID.get(2));
            }
            if (equipMap.containsKey(keyID)) {
                equipInfo = (XMLEquipmentInfo)equipMap.get(keyID);
            } else {
                equipInfo = new XMLEquipmentInfo();
                this.getDevInfo(equipInfo, tempObjectID);
                equipMap.put(keyID, equipInfo);
            }
            tempEntry.getValue().iValue = -1;
            tempEntry.getValue().sValue = pAttrMgr.getAttrDefaultStringValue(tempEntry.getKey().attrID, equipInfo);
            int port = tempObjectID.getPortId();
            List nmDataList = TEGnlCfgDao.getOneAttr(neid, slotid, port, path = tempObjectID.getPathId(), attrID);
            if (nmDataList == null || nmDataList.isEmpty()) continue;
            TEOmniAttrib nmDataObj = (TEOmniAttrib)nmDataList.get(0);
            tempEntry.getValue().sValue = nmDataObj.getValue();
        }
        return 0;
    }

    public void insertAttrListToMGV(TEObjectID objectID, ArrayList attribList, HashMap<TEGenKey, TEGenValue> data) {
    }

    private int getObjOID(TEObjectID objectID, int attrID, int oid) {
        int errCode = 0;
        return errCode;
    }

    public String getAttrMOClassName(int attrID, int objType) {
        return "";
    }

    public int getObjAccess(TEObjectID objectID, int gnlAttrID) {
        int objType = objectID.get(0);
        TEGnlAttrMgr attrMgrInstance = TEGnlAttrMgr.getInstance();
        switch (objType) {
            case 61441: {
                return attrMgrInstance.getNeSupportAttrAccess(objectID, gnlAttrID);
            }
            case 61442: {
                return attrMgrInstance.getCpSupportAttrAccess(objectID, gnlAttrID);
            }
            case 61443: {
                return attrMgrInstance.getPortSupportAttrAccess(objectID, gnlAttrID);
            }
        }
        return 0;
    }

    public void registerGetDomainMethodForScript(int portType, GetDomainMethodForScriptPtr methodPtr) {
        if (!this.getDomainForScriptMap.keySet().contains(portType)) {
            this.getDomainForScriptMap.put(portType, methodPtr);
        }
    }

    public GetDomainMethodForScriptPtr getDomainMethodForScript(int portType) {
        return this.getDomainForScriptMap.get(portType);
    }
}

