/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.frame.TEEquipmentMacro;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlNEAttrMgr {
    TIntObjectHashMap m_mapNEAttr;
    private static TEGnlNEAttrMgr instance = null;
    private TEGnlVar gnlVar = TEGnlVar.getInstance();
    private boolean neattrloaded = false;

    private TEGnlNEAttrMgr() {
        this.m_mapNEAttr = new TIntObjectHashMap();
    }

    public static synchronized TEGnlNEAttrMgr getInstance() {
        if (instance == null) {
            instance = new TEGnlNEAttrMgr();
        }
        return instance;
    }

    private synchronized void loadneattrFile() {
        if (this.neattrloaded) {
            return;
        }
        this.initialize();
        this.neattrloaded = true;
    }

    public void initializeSingle() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.initialize();
        }
    }

    private void initialize() {
        this.neattrloaded = true;
        this.m_mapNEAttr.clear();
        try {
            Document m_pRootTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(12);
            if (!m_pRootTag.hasChildNodes()) {
                return;
            }
            TEEquipmentMacro macro = TEEquipmentMacro.getInstance();
            NodeList nodeList = m_pRootTag.getElementsByTagName("define");
            Node childTag = null;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                childTag = nodeList.item(i);
                int NEType = macro.getNeType(childTag.getAttributes().getNamedItem("neType").getNodeValue());
                Node secondLayer = childTag.getFirstChild();
                TIntArrayList attrList = new TIntArrayList();
                if (!secondLayer.getNodeName().equals("support_attr")) continue;
                this.parseIntList(secondLayer.getNodeValue(), attrList);
                this.m_mapNEAttr.put(NEType, (Object)attrList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file 'neattr.xml' failed:" + e);
        }
    }

    private void parseIntList(String st, TIntArrayList result) {
        if (st == null || st.length() == 0) {
            return;
        }
        result.clear();
        if (st.indexOf("[") != -1 && st.indexOf("]") != -1) {
            st = st.substring(1, st.length() - 1);
            String[] tempStrArr = st.split(",");
            for (int i = 0; i < tempStrArr.length; ++i) {
                String tempStr = tempStrArr[i];
                result.add(this.gnlVar.getGnlVar(tempStr));
            }
        }
    }

    public boolean isSupport(int NEType, int attrID) {
        this.loadneattrFile();
        if (this.m_mapNEAttr.containsKey(NEType)) {
            TIntArrayList attrList = (TIntArrayList)this.m_mapNEAttr.get(NEType);
            return attrList.contains(attrID);
        }
        return false;
    }
}

