/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.frame.TEFuncEntry;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlCpAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlNEAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlPortAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEGnlXMLParse;
import com.huawei.nglct.gencfg.frame.TEObjectMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlFrmModule {
    private static TEGnlFrmModule m_pInstance = null;

    private TEGnlFrmModule() {
    }

    public static synchronized TEGnlFrmModule getInstance() {
        if (m_pInstance == null) {
            m_pInstance = new TEGnlFrmModule();
        }
        return m_pInstance;
    }

    public boolean init() {
        TEGnlScriptFileMgr.getInstance();
        this.initConstant();
        this.initCmdEntryMap();
        TEGnlAttrMgr.getInstance().initialize();
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEGnlAttrMgr.getInstance().initAttrTransMapSingle();
            TEGnlNEAttrMgr.getInstance().initializeSingle();
            TEGnlCpAttrMgr.getInstance().initializeSingle();
            TEObjectMgr.getInstance().parseScriptSingle();
            TEGnlPortAttrMgr.getInstance().initializeSingle();
        }
        return true;
    }

    public boolean reInit() {
        TEGnlScriptFileMgr.getInstance().reLoadQxScript();
        this.initConstant();
        this.initCmdEntryMap();
        return true;
    }

    public boolean readFieldCmdEntry(String fileName, int devType) {
        Document pRoot = TEGnlScriptFileMgr.getInstance().getScriptDesc(fileName, devType);
        this.fillCmdEntryMap(pRoot);
        return true;
    }

    private boolean initConstant() {
        int m;
        Document pTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(2);
        ArrayList<Document> docList = new ArrayList<Document>();
        if (pTag != null) {
            this.gnlExpandScript(pTag, docList);
            m = docList.size();
            for (int i = 0; i < m; ++i) {
                TEGnlXMLParse.gnlInitConstScript((Document)docList.get(i));
            }
            Document pRoot = TEGnlScriptFileMgr.getInstance().getScriptDesc(1);
            TEGnlXMLParse.gnlInitSysScript(pRoot);
        }
        if ((pTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(13)) != null) {
            docList.clear();
            this.gnlExpandScript(pTag, docList);
            m = docList.size();
            for (int i = 0; i < m; ++i) {
                NodeList nodeList = ((Document)docList.get(i)).getElementsByTagName("macro_desc");
                Node node = null;
                int size = nodeList.getLength();
                for (int j = 0; j < size; ++j) {
                    node = nodeList.item(j);
                    NamedNodeMap attres = node.getAttributes();
                    Node attr = null;
                    int kSize = attres.getLength();
                    for (int k = 0; k < kSize; ++k) {
                        attr = attres.item(k);
                        String var = attr.getNodeName();
                        int value = Integer.parseInt(attr.getNodeValue().trim());
                        TEGnlVar.getInstance().addGnlVar(var, value);
                        TEGnlVar.getInstance().addAttrIDNameMap(value, var);
                    }
                }
            }
        }
        if ((pTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(14)) != null) {
            TEGnlXMLParse.gnlInitConstScript(pTag);
        }
        return true;
    }

    private boolean initCmdEntryMap() {
        Document pRoot = TEGnlScriptFileMgr.getInstance().getScriptDesc(5);
        this.fillCmdEntryMap(pRoot);
        return true;
    }

    private void fillCmdEntryMap(Document pRoot) {
        NodeList nodeList = pRoot.getElementsByTagName("item");
        NamedNodeMap nodeMap = null;
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            TEFuncEntry entry = new TEFuncEntry();
            entry.recordLogType = 0;
            nodeMap = nodeList.item(i).getAttributes();
            int n = nodeMap.getLength();
            for (int j = 0; j < n; ++j) {
                String attrName = nodeMap.item(j).getNodeName();
                String attrValue = nodeMap.item(j).getNodeValue();
                if ("cmdcode".equals(attrName)) {
                    entry.cmdCode = TEGnlXMLParse.parseInt(attrValue);
                    continue;
                }
                if ("xml".equals(attrName)) {
                    entry.qxFileName = attrValue;
                    continue;
                }
                if ("name".equals(attrName)) {
                    entry.name = attrValue;
                    continue;
                }
                if ("actionID".equals(attrName)) {
                    entry.actionID = TEGnlXMLParse.parseInt(attrValue);
                    continue;
                }
                if ("action".equals(attrName)) {
                    entry.action = attrValue;
                    continue;
                }
                if ("leadlevel".equals(attrName)) {
                    entry.leadLevel = TEGnlXMLParse.parseInt(attrValue);
                    continue;
                }
                if (!"recordlogtype".equals(attrName)) continue;
                entry.recordLogType = TEGnlXMLParse.parseInt(attrValue);
            }
            TEGnlVar.getInstance().addXMLCmdEntry(entry.cmdCode, entry);
        }
    }

    private void gnlExpandScript(Document pRoot, List<Document> list) {
        if (pRoot == null || !pRoot.hasChildNodes()) {
            return;
        }
        Document subRoot = null;
        Node rootNode = pRoot.getFirstChild();
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node childTag1 = nodeList.item(i);
            boolean bExpand = false;
            if (childTag1 != null && "include".equals(childTag1.getNodeName())) {
                NamedNodeMap pItemData = childTag1.getAttributes();
                Node attr = pItemData.item(0);
                if ("name".equals(attr.getNodeName())) {
                    String sValue = attr.getNodeValue();
                    String strFile = TEGnlScriptFileMgr.getInstance().getScriptDir();
                    strFile = strFile + sValue;
                    subRoot = TEParseXMLFile.parseFile(strFile);
                    this.gnlExpandScript(subRoot, list);
                }
                bExpand = true;
            }
            if (!bExpand) continue;
            rootNode.removeChild(childTag1);
        }
        list.add(pRoot);
    }
}

