/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.TEGnlCfgConstants;
import com.huawei.nglct.gencfg.frame.TEGnlCfgDMHandlerStru;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlDataMgrHelper {
    private static final String FILE_NAME = "gnldatamgr.xml";
    private static final String MACRO_FILE_NAME = "macro_var_gnl.xml";
    private static TEGnlDataMgrHelper instance = null;
    private static Map<TEGnlDataKey, List<TEGnlCfgDMHandlerStru>> infoMap = new HashMap<TEGnlDataKey, List<TEGnlCfgDMHandlerStru>>();
    private static Map<String, Integer> macroMap = new HashMap<String, Integer>();
    private static Map<Integer, String> deMacroMap = new HashMap<Integer, String>();

    private TEGnlDataMgrHelper() {
        infoMap.clear();
        macroMap.clear();
        this.parseXMLFile();
        this.parseMacroXMLFile();
    }

    public static synchronized TEGnlDataMgrHelper getInstance() {
        if (instance == null) {
            instance = new TEGnlDataMgrHelper();
        }
        return instance;
    }

    public List<TEGnlCfgDMHandlerStru> getGnlCfgDMStruList(String deviceType, String operationType, int itemid) {
        TEGnlDataKey key = new TEGnlDataKey(deviceType, operationType, itemid);
        return infoMap.get(key);
    }

    public int getAttrIDByName(String attrName) {
        if (macroMap.containsKey(attrName)) {
            return macroMap.get(attrName);
        }
        return -1;
    }

    public String getAttrNameByID(int attrID) {
        if (deMacroMap.containsKey(attrID)) {
            return deMacroMap.get(attrID);
        }
        return "";
    }

    private void parseXMLFile() {
        Document doc = null;
        try {
            String filePath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(FILE_NAME).toString();
            doc = TEParseXMLFile.parseFile(filePath);
            NodeList nodeList = doc.getElementsByTagName("Device");
            Node node = null;
            Node operNode = null;
            int iSize = nodeList.getLength();
            for (int i = 0; i < iSize; ++i) {
                node = nodeList.item(i);
                String deviceType = node.getAttributes().getNamedItem("type").getNodeValue();
                NodeList operNodeList = node.getChildNodes();
                int jSize = operNodeList.getLength();
                for (int j = 0; j < jSize; ++j) {
                    operNode = operNodeList.item(j);
                    if (!operNode.getNodeName().equals("Operation")) continue;
                    String operationType = operNode.getAttributes().getNamedItem("type").getNodeValue();
                    this.processItemNode(deviceType, operationType, operNode.getChildNodes());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlDataMgrHelper.parseXMLFile() fail!", (Throwable)e);
        }
    }

    private void processItemNode(String deviceType, String operationType, NodeList itemNodeList) {
        Node node = null;
        NodeList gnlgroupNodeList = null;
        Node gnlgroupNode = null;
        int iSize = itemNodeList.getLength();
        for (int i = 0; i < iSize; ++i) {
            node = itemNodeList.item(i);
            if (!"Item".equals(node.getNodeName())) continue;
            String itemId = node.getAttributes().getNamedItem("itemid").getNodeValue();
            gnlgroupNodeList = node.getChildNodes();
            ArrayList<TEGnlCfgDMHandlerStru> struList = new ArrayList<TEGnlCfgDMHandlerStru>();
            int jSize = gnlgroupNodeList.getLength();
            for (int j = 0; j < jSize; ++j) {
                gnlgroupNode = gnlgroupNodeList.item(j);
                if (!"gnlgroup".equals(gnlgroupNode.getNodeName())) continue;
                NamedNodeMap nodeMap = gnlgroupNode.getAttributes();
                TEGnlCfgDMHandlerStru stru = this.getStruInfo(nodeMap);
                struList.add(stru);
            }
            TEGnlDataKey key = new TEGnlDataKey(deviceType, operationType, Integer.valueOf(itemId));
            infoMap.put(key, struList);
        }
    }

    private TEGnlCfgDMHandlerStru getStruInfo(NamedNodeMap nodeMap) {
        String getCmdCode = nodeMap.getNamedItem("getCmdCode").getNodeValue();
        String setCmdCode = nodeMap.getNamedItem("setCmdCode").getNodeValue();
        String attrType = nodeMap.getNamedItem("attrType").getNodeValue();
        TEGnlCfgDMHandlerStru result = null;
        try {
            int getCmdCodeValue = (Integer)TEGnlCfgConstants.class.getField(getCmdCode).get(null);
            int setCmdCodeValue = (Integer)TEGnlCfgConstants.class.getField(setCmdCode).get(null);
            int attrTypeValue = (Integer)TEGnlCfgConstants.class.getField(attrType).get(null);
            result = new TEGnlCfgDMHandlerStru(getCmdCodeValue, setCmdCodeValue, attrTypeValue);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlDataMgrHelper.getStruInfo() fail!", (Throwable)e);
        }
        return result;
    }

    private void parseMacroXMLFile() {
        Document doc = null;
        try {
            String filePath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append("core").append(File.separatorChar).append(MACRO_FILE_NAME).toString();
            doc = TEParseXMLFile.parseFile(filePath);
            NodeList nodeList = doc.getElementsByTagName("macro_desc");
            Node node = null;
            int m = nodeList.getLength();
            for (int i = 0; i < m; ++i) {
                node = nodeList.item(i);
                NamedNodeMap attres = node.getAttributes();
                Node attr = null;
                int n = attres.getLength();
                for (int j = 0; j < n; ++j) {
                    attr = attres.item(j);
                    String var = attr.getNodeName();
                    int value = Integer.parseInt(attr.getNodeValue().trim());
                    macroMap.put(var, value);
                    deMacroMap.put(value, var);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGnlDataMgrHelper.parseMacroXMLFile() fail!", (Throwable)e);
        }
    }

    private class TEGnlDataKey {
        private String deviceType = "";
        private String operationType = "";
        private int itemid = -1;

        TEGnlDataKey(String deviceType, String operationType, int itemid) {
            this.deviceType = deviceType;
            this.operationType = operationType;
            this.itemid = itemid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TEGnlDataKey)) {
                return false;
            }
            TEGnlDataKey other = (TEGnlDataKey)obj;
            return this.deviceType.equalsIgnoreCase(other.deviceType) && this.operationType.equalsIgnoreCase(other.operationType) && this.itemid == other.itemid;
        }

        public int hashCode() {
            int result = 37;
            result += 17 * this.itemid;
            result = result + this.deviceType.hashCode() + this.operationType.hashCode();
            return result;
        }
    }
}

