/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlCpAttrMgr {
    private static TEGnlCpAttrMgr instance = null;
    private TIntObjectHashMap<TIntArrayList> m_mapCpAttr;
    private Object m_dataMutex = new Object();
    private TEGnlVar gnlVar = TEGnlVar.getInstance();
    private boolean cpattrloaded = false;

    private TEGnlCpAttrMgr() {
        this.m_mapCpAttr = new TIntObjectHashMap();
    }

    public static synchronized TEGnlCpAttrMgr getInstance() {
        if (instance == null) {
            instance = new TEGnlCpAttrMgr();
        }
        return instance;
    }

    private synchronized void loadcpattrFile() {
        if (this.cpattrloaded) {
            return;
        }
        this.initialize();
        this.cpattrloaded = true;
    }

    public void initializeSingle() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.initialize();
        }
    }

    private void initialize() {
        this.cpattrloaded = true;
        this.m_mapCpAttr.clear();
        try {
            Document m_pRootTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(8);
            ArrayList<Document> rootList = new ArrayList<Document>();
            if (null != m_pRootTag) {
                this.gnlExpandScript(m_pRootTag, rootList);
            }
            SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
            Document childTag = null;
            NodeList secondLayer = null;
            NodeList thrdLayer = null;
            Node thrdNode = null;
            int size = rootList.size();
            for (int i = 0; i < size; ++i) {
                childTag = (Document)rootList.get(i);
                secondLayer = childTag.getElementsByTagName("define");
                int kSize = secondLayer.getLength();
                for (int k = 0; k < kSize; ++k) {
                    String cpTypeName = secondLayer.item(k).getAttributes().getNamedItem("cpType").getNodeValue();
                    int cpType = mgr.parseInt(cpTypeName);
                    if (cpType == 0) continue;
                    thrdLayer = secondLayer.item(k).getChildNodes();
                    int jSize = thrdLayer.getLength();
                    for (int j = 0; j < jSize; ++j) {
                        thrdNode = thrdLayer.item(j);
                        if (!thrdNode.getNodeName().equals("support_attr")) continue;
                        TIntArrayList attrList = new TIntArrayList();
                        this.parseIntList(thrdNode.getAttributes().getNamedItem("value").getNodeValue(), attrList);
                        TIntArrayList attrListOld = (TIntArrayList)this.m_mapCpAttr.get(cpType);
                        if (attrListOld == null) {
                            attrListOld = new TIntArrayList();
                            this.m_mapCpAttr.put(cpType, (Object)attrListOld);
                        }
                        attrListOld.add(attrList.toNativeArray());
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file 'cpattr.xml' failed:" + e);
        }
    }

    private void gnlExpandScript(Document pRoot, List<Document> rootList) {
        if (pRoot == null || !pRoot.hasChildNodes()) {
            return;
        }
        NodeList nodeList = pRoot.getElementsByTagName("include");
        Node childTag1 = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag1 = nodeList.item(i);
            if (childTag1 == null) continue;
            Node nameNode = childTag1.getAttributes().getNamedItem("name");
            if (nameNode != null) {
                String sValue = nameNode.getNodeValue();
                String strFile = TEGnlScriptFileMgr.getInstance().getScriptDir();
                Document subRoot = TEParseXMLFile.parseFile(strFile = strFile + sValue);
                if (subRoot.hasChildNodes()) {
                    rootList.add(subRoot);
                }
            }
            childTag1 = null;
        }
    }

    private void parseIntList(String st, TIntArrayList result) {
        if (st == null || st.length() == 0) {
            return;
        }
        result.clear();
        if (st.indexOf("[") != -1 && st.indexOf("]") != -1) {
            st = st.substring(1, st.length() - 1);
            String[] tempStrArr = st.split(",");
            for (int i = 0; i < tempStrArr.length; ++i) {
                String tempStr = tempStrArr[i];
                if (tempStr.indexOf("-") != -1) continue;
                result.add(this.gnlVar.getGnlVar(tempStr.trim()));
            }
        }
    }

    public ArrayList getSupportAttrIDList(XMLEquipmentInfo equipInfo) {
        ArrayList supportAttrLis;
        ArrayList attrIDList = new ArrayList();
        int neID = equipInfo.m_neID;
        int neType = equipInfo.m_neType;
        int cpType = equipInfo.m_cpType;
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neID);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(cpType);
        if (null != genCfgModel && null != (supportAttrLis = genCfgModel.getSupportAttrList(neType, ne.getHostVersion())) && !supportAttrLis.isEmpty()) {
            attrIDList.addAll(supportAttrLis);
        }
        return attrIDList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupport(int cpType, int attrID) {
        this.loadcpattrFile();
        Object object = this.m_dataMutex;
        synchronized (object) {
            if (this.m_mapCpAttr.contains(cpType)) {
                TIntArrayList list = (TIntArrayList)this.m_mapCpAttr.get(cpType);
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    if (attrID != list.get(i)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

