/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.core.taskmgr.TETask;
import com.huawei.nglct.gencfg.frame.IGenCfgMsg;
import com.huawei.nglct.gencfg.frame.IGnlModule;
import com.huawei.nglct.gencfg.frame.TEFuncEntry;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlBroker;
import com.huawei.nglct.gencfg.frame.TEGnlOperIF;
import com.huawei.nglct.gencfg.frame.TEGnlRelationMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.gencfg.frame.TEObjectMgr;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.gencfg.frame.dao.TEGnlCfgDao;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEGnlCfgMgr {
    private int m_userID;
    private TETask m_pTask;
    private boolean m_bNeedRecordLog;
    private boolean isNeedSaveMO;
    private boolean m_bRepErrWhenSet;

    public TEGnlCfgMgr(boolean needRecordLog) {
        this.m_bNeedRecordLog = needRecordLog;
    }

    public TEGnlCfgMgr(boolean needRecordLog, boolean isNeedSaveMO) {
        this.m_bNeedRecordLog = needRecordLog;
        this.isNeedSaveMO = isNeedSaveMO;
    }

    public void setUserID(int userid) {
        this.m_userID = userid;
    }

    public int queryOneObject(TEObjectID operObject, TIntArrayList attrIDList, TEGnlBroker pAdapter, HashMap<TEGenKey, TEGenValue> allResult, int missionID, int overloadPolicy) {
        ArrayList<TEObjectID> operObjectVect = new ArrayList<TEObjectID>();
        return this.queryOneObjectByObject(operObject, attrIDList, pAdapter, allResult, operObjectVect, missionID, overloadPolicy);
    }

    public int queryOneObjectByObject(TEObjectID operObject, TIntArrayList attrIDList, TEGnlBroker pAdapter, HashMap<TEGenKey, TEGenValue> allResult, List<TEObjectID> operObjectVect, int missionID, int overloadPolicy) {
        int errCode = 0;
        XMLEquipmentInfo equipmentInfo = new XMLEquipmentInfo();
        equipmentInfo.setAttr(0, 0);
        errCode = this.queryOneObjectNoLog(operObject, attrIDList, pAdapter, allResult, missionID, equipmentInfo, operObjectVect, overloadPolicy);
        return errCode;
    }

    public int queryOneObjectNoLog(TEObjectID operObject, TIntArrayList attrIDList, TEGnlBroker pAdapter, HashMap<TEGenKey, TEGenValue> allResult, int missionID, XMLEquipmentInfo equipmentInfo, List<TEObjectID> operObjectVect, int overloadPolicy) {
        int errCode = 0;
        if (attrIDList.isEmpty()) {
            return errCode;
        }
        IGenCfgMsg queryMsg = new IGenCfgMsg(operObject, pAdapter);
        equipmentInfo.m_neID = queryMsg.m_neID;
        equipmentInfo.m_neType = queryMsg.m_neType;
        equipmentInfo.m_neVer = queryMsg.m_neVer;
        equipmentInfo.m_slotID = queryMsg.m_slotID;
        equipmentInfo.m_cpType = queryMsg.m_cpType;
        if (!queryMsg.m_isSuccess) {
            TEGenKey keyTmp = new TEGenKey();
            keyTmp.objectID = operObject;
            TEGenValue varTmp = new TEGenValue();
            varTmp.errCode = 1090646274;
            allResult.put(keyTmp, varTmp);
            return 1090646274;
        }
        queryMsg.m_pAttrData = allResult;
        if (4 == pAdapter.m_querytype) {
            TIntArrayList tmpattrIDList = new TIntArrayList();
            int acs = -1;
            IGenCfgMsg tmpqueryMsg = queryMsg;
            int size = operObjectVect.size();
            for (int i = 0; i < size; ++i) {
                tmpattrIDList.clear();
                int len = attrIDList.size();
                for (int j = 0; j < len; ++j) {
                    pAdapter.getIfPtr().getAttrValidity(attrIDList.get(j), operObjectVect.get(i), tmpqueryMsg, acs);
                    if (2 == acs) continue;
                    tmpattrIDList.add(attrIDList.get(j));
                }
                this.getAttrDefalutValue(operObjectVect.get(i), tmpattrIDList, allResult, pAdapter.getIfPtr());
            }
        } else {
            this.getAttrDefalutValue(operObject, attrIDList, allResult, pAdapter.getIfPtr());
        }
        Iterator<Map.Entry<TEGenKey, TEGenValue>> iterTmp = allResult.entrySet().iterator();
        while (iterTmp.hasNext()) {
            int acs = -1;
            Map.Entry<TEGenKey, TEGenValue> tempEntry = iterTmp.next();
            pAdapter.getIfPtr().getAttrValidity(tempEntry.getKey().attrID, tempEntry.getKey().objectID, queryMsg, acs);
            tempEntry.getValue().access = acs;
            tempEntry.getValue().bValid = false;
        }
        int size = attrIDList.size();
        for (int i = 0; i < size; ++i) {
            int attrID;
            queryMsg.m_attrID = attrID = attrIDList.get(i);
            queryMsg.initMsg();
            queryMsg.m_pAttrData = allResult;
            if (pAdapter.isTimeOutCancel(queryMsg.m_neType)) {
                this.insertErrorCodeToMGV(operObject, attrID, 1090727780, allResult);
                pAdapter.insertErrorCodeToGroupAttr(operObject, attrID, 1090727780, allResult);
                continue;
            }
            errCode = 1090646028;
            if (TEGnlOperIF.getInstance().isValidAttib(attrID)) {
                int acs = -1;
                errCode = pAdapter.getIfPtr().getAttrValidity(attrID, operObject, queryMsg, acs);
                if (0 == errCode) {
                    if (acs == 2 || (errCode = this.queryOneAttr(queryMsg, allResult)) == 0 || pAdapter.getIfPtr().getErrorStatus(errCode) == 1) continue;
                    pAdapter.insertErrorCodeToGroupAttr(operObject, attrID, errCode, allResult);
                    continue;
                }
                this.insertErrorCodeToMGV(operObject, attrID, errCode, allResult);
                pAdapter.insertErrorCodeToGroupAttr(operObject, attrID, errCode, allResult);
                continue;
            }
            this.insertErrorCodeToMGV(operObject, attrID, 1090646016, allResult);
            pAdapter.insertErrorCodeToGroupAttr(operObject, attrID, 1090646016, allResult);
        }
        iterTmp = allResult.entrySet().iterator();
        while (iterTmp.hasNext()) {
            Map.Entry<TEGenKey, TEGenValue> tempEntry = iterTmp.next();
            TEGenValue tempGenValue = tempEntry.getValue();
            if (2 == tempEntry.getValue().access) {
                allResult.remove(iterTmp.next());
                continue;
            }
            if (39796 == tempGenValue.errCode || 41184 == tempGenValue.errCode || 38759 == tempGenValue.errCode) {
                tempEntry.getValue().access = 2;
                tempEntry.getValue().errCode = 0;
                continue;
            }
            if (pAdapter.getIfPtr().getErrorStatus(tempEntry.getKey(), tempGenValue) != 1) continue;
            tempGenValue.errCode = 0;
        }
        pAdapter.getIfPtr().diyQueryResult(pAdapter.m_nCmdCode, allResult);
        TEGnlCfgDao.updateObjAttr(queryMsg.m_neID, allResult);
        return errCode;
    }

    public boolean isNeedRecordLog() {
        return this.m_bNeedRecordLog;
    }

    public int setAttr(int nCmdCode, Map<TEGenKey, TEGenValue> allData) {
        HashMap<TEObjectID, XMLEquipmentInfo> devMap = new HashMap<TEObjectID, XMLEquipmentInfo>();
        int errCode = this.setAttrNoLog(nCmdCode, allData, devMap);
        return errCode;
    }

    public int setAttrNoLog(int nCmdCode, Map<TEGenKey, TEGenValue> allData, Map<TEObjectID, XMLEquipmentInfo> devMap) {
        int errCode = 0;
        if (allData.isEmpty()) {
            return 0;
        }
        ArrayList<Map.Entry> allDataList = new ArrayList<Map.Entry>();
        Iterator<Map.Entry<TEGenKey, TEGenValue>> it = allData.entrySet().iterator();
        while (it.hasNext()) {
            allDataList.add(it.next());
        }
        HashMap<TEGenKey, TEGenValue> resultData = new HashMap<TEGenKey, TEGenValue>();
        TEGnlBroker broker = new TEGnlBroker();
        broker.m_nCmdCode = nCmdCode;
        int leadLevel = this.getLeadLevel(nCmdCode);
        Iterator<Map.Entry<TEGenKey, TEGenValue>> itFrom = allData.entrySet().iterator();
        TEGenKey itFromKey = itFrom.next().getKey();
        TEObjectID lastLeadObject = new TEObjectID();
        int devType = 255;
        TEObjectMgr.getInstance().getLeadObject(itFromKey.objectID, lastLeadObject, leadLevel);
        if (0 == TEGnlOperIF.getInstance().getObjType(itFromKey.objectID, 2, devType)) {
            broker.parseXMLFileAndInit(broker.m_nCmdCode, devType);
            broker.spawnIfPtr(broker.m_nCmdCode, devType);
        } else {
            broker.parseXMLFileAndInit(nCmdCode, 255);
            broker.spawnIfPtr(nCmdCode, 255);
        }
        if (broker.getIfPtr() != null) {
            broker.getIfPtr().changAttrib(allData, 1, false);
        }
        int from = 0;
        int end = 0;
        int iSize = allDataList.size();
        for (int i = 0; i < iSize; ++i) {
            TEObjectID objectID = ((TEGenKey)((Map.Entry)allDataList.get((int)i)).getKey()).objectID;
            if (leadLevel == -1 || TEObjectMgr.getInstance().isLeadBy(lastLeadObject, objectID)) continue;
            end = i;
            if (broker.getIfPtr().isValidObject(lastLeadObject)) {
                int iter;
                if (broker.isTimeOutCancel(devType)) {
                    this.insertErrorCodeToMGV(lastLeadObject, 0, 1090727780, allData);
                    for (iter = from; iter < allDataList.size(); ++iter) {
                        ((TEGenValue)((Map.Entry)allDataList.get((int)iter)).getValue()).errCode = 1090727780;
                    }
                } else if (errCode != 0) {
                    this.insertErrorCodeToMGV(lastLeadObject, 0, errCode, allData);
                    for (iter = from; iter < allDataList.size(); ++iter) {
                        ((TEGenValue)((Map.Entry)allDataList.get((int)iter)).getValue()).errCode = errCode;
                    }
                } else {
                    this.setOneObjectByLead(broker, lastLeadObject, allData, resultData, allDataList, from, end);
                }
            }
            TEObjectMgr.getInstance().getLeadObject(objectID, lastLeadObject, leadLevel);
            from = i;
            if (0 == TEGnlOperIF.getInstance().getObjType(objectID, 2, devType)) {
                broker.parseXMLFileAndInit(broker.m_nCmdCode, devType);
                broker.spawnIfPtr(broker.m_nCmdCode, devType);
                continue;
            }
            broker.parseXMLFileAndInit(nCmdCode, 255);
            broker.spawnIfPtr(nCmdCode, 255);
        }
        if (leadLevel != -1) {
            devType = 255;
            if (0 == TEGnlOperIF.getInstance().getObjType(lastLeadObject, 2, devType)) {
                broker.spawnIfPtr(broker.m_nCmdCode, devType);
            }
            if (broker.getIfPtr().isValidObject(lastLeadObject)) {
                int iter;
                if (broker.isTimeOutCancel(devType)) {
                    this.insertErrorCodeToMGV(lastLeadObject, 0, 1090727780, allData);
                    for (iter = from; iter < allDataList.size(); ++iter) {
                        ((TEGenValue)((Map.Entry)allDataList.get((int)iter)).getValue()).errCode = 1090727780;
                    }
                } else if (errCode != 0) {
                    this.insertErrorCodeToMGV(lastLeadObject, 0, errCode, allData);
                    for (iter = from; iter < allDataList.size(); ++iter) {
                        ((TEGenValue)((Map.Entry)allDataList.get((int)iter)).getValue()).errCode = errCode;
                    }
                } else {
                    this.setOneObjectByLead(broker, lastLeadObject, allData, resultData, allDataList, from, end);
                }
            }
        }
        errCode = this.getError(allData);
        return errCode;
    }

    public int queryAttrFromNM(TEObjectID operObject, TIntArrayList attrIDList, TEGnlBroker pAdapter, Map<TEGenKey, TEGenValue> allResult, int missionID, int overloadPolicy) {
        int ret = 0;
        ret = pAdapter.queryFromNM(operObject, attrIDList, allResult);
        if (ret != 0) {
            TEGenKey keyTmp = new TEGenKey();
            keyTmp.objectID = operObject;
            TEGenValue varTmp = new TEGenValue();
            varTmp.errCode = ret;
            allResult.put(keyTmp, varTmp);
            return ret;
        }
        IGenCfgMsg queryMsg = new IGenCfgMsg(operObject, pAdapter);
        if (!queryMsg.m_isSuccess) {
            TEGenKey keyTmp = new TEGenKey();
            keyTmp.objectID = operObject;
            TEGenValue varTmp = new TEGenValue();
            varTmp.errCode = 1090646274;
            allResult.put(keyTmp, varTmp);
            return 1090646274;
        }
        queryMsg.m_pAttrData = allResult;
        Iterator<Map.Entry<TEGenKey, TEGenValue>> iter = allResult.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<TEGenKey, TEGenValue> entry = iter.next();
            int acs = 2;
            pAdapter.getIfPtr().getAttrValidity(entry.getKey().attrID, entry.getKey().objectID, queryMsg, acs);
            if (acs == 2) {
                iter.remove();
                continue;
            }
            entry.getValue().access = acs;
        }
        pAdapter.getIfPtr().fillterObject(allResult, overloadPolicy, false);
        return 0;
    }

    public int queryOneAttr(IGenCfgMsg queryMsg, HashMap<TEGenKey, TEGenValue> allResult) {
        TEGnlAttrMgr pAttrMgr = TEGnlAttrMgr.getInstance();
        int errCode = 0;
        int supportType = pAttrMgr.getSupportType(queryMsg.m_attrID);
        if (supportType == 1) {
            TIntArrayList attrList = new TIntArrayList();
            attrList.add(queryMsg.m_attrID);
            HashMap<TEGenKey, TEGenValue> tempResult = new HashMap<TEGenKey, TEGenValue>();
            errCode = this.queryAttrFromNM(queryMsg.m_pObjectID, attrList, queryMsg.m_pAdapter, tempResult, 0, 0);
            if (0 == errCode) {
                for (Map.Entry<TEGenKey, TEGenValue> tempEntry : tempResult.entrySet()) {
                    TEGenValue iterFind = allResult.get(tempEntry.getKey());
                    if (iterFind == null) continue;
                    iterFind.iValue = tempEntry.getValue().iValue;
                    iterFind.sValue = tempEntry.getValue().sValue;
                }
            }
        } else if (supportType == 0) {
            errCode = queryMsg.m_pAdapter.queryAttrCmd(queryMsg, allResult);
            if (0 == errCode && queryMsg.m_nCmdErrCode != 0) {
                errCode = queryMsg.m_nCmdErrCode;
            }
        } else {
            return 1090650111;
        }
        return errCode;
    }

    public static void sortAttribIDForGencfg(TIntArrayList attrIDList) {
        if (null == attrIDList || attrIDList.isEmpty()) {
            return;
        }
        int nTmp = 0;
        int size = attrIDList.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!TEGnlCfgMgr.isAttrPriHigher(attrIDList.get(j), attrIDList.get(i))) continue;
                nTmp = attrIDList.get(i);
                attrIDList.set(i, attrIDList.get(j));
                attrIDList.set(j, nTmp);
            }
        }
    }

    public static boolean isAttrPriHigher(int attrID1, int attrID2) {
        int usPiority1 = TEGnlRelationMgr.getSequenceByID(attrID1);
        int usPiority2 = TEGnlRelationMgr.getSequenceByID(attrID2);
        if (65535 == usPiority1 && 65535 == usPiority2) {
            return attrID1 < attrID2;
        }
        return usPiority1 < usPiority2;
    }

    public int getAttrDefalutValue(TEObjectID objectID, TIntArrayList attrIDList, HashMap<TEGenKey, TEGenValue> result, IGnlModule pIF) {
        TEGnlAttrMgr pAttrMgr = TEGnlAttrMgr.getInstance();
        TEGnlOperIF pOperIF = TEGnlOperIF.getInstance();
        pOperIF.expandObject(objectID, attrIDList, result, pIF);
        for (Map.Entry<TEGenKey, TEGenValue> entry : result.entrySet()) {
            XMLEquipmentInfo equipInfo = new XMLEquipmentInfo();
            pOperIF.getDevInfo(equipInfo, entry.getKey().objectID);
            entry.getValue().iValue = -1;
            entry.getValue().sValue = pAttrMgr.getAttrDefaultStringValue(entry.getKey().attrID, equipInfo);
        }
        return 0;
    }

    private void insertErrorCodeToMGV(TEObjectID operObject, int attrID, int errCode, Map<TEGenKey, TEGenValue> allResult) {
        TEGenKey keyTmp = new TEGenKey();
        keyTmp.objectID = operObject;
        keyTmp.attrID = attrID;
        TEGenValue genValue = allResult.get(keyTmp);
        if (null != genValue) {
            genValue.errCode = errCode;
        } else {
            TEGenValue varTmp = new TEGenValue();
            varTmp.errCode = errCode;
            varTmp.access = 255;
            allResult.put(keyTmp, varTmp);
        }
    }

    public boolean isReportErrorWhenSetNoWriteAccessObj() {
        return this.m_bRepErrWhenSet;
    }

    public int getLeadLevel(int nCmdCode) {
        TEFuncEntry funcEntry = TEGnlVar.getInstance().getXMLCmdEntry(nCmdCode);
        if (funcEntry != null) {
            return funcEntry.leadLevel;
        }
        return 2;
    }

    private int setOneObjectByLead(TEGnlBroker pAdapter, TEObjectID leadObject, Map<TEGenKey, TEGenValue> allData, Map<TEGenKey, TEGenValue> resultData, List<Map.Entry> allDataList, int itFrom, int itEnd) {
        int errCode = 0;
        IGenCfgMsg setMsg = new IGenCfgMsg(leadObject, pAdapter);
        if (!setMsg.m_isSuccess) {
            TEGenValue curValue = new TEGenValue();
            curValue.errCode = 1090646274;
            curValue.iValue = -1;
            curValue.sValue = "";
            TEGenKey key = new TEGenKey(leadObject, -1);
            resultData.put(key, curValue);
            return 1090646274;
        }
        int temp = itFrom;
        int it = itFrom;
        while (it <= itEnd) {
            int attrID = ((TEGenKey)allDataList.get((int)temp).getKey()).attrID;
            while (((TEGenKey)allDataList.get((int)it).getKey()).attrID == attrID && it != itEnd) {
                ++it;
            }
            setMsg.m_attrID = attrID;
            setMsg.initMsg();
            if (pAdapter.isTimeOutCancel(setMsg.m_neType)) {
                this.insertErrorCodeToMGV(leadObject, attrID, 1090727780, allData);
                pAdapter.insertErrorCodeToGroupAttr(leadObject, attrID, 1090727780, allData);
            } else {
                errCode = 1090646028;
                errCode = this.setOneAttr(pAdapter, setMsg, allData, resultData, allDataList, temp, it, attrID);
                if (errCode != 0 && pAdapter.getIfPtr().getErrorStatus(errCode) != 1) {
                    this.insertErrorCodeToMGV(leadObject, attrID, errCode, allData);
                    pAdapter.insertErrorCodeToGroupAttr(leadObject, attrID, errCode, allData);
                }
            }
            temp = it++;
        }
        return 0;
    }

    public int setOneAttr(TEGnlBroker pAdapter, IGenCfgMsg setMsg, Map<TEGenKey, TEGenValue> allData, Map<TEGenKey, TEGenValue> resultData, List<Map.Entry> allDataList, int itFrom, int itEnd, int attrID) {
        TEGnlAttrMgr pAttrMgr = TEGnlAttrMgr.getInstance();
        int errCode = 0;
        int supportType = pAttrMgr.getSupportType(attrID);
        switch (supportType) {
            case 0: {
                errCode = pAdapter.setAttrCmd(setMsg, attrID, allData, allDataList, itFrom, itEnd, resultData);
                if (errCode != 0 || setMsg.m_nCmdErrCode == 0) break;
                errCode = setMsg.m_nCmdErrCode;
                for (int iter = itFrom; iter < allDataList.size(); ++iter) {
                    ((TEGenValue)allDataList.get((int)iter).getValue()).errCode = errCode;
                }
                break;
            }
            case 1: {
                errCode = 0;
                break;
            }
        }
        return errCode;
    }

    private int getError(Map<TEGenKey, TEGenValue> allData) {
        int nCount = 0;
        Iterator<TEGenValue> iter = allData.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().errCode == 0) continue;
            ++nCount;
        }
        if (0 == nCount) {
            return 0;
        }
        return 1090646292;
    }

    public int queryAttr(ArrayList<TEObjectID> operObject, TIntArrayList attrIDList, int bFromNE, int nCmdCode, HashMap<TEGenKey, TEGenValue> allResult, int missionID, int overloadPolicy, TIntObjectHashMap<TIntHashSet> cpSupportAttrMap) {
        int errCode = 0;
        if (attrIDList.isEmpty()) {
            return errCode;
        }
        TEGnlBroker broker = new TEGnlBroker();
        broker.m_nCmdCode = nCmdCode;
        broker.m_querytype = bFromNE;
        int[] objLevel = new int[]{0};
        int objSize = 0;
        TEObjectMgr pObjMgr = TEObjectMgr.getInstance();
        if (!operObject.isEmpty()) {
            objSize = operObject.get(0).size();
            pObjMgr.getObjLevel(operObject.get(0).get(0), objLevel);
        }
        if (4 == bFromNE && objLevel[0] >= 2 && objSize > 2) {
            HashMap<TEGenKey, TEGenValue> tmpData = new HashMap<TEGenKey, TEGenValue>();
            TEObjectID objectID = new TEObjectID();
            TEObjectID firstObj = operObject.get(0);
            TEObjectMgr.getInstance().createOperObj(objectID, 61442, firstObj.get(1), firstObj.get(2), -1);
            int devType = 255;
            devType = TEGnlOperIF.getInstance().getObjType(objectID, 2, devType);
            broker.parseXMLFileAndInit(broker.m_nCmdCode, devType);
            broker.spawnIfPtr(broker.m_nCmdCode, devType);
            this.queryOneObjectByObject(objectID, attrIDList, broker, tmpData, operObject, missionID, overloadPolicy);
            Iterator<Map.Entry<TEGenKey, TEGenValue>> iterMap2 = tmpData.entrySet().iterator();
            Map.Entry<TEGenKey, TEGenValue> entry = null;
            while (iterMap2.hasNext()) {
                entry = iterMap2.next();
                allResult.put(entry.getKey(), entry.getValue());
            }
        } else {
            if (4 == bFromNE) {
                broker.m_querytype = bFromNE = 1;
            }
            HashMap<TEGenKey, TEGenValue> tmpData = new HashMap<TEGenKey, TEGenValue>();
            TIntArrayList tempAttrList = new TIntArrayList();
            int size = operObject.size();
            for (int i = 0; i < size; ++i) {
                tmpData.clear();
                TEObjectID objectID = operObject.get(i);
                int devType = 255;
                devType = TEGnlOperIF.getInstance().getObjType(objectID, 2, devType);
                broker.parseXMLFileAndInit(broker.m_nCmdCode, devType);
                broker.spawnIfPtr(broker.m_nCmdCode, devType);
                if (!broker.getIfPtr().isValidObject(objectID)) continue;
                if (broker.isTimeOutCancel(devType)) {
                    this.insertErrorCodeToMGV(objectID, 0, 1090727780, allResult);
                    continue;
                }
                if (bFromNE != 0) {
                    this.filterAttrList(objectID, cpSupportAttrMap, tempAttrList);
                    this.queryOneObject(objectID, tempAttrList, broker, tmpData, missionID, overloadPolicy);
                } else {
                    this.queryAttrFromNM(objectID, attrIDList, broker, tmpData, missionID, overloadPolicy);
                }
                for (Map.Entry<TEGenKey, TEGenValue> entry : tmpData.entrySet()) {
                    allResult.put(entry.getKey(), entry.getValue());
                }
            }
        }
        errCode = this.getError(allResult);
        return errCode;
    }

    private void filterAttrList(TEObjectID objectID, TIntObjectHashMap<TIntHashSet> cpSupportAttrMap, TIntArrayList tempAttrList) {
        tempAttrList.clear();
        int slotid = objectID.getSlotId();
        TIntHashSet attrIDSet = (TIntHashSet)cpSupportAttrMap.get(slotid);
        tempAttrList.add(attrIDSet.toArray());
    }
}

