/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.gencfg.frame.GnlGroupRecord;
import com.huawei.nglct.gencfg.frame.IGenCfgMsg;
import com.huawei.nglct.gencfg.frame.IGnlModule;
import com.huawei.nglct.gencfg.frame.TEFuncEntry;
import com.huawei.nglct.gencfg.frame.TEGenCfgQxMsg;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEGnlIfMgr;
import com.huawei.nglct.gencfg.frame.TEGnlOperIF;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.TEGnlXMLParse;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.gencfg.frame.dao.TEGnlCfgDao;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlBroker {
    private Document m_pRootTag = null;
    int m_nCmdCode;
    int m_lastGroup = -1;
    int m_querytype;
    private TIntObjectHashMap<TIntArrayList> m_group2AttrsMap = new TIntObjectHashMap();
    private TIntIntHashMap m_attr2GroupMap = new TIntIntHashMap();
    private IGnlModule m_ifPtr;
    private int m_scriptUpdateFlag;
    private int m_ifUpdateFlag;
    private TObjectIntHashMap<GnlGroupRecord> m_groupRecord = new TObjectIntHashMap();
    private TIntIntHashMap m_timeOutCounter = new TIntIntHashMap();

    public TEGnlBroker() {
        this.m_groupRecord.clear();
        this.m_nCmdCode = 0;
        this.m_pRootTag = null;
        this.m_ifPtr = null;
        this.m_scriptUpdateFlag = 255;
        this.m_ifUpdateFlag = 255;
        this.m_timeOutCounter.clear();
    }

    public boolean initMsg(IGenCfgMsg pMsg) {
        return this.getIfPtr().initMsg(pMsg);
    }

    public IGnlModule getIfPtr() {
        return this.m_ifPtr;
    }

    public void spawnIfPtr(int nCmdCode, int devType) {
        if (null == this.m_ifPtr || devType != this.m_ifUpdateFlag) {
            if (null != this.m_ifPtr) {
                this.m_ifPtr = null;
            }
            IGnlModule pGnlIf = TEGnlIfMgr.getInstance().getInterface(nCmdCode, devType);
            this.setIfPtr(pGnlIf);
            this.m_ifUpdateFlag = devType;
        }
    }

    public void setIfPtr(IGnlModule pIf) {
        pIf.m_pBroker = this;
        this.m_ifPtr = pIf;
    }

    public int parseXMLFileAndInit(int nCmdCode, int devType) {
        TEGnlScriptFileMgr pGnlFileMgr = TEGnlScriptFileMgr.getInstance();
        if (null == this.m_pRootTag || devType != this.m_scriptUpdateFlag) {
            if (null != this.m_pRootTag) {
                this.m_group2AttrsMap.clear();
                this.m_groupRecord.clear();
                this.m_attr2GroupMap.clear();
            }
            this.m_pRootTag = pGnlFileMgr.getScriptDesc(4, devType, nCmdCode);
            if (null == this.m_pRootTag) {
                this.m_pRootTag = pGnlFileMgr.getScriptDesc(4, 255, nCmdCode);
                if (null == this.m_pRootTag) {
                    return 1090596626;
                }
            }
            this.initEnv();
            this.m_scriptUpdateFlag = devType;
        }
        return 0;
    }

    private void initEnv() {
        if (null == this.m_pRootTag || !this.m_pRootTag.hasChildNodes()) {
            return;
        }
        NodeList nodeList = this.m_pRootTag.getElementsByTagName("group_define");
        Node childTag = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag = nodeList.item(i);
            this.initAttrGroup(childTag);
        }
    }

    public boolean isTimeOutCancel(int devType) {
        int nTimes = this.m_timeOutCounter.get(devType);
        return nTimes != 0 && nTimes > 3;
    }

    public void insertErrorCodeToGroupAttr(TEObjectID objectID, int attrID, int errCode, Map<TEGenKey, TEGenValue> allData) {
        if (objectID.isEmpty()) {
            return;
        }
        TEGenKey key = new TEGenKey();
        key.objectID = objectID;
        TIntArrayList attrIDList = new TIntArrayList();
        this.getGroupAttrIDList(this.m_lastGroup, attrIDList);
        if (attrIDList.contains(attrID)) {
            return;
        }
        int size = attrIDList.size();
        for (int attrIDListIndex = 0; attrIDListIndex < size; ++attrIDListIndex) {
            if (attrIDList.get(attrIDListIndex) != attrID) continue;
            attrIDList.remove(attrIDListIndex);
            break;
        }
        int iSize = attrIDList.size();
        for (int i = 0; i < iSize; ++i) {
            key.attrID = attrIDList.get(i);
            TEGenValue iterFind = allData.get(key);
            if (null == iterFind) continue;
            iterFind.errCode = errCode;
        }
        TIntArrayList IDsWillBeSet = new TIntArrayList();
        Iterator<TEGenKey> it = allData.keySet().iterator();
        while (it.hasNext()) {
            int tmpAttrID = it.next().attrID;
            if (!attrIDList.contains(tmpAttrID)) continue;
            IDsWillBeSet.add(tmpAttrID);
        }
        for (int n = 0; n < IDsWillBeSet.size(); ++n) {
            TEGenKey tmpKey = new TEGenKey(objectID, IDsWillBeSet.get(n));
            TEGenValue itTmp = allData.get(tmpKey);
            if (null != itTmp) {
                itTmp.errCode = errCode;
                continue;
            }
            TEGenValue varTmp = new TEGenValue();
            varTmp.errCode = errCode;
            varTmp.access = 255;
            allData.put(tmpKey, varTmp);
        }
    }

    private int getGroupAttrIDList(int groupID, TIntArrayList idList) {
        idList.clear();
        TIntArrayList tempIdList = (TIntArrayList)this.m_group2AttrsMap.get(groupID);
        if (null != tempIdList) {
            idList.add(tempIdList.toNativeArray());
            return 0;
        }
        return 1;
    }

    public int queryAttrCmd(IGenCfgMsg msg, HashMap<TEGenKey, TEGenValue> result) {
        int errCode = 0;
        TEGenCfgQxMsg qxMsg = new TEGenCfgQxMsg(msg, msg.m_attrID, this.m_nCmdCode);
        qxMsg.m_pGenMsg.m_nCmdType = 0;
        qxMsg.m_pGenMsg.m_pAttrData = result;
        errCode = this.getXMLAttrEntry(qxMsg, msg.m_attrID);
        if (0 != errCode) {
            return errCode;
        }
        errCode = qxMsg.syncHandleMessage(30);
        if (0 == errCode) {
            errCode = qxMsg.m_pGenMsg.m_nCmdErrCode;
            if (0 == errCode) {
                Iterator<Map.Entry<TEGenKey, TEGenValue>> iterMap = msg.m_pAttrData.entrySet().iterator();
                Map.Entry<TEGenKey, TEGenValue> tempEntry = null;
                while (iterMap.hasNext()) {
                    tempEntry = iterMap.next();
                    if (tempEntry.getKey().attrID != msg.m_attrID) continue;
                    tempEntry.getValue().bValid = true;
                }
            }
        } else if (1090646019 == errCode) {
            this.incTimeOutCounter(msg.m_neType);
        }
        return errCode;
    }

    public int queryFromNM(TEObjectID objectID, TIntArrayList attrIDList, Map<TEGenKey, TEGenValue> result) {
        if (attrIDList.isEmpty()) {
            return 0;
        }
        if (objectID.size() < 2) {
            return 1090596628;
        }
        int errCode = 0;
        errCode = TEGnlOperIF.getInstance().getObjAttr(objectID, attrIDList, result, this.getIfPtr());
        if (0 != errCode) {
            return errCode;
        }
        return 0;
    }

    public int setAttrCmd(IGenCfgMsg msg, int attrID, Map<TEGenKey, TEGenValue> allData, List<Map.Entry> allDataList, int itFrom, int itEnd, Map<TEGenKey, TEGenValue> result) {
        int itEnd2;
        int errCode = 0;
        TEGenCfgQxMsg qxMsg = new TEGenCfgQxMsg(msg, attrID, this.m_nCmdCode);
        qxMsg.m_pGenMsg.m_nCmdType = 1;
        qxMsg.m_pGenMsg.m_pAttrData = allData;
        errCode = this.getXMLAttrEntry(qxMsg, attrID);
        if (0 != errCode) {
            return errCode;
        }
        for (int iterTmp = itFrom; iterTmp < allDataList.size(); ++iterTmp) {
            ((TEGenValue)allDataList.get((int)iterTmp).getValue()).bValid = true;
        }
        IGnlModule pIf = this.getIfPtr();
        int itFrom2 = itFrom;
        int cmdCount = 0;
        int CMDMax = pIf.getMaxCMDCountPerPacket();
        for (itEnd2 = itFrom; itEnd2 != itEnd; ++itEnd2) {
            if (++cmdCount != CMDMax + 1) continue;
            qxMsg.m_pGenMsg.m_nCmdBitSet = 0;
            errCode = qxMsg.syncHandleMessage(60);
            if (0 == errCode) {
                errCode = qxMsg.m_pGenMsg.m_nCmdErrCode;
            } else if (1090646019 == errCode) {
                this.incTimeOutCounter(msg.m_neType);
            }
            if (0 != errCode) {
                this.insertErrorCodeINSubOPerater(errCode, allData, allDataList, itFrom2, itEnd2, attrID);
            }
            itFrom2 = itEnd2;
            cmdCount = 1;
        }
        qxMsg.m_pGenMsg.m_nCmdBitSet = 0;
        errCode = qxMsg.syncHandleMessage(60);
        if (errCode == 0) {
            errCode = qxMsg.m_pGenMsg.m_nCmdErrCode;
        } else if (errCode == 1090650120) {
            this.incTimeOutCounter(msg.m_neType);
        }
        if (errCode != 0) {
            this.insertErrorCodeINSubOPerater(errCode, allData, allDataList, itFrom2, itEnd2, attrID);
        }
        TEGnlCfgDao.updateObjAttr(msg.m_neID, allData);
        return errCode;
    }

    private void initAttrGroup(Node tag) {
        if (!tag.hasChildNodes()) {
            return;
        }
        NodeList nodeList = tag.getChildNodes();
        NamedNodeMap childTag = null;
        Node node = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            int groupID;
            node = nodeList.item(i);
            if (!node.getNodeName().equals("item") || null == (childTag = node.getAttributes()).getNamedItem("groupID") || (groupID = Integer.parseInt(childTag.getNamedItem("groupID").getNodeValue())) <= 0 || null == childTag.getNamedItem("attrID")) continue;
            TIntArrayList idList = new TIntArrayList();
            TEGnlXMLParse.parseIntListByMarco(childTag.getNamedItem("attrID").getNodeValue(), idList);
            if (idList.isEmpty()) continue;
            if (!this.m_group2AttrsMap.containsKey(groupID)) {
                this.m_group2AttrsMap.put(groupID, (Object)idList);
            }
            int jSize = idList.size();
            for (int j = 0; j < jSize; ++j) {
                this.m_attr2GroupMap.put(idList.get(j), groupID);
            }
        }
    }

    private void incTimeOutCounter(int devType) {
        if (this.m_timeOutCounter.containsKey(devType)) {
            int timeCounter = this.m_timeOutCounter.get(devType);
            this.m_timeOutCounter.put(devType, timeCounter + 1);
        } else {
            this.m_timeOutCounter.put(devType, 1);
        }
    }

    private int getXMLAttrEntry(TEGenCfgQxMsg qxMsg, int attrID) {
        qxMsg.m_pXMLEntry = null;
        TEFuncEntry funcEnctry = TEGnlVar.getInstance().getXMLCmdEntry(this.m_nCmdCode);
        if (funcEnctry == null) {
            return 1090596630;
        }
        String action = funcEnctry.action;
        Node childTag = this.getXMLActionEntry(action);
        if (childTag == null || !childTag.hasChildNodes()) {
            return 1090596627;
        }
        NodeList nodeList = childTag.getChildNodes();
        TIntArrayList result = new TIntArrayList();
        Node node = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodeList.item(i);
            if (!node.getNodeName().equals("attr")) continue;
            result.clear();
            TEGnlXMLParse.parseIntListByMarco(node.getAttributes().getNamedItem("id").getNodeValue(), result);
            if (attrID != -1 && !result.contains(attrID)) continue;
            qxMsg.m_pXMLEntry = node;
            break;
        }
        if (null == qxMsg.m_pXMLEntry) {
            Document pCoreRootTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(4, 255, this.m_nCmdCode);
            nodeList = pCoreRootTag.getElementsByTagName("action");
            Node childTag2 = null;
            NodeList secNodeList = null;
            Node secNode = null;
            int jSize = nodeList.getLength();
            block1: for (int j = 0; j < jSize; ++j) {
                childTag2 = nodeList.item(j);
                if (!childTag2.getAttributes().getNamedItem("name").getNodeValue().equals(action)) continue;
                secNodeList = childTag2.getChildNodes();
                int kSize = secNodeList.getLength();
                for (int k = 0; k < kSize; ++k) {
                    secNode = secNodeList.item(k);
                    if (!secNode.getNodeName().equals("attr")) continue;
                    result.clear();
                    TEGnlXMLParse.parseIntListByMarco(secNode.getAttributes().getNamedItem("id").getNodeValue(), result);
                    if (attrID != -1 && !result.contains(attrID)) continue;
                    qxMsg.m_pXMLEntry = secNode;
                    continue block1;
                }
            }
        }
        if (null == qxMsg.m_pXMLEntry) {
            return 1090596627;
        }
        return 0;
    }

    private Node getXMLActionEntry(String actionName) {
        if (null == this.m_pRootTag) {
            return null;
        }
        NodeList nodeList = this.m_pRootTag.getElementsByTagName("action");
        Node childTag = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.getAttributes().getNamedItem("name").getNodeValue().equals(actionName)) continue;
            return childTag;
        }
        TEGnlScriptFileMgr pFileMgr = TEGnlScriptFileMgr.getInstance();
        Document pCoreRootTag = pFileMgr.getScriptDesc(4, 255, this.m_nCmdCode);
        nodeList = pCoreRootTag.getElementsByTagName("action");
        int size2 = nodeList.getLength();
        for (int i = 0; i < size2; ++i) {
            childTag = nodeList.item(i);
            if (childTag.getAttributes().getNamedItem(actionName) == null) continue;
            return childTag;
        }
        return null;
    }

    private void insertErrorCodeINSubOPerater(int errCode, Map<TEGenKey, TEGenValue> allData, List<Map.Entry> allDataList, int itFrom, int itEnd, int attrID) {
        Map.Entry entry = null;
        for (int it = itFrom; it < allDataList.size(); ++it) {
            entry = allDataList.get(it);
            if (((TEGenKey)entry.getKey()).attrID == attrID) {
                ((TEGenValue)entry.getValue()).errCode = errCode;
            }
            this.insertErrorCodeToGroupAttr(((TEGenKey)entry.getKey()).objectID, ((TEGenKey)entry.getKey()).attrID, errCode, allData);
        }
    }
}

