/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.bscfg.installcp.TECPDBMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.frame.TEAttrDesc;
import com.huawei.nglct.gencfg.frame.TEEMS2GnlAttrRecord;
import com.huawei.nglct.gencfg.frame.TEGnlCpAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlNEAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlPortAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlScriptFileMgr;
import com.huawei.nglct.gencfg.frame.TEGnlValueSDMgr;
import com.huawei.nglct.gencfg.frame.TEGnlValueUnit;
import com.huawei.nglct.gencfg.frame.TEIDCondition;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.gencfg.frame.attrvaluernge.AttrValueRangeConditions;
import com.huawei.nglct.gencfg.frame.attrvaluernge.BoardModeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.BoardTypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.CrossModeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.NETypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.PortAndPathCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.PortModeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.PortTypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.ShelfTypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.VersionCondition;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGnlAttrMgr
implements TESDMgrInterface {
    private static final int COMMON_ENVCTRL_ATTRIB_BASE = 86016;
    private static final int ENVCTRL_PMU_PMUTYPE = 86026;
    private static TEGnlAttrMgr instance = null;
    private TIntObjectHashMap<TEAttrDesc> m_attrMap = new TIntObjectHashMap();
    private Hashtable<String, List<AttrValueRangeConditions>> valueRangeTable = new Hashtable();
    private Map<String, Integer> m_attrListForSaveDB = new Hashtable<String, Integer>();
    private TIntObjectHashMap<TIntArrayList> m_attrTypeMap = new TIntObjectHashMap();
    private List<TEEMS2GnlAttrRecord> m_attrTransList = new ArrayList<TEEMS2GnlAttrRecord>();
    private SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
    private boolean attrib_description_inited = false;
    private boolean attrib_transition_inited = false;

    private TEGnlAttrMgr() {
        this.m_attrMap.clear();
        this.m_attrTransList.clear();
    }

    public static synchronized TEGnlAttrMgr getInstance() {
        if (null == instance) {
            instance = new TEGnlAttrMgr();
        }
        return instance;
    }

    private synchronized void loadAttribTransitionFile() {
        if (this.attrib_transition_inited) {
            return;
        }
        this.initAttrTransMap();
        this.attrib_transition_inited = true;
    }

    public TEAttrDesc getAttrDesc(int attrID) {
        return (TEAttrDesc)this.m_attrMap.get(attrID);
    }

    public int getSupportType(int attrID) {
        if (this.m_attrMap.containsKey(attrID)) {
            return ((TEAttrDesc)this.m_attrMap.get(attrID)).getSupportType();
        }
        return 0;
    }

    public int getAttrDefaultIntValue(int attrID, XMLEquipmentInfo equipInfo) {
        TEAttrDesc attrDesc = null;
        if (this.m_attrMap.containsKey(attrID)) {
            attrDesc = (TEAttrDesc)this.m_attrMap.get(attrID);
            List<TEIDCondition> defaultValueList = attrDesc.getDefaultValueMap();
            int size = defaultValueList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isFitCondition(defaultValueList.get((int)i).condition, equipInfo)) continue;
                return Integer.parseInt((String)defaultValueList.get((int)i).condition.get("value").get(0));
            }
        }
        return 0;
    }

    public String getAttrDefaultStringValue(int attrID, XMLEquipmentInfo equipInfo) {
        TEAttrDesc attrDesc = null;
        if (this.m_attrMap.containsKey(attrID)) {
            attrDesc = (TEAttrDesc)this.m_attrMap.get(attrID);
            List<TEIDCondition> defaultValueList = attrDesc.getDefaultStrValueMap();
            int size = defaultValueList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isFitCondition(defaultValueList.get((int)i).condition, equipInfo)) continue;
                return (String)defaultValueList.get((int)i).condition.get("value").get(0);
            }
        }
        return "";
    }

    public TIntArrayList getAttrObjType(int attrID) {
        if (this.m_attrMap.containsKey(attrID)) {
            return ((TEAttrDesc)this.m_attrMap.get(attrID)).getAttrObjTypeList();
        }
        return new TIntArrayList();
    }

    public int getAttrValueType(int attrID) {
        if (this.m_attrMap.containsKey(attrID)) {
            return ((TEAttrDesc)this.m_attrMap.get(attrID)).getValueType();
        }
        return 2;
    }

    public int getSaveType(int attrID) {
        if (this.m_attrMap.containsKey(attrID)) {
            return ((TEAttrDesc)this.m_attrMap.get(attrID)).getSaveType();
        }
        return 1;
    }

    public void initialize() {
        if (this.attrib_description_inited) {
            return;
        }
        this.m_attrMap.clear();
        this.m_attrTypeMap.clear();
        try {
            TEGnlScriptFileMgr pGnlMgr = TEGnlScriptFileMgr.getInstance();
            Document m_pRootTag = pGnlMgr.getScriptDesc(3);
            ArrayList<Document> expandNodeList = new ArrayList<Document>();
            if (null != m_pRootTag) {
                this.gnlExpandScript(m_pRootTag, expandNodeList);
            }
            Document tempNode = null;
            int length = expandNodeList.size();
            for (int i = 0; i < length; ++i) {
                tempNode = (Document)expandNodeList.get(i);
                this.initAttr(tempNode);
            }
            this.classifyAttrID();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file 'attrib_description.xml' failed:" + e);
        }
        this.attrib_description_inited = true;
    }

    public void gnlExpandScript(Document pRoot, List<Document> expandList) {
        if (pRoot == null || !pRoot.hasChildNodes()) {
            return;
        }
        Document subRoot = null;
        NodeList nodeList = pRoot.getElementsByTagName("include");
        Node tempNode = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            tempNode = nodeList.item(i);
            boolean bExpand = false;
            if (tempNode != null) {
                Node nameNode = tempNode.getAttributes().getNamedItem("name");
                if (null != nameNode) {
                    String sValue = nameNode.getNodeValue();
                    String strFile = TEGnlScriptFileMgr.getInstance().getScriptDir();
                    strFile = strFile + sValue;
                    TELogFactory.getNormalLogger().info(strFile);
                    subRoot = TEParseXMLFile.parseFile(strFile);
                }
                bExpand = true;
            }
            if (!bExpand || subRoot == null) continue;
            expandList.add(subRoot);
        }
    }

    public void parseAttrNode(Node attrNode) {
        if (attrNode == null || !attrNode.hasChildNodes()) {
            return;
        }
        TEGnlValueUnit valueUnit = new TEGnlValueUnit();
        NamedNodeMap nodeMap = attrNode.getAttributes();
        Node idNode = nodeMap.getNamedItem("id");
        if (idNode == null || idNode.getNodeValue().equals("") || idNode.getNodeValue().equals("0")) {
            return;
        }
        int attrID = this.mgr.parseInt(idNode.getNodeValue());
        TEAttrDesc attrMap = (TEAttrDesc)this.m_attrMap.get(attrID);
        if (null == attrMap) {
            attrMap = new TEAttrDesc();
            attrMap.setAttrID(attrID);
            attrMap.setAttrName(idNode.getNodeValue());
            this.m_attrMap.put(attrID, (Object)attrMap);
        }
        NodeList secNodeList = attrNode.getChildNodes();
        Node child = null;
        NamedNodeMap secNodeMap = null;
        int secLength = secNodeList.getLength();
        for (int j = 0; j < secLength; ++j) {
            List<Comparable> conditions;
            child = secNodeList.item(j);
            if (child.getNodeName().equals("define")) {
                secNodeMap = child.getAttributes();
                this.initAttrMap(secNodeMap, attrMap, valueUnit);
                continue;
            }
            if (child.getNodeName().equals("attr_access")) {
                conditions = new ArrayList<TEIDCondition>();
                this.parseAttrCondition(child, "value", conditions);
                attrMap.getAccessAttrMap().addAll(conditions);
                continue;
            }
            if (child.getNodeName().equals("value_range")) {
                conditions = this.valueRangeTable.get(idNode.getNodeValue());
                if (null == conditions) {
                    conditions = new ArrayList();
                    this.valueRangeTable.put(idNode.getNodeValue(), conditions);
                }
                conditions.addAll(this.parseValueRange(child.getChildNodes()));
                continue;
            }
            if (child.getNodeName().equals("default_value")) {
                this.parseAttrCondition(child, "value", attrMap.getDefaultStrValueMap(), attrMap.getValueType());
                continue;
            }
            if (!child.getNodeName().equals("dm_access") || !child.hasAttributes()) continue;
            this.fillSpecializedDMAccess(child, attrMap);
            NamedNodeMap thrdNodeMap = child.getAttributes();
            List<TEIDCondition> pattrs = null;
            int kSize = thrdNodeMap.getLength();
            for (int k = 0; k < kSize; ++k) {
                Node tempNode = thrdNodeMap.item(k);
                String nodeName = tempNode.getNodeName();
                if ("IsUpLoad".equals(nodeName)) {
                    pattrs = attrMap.getUploadAttrs();
                } else if ("IsDownLoad".equals(nodeName)) {
                    pattrs = attrMap.getDownloadAttrs();
                } else if ("IsSynCheck".equals(nodeName)) {
                    pattrs = attrMap.getSyncCheckAttrs();
                } else if ("IsCopy".equals(nodeName)) {
                    pattrs = attrMap.getCopyAttrs();
                } else {
                    if (!"IsScrip".equals(nodeName)) continue;
                    pattrs = attrMap.getScriptAttrs();
                }
                if (!tempNode.getNodeValue().equals("1")) continue;
                TEIDCondition condition = new TEIDCondition();
                condition.value = tempNode.getNodeValue();
                pattrs.add(condition);
            }
        }
        if (attrMap.getSaveType() == 0 && !this.m_attrListForSaveDB.containsKey(attrMap.getAttrName())) {
            this.m_attrListForSaveDB.put(attrMap.getAttrName(), attrMap.getAttrID());
        }
    }

    public void initAttr(Document tag) {
        if (null == tag || !tag.hasChildNodes()) {
            return;
        }
        NodeList nodeList = tag.getElementsByTagName("attr");
        Node childTag = null;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            childTag = nodeList.item(i);
            this.parseAttrNode(childTag);
        }
    }

    public Map<String, Integer> getM_attrListForSaveDB() {
        return this.m_attrListForSaveDB;
    }

    private void initAttrMap(NamedNodeMap secNodeMap, TEAttrDesc attrMap, TEGnlValueUnit valueUnit) {
        if (null == secNodeMap || secNodeMap.getLength() == 0) {
            return;
        }
        boolean bAttrNeedUnit = false;
        Node tempNode = null;
        if (this.isNodeValid(secNodeMap, "type")) {
            tempNode = secNodeMap.getNamedItem("type");
            attrMap.setValueType(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "supportType")) {
            tempNode = secNodeMap.getNamedItem("supportType");
            attrMap.setSupportType(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "saveType")) {
            tempNode = secNodeMap.getNamedItem("saveType");
            attrMap.setSaveType(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "FuncType")) {
            tempNode = secNodeMap.getNamedItem("FuncType");
            attrMap.setAttrFuncType(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "AttribObjectType")) {
            tempNode = secNodeMap.getNamedItem("AttribObjectType");
            this.mgr.parseIntList(tempNode.getNodeValue(), attrMap.getAttrObjTypeList());
        }
        if (this.isNodeValid(secNodeMap, "InitType")) {
            tempNode = secNodeMap.getNamedItem("InitType");
            attrMap.setInitType(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "haveMO")) {
            tempNode = secNodeMap.getNamedItem("haveMO");
            attrMap.setHaveMO(this.mgr.parseInt(tempNode.getNodeValue()));
        }
        if (this.isNodeValid(secNodeMap, "NumUnit")) {
            tempNode = secNodeMap.getNamedItem("NumUnit");
            valueUnit.m_iUnit = Integer.parseInt(tempNode.getNodeValue());
            bAttrNeedUnit = true;
        }
        if (this.isNodeValid(secNodeMap, "StrUnit")) {
            tempNode = secNodeMap.getNamedItem("StrUnit");
            valueUnit.m_strUnit = tempNode.getNodeValue();
            bAttrNeedUnit = true;
        }
        if (this.isNodeValid(secNodeMap, "NeedRes")) {
            tempNode = secNodeMap.getNamedItem("NeedRes");
            valueUnit.m_bNeedRes = tempNode.getNodeValue().equals("1");
            bAttrNeedUnit = true;
        }
        if (bAttrNeedUnit) {
            TEGnlValueSDMgr.getInstance().addUnitRecord(attrMap.getAttrID(), valueUnit);
        }
    }

    private List<AttrValueRangeConditions> parseValueRange(NodeList valueRangeNodeList) {
        ArrayList<AttrValueRangeConditions> conditions = new ArrayList<AttrValueRangeConditions>();
        Node child = null;
        String valueStr = "";
        int secLength = valueRangeNodeList.getLength();
        for (int j = 0; j < secLength; ++j) {
            Node untypenode;
            Node decimal;
            Node step;
            Node exclude;
            NamedNodeMap nodeMap;
            Node idNode;
            child = valueRangeNodeList.item(j);
            if (!child.getNodeName().equals("item") || (idNode = (nodeMap = child.getAttributes()).getNamedItem("value")) == null) continue;
            valueStr = idNode.getNodeValue();
            AttrValueRangeConditions rageCon = new AttrValueRangeConditions();
            ArrayList<String> attrValueRange = new ArrayList<String>();
            String[] valueStrs = valueStr.split("~");
            if (valueStrs.length == 2) {
                attrValueRange.add(valueStrs[0].substring(1, valueStrs[0].length() - 1));
                attrValueRange.add(valueStrs[1].substring(1, valueStrs[1].length() - 1));
                rageCon.setAttrValueRange(attrValueRange);
                rageCon.setValueType(1);
            } else {
                this.convertNodeValueToValueRangeList(idNode.getNodeValue(), attrValueRange);
                rageCon.setAttrValueRange(attrValueRange);
                rageCon.setValueType(0);
            }
            Node defaultMode = nodeMap.getNamedItem("default");
            if (defaultMode != null && !defaultMode.getNodeValue().equals("default")) {
                rageCon.setDefaultValue(defaultMode.getNodeValue());
            }
            if ((exclude = nodeMap.getNamedItem("exclude")) != null && !exclude.getNodeValue().equals("exclude")) {
                rageCon.setExclude(exclude.getNodeValue());
            }
            if ((step = nodeMap.getNamedItem("step")) != null && !step.getNodeValue().equals("step")) {
                rageCon.setStep(step.getNodeValue());
            }
            if ((decimal = nodeMap.getNamedItem("decimal")) != null && !decimal.getNodeValue().equals("decimal")) {
                rageCon.setDecimal(decimal.getNodeValue());
            }
            if ((untypenode = nodeMap.getNamedItem("untype")) != null && !untypenode.getNodeValue().equals("untype")) {
                rageCon.setUntypeFlag(Integer.parseInt(untypenode.getNodeValue()));
            }
            this.addAttrCondition(nodeMap, rageCon);
            conditions.add(rageCon);
        }
        return conditions;
    }

    private void convertNodeValueToValueRangeList(String nodeValue, List<String> attrValueRange) {
        String[] numString = this.splitIntString(nodeValue);
        int size = numString.length;
        for (int i = 0; i < size; ++i) {
            String numberStr = numString[i].trim();
            int indexSplit = numberStr.indexOf("-");
            if (indexSplit > 0) {
                String[] numSplitStr = numberStr.split("-");
                int start = 0;
                int end = 0;
                try {
                    start = Integer.decode(numSplitStr[0].trim());
                    end = Integer.decode(numSplitStr[1].trim());
                    for (int j = start; j <= end; ++j) {
                        attrValueRange.add(String.valueOf(j));
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("Range: " + numberStr + " is invalid.");
                    continue;
                }
            }
            int macroValue = SDXMLInterpreterMgr.getInstance().getMacroValueByName(numberStr);
            if (macroValue != -1) {
                attrValueRange.add(String.valueOf(macroValue));
                continue;
            }
            attrValueRange.add(numberStr);
        }
    }

    private String[] splitIntString(String numStr) {
        String[] strResult = new String[]{};
        if (null != numStr && !"".equalsIgnoreCase(numStr.trim())) {
            numStr = numStr.replace("[", "");
            numStr = numStr.replace("]", "");
            strResult = numStr.split(",");
        }
        return strResult;
    }

    private void addAttrCondition(NamedNodeMap nodeMap, AttrValueRangeConditions rageCon) {
        Node crossModeNode;
        Node portypeNode;
        Node portModeNode;
        Node boardmodeNode;
        Node portNode;
        Node cpTypeNode;
        Node neversionNode;
        Node shelfTypeNode;
        Node neTypeNode = nodeMap.getNamedItem("neType");
        if (neTypeNode != null && !neTypeNode.getNodeValue().equals("")) {
            NETypeCondition typeCon = new NETypeCondition();
            typeCon.setSupportNE(neTypeNode.getNodeValue());
            rageCon.addCondition(typeCon);
        }
        if ((shelfTypeNode = nodeMap.getNamedItem("shelfType")) != null && !shelfTypeNode.getNodeValue().equals("")) {
            ShelfTypeCondition boardCon = new ShelfTypeCondition();
            boardCon.setShelfType(shelfTypeNode.getNodeValue());
            rageCon.addCondition(boardCon);
        }
        if ((neversionNode = nodeMap.getNamedItem("neversion")) != null && !neversionNode.getNodeValue().equals("")) {
            VersionCondition verCon = new VersionCondition();
            verCon.setSupportVersion(neversionNode.getNodeValue());
            rageCon.addCondition(verCon);
        }
        if ((cpTypeNode = nodeMap.getNamedItem("cpType")) != null && !cpTypeNode.getNodeValue().equals("")) {
            BoardTypeCondition boardCon = new BoardTypeCondition();
            boardCon.setSupportBoard(cpTypeNode.getNodeValue());
            rageCon.addCondition(boardCon);
        }
        if ((portNode = nodeMap.getNamedItem("port_no_list")) != null && !portNode.getNodeValue().equals("")) {
            PortAndPathCondition portCon = new PortAndPathCondition();
            portCon.setSupportPort(portNode.getNodeValue());
            Node pathNode = nodeMap.getNamedItem("path_list");
            if (pathNode != null && !pathNode.getNodeValue().equals("")) {
                portCon.setSupportpatch(pathNode.getNodeValue());
            }
            rageCon.addCondition(portCon);
        }
        if ((boardmodeNode = nodeMap.getNamedItem("boardmode")) != null && !boardmodeNode.getNodeValue().equals("")) {
            BoardModeCondition boardModeCon = new BoardModeCondition();
            boardModeCon.setSupportBoardMode(boardmodeNode.getNodeValue());
            rageCon.addCondition(boardModeCon);
        }
        if ((portModeNode = nodeMap.getNamedItem("portmode")) != null && !portModeNode.getNodeValue().equals("")) {
            PortModeCondition portModeCon = new PortModeCondition();
            portModeCon.setSupportPortMode(portModeNode.getNodeValue());
            rageCon.addCondition(portModeCon);
        }
        if ((portypeNode = nodeMap.getNamedItem("portype")) != null && !portypeNode.getNodeValue().equals("")) {
            PortTypeCondition portypeCon = new PortTypeCondition();
            portypeCon.setSupportPortType(portypeNode.getNodeValue());
            rageCon.addCondition(portypeCon);
        }
        if ((crossModeNode = nodeMap.getNamedItem("crossmode")) != null && !crossModeNode.getNodeValue().equals("")) {
            CrossModeCondition crossModeCon = new CrossModeCondition();
            crossModeCon.setSupportCrossMode(crossModeNode.getNodeValue());
            rageCon.addCondition(crossModeCon);
        }
    }

    private boolean isNodeValid(NamedNodeMap secNodeMap, String nodeName) {
        Node tempNode = secNodeMap.getNamedItem(nodeName);
        return tempNode != null && !tempNode.getNodeValue().equals("");
    }

    public void parseAttrCondition(Node pXMLTag, String attrName, List<TEIDCondition> attrVect) {
        this.parseAttrCondition(pXMLTag, attrName, attrVect, 0);
    }

    private void parseAttrCondition(Node pXMLTag, String attrName, List<TEIDCondition> attrVect, int fieldType) {
        if (null != pXMLTag && pXMLTag.hasChildNodes()) {
            Node tempNode = null;
            NodeList nodeList = pXMLTag.getChildNodes();
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                TEIDCondition idCondition;
                tempNode = nodeList.item(i);
                if (0 != this.parseCondition(tempNode, attrName, idCondition = new TEIDCondition(), fieldType)) continue;
                attrVect.add(idCondition);
            }
        }
    }

    private int parseCondition(Node pXmlTag, String attrName, TEIDCondition idCondition, int fieldType) {
        if (null == pXmlTag || !pXmlTag.hasAttributes()) {
            return 1;
        }
        NamedNodeMap nodeMap = pXmlTag.getAttributes();
        String itemName = null;
        String itemValue = null;
        ArrayList<String> tempList = null;
        int len = nodeMap.getLength();
        for (int i = 0; i < len; ++i) {
            itemName = nodeMap.item(i).getNodeName();
            itemValue = nodeMap.item(i).getNodeValue();
            if (itemName.equals(attrName)) {
                if (0 == fieldType) {
                    idCondition.value = String.valueOf(this.mgr.parseInt(itemValue));
                    continue;
                }
                idCondition.value = itemValue;
                continue;
            }
            if ("neVersion".equals(itemName)) {
                tempList = new ArrayList<String>();
                if (0 != this.parseVerFromTo(itemValue, tempList)) continue;
                idCondition.condition.put("neVersion", tempList);
                continue;
            }
            if ("neType".equals(itemName)) {
                tempList = this.parseStrNumList(itemValue);
                idCondition.condition.put("neType", tempList);
                continue;
            }
            if ("dependExistBd".equals(itemName)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                SDXMLInterpreterMgr.getInstance().parseIntList(itemValue, list);
                idCondition.condition.put("dependExistBd", list);
                continue;
            }
            tempList = new ArrayList();
            this.parseStrList(itemValue, tempList);
            idCondition.condition.put(itemName, tempList);
        }
        return 0;
    }

    public void fillSpecializedDMAccess(Node pXMLTag, TEAttrDesc attrDesc) {
        if (null == pXMLTag) {
            return;
        }
        ArrayList<TEIDCondition> idAttrVector = new ArrayList<TEIDCondition>();
        this.parseAttrCondition(pXMLTag, "value", idAttrVector);
        int size = idAttrVector.size();
        for (int i = 0; i < size; ++i) {
            TEIDCondition condition = (TEIDCondition)idAttrVector.get(i);
            if (!condition.condition.containsKey("dm_type")) continue;
            ArrayList tempArr = condition.condition.get("dm_type");
            int len = tempArr.size();
            for (int j = 0; j < len; ++j) {
                int itDM = Integer.parseInt((String)tempArr.get(j));
                List<TEIDCondition> pattrs = null;
                switch (itDM) {
                    case 0: {
                        pattrs = attrDesc.getUploadAttrs();
                        break;
                    }
                    case 1: {
                        pattrs = attrDesc.getDownloadAttrs();
                        break;
                    }
                    case 2: {
                        pattrs = attrDesc.getCopyAttrs();
                        break;
                    }
                    case 3: {
                        pattrs = attrDesc.getSyncCheckAttrs();
                        break;
                    }
                    case 4: {
                        pattrs = attrDesc.getScriptAttrs();
                        break;
                    }
                }
                if (null == pattrs) continue;
                pattrs.add(condition);
            }
        }
    }

    private int parseVerFromTo(String str, ArrayList<String> tempList) {
        if ("".equals(str)) {
            return 77589;
        }
        tempList.clear();
        if (str.indexOf(91) != -1 && str.indexOf(93) != -1) {
            str = str.substring(1, str.length() - 1);
            String[] tempArr = str.split("-");
            tempList.add(tempArr[0]);
            tempList.add(tempArr[1]);
            return 0;
        }
        return 77585;
    }

    private void parseStrList(String st, ArrayList<String> result) {
        if (st == null || st.length() == 0) {
            return;
        }
        result.clear();
        TIntArrayList intList = new TIntArrayList();
        this.mgr.parseIntList(st, intList);
        int m = intList.size();
        for (int i = 0; i < m; ++i) {
            result.add(String.valueOf(intList.get(i)));
        }
    }

    public ArrayList<String> parseStrNumList(String st) {
        ArrayList<String> resultList = new ArrayList<String>();
        String numStr = st;
        String[] strResult = new String[]{};
        if (null != st && !"".equalsIgnoreCase(st.trim())) {
            numStr = numStr.replace("[", "");
            numStr = numStr.replace("]", "");
            strResult = numStr.split(",");
        }
        int size = strResult.length;
        for (int i = 0; i < size; ++i) {
            String numberStr = strResult[i].trim();
            resultList.add(String.valueOf(this.mgr.parseInt(numberStr)));
        }
        return resultList;
    }

    private void classifyAttrID() {
        TIntObjectIterator iterDesc = this.m_attrMap.iterator();
        while (iterDesc.hasNext()) {
            iterDesc.advance();
            int attrType = ((TEAttrDesc)iterDesc.value()).getAttrFuncType();
            if (this.m_attrTypeMap.containsKey(attrType)) {
                ((TIntArrayList)this.m_attrTypeMap.get(attrType)).add(iterDesc.key());
                continue;
            }
            TIntArrayList tmpVec = new TIntArrayList();
            tmpVec.add(iterDesc.key());
            this.m_attrTypeMap.put(attrType, (Object)tmpVec);
        }
    }

    public void initAttrTransMapSingle() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.initAttrTransMap();
        }
    }

    private synchronized void initAttrTransMap() {
        this.attrib_transition_inited = true;
        this.m_attrTransList.clear();
        try {
            Document pRootTag = TEGnlScriptFileMgr.getInstance().getScriptDesc(9);
            if (!pRootTag.hasChildNodes()) {
                return;
            }
            this.initAttrTrans(pRootTag);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file 'attrib_transition.xml' failed:" + e);
        }
    }

    private void initAttrTrans(Document root) {
        if (null == root || !root.hasChildNodes()) {
            return;
        }
        NodeList nodeList = root.getElementsByTagName("attrib");
        Node childTag = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.hasChildNodes()) continue;
            NamedNodeMap attrMap = childTag.getAttributes();
            TEEMS2GnlAttrRecord record = new TEEMS2GnlAttrRecord();
            Node attr = null;
            int len = attrMap.getLength();
            for (int j = 0; j < len; ++j) {
                attr = attrMap.item(j);
                if (attr.getNodeName().equals("attrib_id")) {
                    record.emsAttrID = this.mgr.parseInt(attr.getNodeValue());
                    continue;
                }
                if (!attr.getNodeName().equals("type")) continue;
                record.valueType = this.mgr.parseInt(attr.getNodeValue());
            }
            NodeList secNodeList = childTag.getChildNodes();
            int kSize = secNodeList.getLength();
            for (int k = 0; k < kSize; ++k) {
                Node child = secNodeList.item(k);
                if (!child.getNodeName().equals("object") || !child.hasAttributes()) continue;
                NamedNodeMap tempNodeMap = child.getAttributes();
                Node tempNode = null;
                if (this.isNodeValid(tempNodeMap, "fb_type")) {
                    tempNode = tempNodeMap.getNamedItem("fb_type");
                    record.fbType = this.mgr.parseInt(tempNode.getNodeValue());
                }
                if (this.isNodeValid(tempNodeMap, "gencfg_attrib")) {
                    tempNode = tempNodeMap.getNamedItem("gencfg_attrib");
                    record.gnlAttrID = this.mgr.parseInt(tempNode.getNodeValue());
                }
                if (this.isNodeValid(tempNodeMap, "gencfg_object_type")) {
                    tempNode = tempNodeMap.getNamedItem("gencfg_object_type");
                    record.objType = this.mgr.parseInt(tempNode.getNodeValue());
                }
                if (this.isNodeValid(tempNodeMap, "get_cmdcode")) {
                    tempNode = tempNodeMap.getNamedItem("get_cmdcode");
                    record.getCmdCode = this.mgr.parseInt(tempNode.getNodeValue());
                }
                if (this.isNodeValid(tempNodeMap, "set_cmdcode")) {
                    tempNode = tempNodeMap.getNamedItem("set_cmdcode");
                    record.setCmdCode = this.mgr.parseInt(tempNode.getNodeValue());
                }
                if (this.isNodeValid(tempNodeMap, "used_flag")) {
                    tempNode = tempNodeMap.getNamedItem("used_flag");
                    record.attrUsedFlag = Integer.parseInt(tempNode.getNodeValue());
                }
                this.m_attrTransList.add((TEEMS2GnlAttrRecord)record.clone());
            }
        }
    }

    public TIntArrayList getAttrIDList(int attrType) {
        if (this.m_attrTypeMap.containsKey(attrType)) {
            return (TIntArrayList)this.m_attrTypeMap.get(attrType);
        }
        return new TIntArrayList();
    }

    public int getAttrDataManage(int attrID, int ucItem, XMLEquipmentInfo equipInfo, ArrayList<String> ucResult) {
        int errcode = 0;
        List<TEIDCondition> pattrs = null;
        if (this.m_attrMap.containsKey(attrID)) {
            TEAttrDesc attrDesc = (TEAttrDesc)this.m_attrMap.get(attrID);
            switch (ucItem) {
                case 0: {
                    pattrs = attrDesc.getUploadAttrs();
                    break;
                }
                case 1: {
                    pattrs = attrDesc.getDownloadAttrs();
                    break;
                }
                case 3: {
                    pattrs = attrDesc.getSyncCheckAttrs();
                    break;
                }
                case 2: {
                    pattrs = attrDesc.getCopyAttrs();
                    break;
                }
                case 4: {
                    pattrs = attrDesc.getScriptAttrs();
                    break;
                }
                default: {
                    errcode = 1090646017;
                }
            }
            if (null == pattrs) {
                return errcode;
            }
            boolean isFound = false;
            int size = pattrs.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isFitCondition(pattrs.get((int)i).condition, equipInfo)) continue;
                ucResult.add(pattrs.get((int)i).value);
                isFound = true;
                break;
            }
            if (!isFound) {
                errcode = 1090646017;
            }
        } else {
            errcode = 1090646017;
        }
        return errcode;
    }

    private boolean isFitCondition(HashMap conditionMap, XMLEquipmentInfo equipInfo) {
        if (conditionMap.isEmpty()) {
            return true;
        }
        Iterator itMap = conditionMap.entrySet().iterator();
        Map.Entry entry = null;
        while (itMap.hasNext()) {
            entry = itMap.next();
            String tempStr = (String)entry.getKey();
            ArrayList result = (ArrayList)entry.getValue();
            if ("neType".equals(tempStr)) {
                if (result.contains(String.valueOf(equipInfo.m_neType))) continue;
                return false;
            }
            if ("cpType".equals(tempStr)) {
                TESDCircuitPackRecord record = TECircuitPackDescription.getInstance().getCPRecord(equipInfo.m_cpType);
                if (null != record && result.contains(String.valueOf(record.getBoardType()))) continue;
                return false;
            }
            if ("slotID".equals(tempStr)) {
                if (result.contains(equipInfo.m_slotID)) continue;
                return false;
            }
            if ("pmuType".equals(tempStr)) {
                if (result.contains(equipInfo.m_pmuType)) continue;
                return false;
            }
            if ("neVersion".equalsIgnoreCase(tempStr)) {
                if (equipInfo.m_neVer <= Integer.parseInt((String)result.get(1)) && equipInfo.m_neVer >= Integer.parseInt((String)result.get(0))) continue;
                return false;
            }
            if ("ttpID".equals(tempStr) && !result.contains(equipInfo.m_ttpID)) {
                return false;
            }
            if (!"dependExistBd".equalsIgnoreCase(tempStr)) continue;
            List<TEBoard> boardList = TEConfigurationDataMgr.getInstance().getBoardList(equipInfo.m_neID);
            int len = boardList.size();
            for (int i = 0; i < len; ++i) {
                if (!result.contains(boardList.get(i).getBoardType())) continue;
                return true;
            }
            if (boardList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getAttrAccess(int attrID, XMLEquipmentInfo equipInfo) {
        if (this.m_attrMap.containsKey(attrID)) {
            TEAttrDesc desc = (TEAttrDesc)this.m_attrMap.get(attrID);
            List<TEIDCondition> m_accessAttrMap = desc.getAccessAttrMap();
            Collections.sort(m_accessAttrMap);
            int m = m_accessAttrMap.size();
            for (int i = 0; i < m; ++i) {
                TEIDCondition condition = m_accessAttrMap.get(i);
                if (!this.isFitCondition(condition.condition, equipInfo)) continue;
                return Integer.parseInt(condition.value);
            }
        }
        return 0;
    }

    public int gnlAttrID2EMSAttrID(int gnlAttrID, int objType, TEEMS2GnlAttrRecord attrRecord) {
        this.loadAttribTransitionFile();
        TEEMS2GnlAttrRecord record = null;
        int m = this.m_attrTransList.size();
        for (int i = 0; i < m; ++i) {
            record = this.m_attrTransList.get(i);
            if (record.gnlAttrID != gnlAttrID || record.objType != objType && 0 != objType) continue;
            attrRecord.emsAttrID = record.emsAttrID;
            attrRecord.fbType = record.fbType;
            attrRecord.valueType = record.valueType;
            return 0;
        }
        attrRecord.emsAttrID = 0;
        attrRecord.fbType = 255;
        return 1090596633;
    }

    public void getGnlAttrsByEmsAttr(List<TEEMS2GnlAttrRecord> attrList, int emsAttrID, int useFlag) {
        this.loadAttribTransitionFile();
        attrList.clear();
        TEEMS2GnlAttrRecord record = null;
        int m = this.m_attrTransList.size();
        for (int i = 0; i < m; ++i) {
            record = this.m_attrTransList.get(i);
            if (record.emsAttrID != emsAttrID || (record.attrUsedFlag & useFlag) == 0) continue;
            attrList.add(record);
        }
    }

    public int getEmsAttrUsedFlag(int EMSAttrID, int fbType) {
        this.loadAttribTransitionFile();
        int biFBType = TEFuncBlockDescription.getInstance().getBidirFBType(fbType);
        TEEMS2GnlAttrRecord record = null;
        int m = this.m_attrTransList.size();
        for (int i = 0; i < m; ++i) {
            record = this.m_attrTransList.get(i);
            if (record.emsAttrID != EMSAttrID || record.fbType != fbType && record.fbType != biFBType) continue;
            return record.attrUsedFlag;
        }
        return 0;
    }

    public int emsAttrID2GnlAttrID(int EMSAttrID, int fbType, TEEMS2GnlAttrRecord attrRocord) {
        this.loadAttribTransitionFile();
        int biFBType = TEFuncBlockDescription.getInstance().getBidirFBType(fbType);
        int size = this.m_attrTransList.size();
        for (int i = 0; i < size; ++i) {
            TEEMS2GnlAttrRecord it = this.m_attrTransList.get(i);
            if (it.emsAttrID != EMSAttrID || it.fbType != fbType && it.fbType != biFBType) continue;
            attrRocord.gnlAttrID = it.gnlAttrID;
            attrRocord.objType = it.objType;
            attrRocord.getCmdCode = it.getCmdCode;
            attrRocord.setCmdCode = it.setCmdCode;
            attrRocord.valueType = it.valueType;
            return 0;
        }
        return 1090596633;
    }

    public void getEMSAttrIDByTTPType(int fbType, List<Integer> attrIDList) {
        this.loadAttribTransitionFile();
        attrIDList.clear();
        int biFBType = TEFuncBlockDescription.getInstance().getBidirFBType(fbType);
        TEEMS2GnlAttrRecord it = null;
        int size = this.m_attrTransList.size();
        for (int i = 0; i < size; ++i) {
            it = this.m_attrTransList.get(i);
            if (it.fbType != fbType && it.fbType != biFBType) continue;
            attrIDList.add(it.emsAttrID);
        }
    }

    public int getNeSupportAttrAccess(TEObjectID objectID, int attrID) {
        TEGnlNEAttrMgr pNEMgr = TEGnlNEAttrMgr.getInstance();
        TEGnlAttrMgr pGenMgr = TEGnlAttrMgr.getInstance();
        TENEPO pNE = TECPDBMgr.getNEPO(objectID.getNeId());
        int access = 2;
        if (pNEMgr.isSupport(pNE.getType(), attrID)) {
            XMLEquipmentInfo equinfo = new XMLEquipmentInfo();
            equinfo.m_neType = pNE.getType();
            equinfo.m_neVer = pNE.getVersion();
            access = pGenMgr.getAttrAccess(attrID, equinfo);
        } else {
            access = 2;
        }
        return access;
    }

    public int getCpSupportAttrAccess(TEObjectID objectID, int attrID) {
        TENEPO pNE = TECPDBMgr.getNEPO(objectID.getNeId());
        TECircuitPack pBoard = TECPDBMgr.getBoardPO(objectID.getNeId(), objectID.getSlotId());
        return this.getCpSupportAttrAccess(pNE, pBoard, attrID);
    }

    public int getCpSupportAttrAccess(TENEPO pNE, TECircuitPack pCP, int attrID) {
        int access = 2;
        if (null == pNE || null == pCP) {
            return access;
        }
        TEGnlCpAttrMgr pCpMgr = TEGnlCpAttrMgr.getInstance();
        TEGnlAttrMgr pGenMgr = TEGnlAttrMgr.getInstance();
        if (pCpMgr.isSupport(pCP.getTypeId(), attrID)) {
            XMLEquipmentInfo equinfo = new XMLEquipmentInfo();
            equinfo.m_cpType = pCP.getTypeId();
            equinfo.m_neType = pNE.getType();
            equinfo.m_neVer = pNE.getVersion();
            equinfo.m_slotID = pCP.getSlotId();
            ArrayList<TEOmniAttrib> value = new ArrayList<TEOmniAttrib>();
            pCP.getAttrib(86026, value);
            TEOmniAttrib iter = null;
            int m = value.size();
            for (int i = 0; i < m; ++i) {
                int nTmp;
                iter = (TEOmniAttrib)value.get(i);
                equinfo.m_pmuType = nTmp = Integer.parseInt(iter.getValue());
            }
            access = pGenMgr.getAttrAccess(attrID, equinfo);
        }
        return access;
    }

    public int getPortSupportAttrAccess(TEObjectID objectID, int attrID) {
        int access = 2;
        TEGnlAttrMgr pGenMgr = TEGnlAttrMgr.getInstance();
        access = this.getCpSupportAttrAccess(objectID, attrID);
        if (access == 2) {
            return access;
        }
        TENEPO pNE = TECPDBMgr.getNEPO(objectID.getNeId());
        if (null == pNE) {
            return access;
        }
        int slotID = objectID.get(2);
        TECircuitPack cp = TECPDBMgr.getBoardPO(objectID.getNeId(), slotID);
        int cpType = cp.getTypeId();
        if (TEGnlPortAttrMgr.getInstance().isPortSupportAttr(pNE, cpType, objectID.get(3), attrID)) {
            XMLEquipmentInfo equinfo = new XMLEquipmentInfo();
            equinfo.m_cpType = cpType;
            equinfo.m_neType = pNE.getType();
            equinfo.m_neVer = pNE.getVersion();
            equinfo.m_slotID = slotID;
            access = pGenMgr.getAttrAccess(attrID, equinfo);
        } else {
            access = 2;
        }
        return access;
    }

    public List<AttrValueRangeConditions> getAttrValueRangeConditions(String attrName) {
        List<AttrValueRangeConditions> conditions = this.valueRangeTable.get(attrName);
        if (conditions != null && !conditions.isEmpty()) {
            Collections.sort(conditions);
            return conditions;
        }
        return null;
    }

    @Override
    public void clear() {
        this.m_attrMap.clear();
        this.valueRangeTable.clear();
        this.m_attrListForSaveDB.clear();
        this.m_attrTypeMap.clear();
        this.attrib_description_inited = false;
    }
}

