/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.gencfg.frame.IGenCfgMsg;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEGnlDataMgrHelper;
import com.huawei.nglct.gencfg.frame.TEGnlXMLParse;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGenCfgQxMsg {
    private int nCmdCode;
    IGenCfgMsg m_pGenMsg;
    Node m_pXMLEntry;
    private ArrayList<Operation> operationList = new ArrayList();
    private String attrName = "";
    private ArrayList<Map.Entry<TEGenKey, TEGenValue>> entryList = new ArrayList();

    public TEGenCfgQxMsg() {
        this.m_pGenMsg = null;
        this.operationList.clear();
    }

    public TEGenCfgQxMsg(IGenCfgMsg msg, int attrID, int nCmdCode) {
        this.m_pGenMsg = msg;
        this.operationList.clear();
        this.m_pGenMsg.m_attrID = attrID;
        this.nCmdCode = nCmdCode;
    }

    public int syncHandleMessage(int timeOut) {
        int retCode = 0;
        this.getOperationList();
        if (this.operationList == null || this.operationList.isEmpty()) {
            return retCode;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.m_pGenMsg.m_neID, this.operationList, timeOut);
        retCode = result.retCode;
        this.handleMessage(retCode);
        return retCode;
    }

    private String getQXCmdName() {
        if (this.m_pXMLEntry == null) {
            return null;
        }
        this.attrName = this.m_pXMLEntry.getAttributes().getNamedItem("id").getNodeValue();
        NodeList nodeList = this.m_pXMLEntry.getChildNodes();
        Node qx5Node = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            qx5Node = nodeList.item(i);
            if (!qx5Node.getNodeName().equals("qx5_req_cmd_param")) continue;
            return this.processQx5Node(qx5Node);
        }
        return null;
    }

    public void getOperationList() {
        this.operationList.clear();
        this.entryList.clear();
        String cmdName = this.getQXCmdName();
        if (cmdName == null) {
            return;
        }
        int neId = this.m_pGenMsg.m_neID;
        try {
            TEConfigurationDataMgr.getInstance().getNE(neId);
            Operation operation = TECreateObjectFactory.getOperation(neId, cmdName);
            if (null == operation) {
                return;
            }
            Part[] inputPart = operation.getInput().getPart();
            Map<TEGenKey, TEGenValue> result = this.m_pGenMsg.m_pAttrData;
            Iterator<Map.Entry<TEGenKey, TEGenValue>> iter = result.entrySet().iterator();
            HashMap<TEGenKey, TEGenValue> tempMap = new HashMap<TEGenKey, TEGenValue>();
            Map.Entry<TEGenKey, TEGenValue> entry = null;
            TEGenKey key = null;
            TEObjectID objectID = null;
            while (iter.hasNext()) {
                entry = iter.next();
                key = entry.getKey();
                objectID = key.objectID;
                if (key.attrID != this.m_pGenMsg.m_attrID) continue;
                boolean isValidOper = true;
                for (int i = 0; i < inputPart.length && objectID.size() != i + 2; ++i) {
                    int portId;
                    if (objectID.get(i + 2) == 255) {
                        if (inputPart[i].hasDefault()) {
                            inputPart[i].setValue(inputPart[i].getDefault());
                            iter.remove();
                            objectID.set(i + 2, Integer.parseInt(inputPart[i].getDefault()));
                            this.m_pGenMsg.m_pObjectID.set(i + 2, Integer.parseInt(inputPart[i].getDefault()));
                            tempMap.put(key, entry.getValue());
                            continue;
                        }
                        isValidOper = false;
                        break;
                    }
                    if (i == 1 && (portId = objectID.getPortId()) > 65536) {
                        inputPart[i].setValue(String.valueOf(TEConfigurationDataMgr.getPortRelativeID(portId)));
                        continue;
                    }
                    inputPart[i].setValue(String.valueOf(objectID.get(i + 2)));
                }
                if (!isValidOper) continue;
                this.entryList.add(entry);
                if (this.m_pGenMsg.m_nCmdType == 1) {
                    inputPart[inputPart.length - 1].setValue(entry.getValue().sValue);
                }
                this.operationList.add((Operation)operation.clone());
            }
            result.putAll(tempMap);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
    }

    private void handleMessage(int retCode) {
        if (retCode != 0) {
            Iterator<TEGenValue> iter = this.m_pGenMsg.m_pAttrData.values().iterator();
            while (iter.hasNext()) {
                iter.next().errCode = retCode;
                iter.next().errorInfo = TEErrorResourceUtil.getErrorMessage(retCode).getErrorinfo();
            }
            return;
        }
        Operation oper = null;
        int size = this.operationList.size();
        for (int i = 0; i < size; ++i) {
            oper = this.operationList.get(i);
            Output[] outputArr = oper.getOutput();
            for (int j = 0; j < outputArr.length; ++j) {
                Map.Entry<TEGenKey, TEGenValue> entry = this.entryList.get(i);
                Output output = outputArr[j];
                int errorCode = Integer.valueOf(output.getFault(0).getCode());
                if (errorCode != 0) {
                    this.m_pGenMsg.m_nCmdErrCode = errorCode;
                }
                entry.getValue().errCode = errorCode;
                entry.getValue().errorInfo = TEErrorResourceUtil.getErrorMessage(errorCode).getErrorinfo();
                this.fillData(output, entry);
            }
        }
    }

    private void fillData(Output output, Map.Entry<TEGenKey, TEGenValue> entry) {
        if (this.m_pGenMsg.m_nCmdType != 0) {
            return;
        }
        if (output != null && output.getFault(0).getCode().equals("0")) {
            for (Map.Entry<TEGenKey, TEGenValue> tempEntry : this.m_pGenMsg.m_pAttrData.entrySet()) {
                String attrValue;
                if (!tempEntry.getKey().equals(entry.getKey())) continue;
                String webLctAttrName = TEGnlDataMgrHelper.getInstance().getAttrNameByID(this.m_pGenMsg.m_attrID);
                if (webLctAttrName == null || webLctAttrName.equals("")) {
                    webLctAttrName = this.attrName;
                }
                if ((attrValue = output.getPartValue(webLctAttrName)) == null) {
                    tempEntry.getValue().errCode = 50;
                    return;
                }
                tempEntry.getValue().sValue = attrValue;
            }
        }
    }

    private String processQx5Node(Node qx5Node) {
        NodeList childNodeList = qx5Node.getChildNodes();
        if (childNodeList.getLength() == 0) {
            return null;
        }
        int iSize = childNodeList.getLength();
        for (int i = 0; i < iSize; ++i) {
            Node secNode = childNodeList.item(i);
            if (secNode.getNodeName().equals("for_all_object")) {
                return this.processForAllNode(secNode);
            }
            if (secNode.getNodeName().equals("ptcode")) {
                Node ptcodeNode = secNode.getAttributes().getNamedItem("cmdcode");
                return ptcodeNode.getNodeValue();
            }
            if (!secNode.getNodeName().equals("case_start")) continue;
            return this.processCaseStartNode(secNode);
        }
        return null;
    }

    private String processCaseStartNode(Node startNode) {
        NodeList caseNodeList = startNode.getChildNodes();
        Node caseNode = null;
        int kSize = caseNodeList.getLength();
        for (int k = 0; k < kSize; ++k) {
            String cmdName;
            caseNode = caseNodeList.item(k);
            if (!caseNode.getNodeName().equals("case") || (cmdName = this.processCaseNode(caseNode)) == null) continue;
            return cmdName;
        }
        return null;
    }

    private String processCaseNode(Node caseNode) {
        if (caseNode.hasAttributes()) {
            Node cpTypeNode = caseNode.getAttributes().getNamedItem("cpType");
            if (cpTypeNode == null) {
                return null;
            }
            String supportCpType = cpTypeNode.getNodeValue();
            TIntArrayList cpTypeList = new TIntArrayList();
            TEGnlXMLParse.parseIntListByMarco(supportCpType, cpTypeList);
            int neid = this.m_pGenMsg.m_pObjectID.getNeId();
            int slotid = this.m_pGenMsg.m_pObjectID.getSlotId();
            int currBoardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            if (!cpTypeList.contains(currBoardType)) {
                return null;
            }
        }
        NodeList childNodeList = caseNode.getChildNodes();
        int size = childNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = childNodeList.item(i);
            if (tempNode.getNodeName().equals("for_all_object")) {
                return this.processForAllNode(tempNode);
            }
            if (!tempNode.getNodeName().equals("ptcode")) continue;
            Node ptcodeNode = tempNode.getAttributes().getNamedItem("cmdcode");
            return ptcodeNode.getNodeValue();
        }
        return null;
    }

    private String processForAllNode(Node forAllNode) {
        NodeList nodeList = forAllNode.getChildNodes();
        int kSize = nodeList.getLength();
        for (int k = 0; k < kSize; ++k) {
            Node thrdNode = nodeList.item(k);
            if (thrdNode.getNodeName().equals("ptcode")) {
                Node ptcodeNode = thrdNode.getAttributes().getNamedItem("cmdcode");
                return ptcodeNode.getNodeValue();
            }
            if (!thrdNode.getNodeName().equals("case_start")) continue;
            return this.processCaseStartNode(thrdNode);
        }
        return null;
    }
}

