/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.frame;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEEquipmentMacro {
    private static TEEquipmentMacro instance = null;
    private static TObjectIntHashMap<String> neTypeMap = new TObjectIntHashMap();

    private TEEquipmentMacro() {
        neTypeMap.clear();
        this.initialize();
    }

    public static synchronized TEEquipmentMacro getInstance() {
        if (instance == null) {
            instance = new TEEquipmentMacro();
        }
        return instance;
    }

    public void initialize() {
        try {
            String strServerDir = TEResourceManager.getPath() + File.separator;
            String strFilePath = strServerDir + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "model" + File.separator + "macro_var_equipment.xml";
            Document root = TEParseXMLFile.parseFile(strFilePath);
            if (!root.hasChildNodes()) {
                return;
            }
            NodeList nodeList = root.getElementsByTagName("macro_desc");
            Node childTag = null;
            Node attrNode = null;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                childTag = nodeList.item(i);
                if (!childTag.hasAttributes()) continue;
                NamedNodeMap nodeMap = childTag.getAttributes();
                int len = nodeMap.getLength();
                for (int j = 0; j < len; ++j) {
                    attrNode = nodeMap.item(j);
                    String neTypeName = attrNode.getNodeName();
                    int neTypeVaule = Integer.parseInt(attrNode.getNodeValue());
                    neTypeMap.put((Object)neTypeName, neTypeVaule);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file 'macro_var_equipment.xml' failed:" + e);
        }
    }

    public int getNeType(String neTypeName) {
        if (neTypeMap.containsKey((Object)neTypeName)) {
            return neTypeMap.get((Object)neTypeName);
        }
        return -1;
    }
}

