/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TETimeParams;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TimeZoneDateBean {
    private static final String TIME_FORMAT_FILE_NAME = "timeformat.xml";
    private static int TIME_OUT = 10;
    private static DeploymentMode IS_INTEGRATION = TESysManagerConstants.SYS_SINGLE_STATUS;
    private static String formatName = "yyyy-MM-dd HH:mm:ss";
    private int neid = 58897;
    private String enableTimeLocalization = "0";
    private boolean isSucceed = false;
    private int times = 0;
    private static boolean isGetFormat = false;
    private TETimeParams neTimeParams = new TETimeParams();
    public int nebaseyear = 1990;
    private static final int BASE_YEAR1 = 1990;
    private static final int BASE_YEAR2 = 1970;
    private static final int YEAR_START2 = 2;
    private static final String TIME_LOCALIZATION_DISABLED = "0";
    private static Map<String, String> TL1_MONTH_VALUE = new HashMap<String, String>();
    private static Map<String, String> TL1_WEEK_VALUE = new HashMap<String, String>();

    public TimeZoneDateBean(int neid, DeploymentMode deploymentMode) {
        this.neid = neid;
        IS_INTEGRATION = deploymentMode;
        this.initStaticData();
    }

    private void initStaticData() {
        TL1_MONTH_VALUE.put("JAN", "1");
        TL1_MONTH_VALUE.put("FEB", "2");
        TL1_MONTH_VALUE.put("MAR", "3");
        TL1_MONTH_VALUE.put("APR", "4");
        TL1_MONTH_VALUE.put("MAY", "5");
        TL1_MONTH_VALUE.put("JUN", "6");
        TL1_MONTH_VALUE.put("JUL", "7");
        TL1_MONTH_VALUE.put("AUG", "8");
        TL1_MONTH_VALUE.put("SEP", "9");
        TL1_MONTH_VALUE.put("OCT", "10");
        TL1_MONTH_VALUE.put("NOV", "11");
        TL1_MONTH_VALUE.put("DEC", "12");
        TL1_WEEK_VALUE.put("SUN", TIME_LOCALIZATION_DISABLED);
        TL1_WEEK_VALUE.put("MON", "1");
        TL1_WEEK_VALUE.put("TUE", "2");
        TL1_WEEK_VALUE.put("WED", "3");
        TL1_WEEK_VALUE.put("THU", "4");
        TL1_WEEK_VALUE.put("FRI", "5");
        TL1_WEEK_VALUE.put("SAT", "6");
    }

    public int getNeId() {
        return this.neid;
    }

    public TETimeParams getNETimeParams() {
        return this.neTimeParams;
    }

    public synchronized void setSucceed(boolean bool) {
        this.isSucceed = bool;
    }

    public synchronized boolean isSupportTimeLocation() {
        return !TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization);
    }

    public synchronized void getTL1NETimeZone() {
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = TECreateObjectFactory.getTL1Operation(this.neid, "RTRV-DAT");
        if (tl1Operation != null) {
            tl1OperList.add(tl1Operation);
        }
        if ((tl1Operation = TECreateObjectFactory.getTL1Operation(this.neid, "RTRV-DST")) != null) {
            tl1OperList.add(tl1Operation);
        }
        if (tl1OperList.isEmpty()) {
            return;
        }
        try {
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, tl1OperList, TIME_OUT);
            if (result.retCode == 0) {
                int len = tl1OperList.size();
                for (int i = 0; i < len; ++i) {
                    tl1Operation = (TL1Operation)tl1OperList.get(i);
                    if (tl1Operation.getName().equalsIgnoreCase("RTRV-DAT")) {
                        this.parseTL1RTRVDAT(tl1Operation);
                        continue;
                    }
                    if (!tl1Operation.getName().equalsIgnoreCase("RTRV-DST")) continue;
                    this.parseTL1RTRVDST(tl1Operation);
                }
            } else {
                TELogFactory.getNormalLogger().error("getTL1NETimeZone fail!Errcode=" + result.retCode);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getTL1NETimeZone fail!", (Throwable)e);
        }
    }

    private void parseTL1RTRVDAT(TL1Operation tl1Operation) {
        if (null != tl1Operation && 0 == tl1Operation.getOutMsg(0).getFault().getCompletionCode()) {
            MsgBlock output = tl1Operation.getOutMsg(0).getMsgBlock();
            if (null != output.getPart("TMZONE")) {
                String timezone = TEDateUtils.setNEStrToUtcStr(output.getPart("TMZONE").getValue());
                TimeZone zone = TimeZone.getTimeZone(timezone);
                this.neTimeParams.setTZOffset(zone.getRawOffset() / 60000);
            } else {
                TELogFactory.getNormalLogger().error("RTRV-DAT TMZONE is null!");
            }
        } else {
            TELogFactory.getNormalLogger().error("RTRV-DAT query fail!");
        }
    }

    private void parseTL1RTRVDST(TL1Operation tl1Operation) {
        if (null == tl1Operation || 0 != tl1Operation.getOutMsg(0).getFault().getCompletionCode()) {
            TELogFactory.getNormalLogger().error("RTRV-DST query fail!");
            return;
        }
        MsgBlock output = tl1Operation.getOutMsg(0).getMsgBlock();
        if (null != output.getPart("FLAG")) {
            String flag = output.getPart("FLAG").getValue();
            if ("ENABLE".equalsIgnoreCase(flag)) {
                this.neTimeParams.setIsUseDST(1);
            } else {
                this.neTimeParams.setIsUseDST(0);
            }
        }
        if (null != output.getPart("ADJMODE")) {
            String adjMode = output.getPart("ADJMODE").getValue();
            if ("BYWEEK".equalsIgnoreCase(adjMode)) {
                this.neTimeParams.setStartRule(1);
                this.neTimeParams.setEndRule(1);
            } else if ("BYDATE".equalsIgnoreCase(adjMode)) {
                this.neTimeParams.setStartRule(0);
                this.neTimeParams.setEndRule(0);
            }
        }
        if (null != output.getPart("ADJWAY") && null != output.getPart("ADJ_MINUTE")) {
            String adjway = output.getPart("ADJWAY").getValue();
            int adjtime = Integer.parseInt(output.getPart("ADJ_MINUTE").getValue());
            if (null == adjway || "".equals(adjway) || "FORWARD".equals(adjway)) {
                this.neTimeParams.setDSTOffset(adjtime);
            } else {
                this.neTimeParams.setDSTOffset(-adjtime);
            }
        }
        this.neTimeParams.setStartMonth(TL1_MONTH_VALUE.get(output.getPart("START_MONTH").getValue()));
        this.neTimeParams.setStartDay(output.getPart("START_DAY").getValue());
        this.neTimeParams.setStartWeekOfMonth(TL1_WEEK_VALUE.get(output.getPart("START_WEEKDAY").getValue()));
        this.neTimeParams.setStartHour(output.getPart("START_HOUR").getValue());
        this.neTimeParams.setStartMinute(output.getPart("START_MINUTE").getValue());
        this.neTimeParams.setEndMonth(TL1_MONTH_VALUE.get(output.getPart("END_MONTH").getValue()));
        this.neTimeParams.setEndDay(output.getPart("END_DAY").getValue());
        this.neTimeParams.setEndWeekOfMonth(TL1_WEEK_VALUE.get(output.getPart("END_WEEKDAY").getValue()));
        this.neTimeParams.setEndHour(output.getPart("END_HOUR").getValue());
        this.neTimeParams.setEndMinute(output.getPart("END_MINUTE").getValue());
    }

    public synchronized void getQxNETimeZone() {
        if (this.times >= 3) {
            this.times = 0;
            return;
        }
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation operation = null;
            ArrayList<Output> operationoutput = new ArrayList<Output>();
            operation = TECreateObjectFactory.getOperation(this.neid, "NSCMD_MON_GET_TIMEZONE");
            if (null != operation) {
                operationList.add(operation);
            }
            if (null != (operation = TECreateObjectFactory.getOperation(this.neid, "NSCMD_MON_GET_DST"))) {
                operationList.add(operation);
            }
            if (null != (operation = TECreateObjectFactory.getOperation(this.neid, "NSCMD_MON_GET_LOCALIZE"))) {
                operationList.add(operation);
            }
            if (operationList.isEmpty()) {
                return;
            }
            com.huawei.uflight.qxprotocol.OperationResult result_ope = TENECommMgr.getInstance().sendCommand(this.neid, operationList, TIME_OUT);
            int result = result_ope.retCode;
            if (result == 0) {
                for (int i = operationList.size() - 1; i >= 0; --i) {
                    operation = (Operation)operationList.get(i);
                    Output output = operation.getOutput(0);
                    operationoutput.add(output);
                }
                this.parseQXTimeZoneOperation(operationoutput);
                this.times = 0;
            } else {
                TELogFactory.getNormalLogger().error("getQxNETimeZone fail, errorcode=" + result);
                ++this.times;
                this.getQxNETimeZone();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getQxNETimeZone fail!", (Throwable)e);
        }
    }

    public synchronized void getNETimeZone() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (ne.getIsTL1OrQX() == 1) {
            this.getTL1NETimeZone();
        } else {
            this.getQxNETimeZone();
        }
    }

    private void parseQXTimeZoneOperation(List<Output> operationoutput) {
        String adjway;
        if (operationoutput.size() < 2) {
            return;
        }
        int len = operationoutput.size();
        for (int i = 0; i < len; ++i) {
            if (0 == operationoutput.get(i).getFaultCount()) {
                return;
            }
            if (TIME_LOCALIZATION_DISABLED.equals(operationoutput.get(i).getFault(0).getCode())) continue;
            return;
        }
        String yearstart = operationoutput.get(0).getPartValue("yearstart");
        String isuse = operationoutput.get(1).getPartValue("isuse");
        String timezone = operationoutput.get(2).getPartValue("timezone");
        String adjmode = operationoutput.get(1).getPartValue("adjmode");
        String endjmode = null;
        String startjmode = null;
        if (isuse != null && adjmode == null) {
            startjmode = operationoutput.get(1).getPartValue("startadjmode");
            endjmode = operationoutput.get(1).getPartValue("endadjmode");
        }
        if ((adjway = operationoutput.get(1).getPartValue("adjway")) == null) {
            adjway = TIME_LOCALIZATION_DISABLED;
        }
        String adjminuteStr = operationoutput.get(1).getPartValue("adjminute");
        if (null != yearstart && null != isuse && null != timezone && null != adjminuteStr) {
            int adjminute = Integer.parseInt(adjminuteStr);
            this.enableTimeLocalization = yearstart;
            this.nebaseyear = yearstart.equals("2") ? 1970 : 1990;
            this.neTimeParams.setIsUseDST(Integer.parseInt(isuse));
            int hour = Integer.parseInt(timezone.substring(4, 5)) * 10 + Integer.parseInt(timezone.substring(5, 6));
            int minute = Integer.parseInt(timezone.substring(7, 8)) * 10 + Integer.parseInt(timezone.substring(8, 9));
            char offset_Direction = timezone.charAt(3);
            if ('+' == offset_Direction) {
                this.neTimeParams.setTZOffset(hour * 60 + minute);
            } else {
                this.neTimeParams.setTZOffset(-hour * 60 - minute);
            }
            if (TIME_LOCALIZATION_DISABLED.equals(adjway)) {
                this.neTimeParams.setDSTOffset(adjminute);
            } else {
                this.neTimeParams.setDSTOffset(-adjminute);
            }
            this.neTimeParams.setStartMonth(Integer.parseInt(operationoutput.get(1).getPartValue("startmonth")));
            this.neTimeParams.setStartDay(Integer.parseInt(operationoutput.get(1).getPartValue("startday")));
            this.neTimeParams.setStartWeekOfMonth(Integer.parseInt(operationoutput.get(1).getPartValue("startday")));
            this.neTimeParams.setStartDayOfWeek(Integer.parseInt(operationoutput.get(1).getPartValue("startweekday")));
            this.neTimeParams.setStartHour(Integer.parseInt(operationoutput.get(1).getPartValue("starthour")));
            this.neTimeParams.setStartMinute(Integer.parseInt(operationoutput.get(1).getPartValue("startminute")));
            this.neTimeParams.setEndMonth(Integer.parseInt(operationoutput.get(1).getPartValue("endmonth")));
            this.neTimeParams.setEndDay(Integer.parseInt(operationoutput.get(1).getPartValue("endday")));
            this.neTimeParams.setEndWeekOfMonth(Integer.parseInt(operationoutput.get(1).getPartValue("endday")));
            this.neTimeParams.setEndDayOfWeek(Integer.parseInt(operationoutput.get(1).getPartValue("endweekday")));
            this.neTimeParams.setEndHour(Integer.parseInt(operationoutput.get(1).getPartValue("endhour")));
            this.neTimeParams.setEndMinute(Integer.parseInt(operationoutput.get(1).getPartValue("endminute")));
            if (adjmode == null) {
                this.neTimeParams.setStartRule(Integer.parseInt(startjmode));
                this.neTimeParams.setEndRule(Integer.parseInt(endjmode));
            } else {
                this.neTimeParams.setStartRule(Integer.parseInt(adjmode));
                this.neTimeParams.setEndRule(Integer.parseInt(adjmode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getTimeFormat() {
        boolean isGetTimeFormat = false;
        Document doc = null;
        InputStream in = null;
        try {
            File timeForateFileObj = new File(TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, TEPathManager.CONFIG_PROFILE_PATH + TIME_FORMAT_FILE_NAME));
            in = timeForateFileObj.toURI().toURL().openStream();
            doc = TEParseXMLFile.parseFile(in);
            NodeList timeFormatNodeList = doc.getElementsByTagName("timeformat");
            Element time_Format = (Element)timeFormatNodeList.item(0);
            String formatName_t = time_Format.getElementsByTagName("formatName").item(0).getFirstChild().getNodeValue();
            if (null != formatName_t) {
                formatName = formatName_t;
                isGetTimeFormat = true;
            }
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().error("", (Throwable)e1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("", (Throwable)e);
                }
            }
        }
        return isGetTimeFormat;
    }

    public synchronized String UTCToTime(String time) {
        Calendar calendar = TEDateUtils.byteStrToCalendar(time, this.nebaseyear);
        String time_instance = this.calendarToTime(calendar);
        return time_instance;
    }

    public synchronized String calendarToTime(Calendar calendar1) {
        if (null == calendar1) {
            return "";
        }
        SimpleDateFormat formatter = null;
        formatter = TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION ? new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH) : new SimpleDateFormat(formatName, Locale.ENGLISH);
        Calendar calendarBase = Calendar.getInstance();
        calendarBase.set(this.nebaseyear, 0, 1, 0, 0, 0);
        String time_instance = "";
        if (calendar1.getTimeInMillis() == calendarBase.getTimeInMillis()) {
            time_instance = formatter.format(calendar1.getTime());
            TELogFactory.getNormalLogger().debug("calendar1.getTimeInMillis() == calendarBase.getTimeInMillis() time_instance=" + time_instance);
        } else {
            boolean isDST = this.changeCalendarToTime(calendar1);
            time_instance = formatter.format(calendar1.getTime());
            TELogFactory.getNormalLogger().debug("isDST=" + isDST + " getIsShowDST()=" + TETimeTocalizationSwitchBean.getIsShowDST());
            if (isDST && TETimeTocalizationSwitchBean.getIsShowDST() == 1) {
                time_instance = time_instance + " DST";
            }
        }
        TELogFactory.getNormalLogger().debug("calendarToTime time_instance=" + time_instance);
        return time_instance;
    }

    public synchronized boolean changeCalendarToTime(Calendar calendar) {
        if (null == calendar) {
            return false;
        }
        boolean isDST = false;
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            if (TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
                isDST = TETimeTocalizationSwitchBean.getServerTimeParams().getUTCFromTime(calendar);
                isDST = TETimeTocalizationSwitchBean.getClientTimeParams().getTimeFromUTC(calendar);
            } else {
                isDST = TETimeTocalizationSwitchBean.getClientTimeParams().getTimeFromUTC(calendar);
            }
        } else if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            isDST = this.neTimeParams.getTimeFromUTC(calendar);
        }
        return isDST;
    }

    public synchronized String strToTime(String time) {
        Calendar calendar = TEDateUtils.strToCalendar(time);
        String time_instance = this.calendarToTime(calendar);
        return time_instance;
    }

    public synchronized String calendarToUTC(Calendar calendar1) {
        if (null == calendar1) {
            return "";
        }
        Calendar calendar = (Calendar)calendar1.clone();
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            if (TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
                TETimeTocalizationSwitchBean.getServerTimeParams().getUTCFromTime(calendar);
            } else {
                TETimeTocalizationSwitchBean.getClientTimeParams().getUTCFromTime(calendar);
            }
        } else if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            this.neTimeParams.getUTCFromTime(calendar);
        }
        String time_instance = TEDateUtils.calendarToByteStr(calendar, this.nebaseyear);
        return time_instance;
    }

    public synchronized Calendar getCalendarToUTC() {
        Calendar calendar = Calendar.getInstance();
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            if (TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
                TETimeTocalizationSwitchBean.getServerTimeParams().getUTCFromTime(calendar);
            } else {
                TETimeTocalizationSwitchBean.getClientTimeParams().getUTCFromTime(calendar);
            }
        } else if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            this.neTimeParams.getUTCFromTime(calendar);
        }
        return calendar;
    }

    public synchronized String strToUTC(String time) {
        Calendar calendar = TEDateUtils.strToCalendar(time);
        String time_instance = this.calendarToUTC(calendar);
        return time_instance;
    }

    public synchronized String strToNewUTC(String time) {
        Calendar calendar = null;
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            calendar = TEDateUtils.strToCalendar(time);
            if (null == calendar) {
                return "";
            }
            TETimeTocalizationSwitchBean.getClientTimeParams().getUTCFromTime(calendar);
            if (TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
                TETimeTocalizationSwitchBean.getServerTimeParams().getTimeFromUTC(calendar);
            }
        } else {
            calendar = TEDateUtils.strToCalendar(time, formatName);
            if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
                this.neTimeParams.getUTCFromTime(calendar);
            }
        }
        String time_instance = TEDateUtils.calendarToStr(calendar);
        return time_instance;
    }

    public static synchronized void setFormatName(String formatname) {
        formatName = formatname;
    }

    public static synchronized String getTimeConvertFormat() {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            return TETimeTocalizationSwitchBean.getDateFormat();
        }
        return formatName;
    }

    public synchronized String newCalendarToTime(Calendar calendar1) {
        if (null == calendar1) {
            return "";
        }
        boolean isDST = this.isUSTTimeInDst(calendar1);
        TELogFactory.getNormalLogger().debug(calendar1.toString() + " isDST=" + isDST);
        Calendar calendar = this.changeNewCalendarToTime(calendar1);
        SimpleDateFormat formatter = null;
        formatter = TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION ? new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH) : new SimpleDateFormat(formatName, Locale.ENGLISH);
        String time_instance = formatter.format(calendar.getTime());
        if (isDST && TETimeTocalizationSwitchBean.getIsShowDST() == 1) {
            time_instance = time_instance + " DST";
            TELogFactory.getNormalLogger().debug("newCalendarToTime=" + time_instance);
        }
        return time_instance;
    }

    public synchronized boolean isUSTTimeInDst(Calendar calendar1) {
        if (null == calendar1) {
            return false;
        }
        if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            Calendar tempCal = (Calendar)calendar1.clone();
            tempCal.add(14, -(tempCal.get(15) + tempCal.get(16)));
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
                return TETimeTocalizationSwitchBean.getClientTimeParams().isUTCInDST(tempCal);
            }
            return this.neTimeParams.isUTCInDST(tempCal);
        }
        return false;
    }

    public synchronized Calendar changeNewCalendarToTime(Calendar calendar1) {
        if (null == calendar1) {
            return null;
        }
        Calendar calendar = (Calendar)calendar1.clone();
        if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            calendar.add(14, -(calendar.get(15) + calendar.get(16)));
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
                TETimeTocalizationSwitchBean.getClientTimeParams().getTimeFromUTC(calendar);
            } else {
                this.neTimeParams.getTimeFromUTC(calendar);
            }
        }
        return calendar;
    }

    public synchronized String strToStr(String time) {
        Calendar calendar = TEDateUtils.strToCalendar(time);
        if (null == calendar) {
            return "";
        }
        if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
                TETimeTocalizationSwitchBean.getClientTimeParams().getUTCFromTime(calendar);
            } else {
                this.neTimeParams.getUTCFromTime(calendar);
            }
            calendar.add(14, calendar.get(15) + calendar.get(16));
        }
        String time_instance = TEDateUtils.calendarToStr(calendar);
        return time_instance;
    }

    public synchronized int getTimeZone() {
        int offset = 0;
        if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
            offset = this.neTimeParams.getTZOffset();
            if (this.neTimeParams.isDST(cal)) {
                offset += this.neTimeParams.getDSTOffset();
            }
        }
        return offset;
    }

    public long getNECurrentTime(int year, int month, int date, int hour, int minute, int second) {
        Calendar cal = this.getNEUTCTime(year, month, date, hour, minute, second);
        if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
                TETimeTocalizationSwitchBean.getClientTimeParams().getTimeFromUTC(cal);
            } else {
                this.neTimeParams.getTimeFromUTC(cal);
            }
        }
        return cal.getTimeInMillis();
    }

    public Calendar getNEUTCTime(int year, int month, int date, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year + this.nebaseyear, month - 1, date, hour, minute, second);
        return cal;
    }

    public Calendar byteStrToCalendar(String byteStr) {
        return TEDateUtils.byteStrToCalendar(byteStr, this.nebaseyear);
    }

    public String byteStrToDateStrYmd(String byteStr) {
        return TEDateUtils.byteStrToDateStrYmd(byteStr, this.nebaseyear);
    }

    public String dateStrToByteStr(String byteStr) {
        return TEDateUtils.dateStrToByteStr(byteStr, this.nebaseyear);
    }

    public synchronized String calendarToServerTime(Calendar calendar1) {
        if (null == calendar1) {
            return "";
        }
        SimpleDateFormat formatter = null;
        formatter = TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION ? new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH) : new SimpleDateFormat(formatName, Locale.ENGLISH);
        Calendar calendarBase = Calendar.getInstance();
        calendarBase.set(this.nebaseyear, 0, 1, 0, 0, 0);
        String time_instance = "";
        if (calendar1.getTimeInMillis() == calendarBase.getTimeInMillis()) {
            time_instance = formatter.format(calendar1.getTime());
        } else {
            boolean isDST = this.changeCalendarToServerTime(calendar1);
            time_instance = formatter.format(calendar1.getTime());
            if (isDST && TETimeTocalizationSwitchBean.getIsShowDST() == 1) {
                time_instance = time_instance + " DST";
            }
        }
        return time_instance;
    }

    public synchronized boolean changeCalendarToServerTime(Calendar calendar) {
        if (null == calendar) {
            return false;
        }
        boolean isDST = false;
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            isDST = TETimeTocalizationSwitchBean.getServerTimeParams().getTimeFromUTC(calendar);
        } else if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            isDST = this.neTimeParams.getTimeFromUTC(calendar);
        }
        return isDST;
    }

    public synchronized TETimeParams getServerTimeParams() {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            return TETimeTocalizationSwitchBean.getServerTimeParams();
        }
        return this.neTimeParams;
    }

    public synchronized String utcCalendarToTime(Calendar calendar) {
        if (null == calendar) {
            return "";
        }
        SimpleDateFormat formatter = null;
        formatter = TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION ? new SimpleDateFormat(TETimeTocalizationSwitchBean.getDateFormat(), Locale.ENGLISH) : new SimpleDateFormat(formatName, Locale.ENGLISH);
        boolean isDST = false;
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == IS_INTEGRATION) {
            isDST = TETimeTocalizationSwitchBean.getClientTimeParams().getTimeFromUTC(calendar);
        } else if (!TIME_LOCALIZATION_DISABLED.equals(this.enableTimeLocalization)) {
            isDST = this.neTimeParams.getTimeFromUTC(calendar);
        }
        String time_instance = formatter.format(calendar.getTime());
        TELogFactory.getNormalLogger().debug("isDST=" + isDST + " getIsShowDST()=" + TETimeTocalizationSwitchBean.getIsShowDST());
        if (isDST && TETimeTocalizationSwitchBean.getIsShowDST() == 1) {
            time_instance = time_instance + " DST";
        }
        TELogFactory.getNormalLogger().debug("utcCalendarToTime time_instance=" + time_instance);
        return time_instance;
    }
}

