/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEObjTypeMgr {
    private static final String filePath = TEResourceManager.getPath() + File.separator + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "gencfg" + File.separator + "objtype_method_map.xml";
    private static final int TCM_LEVEL = 2;
    private static final int TCM_1 = 2;
    private static final int TCM_6 = 7;
    private static final int PM_LEVEL = 1;
    private static final int SM_LEVEL = 8;
    private static final int OTS_LEVEL = 9;
    private static final int ODU0 = 5;
    private static final int ODU1 = 1;
    private static final int ODU2 = 2;
    private static final int ODU3 = 3;
    private static final int ODU4 = 6;
    private static final int ODUFLEX = 7;
    private static final int ODUCn = 8;
    private static final int ODU15 = 4;
    private static final int ODU16 = 255;
    private static final int FB_ODU0 = 832;
    private static final int FB_ODU1 = 829;
    private static final int FB_OTU5G = 807;
    private static final int FB_CTP_ODU1 = 880;
    private static final int FB_ODU2 = 823;
    private static final int FB_ODU3 = 820;
    private static final int FB_ODU4 = 838;
    private static final int FB_ODUFLEX = 841;
    private static final int FB_ODUCn = 844;
    private static final int OTU1 = 1;
    private static final int OTU2 = 2;
    private static final int OTU3 = 3;
    private static final int FB_OTU1 = 810;
    private static final int FB_OTU2 = 804;
    private static final int FB_OTU3 = 801;
    private static final int CUST_FB_VC4_1 = 100001;
    private static final int CUST_FB_VC4_2 = 100002;
    private static final int CUST_FB_VC4_3 = 100003;
    private static final int CUST_FB_VC4_4 = 100004;
    private static final int VC4_1 = 1;
    private static final int VC4_2 = 2;
    private static final int VC4_3 = 3;
    private static final int VC4_4 = 4;
    private static final int EXC_OTU1 = 513;
    private static final int EXC_OTU2 = 514;
    private static final int EXC_OTU3 = 515;
    private static final int EXC_OTU5G = 516;
    private static final int EXC_ODU0 = 528;
    private static final int EXC_ODU1 = 529;
    private static final int EXC_ODU2 = 530;
    private static final int EXC_ODU3 = 531;
    private static final int EXC_ODU5G = 532;
    private static final int EXC_ODU4 = 533;
    private static final int EXC_ODUFLEX = 534;
    private static final int[][] FBTOODU = new int[][]{{832, 5}, {829, 1}, {823, 2}, {820, 3}, {838, 6}, {841, 7}, {844, 8}, {807, 4}, {880, 255}, {810, 1}, {804, 2}, {801, 3}, {100001, 1}, {100002, 2}, {100003, 3}, {100004, 4}};
    private static final int[][] EXCTOODU = new int[][]{{528, 5}, {529, 1}, {530, 2}, {531, 3}, {533, 6}, {534, 7}, {532, 4}, {516, 4}, {513, 1}, {514, 2}, {515, 3}};
    private static final int INVALID = -65535;
    private static TEObjTypeMgr instance = null;
    private static HashMap objConvertMethodMap;

    private TEObjTypeMgr() {
        this.initObjMethodMap();
    }

    public static synchronized TEObjTypeMgr getInstance() {
        if (null == instance) {
            instance = new TEObjTypeMgr();
        }
        return instance;
    }

    private void initObjMethodMap() {
        objConvertMethodMap = new HashMap();
        Document doc = TEParseXMLFile.parseFile(filePath);
        if (null == doc) {
            return;
        }
        NodeList srcNodeList = doc.getElementsByTagName("src_object_type");
        NodeList sinkNodeList = null;
        Element srcEle = null;
        Element sinkEle = null;
        String srcObjName = "";
        String sinkObjName = "";
        String methodName = "";
        int size = srcNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            srcEle = (Element)srcNodeList.item(i);
            srcObjName = srcEle.getAttribute("name");
            sinkNodeList = srcEle.getElementsByTagName("sink_object_type");
            int sinkSize = sinkNodeList.getLength();
            for (int sinkIndex = 0; sinkIndex < sinkSize; ++sinkIndex) {
                sinkEle = (Element)sinkNodeList.item(sinkIndex);
                sinkObjName = sinkEle.getAttribute("name");
                methodName = sinkEle.getAttribute("method");
                objConvertMethodMap.put(srcObjName + "_" + sinkObjName, methodName);
            }
        }
    }

    public static int getODUFromFB(int fbType) {
        int len = FBTOODU.length;
        for (int i = 0; i < len; ++i) {
            if (FBTOODU[i][0] != fbType) continue;
            return FBTOODU[i][1];
        }
        return 0;
    }

    public static int getODUFromEXC(int excServiceType) {
        int len = EXCTOODU.length;
        for (int i = 0; i < len; ++i) {
            if (EXCTOODU[i][0] != excServiceType) continue;
            return EXCTOODU[i][1];
        }
        return 0;
    }

    public String getConvertMethod(String srcObjType, String sinkObjType) {
        if (null == objConvertMethodMap) {
            return null;
        }
        return (String)objConvertMethodMap.get(srcObjType + "_" + sinkObjType);
    }

    public Datainterface neExpandToBoard(String attrId, Datainterface inputData) {
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        int neid = -1;
        int slotid = -1;
        TENE neObj = null;
        TEGenCfgModel genCfgModel = null;
        List<TEBoard> boardList = null;
        TEBoard boardObj = null;
        RowParams rowparams = null;
        if (null == inputData) {
            return null;
        }
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = inputData.getBussinessParams().getRowParams(i);
            neid = this.getParaIntValue(rowparams, "neid");
            if (-65535 == neid || null == (neObj = TENEListMgr.getInstance().getNE(neid)) || null == (boardList = TEBoardConfigurationDataMgr.getInstance().getBoardRef(neid))) continue;
            int size = boardList.size();
            for (int j = 0; j < size; ++j) {
                rowparams = new RowParams();
                boardObj = boardList.get(j);
                genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType());
                if (null == genCfgModel || null == genCfgModel.getAttrFromId(attrId)) continue;
                slotid = boardObj.getSlotID();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                bussinessparams.addRowParams(rowparams);
            }
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    public Datainterface boardExpandToPort(String attrId, Datainterface inputData) {
        if (null == inputData) {
            return null;
        }
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        int neid = -1;
        int slotid = -1;
        int port = -1;
        String grade = "";
        String tl1Grade = "";
        String tcmLevel = "";
        TENE neObj = null;
        TEGenCfgModel genCfgModel = null;
        TEGenCfgAttribute attrObj = null;
        TEGenCfgPortAttribute portObj = null;
        ArrayList portList = null;
        TEBoard boardObj = null;
        RowParams rowparams = null;
        ArrayList<Integer> expandPortList = new ArrayList<Integer>();
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            expandPortList.clear();
            rowparams = inputData.getBussinessParams().getRowParams(i);
            neid = this.getParaIntValue(rowparams, "neid");
            if (-65535 == neid || null == (neObj = TENEListMgr.getInstance().getNE(neid)) || -65535 == (slotid = this.getParaIntValue(rowparams, "slotid"))) continue;
            Set<String> cPortList = this.getParamListValue(rowparams, "port");
            grade = this.getParamValue(rowparams, "grade");
            tl1Grade = this.getParamValue(rowparams, "tl1Grade");
            tcmLevel = this.getParamValue(rowparams, "tcmlevel");
            boardObj = TEBoardConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            if (null == boardObj || null == (genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType())) || null == (attrObj = genCfgModel.getAttrFromId(attrId))) continue;
            portList = attrObj.getPortList();
            if (null == portList || portList.isEmpty()) {
                if (expandPortList.contains(1)) continue;
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("port", "1");
                expandPortList.add(1);
                bussinessparams.addRowParams(rowparams);
                continue;
            }
            Collections.sort(portList);
            int size = portList.size();
            for (int j = 0; j < size; ++j) {
                portObj = (TEGenCfgPortAttribute)portList.get(j);
                port = portObj.getPort();
                if (expandPortList.contains(port) || !cPortList.isEmpty() && !cPortList.contains(String.valueOf(port))) continue;
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("port", String.valueOf(port));
                if (!grade.equals("")) {
                    rowparams.addParam("grade", grade);
                }
                if (!tl1Grade.equals("")) {
                    rowparams.addParam("tl1Grade", tl1Grade);
                }
                if (!tcmLevel.equals("")) {
                    rowparams.addParam("tcmlevel", tcmLevel);
                }
                expandPortList.add(port);
                bussinessparams.addRowParams(rowparams);
            }
        }
        if (bussinessparams.getRowParamsCount() <= 0) {
            return null;
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    public Datainterface portExpandToPath(String attrId, Datainterface inputData) {
        if (null == inputData) {
            return null;
        }
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        int neid = -1;
        int slotid = -1;
        int port = -1;
        int path = -1;
        String grade = "";
        String tcmLevel = "";
        TENE neObjPath = null;
        TEGenCfgModel genCfgModel = null;
        TEGenCfgAttribute attrObj = null;
        TEGenCfgPortAttribute portObj = null;
        ArrayList portList = null;
        TEBoard boardObjPath = null;
        RowParams rowparams = null;
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = inputData.getBussinessParams().getRowParams(i);
            neid = this.getParaIntValue(rowparams, "neid");
            if (-65535 == neid || null == (neObjPath = TENEListMgr.getInstance().getNE(neid)) || -65535 == (slotid = this.getParaIntValue(rowparams, "slotid")) || null == (boardObjPath = TEBoardConfigurationDataMgr.getInstance().getBoard(neid, slotid)) || null == (genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObjPath.getBoardType())) || null == (attrObj = genCfgModel.getAttrFromId(attrId)) || -65535 == (port = this.getParaIntValue(rowparams, "port"))) continue;
            grade = this.getParamValue(rowparams, "grade");
            tcmLevel = this.getParamValue(rowparams, "tcmlevel");
            portList = attrObj.getPortList(port, neid);
            if (null == portList) {
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("path", "1");
                bussinessparams.addRowParams(rowparams);
                continue;
            }
            Collections.sort(portList);
            Set<String> pathlist = this.getParamListValue(rowparams, "pathlist");
            int size = portList.size();
            for (int j = 0; j < size; ++j) {
                rowparams = new RowParams();
                portObj = (TEGenCfgPortAttribute)portList.get(j);
                path = portObj.getPath();
                if (!pathlist.isEmpty() && !pathlist.contains(String.valueOf(path))) continue;
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("path", String.valueOf(path));
                if ("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER".equals(portObj.getAttrId()) && neObjPath.getNEType() == 66) {
                    rowparams.addParam("grade", String.valueOf(TEObjTypeMgr.getODUFromFB(portObj.getFbtype())));
                }
                if (!grade.equals("")) {
                    rowparams.addParam("grade", grade);
                }
                if (!tcmLevel.equals("")) {
                    rowparams.addParam("tcmlevel", tcmLevel);
                }
                bussinessparams.addRowParams(rowparams);
            }
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    private int getParaIntValue(RowParams row, String name) {
        int value = -65535;
        Param tmpParam = row.getParam(name);
        if (null != tmpParam && null != tmpParam.getValue() && !tmpParam.getValue().equals("")) {
            try {
                value = Integer.parseInt(tmpParam.getValue());
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("The " + name + " is not number!", (Throwable)e);
            }
        }
        return value;
    }

    private String getParamValue(RowParams row, String name) {
        String value = "";
        Param param = row.getParam(name);
        if (null != param && param.getValue() != null && !param.getValue().equals("")) {
            value = param.getValue();
        }
        return value;
    }

    private Set<String> getParamListValue(RowParams row, String name) {
        HashSet<String> result = new HashSet<String>();
        Param param = row.getParam(name);
        if (null != param && param.getValue() != null && !param.getValue().equals("")) {
            result.addAll(Arrays.asList(param.getValue().split(",")));
        }
        return result;
    }

    public Datainterface portExpandToODU(String attrId, Datainterface inputData) {
        if (null == inputData) {
            return null;
        }
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        int neid = -1;
        int slotid = -1;
        int port = -1;
        int path = -1;
        String tcmLevel = "";
        TENE neObjodu = null;
        TEGenCfgModel genCfgModel = null;
        TEGenCfgAttribute attrObjOdu = null;
        TEGenCfgPortAttribute portObj = null;
        ArrayList portList = null;
        TEBoard boardObj = null;
        RowParams rowparams = null;
        Param tmpParam = null;
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = inputData.getBussinessParams().getRowParams(i);
            neid = this.getParaIntValue(rowparams, "neid");
            if (-65535 == neid || null == (neObjodu = TENEListMgr.getInstance().getNE(neid)) || -65535 == (slotid = this.getParaIntValue(rowparams, "slotid")) || null == (boardObj = TEBoardConfigurationDataMgr.getInstance().getBoard(neid, slotid)) || null == (genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType())) || null == (attrObjOdu = genCfgModel.getAttrFromId(attrId)) || -65535 == (port = this.getParaIntValue(rowparams, "port"))) continue;
            tmpParam = inputData.getBussinessParams().getRowParams(i).getParam("tcmlevel");
            if (null != tmpParam && null != tmpParam.getValue()) {
                tcmLevel = tmpParam.getValue();
            }
            if (null == (portList = attrObjOdu.getPortList(port, neid))) continue;
            Collections.sort(portList);
            Set<String> gradeList = this.getParamListValue(rowparams, "grade");
            Set<String> tl1GradeList = this.getParamListValue(rowparams, "tl1Grade");
            Set<String> pathlist = this.getParamListValue(rowparams, "pathlist");
            String pathMod2 = "";
            int size = portList.size();
            for (int j = 0; j < size; ++j) {
                rowparams = new RowParams();
                portObj = (TEGenCfgPortAttribute)portList.get(j);
                int tempGrade = TEObjTypeMgr.getODUFromFB(portObj.getFbtype());
                if (!gradeList.isEmpty() && !gradeList.contains(String.valueOf(tempGrade))) continue;
                path = portObj.getPath();
                if (!pathlist.isEmpty() && !pathlist.contains(String.valueOf(path))) continue;
                pathMod2 = TETL1AIDTranslateRuleMgr.getInstance().getCurMod2(boardObj.getBoardType(), String.valueOf(path));
                if (!tl1GradeList.isEmpty() && !tl1GradeList.contains(pathMod2)) continue;
                rowparams.addParam("neid", String.valueOf(neid));
                rowparams.addParam("slotid", String.valueOf(slotid));
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("path", String.valueOf(path));
                rowparams.addParam("grade", String.valueOf(tempGrade));
                if (!tcmLevel.equals("")) {
                    rowparams.addParam("tcmlevel", tcmLevel);
                }
                bussinessparams.addRowParams(rowparams);
            }
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    public Datainterface oduExpandToODULevel(String attrId, Datainterface inputData, int level) {
        if (null == inputData) {
            return null;
        }
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        int neid = 0;
        int slotid = 0;
        int port = 0;
        int path = 0;
        int grade = 0;
        TENE neObj = null;
        RowParams rowparams = null;
        int len = inputData.getBussinessParams().getRowParamsCount();
        block6: for (int i = 0; i < len; ++i) {
            rowparams = inputData.getBussinessParams().getRowParams(i);
            neid = this.getParaIntValue(rowparams, "neid");
            if (-65535 == neid || null == (neObj = TENEListMgr.getInstance().getNE(neid)) || -65535 == (slotid = this.getParaIntValue(rowparams, "slotid")) || -65535 == (port = this.getParaIntValue(rowparams, "port")) || -65535 == (path = this.getParaIntValue(rowparams, "path")) || -65535 == (grade = this.getParaIntValue(rowparams, "grade"))) continue;
            Set<String> tcmLevelList = this.getParamListValue(rowparams, "tcmlevel");
            switch (level) {
                case 2: {
                    for (int tcm = 2; tcm <= 7; ++tcm) {
                        if (!tcmLevelList.isEmpty() && !tcmLevelList.contains(String.valueOf(tcm))) continue;
                        rowparams = new RowParams();
                        rowparams.addParam("neid", String.valueOf(neid));
                        rowparams.addParam("slotid", String.valueOf(slotid));
                        rowparams.addParam("port", String.valueOf(port));
                        rowparams.addParam("path", String.valueOf(path));
                        rowparams.addParam("grade", String.valueOf(grade));
                        rowparams.addParam("level", String.valueOf(tcm));
                        bussinessparams.addRowParams(rowparams);
                    }
                    continue block6;
                }
                case 1: {
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(neid));
                    rowparams.addParam("slotid", String.valueOf(slotid));
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("path", String.valueOf(path));
                    rowparams.addParam("grade", String.valueOf(grade));
                    rowparams.addParam("level", String.valueOf(1));
                    bussinessparams.addRowParams(rowparams);
                    continue block6;
                }
                case 8: {
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(neid));
                    rowparams.addParam("slotid", String.valueOf(slotid));
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("path", String.valueOf(path));
                    rowparams.addParam("grade", String.valueOf(grade));
                    rowparams.addParam("level", String.valueOf(8));
                    bussinessparams.addRowParams(rowparams);
                    continue block6;
                }
                case 9: {
                    rowparams = new RowParams();
                    rowparams.addParam("neid", String.valueOf(neid));
                    rowparams.addParam("slotid", String.valueOf(slotid));
                    rowparams.addParam("port", String.valueOf(port));
                    rowparams.addParam("path", String.valueOf(path));
                    rowparams.addParam("grade", String.valueOf(grade));
                    rowparams.addParam("level", String.valueOf(9));
                    bussinessparams.addRowParams(rowparams);
                    continue block6;
                }
            }
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    public Datainterface oduExpandToODUTCM(String attrId, Datainterface inputData) {
        return this.oduExpandToODULevel(attrId, inputData, 2);
    }

    public Datainterface oduExpandToODUOTS(String attrId, Datainterface inputData) {
        return this.oduExpandToODULevel(attrId, inputData, 9);
    }

    public Datainterface oduExpandToODUPM(String attrId, Datainterface inputData) {
        return this.oduExpandToODULevel(attrId, inputData, 1);
    }

    public Datainterface oduExpandToODUSM(String attrId, Datainterface inputData) {
        return this.oduExpandToODULevel(attrId, inputData, 8);
    }

    public Datainterface neExpandToPort(String attrId, Datainterface inputData) {
        return this.boardExpandToPort(attrId, this.neExpandToBoard(attrId, inputData));
    }

    public Datainterface neExpandToPath(String attrId, Datainterface inputData) {
        return this.portExpandToPath(attrId, this.boardExpandToPort(attrId, this.neExpandToBoard(attrId, inputData)));
    }

    public Datainterface boardExpandToPath(String attrId, Datainterface inputData) {
        return this.portExpandToPath(attrId, this.boardExpandToPort(attrId, inputData));
    }

    public Datainterface boardExpandToODU(String attrId, Datainterface inputData) {
        return this.portExpandToODU(attrId, this.boardExpandToPort(attrId, inputData));
    }

    public Datainterface boardExpandToODUTCM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUTCM(attrId, this.boardExpandToODU(attrId, inputData));
    }

    public Datainterface boardExpandToODUOTS(String attrId, Datainterface inputData) {
        return this.oduExpandToODUOTS(attrId, this.boardExpandToODU(attrId, inputData));
    }

    public Datainterface boardExpandToODUPM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUPM(attrId, this.boardExpandToODU(attrId, inputData));
    }

    public Datainterface boardExpandToODUSM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUSM(attrId, this.boardExpandToODU(attrId, inputData));
    }

    public Datainterface portExpandToODUTCM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUTCM(attrId, this.portExpandToODU(attrId, inputData));
    }

    public Datainterface portExpandToODUPM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUPM(attrId, this.portExpandToODU(attrId, inputData));
    }

    public Datainterface portExpandToODUSM(String attrId, Datainterface inputData) {
        return this.oduExpandToODUSM(attrId, this.portExpandToODU(attrId, inputData));
    }
}

