/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.bscfg.installcp.TENECircuitPackInstall;
import com.huawei.nglct.bscfg.installcp.TETTPIndex;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.ScriptFile;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TScriptFileImpl;
import com.huawei.nglct.consts.equipment.TEDomain;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.gencfg.TEGnlcfgMgrIF;
import com.huawei.nglct.gencfg.frame.GetDomainMethodForScriptPtr;
import com.huawei.nglct.gencfg.frame.TEEMS2GnlAttrRecord;
import com.huawei.nglct.gencfg.frame.TEGenKey;
import com.huawei.nglct.gencfg.frame.TEGenValue;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlIF;
import com.huawei.nglct.gencfg.frame.TEGnlOperIF;
import com.huawei.nglct.gencfg.frame.TEObjectID;
import com.huawei.nglct.mo.TEPortInfo;
import com.huawei.nglct.mo.ttp.TETTPKey;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.clientitem.TEBoardInfo;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.po.TEObjectFuncMTState;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.po.TEPortPO;
import com.huawei.nglct.po.ttp.TETP;
import com.huawei.nglct.po.ttp.sdh.TEPPITTPSource;
import com.huawei.nglct.util.datastruct.TEReturnValue;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.sort.TEKeySorter;
import com.huawei.nglct.util.string.TEStringUtils;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TEGnlcfgMgrImpl
extends TEGnlcfgMgrIF {
    int getComAttrID(int attrID, TEObjectID objID, TEEMS2GnlAttrRecord attrRecord) {
        TEEMS2GnlAttrRecord record = new TEEMS2GnlAttrRecord();
        return TEGnlAttrMgr.getInstance().gnlAttrID2EMSAttrID(attrID, objID.get(0), record);
    }

    boolean toMTState(int classID, int iValue, TEReturnValue ret) {
        switch (classID) {
            case 773: {
                ret.intValue = 1;
                ret.bValue = 0 != iValue;
                break;
            }
            case 794: {
                ret.intValue = 2;
                ret.bValue = 0 == iValue;
                break;
            }
            case 774: {
                ret.intValue = 3;
                ret.bValue = 0 == iValue;
                break;
            }
            case 517: {
                ret.intValue = 17;
                ret.bValue = 0 != iValue;
                break;
            }
            case 531: {
                ret.intValue = 18;
                ret.bValue = 0 == iValue;
                break;
            }
            case 263: {
                ret.intValue = 33;
                ret.bValue = 0 != iValue;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean toMTAttr(int attrID, TEObjectID objID, TEGenValue inValue, List<TEObjectFuncMTState> outData) {
        TEObjectFuncMTState MTdata = new TEObjectFuncMTState();
        MTdata.setNeID(objID.get(1));
        MTdata.setSlotID(objID.get(2));
        if (objID.size() >= 4) {
            MTdata.setPortID(objID.get(3));
        }
        MTdata.state = 0;
        int classID = 0;
        int fb = 255;
        TEEMS2GnlAttrRecord attrRecord = new TEEMS2GnlAttrRecord();
        if (0 != this.getComAttrID(attrID, objID, attrRecord)) {
            return false;
        }
        classID = attrRecord.emsAttrID;
        fb = attrRecord.fbType;
        int flag = TEGnlAttrMgr.getInstance().getEmsAttrUsedFlag(classID, fb);
        if (0 == (2 & flag)) {
            return false;
        }
        int iValue = 0;
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        if (0 != valueType) {
            return false;
        }
        iValue = inValue.iValue;
        TEReturnValue ret = new TEReturnValue();
        if (!this.toMTState(classID, iValue, ret)) {
            return false;
        }
        MTdata.setFuncID(ret.intValue);
        if (outData.contains(MTdata)) {
            return true;
        }
        if (MTdata.state != 0) {
            outData.add(MTdata);
            return true;
        }
        if (this.getMTState(classID, MTdata)) {
            outData.add(MTdata);
        }
        return true;
    }

    boolean getMTState(int classID, TEObjectFuncMTState MTdata) {
        ArrayList<TEEMS2GnlAttrRecord> attrList = new ArrayList<TEEMS2GnlAttrRecord>();
        TEGnlAttrMgr.getInstance().getGnlAttrsByEmsAttr(attrList, classID, 2);
        TIntArrayList value = null;
        HashMap<String, TIntArrayList> moAttrMap = new HashMap<String, TIntArrayList>();
        int m = attrList.size();
        for (int i = 0; i < m; ++i) {
            TEEMS2GnlAttrRecord tmp = (TEEMS2GnlAttrRecord)attrList.get(i);
            String strName = TEGnlOperIF.getInstance().getAttrMOClassName(tmp.gnlAttrID, tmp.objType);
            if (strName.length() <= 0) continue;
            if (moAttrMap.containsKey(strName)) {
                value = (TIntArrayList)moAttrMap.get(strName);
                value.add(tmp.gnlAttrID);
                continue;
            }
            value = new TIntArrayList();
            value.add(tmp.gnlAttrID);
            moAttrMap.put(strName, value);
        }
        int mtAttr = MTdata.getFuncID();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : moAttrMap.entrySet()) {
            if ((mtAttr & 0x20) != 0) {
                this.getBoardMaintainState(classID, MTdata, (String)entry2.getKey(), (TIntArrayList)entry2.getValue());
            }
            if (MTdata.state == 0) continue;
            break;
        }
        return true;
    }

    void getBoardMaintainState(int classID, TEObjectFuncMTState MTdata, String strMoName, TIntArrayList attrList) {
        TECircuitPack cp = new TECircuitPack(MTdata.getNeID(), MTdata.getSlotID());
        if (null == (cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp))) {
            return;
        }
        ArrayList<TEOmniAttrib> result = new ArrayList<TEOmniAttrib>();
        cp.getAttrib(attrList, result);
        TEOmniAttrib attr = null;
        int m = result.size();
        for (int i = 0; i < m; ++i) {
            attr = (TEOmniAttrib)result.get(i);
            TEReturnValue ret = new TEReturnValue();
            this.toMTState(classID, Integer.parseInt(attr.getValue()), ret);
            int n = MTdata.state = ret.bValue ? 1 : 0;
            if (ret.bValue) break;
        }
    }

    @Override
    public String getName() {
        return "TEGnlcfgMgrIF";
    }

    @Override
    public boolean isSupported(int funcID, TENEPO ne, TECircuitPack board) {
        return false;
    }

    @Override
    public int exportFunc(int neID, int cmdID, ScriptFile scriptObj) {
        int retCode = 0;
        switch (cmdID) {
            case 0x210001: {
                retCode = this.exportPortName(neID, scriptObj);
                break;
            }
            case 0x210002: {
                retCode = this.exportPathName(neID, scriptObj);
                break;
            }
            case 2162691: {
                retCode = this.exportPathPayindct(neID, scriptObj);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().trace(String.format("Unknown ScriptCmd when call gnlcfg Export module.cmdID:%d\n", cmdID));
            }
        }
        return retCode;
    }

    @Override
    public int importFunc(int neID, int cmdID, ScriptFile scriptObj) {
        int retCode = 0;
        switch (cmdID) {
            case 0x210001: {
                retCode = this.importPortName(neID, scriptObj);
                break;
            }
            case 0x210002: {
                retCode = this.importPathName(neID, scriptObj);
                break;
            }
            case 2162691: {
                retCode = this.importPathPayindct(neID, scriptObj);
                break;
            }
            default: {
                retCode = 1090614024;
                TELogFactory.getNormalLogger().trace(String.format("Unknown ScriptCmd when Call gnlcfg Import Module.CmdID:%d\n", cmdID));
            }
        }
        return retCode;
    }

    public int importPortName(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        TScriptFileImpl fileImpl = (TScriptFileImpl)scriptObj;
        ArrayList<TEScriptCmd> hook = new ArrayList<TEScriptCmd>(1);
        if (!fileImpl.getOneCommand(hook)) {
            return retCode;
        }
        TEScriptCmd cmd = (TEScriptCmd)hook.get(0);
        ArrayList<String> strHook = new ArrayList<String>(1);
        TEBoardInfo board = new TEBoardInfo();
        if (!cmd.getPara("board", strHook, false) || !TEBoardUtil.str2BoardInfo((String)strHook.get(0), board, neID, 3)) {
            return 1090614027;
        }
        int[] bdType = new int[1];
        retCode = TEBoardUtil.getBoardType(neID, board.slot, bdType);
        if (0 != retCode) {
            return retCode;
        }
        if (bdType[0] != board.bdtype) {
            return 1090594855;
        }
        strHook.clear();
        if (!cmd.getPara("name", strHook, false)) {
            return 1090614027;
        }
        TECircuitPack cp = new TECircuitPack(neID, board.slot);
        if (!this.isNeedImport(cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp), board.port, (String)strHook.get(0), fileImpl)) {
            return 0;
        }
        TEDomain portDomain = new TEDomain();
        StringBuffer portName = new StringBuffer();
        if (!this.getPortInfoFromStrName(cp, board.port, (String)strHook.get(0), portDomain, portName, fileImpl)) {
            return 1090593051;
        }
        int portID = (portDomain.domainType << 16) + board.port;
        TEPortPO port = new TEPortPO(neID, board.slot, portID);
        if ((port = (TEPortPO)CommonDaoService.getById(TEPortPO.class, port)) == null) {
            port = new TEPortPO(neID, board.slot, portID);
        }
        port.setName(portName.toString());
        CommonDaoService.save(port);
        return retCode;
    }

    public int importPathName(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        TScriptFileImpl fileImpl = (TScriptFileImpl)scriptObj;
        ArrayList<TEScriptCmd> cmdHook = new ArrayList<TEScriptCmd>(1);
        if (!fileImpl.getOneCommand(cmdHook)) {
            return retCode;
        }
        TEScriptCmd cmd = (TEScriptCmd)cmdHook.get(0);
        ArrayList<String> strHook = new ArrayList<String>(1);
        int[] cpType = new int[1];
        TETTPIndex ttpIndex = new TETTPIndex();
        ttpIndex.m_neID = neID;
        if (!cmd.getPara("path", strHook, false) || !this.str2TTPInfo((String)strHook.get(0), ttpIndex, cpType)) {
            return 1090614027;
        }
        int[] mo_cpType = new int[1];
        retCode = TEBoardUtil.getBoardType(neID, ttpIndex.m_slotID, mo_cpType);
        if (0 != retCode) {
            return retCode;
        }
        if (mo_cpType[0] != cpType[0]) {
            return 1090594855;
        }
        strHook.clear();
        if (!cmd.getPara("type", strHook, false)) {
            return 1090614027;
        }
        ttpIndex.m_TTP.setTTPType(TEFuncBlockDescription.getInstance().getFBTypeByName((String)strHook.get(0)));
        strHook.clear();
        if (!cmd.getPara("name", strHook, false)) {
            return 1090614027;
        }
        TETP ttp = (TETP)CommonDaoService.getById(TETP.class, ttpIndex);
        ttp.setName((String)strHook.get(0));
        CommonDaoService.save(ttp);
        return retCode;
    }

    public int importPathPayindct(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        TScriptFileImpl fileImpl = (TScriptFileImpl)scriptObj;
        ArrayList<Integer> cmdCode = new ArrayList<Integer>(1);
        ArrayList<TEScriptCmd> cmdHook = new ArrayList<TEScriptCmd>(1);
        TreeMap<TEGenKey, TEGenValue> allData = new TreeMap<TEGenKey, TEGenValue>(new TEKeySorter());
        while (fileImpl.getCmdCodeOfCurrCmd(cmdCode) && 2162691 == (Integer)cmdCode.get(0)) {
            fileImpl.getOneCommand(cmdHook);
            TEScriptCmd cmd = (TEScriptCmd)cmdHook.get(0);
            ArrayList<String> strHook = new ArrayList<String>(1);
            TEBoardInfo boardinfo = new TEBoardInfo();
            int[] bdtype = new int[1];
            ArrayList<Integer> intHook = new ArrayList<Integer>(1);
            if (!cmd.getPara("board", strHook, false) || !TEBoardUtil.str2BoardInfo((String)strHook.get(0), boardinfo, neID, 3)) {
                return 1090614027;
            }
            retCode = TEBoardUtil.getBoardType(neID, boardinfo.slot, bdtype);
            if (0 != retCode) {
                return retCode;
            }
            if (bdtype[0] != boardinfo.bdtype) {
                return 1090594855;
            }
            if (!cmd.getPara("payloadloadflag", false, intHook)) {
                return 1090614027;
            }
            if (TEBoardUtil.TEINDICATIONAttr.INDICATION_UNLOAD.ordinal() != ((Integer)intHook.get(0)).intValue() && TEBoardUtil.TEINDICATIONAttr.INDICATION_LOAD.ordinal() != ((Integer)intHook.get(0)).intValue()) {
                return 0;
            }
            TEGenKey genKey = new TEGenKey();
            genKey.objectID.add(61443);
            genKey.objectID.add(neID);
            genKey.objectID.add(boardinfo.slot);
            genKey.objectID.add(this.getPortID(1, boardinfo.port & 0xFFFF));
            genKey.attrID = 208900;
            TEGenValue genValue = new TEGenValue();
            genValue.iValue = (Integer)intHook.get(0);
            allData.put(genKey, genValue);
            fileImpl.getNextCmdCode(cmdCode);
            cmdCode.clear();
        }
        for (Map.Entry entry : allData.entrySet()) {
            TEGenKey genKey = (TEGenKey)entry.getKey();
            TEGenValue genValue = (TEGenValue)entry.getValue();
            int slotID = genKey.objectID.get(2);
            int portID = genKey.objectID.get(3);
            int loadValue = genValue.iValue;
            TEPPITTPSource ppiSource = new TEPPITTPSource(neID, slotID, portID, 45, 1);
            if ((ppiSource = (TEPPITTPSource)CommonDaoService.getById(TEPPITTPSource.class, ppiSource)) == null) {
                ppiSource = new TEPPITTPSource(neID, slotID, portID, 45, 1);
            }
            TEOmniAttrib attrTmp = new TEOmniAttrib();
            ArrayList<TEOmniAttrib> portpay = new ArrayList<TEOmniAttrib>(1);
            attrTmp.setAttribId(208900);
            attrTmp.setValue(Integer.toString(loadValue));
            portpay.add(attrTmp);
            ppiSource.setAttrib(portpay);
            CommonDaoService.save(ppiSource);
        }
        return retCode;
    }

    public boolean isNeedImport(TECircuitPack cp, int portNo, String strName, TScriptFileImpl scriptObj) {
        int findPos = strName.indexOf("&");
        if (findPos == -1) {
            if (scriptObj.getVersion() > 0x2010000) {
                return false;
            }
            ArrayList<String> defnames = new ArrayList<String>();
            defnames.add("SPI");
            defnames.add("PPI");
            defnames.add("SDH");
            defnames.add("SDH_TU");
            defnames.add("FAC");
            for (String name : defnames) {
                if (strName.equals(this.getDefaultPortName(portNo, name))) {
                    return false;
                }
                Iterator<TEPortPO> it = cp.getPortes().iterator();
                while (it.hasNext()) {
                    if (!strName.equals(this.getDefaultPortName(it.next().getPortNo(), name))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getDefaultPortName(int portid, String porttype) {
        return TEStringUtils.snprintf(1023, "%s-%d", porttype, portid & 0xFFFF);
    }

    public boolean getPortInfoFromStrName(TECircuitPack cp, int portNo, String inStrName, TEDomain portDomain, StringBuffer outStrName, TScriptFileImpl scriptObj) {
        block11: {
            TEPortInfo portInfo;
            HashSet<Integer> setDomain;
            TEPortDescription portDes;
            block9: {
                HashSet<Integer> setDomainEx;
                String domainStr;
                block10: {
                    portDomain.domainType = 255;
                    int findPos = inStrName.indexOf("&");
                    if (findPos == -1) {
                        domainStr = inStrName;
                        outStrName.append(inStrName);
                        if (scriptObj.getVersion() < 0x2010000) {
                            portDomain.domainType = 1;
                            return true;
                        }
                    } else {
                        domainStr = inStrName.substring(0, findPos);
                        outStrName.append(inStrName.substring(findPos + 1));
                    }
                    portDes = TEPortDescription.getInstance();
                    setDomain = new HashSet<Integer>();
                    setDomainEx = new HashSet<Integer>();
                    HashMap allSDPortMap = portDes.getAllPort();
                    TEGnlOperIF gnlIF = TEGnlOperIF.getInstance();
                    for (Map.Entry entry : allSDPortMap.entrySet()) {
                        if (!portDes.isNameUpdable((Integer)entry.getKey())) continue;
                        setDomainEx.add(portDes.getPortDomain((Integer)entry.getKey()));
                        if (domainStr.indexOf((String)entry.getValue()) == -1) {
                            GetDomainMethodForScriptPtr methodPtr = null;
                            methodPtr = gnlIF.getDomainMethodForScript((Integer)entry.getKey());
                            if (null == methodPtr || !methodPtr.judge(domainStr)) continue;
                            setDomain.add(portDes.getPortDomain((Integer)entry.getKey()));
                            continue;
                        }
                        setDomain.add(portDes.getPortDomain((Integer)entry.getKey()));
                    }
                    if (setDomain.size() != 0) break block9;
                    if (setDomainEx.size() != 1) break block10;
                    portDomain.domainType = (Integer)setDomainEx.iterator().next();
                    break block11;
                }
                portInfo = new TEPortInfo();
                TECircuitPackDescription cpd = TECircuitPackDescription.getInstance();
                Iterator itS = setDomainEx.iterator();
                boolean found = false;
                while (itS.hasNext()) {
                    Integer domain = (Integer)itS.next();
                    if (0 != cp.getCPPort(this.getPortID(domain, portNo), portInfo) || !portDes.isNameUpdable(portInfo.m_Type)) continue;
                    setDomain.add(domain);
                    String inName = cpd.getCPPortINName(cp.getTypeId(), this.getPortID(domain, portNo));
                    String outName = cpd.getCPPortOUTName(cp.getTypeId(), this.getPortID(domain, portNo));
                    if ((inName == null || inName.length() == 0 || domainStr.indexOf(inName) == -1) && (outName == null || outName.length() == 0 || domainStr.indexOf(outName) == -1)) continue;
                    portDomain.domainType = domain;
                    found = true;
                    break;
                }
                if (found || 1 != setDomain.size()) break block11;
                portDomain.domainType = (Integer)setDomain.iterator().next();
                break block11;
            }
            if (setDomain.size() == 1) {
                portDomain.domainType = (Integer)setDomain.iterator().next();
            } else {
                portInfo = new TEPortInfo();
                for (Integer domain : setDomain) {
                    if (0 != cp.getCPPort(this.getPortID(domain, portNo), portInfo) || !portDes.isNameUpdable(portInfo.m_Type)) continue;
                    portDomain.domainType = domain;
                    break;
                }
            }
        }
        return 255 != portDomain.domainType;
    }

    public boolean str2TTPInfo(String strTTPOjb, TETTPIndex ttpIndex, int[] cpType) {
        ttpIndex.m_TTP.setTTPLow(0);
        String[] tokens = strTTPOjb.split("-");
        block7: for (int i = 0; i < tokens.length; ++i) {
            switch (i) {
                case 0: {
                    ttpIndex.m_slotID = Integer.parseInt(tokens[i]);
                    continue block7;
                }
                case 1: {
                    cpType[0] = TEBoardUtil.getBoardTypeFromName(tokens[i], ttpIndex.m_neID, ttpIndex.m_slotID);
                    if (0 != cpType[0]) continue block7;
                    return false;
                }
                case 2: {
                    ttpIndex.m_TTP.setPortID(Integer.parseInt(tokens[i]));
                    continue block7;
                }
                case 3: {
                    ttpIndex.m_TTP.setTTPHigh(Integer.parseInt(tokens[i]));
                    continue block7;
                }
                case 4: {
                    ttpIndex.m_TTP.setTTPLow(Integer.parseInt(tokens[i]));
                    continue block7;
                }
            }
        }
        return true;
    }

    public int exportPortName(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        TScriptFileImpl fileImpl = (TScriptFileImpl)scriptObj;
        ArrayList<TENECircuitPackInstall> cps = new ArrayList<TENECircuitPackInstall>();
        retCode = TEBoardUtil.getAllCPs(neID, cps, true);
        if (0 != retCode) {
            return retCode;
        }
        Collections.sort(cps);
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.addPara("annotation", "// Port Name\n", false, true);
        scriptObj.writeCommand(cmd);
        cmd.deleteAllPara();
        cmd.setCmdCode(0x210001);
        ArrayList<TEPortPO> ports = new ArrayList<TEPortPO>();
        HashMap<Integer, String> portNameMap = new HashMap<Integer, String>();
        TEPortDescription portDes = TEPortDescription.getInstance();
        HashMap<Integer, Object> portInfo = new HashMap<Integer, Object>();
        for (TENECircuitPackInstall one : cps) {
            TECircuitPack cp = new TECircuitPack(neID, one.getM_SlotID());
            cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp);
            portNameMap.clear();
            cp.getCPPorts(ports, 0, 0, false);
            Collections.sort(ports);
            for (TEPortPO port : ports) {
                if (port == null || !portDes.isNameUpdable(port.getPortType())) continue;
                portInfo.clear();
                port.getPortInfo(portInfo, false);
                if (portInfo.get(515) != null && portInfo.get(521) != null) {
                    String strTmp = (String)portInfo.get(521);
                    strTmp = strTmp + "&" + (String)portInfo.get(515);
                    portNameMap.put(port.getPortNo(), strTmp);
                    continue;
                }
                if (portInfo.get(515) != null) {
                    portNameMap.put(port.getPortNo(), (String)portInfo.get(515));
                    continue;
                }
                if (portInfo.get(521) == null) continue;
                portNameMap.put(port.getPortNo(), (String)portInfo.get(521));
            }
            for (Map.Entry entry : portNameMap.entrySet()) {
                String strBDName = TEBoardUtil.board2Str(neID, one.getM_SlotID(), one.getM_CircuitPackType(), (Integer)entry.getKey() & 0xFFFF, "");
                strBDName = strBDName.toUpperCase();
                cmd.addPara("board", strBDName, false, true);
                cmd.addPara("name", (String)entry.getValue(), true, true);
                fileImpl.writeCommand(cmd);
                cmd.deleteAllPara();
            }
        }
        return retCode;
    }

    public int exportPathPayindct(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        ArrayList<TENECircuitPackInstall> cps = new ArrayList<TENECircuitPackInstall>();
        retCode = TEBoardUtil.getAllCPs(neID, cps, true);
        if (0 != retCode) {
            return retCode;
        }
        Collections.sort(cps);
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.addPara("annotation", "// Payloadloadflag\n", false, true);
        scriptObj.writeCommand(cmd);
        cmd.deleteAllPara();
        cmd.setCmdCode(2162691);
        for (TENECircuitPackInstall one : cps) {
            if (!TEBoardUtil.isTUCircuitPack(one.getM_CircuitPackType()) || TEBoardUtil.isEthernetBoard(one.getM_CircuitPackType())) continue;
            HashMap<Integer, TEBoardUtil.TEINDICATIONAttr> portAttrMap = new HashMap<Integer, TEBoardUtil.TEINDICATIONAttr>();
            TIntArrayList attribs = new TIntArrayList();
            attribs.add(208900);
            TEObjectID operObject = new TEObjectID();
            operObject.add(61442);
            operObject.add(neID);
            operObject.add(one.getM_SlotID());
            TreeMap<TEGenKey, TEGenValue> allResult = new TreeMap<TEGenKey, TEGenValue>(new TEKeySorter());
            retCode = TEGnlIF.getAttrib(operObject, attribs, 2107395, allResult, false, 1);
            if (1090595041 == retCode) {
                retCode = 0;
                continue;
            }
            if (0 != retCode) {
                return retCode;
            }
            for (Map.Entry entry : allResult.entrySet()) {
                if (208900 != ((TEGenKey)entry.getKey()).attrID || 61443 != ((TEGenKey)entry.getKey()).objectID.get(0) || 0 != ((TEGenValue)entry.getValue()).access || 0 != ((TEGenValue)entry.getValue()).errCode) continue;
                TEBoardUtil.TEINDICATIONAttr loadvalue = ((TEGenValue)entry.getValue()).iValue == 0 ? TEBoardUtil.TEINDICATIONAttr.INDICATION_UNLOAD : TEBoardUtil.TEINDICATIONAttr.INDICATION_LOAD;
                portAttrMap.put(((TEGenKey)entry.getKey()).objectID.get(3), loadvalue);
            }
            for (Map.Entry oneAttr : portAttrMap.entrySet()) {
                String strBDName = TEBoardUtil.board2Str(neID, one.getM_SlotID(), one.getM_CircuitPackType(), (Integer)oneAttr.getKey(), "");
                strBDName = strBDName.toUpperCase();
                cmd.addPara("board", strBDName, false, true);
                cmd.addPara("payloadloadflag", ((TEBoardUtil.TEINDICATIONAttr)((Object)oneAttr.getValue())).ordinal(), false, true);
                scriptObj.writeCommand(cmd);
                cmd.deleteAllPara();
            }
        }
        return retCode;
    }

    public int exportPathName(int neID, ScriptFile scriptObj) {
        int retCode = 0;
        ArrayList<TENECircuitPackInstall> cps = new ArrayList<TENECircuitPackInstall>();
        retCode = TEBoardUtil.getAllCPs(neID, cps, true);
        if (0 != retCode) {
            return retCode;
        }
        Collections.sort(cps);
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.addPara("annotation", "// Path Name\n", false, true);
        scriptObj.writeCommand(cmd);
        cmd.deleteAllPara();
        cmd.setCmdCode(0x210002);
        HashMap<TETTPKey, String> ttpNameMap = new HashMap<TETTPKey, String>();
        for (TENECircuitPackInstall one : cps) {
            ttpNameMap.clear();
            TECircuitPack cp = new TECircuitPack(neID, one.getM_SlotID());
            cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp);
            Set<TETP> tps = cp.getTps();
            for (TETP tp : tps) {
                if (!tp.isNameModify()) continue;
                TETTPKey ttpKey = new TETTPKey();
                tp.toKey(ttpKey);
                ttpNameMap.put(ttpKey, tp.getName());
            }
            Set<TEPortPO> ports = cp.getPortes();
            for (TEPortPO port : ports) {
                Set<TETP> portTTPs = port.getTps();
                if (portTTPs == null) continue;
                for (TETP tp : portTTPs) {
                    if (!tp.isNameModify()) continue;
                    TETTPKey ttpKey = new TETTPKey();
                    tp.toKey(ttpKey);
                    ttpNameMap.put(ttpKey, tp.getName());
                }
            }
            for (Map.Entry entry : ttpNameMap.entrySet()) {
                StringBuffer strTmp = new StringBuffer();
                TEGnlcfgMgrImpl.ttpObj2Str(neID, one.getM_SlotID(), one.getM_CircuitPackType(), (TETTPKey)entry.getKey(), strTmp);
                cmd.addPara("path", strTmp.toString(), false, true);
                strTmp.setLength(0);
                strTmp.append(TEFuncBlockDescription.getInstance().getFBTypeName(((TETTPKey)entry.getKey()).getTTPType()));
                cmd.addPara("type", strTmp.toString(), true, false);
                cmd.addPara("name", (String)entry.getValue(), true, false);
                scriptObj.writeCommand(cmd);
                cmd.deleteAllPara();
            }
        }
        return retCode;
    }

    public static void ttpObj2Str(int neID, int slotID, int cpType, TETTPKey ttpKey, StringBuffer strTTPObj) {
        String strPath = 0 != ttpKey.getTTPLow() ? TEStringUtils.snprintf(19, "-%d-%d", ttpKey.getTTPHigh(), ttpKey.getTTPLow()) : TEStringUtils.snprintf(19, "-%d", ttpKey.getTTPHigh());
        strTTPObj.append(TEBoardUtil.board2Str(neID, slotID, cpType, ttpKey.getPortID() & 0xFFFF, strPath));
        strTTPObj.append(strTTPObj.toString().toUpperCase());
    }

    protected int getPortID(int domain, int portNo) {
        return (domain << 16 & 0xFFFF0000) + (portNo & 0xFFFF);
    }
}

