/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.gencfg.frame.TEGnlVar;
import com.huawei.nglct.gencfg.frame.XMLEquipmentInfo;
import com.huawei.nglct.gencfg.frame.attrvaluernge.TEGnlAttrRangeMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDCfgDataMgr;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDSupportFunObj;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEGetGenCfgAttrBean
implements TENEMgrInterface {
    protected Datainterface outputData = null;
    private Logger log = TELogFactory.getNormalLogger();
    private int neID = 0;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int boardType;
        int slotid;
        Param funIdParam;
        TEGenCfgModel genCfgModel;
        TEBoard boardObj;
        StringBuilder bdInfoStr;
        XMLEquipmentInfo equipInfo;
        String neVersion;
        int neType;
        TENE neObj;
        ArrayList<TEBoard> boardList;
        ArrayList supportAttrList;
        block14: {
            this.neID = neid;
            supportAttrList = new ArrayList();
            boardList = new ArrayList<TEBoard>();
            neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                this.log.error("NE object not exist!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
                return this.outputData;
            }
            neType = neObj.getNEType();
            neVersion = neObj.getShowNEVersion();
            if (neVersion != null && !neVersion.equals("")) {
                neVersion = neObj.getHostVersion();
            }
            TELogFactory.getNormalLogger().debug("Get Support GenCfg AttrList,The neType=" + neType + " neVersion=" + neVersion);
            equipInfo = new XMLEquipmentInfo();
            equipInfo.m_neID = neid;
            equipInfo.m_neType = TEGetNEDomainVersion.getInstance().getDevType(neType);
            equipInfo.m_neVer = Integer.parseInt(neVersion.replace(".", ""));
            bdInfoStr = new StringBuilder();
            boardObj = null;
            genCfgModel = null;
            Param slotidParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "slotid");
            Param boardTypeParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "boardType");
            funIdParam = inputData.getBussinessParams().getRowParams(0).getParam("funid");
            slotid = 0;
            boardType = 0;
            if (null != slotidParam) {
                try {
                    slotid = Integer.parseInt(slotidParam.getValue());
                }
                catch (NumberFormatException e) {
                    slotid = 0;
                }
            }
            if (boardTypeParam != null) {
                try {
                    boardType = Integer.parseInt(boardTypeParam.getValue());
                    TELogFactory.getNormalLogger().debug("Get Support GenCfg AttrList,The slotid=" + slotid + " boardType=" + boardType);
                }
                catch (NumberFormatException e) {
                    if (slotid == 0) break block14;
                    boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                }
            }
        }
        if (slotid < 1) {
            boardList.addAll(this.getBDList(neObj, funIdParam));
        } else {
            TEBoard tempObj = neObj.getBoard(slotid);
            if (tempObj == null) {
                tempObj = new TEBoard(neid, slotid, boardType);
            } else {
                boardType = tempObj.getBoardType();
            }
            boardList.add(tempObj);
            equipInfo.m_slotID = slotid;
            equipInfo.m_cpType = boardType;
        }
        ArrayList supportAttrLis = null;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            boardObj = (TEBoard)boardList.get(i);
            if (null != boardObj) {
                bdInfoStr.append(boardObj.getSlotID()).append("-").append(boardObj.getBoardName()).append(",");
                genCfgModel = TEGenCfgDataMgr.getGenCfgMode(boardObj.getBoardType());
                if (null == genCfgModel || null == (supportAttrLis = genCfgModel.getSupportAttrList(neType, neVersion)) || supportAttrLis.isEmpty()) continue;
                supportAttrList.addAll(supportAttrLis);
                continue;
            }
            this.log.error("board object not exist!");
        }
        this.convertToOutPutData(supportAttrList, equipInfo, boardList, bdInfoStr);
        return this.outputData;
    }

    private List getBDList(TENE neObj, Param funIdParam) {
        if (null == funIdParam) {
            return neObj.getBoardList();
        }
        String funId = funIdParam.getValue();
        if (funId == null || funId.equals("") || funId.equals("0")) {
            return Collections.EMPTY_LIST;
        }
        String funcLanguage = TESysManagerBean.getInstance().getlanguage();
        int neType = neObj.getNEType();
        String BOARD_FUNC_TREE_FILE_NAME = "boardfunctiontree_" + funcLanguage + ".xml";
        TELogFactory.getNormalLogger().info("Get board function tree!");
        String path = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath(neType, null, TEPathManager.CONFIG_PROFILE_PATH + BOARD_FUNC_TREE_FILE_NAME);
        String bundlename = TEGetFilePath.getNEBundleName(neType);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile(bundlename, path);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGetGenCfgAttrBean.getBDList() fail!", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
            return Collections.EMPTY_LIST;
        }
        List<String> supportBDTypeList = this.getSupBDTypeList(doc, funId);
        HashSet<String> bdTypeSet = new HashSet<String>();
        ArrayList<TEBoard> boardList = new ArrayList<TEBoard>();
        List boardObjList = null;
        int size = supportBDTypeList.size();
        for (int i = 0; i < size; ++i) {
            String supBDStr = supportBDTypeList.get(i);
            String[] bdTypeArr = supBDStr.substring(1, supBDStr.length() - 1).split(",");
            for (int j = 0; j < bdTypeArr.length; ++j) {
                bdTypeSet.add(bdTypeArr[j]);
            }
        }
        if ("8518".equals(funIdParam.getValue())) {
            bdTypeSet.add(String.valueOf(2269));
        }
        Iterator iter = bdTypeSet.iterator();
        while (iter.hasNext()) {
            boardObjList = TEConfigurationDataMgr.getInstance().getBoardList(neObj.getNEID(), Integer.parseInt((String)iter.next()));
            boardList.addAll(boardObjList);
        }
        for (TEBoard board : neObj.getBoardList()) {
            boolean isNewPNPBoard = TEPNPBDCfgDataMgr.getInstance().isNewPNPBoard(String.valueOf(board.getBoardType()));
            if (!isNewPNPBoard) continue;
            TEPNPBDSupportFunObj bdSupportFunObj = TEPNPBDCfgDataMgr.getInstance().getBDSupportFun(board.getBoardType());
            if (bdSupportFunObj == null) {
                TELogFactory.getNormalLogger().info("Get PNP Board Function Tree Error : slotId=" + board.getSlotID() + ",boardType=" + board.getBoardType());
                continue;
            }
            if (!bdSupportFunObj.isSupportFunId(funId)) continue;
            boardList.add(board);
        }
        return boardList;
    }

    private List<String> getSupBDTypeList(Document doc, String funId) {
        ArrayList<String> supportBDTypeList = new ArrayList<String>();
        NodeList nodeList = doc.getElementsByTagName("nonleaf");
        NodeList leaf_list = null;
        NodeList itemList = null;
        NodeList supByList = null;
        Element noleaf = null;
        Element element = null;
        Element itemElement = null;
        Element supByElement = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            noleaf = (Element)nodeList.item(i);
            leaf_list = noleaf.getElementsByTagName("leaf");
            for (int j = leaf_list.getLength() - 1; j >= 0; --j) {
                element = (Element)leaf_list.item(j);
                if (!element.getAttribute("defaultFunID").equals(funId) || null == (itemList = element.getElementsByTagName("functionItem")) || itemList.getLength() == 0) continue;
                int kSize = itemList.getLength();
                for (int k = 0; k < kSize; ++k) {
                    itemElement = (Element)itemList.item(k);
                    supByList = itemElement.getElementsByTagName("supported_by");
                    for (int m = supByList.getLength() - 1; m >= 0; --m) {
                        supByElement = (Element)supByList.item(m);
                        if (!supByElement.hasAttribute("bdType")) continue;
                        supportBDTypeList.add(supByElement.getAttribute("bdType"));
                    }
                }
            }
        }
        return supportBDTypeList;
    }

    public void convertToOutPutData(List supportAttrList, XMLEquipmentInfo equipInfo, List boardlist, StringBuilder bdInfoStr) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        if (null == supportAttrList) {
            return;
        }
        TEGnlVar varInstance = TEGnlVar.getInstance();
        TEGnlAttrMgr gnlAttrMgr = TEGnlAttrMgr.getInstance();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams rowparams = null;
        if (bdInfoStr != null && bdInfoStr.length() != 0) {
            rowparams = new RowParams();
            String slotStr = bdInfoStr.toString();
            rowparams.addParam("bdInfo", slotStr.substring(0, slotStr.length() - 1));
            bussinessParams.addRowParams(rowparams);
        }
        TENE neObj = TENEListMgr.getInstance().getNE(this.neID);
        String neverion = neObj.getHostVersion();
        int netype = neObj.getNEType();
        int shelftype = neObj.getShelfType();
        TEPNPGenCfgAttrMgr attrMgr = TEPNPGenCfgAttrMgr.getInstance();
        TEGenCfgAttribute genCfgAttrObj = null;
        String attrId = null;
        String attrAccess = null;
        ArrayList domain_list = null;
        HashSet<String> attrSet = new HashSet<String>();
        int len = supportAttrList.size();
        for (int i = 0; i < len; ++i) {
            int attrAcc;
            rowparams = new RowParams();
            genCfgAttrObj = (TEGenCfgAttribute)supportAttrList.get(i);
            attrId = genCfgAttrObj.getAttrId();
            int attrIntId = varInstance.getGnlVar(attrId);
            if (attrIntId != -1 && attrIntId != 0 && 2 == (attrAcc = gnlAttrMgr.getAttrAccess(attrIntId, equipInfo)) || attrSet.contains(attrId)) continue;
            attrSet.add(attrId);
            attrAccess = genCfgAttrObj.getAccType();
            domain_list = genCfgAttrObj.getDomainList();
            rowparams.addParam("attrId", attrId);
            rowparams.addParam("attrAccess", attrAccess);
            if (genCfgAttrObj.getUnit() > 0) {
                rowparams.addParam("unit", String.valueOf(genCfgAttrObj.getUnit()));
            }
            Param domainParam = new Param("domain_list", "");
            rowparams.addParam("attrRange", TEGnlAttrRangeMgr.getInstance().getAttrRangeJSON(neverion, netype, shelftype, attrId, boardlist));
            if (null != domain_list) {
                int size = domain_list.size();
                for (int index = 0; index < size; ++index) {
                    domainParam.addOption(new Option(((Integer)domain_list.get(index)).toString()));
                }
            }
            rowparams.addParam(domainParam);
            bussinessParams.addRowParams(rowparams);
            rowparams = attrMgr.getPNPRowParams(this.neID, attrId);
            if (rowparams == null) continue;
            bussinessParams.addRowParams(rowparams);
        }
        attrSet = null;
        this.outputData.setBussinessParams(bussinessParams);
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }
}

