/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class TEGenGetWaveLengthBean
extends TENEExplorerBean {
    private static int[] waveBandTypeArr = new int[]{0, 1, 2, 3, 7, 6, 255};
    private static final int ALL_PARITY = 0;
    private static final int NGWDM_MAX = 80;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            String domain = TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType());
            this.inputData = inputData;
            this.outputData = new Datainterface();
            BussinessParams bParams = new BussinessParams();
            TEWaveLengthInfoStaticData waveLengthDataInstance = TEWaveLengthInfoStaticData.getInstance();
            Map waveLengthMap = null;
            RowParams rParam = null;
            for (int i = 0; i < waveBandTypeArr.length; ++i) {
                rParam = new RowParams();
                waveLengthMap = waveLengthDataInstance.getWaveLengthInfoMap(waveBandTypeArr[i], 0, Integer.MAX_VALUE);
                rParam.addParam("bandType", String.valueOf(waveBandTypeArr[i]));
                Set custWaveNOSet = waveLengthMap.keySet();
                ArrayList custWaveNOList = new ArrayList();
                custWaveNOList.addAll(custWaveNOSet);
                WaveComparator waveComparator = new WaveComparator();
                Collections.sort(custWaveNOList, waveComparator);
                int count = 0;
                int size = custWaveNOList.size();
                for (int j = 0; j < size; ++j) {
                    if ((domain.equalsIgnoreCase("ngwdm") || domain.equalsIgnoreCase("tl1ngwdm") || domain.equalsIgnoreCase("wdm")) && waveBandTypeArr[i] == 1 && Integer.parseInt(String.valueOf(custWaveNOList.get(j))) > 80) continue;
                    rParam.addParam("custWaveNO" + j, String.valueOf(custWaveNOList.get(j)));
                    rParam.addParam("waveNO" + j, String.valueOf(waveLengthDataInstance.getWaveNoByCustNO(waveBandTypeArr[i], String.valueOf(custWaveNOList.get(j)))));
                    rParam.addParam("waveLengthInfo" + j, (String)waveLengthMap.get(custWaveNOList.get(j)));
                    ++count;
                }
                rParam.addParam("waveLengthCount", String.valueOf(count));
                bParams.addRowParams(rParam);
            }
            this.outputData.setBussinessParams(bParams);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    class WaveComparator
    implements Comparator {
        WaveComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (String.valueOf(o1).equals("dummy") || String.valueOf(o2).equals("dummy")) {
                return 1;
            }
            return Integer.parseInt(String.valueOf(o1)) - Integer.parseInt(String.valueOf(o2));
        }
    }
}

