/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgObject;
import com.huawei.nglct.gencfg.TEGenCfgObjectFactory;
import com.huawei.nglct.gencfg.TEObjTypeMgr;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGencfgConvertQxFile;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrMgr;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrObj;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEPortUtil;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEGenCfgQueryBean
implements TENEMgrInterface {
    protected static final int TIME_OUT = 120;
    protected static Logger log = TELogFactory.getNormalLogger();
    protected Datainterface outputData = null;
    protected int neid;
    protected SubFunc subFunc = null;
    protected StringBuffer queryAttrListBuff = new StringBuffer();
    public TEResourceUtil res = null;
    protected ArrayList operationList = null;
    protected List attrIdList = new ArrayList();
    protected Datainterface inputData = null;
    protected int slotId = -1;
    protected int boardType = -1;
    ArrayList<Integer> slotIDList = new ArrayList();
    private static ArrayList<String> list = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subFunc = subFunc;
            this.inputData = inputData;
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            this.outputData = new Datainterface();
            if (null == neObj) {
                log.info("Get ne object fail!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596385));
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            this.slotId = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
            this.slotIDList.add(this.slotId);
            TEConfigurationDataMgr.getInstance().startMethodBuffer(neid, this.slotIDList);
            TENEConfigurationDataMgr.getInstance().startBufferSubrack(neid);
            this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotId);
            String fileName = subFunc.getGenCfgAttrDesPath().getContent();
            String parentPath = TEFileUtil.getParentPath(TEFileUtil.getParentPath(TEFileUtil.getParentPath(fileName)));
            StringBuffer filePath = new StringBuffer("nemgr").append(File.separator).append(parentPath).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEResourceUtil.getInstance(filePath.toString());
            this.operationList = (ArrayList)this.getQueryOperationList(inputData);
            if (null == this.operationList || this.operationList.isEmpty()) {
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            this.filterOperationList(this.operationList, this.slotId, this.boardType);
            if (null == this.operationList || this.operationList.isEmpty()) {
                log.info("Filter result:The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090593051));
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            OperationResult result = null;
            ArrayList operList = null;
            int m = 200;
            int n = this.operationList.size();
            for (int i = 0; i < n; i += m) {
                operList = new ArrayList();
                if (i + m > n) {
                    operList.addAll(this.operationList.subList(i, n));
                } else {
                    operList.addAll(this.operationList.subList(i, i + m));
                }
                result = TECommuNEMgr.getInstance().sendCommand(neid, operList, this.getTimeOut(), subFunc);
                if (0 != result.retCode) break;
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("TEGenCfgQueryBean thread sleep error! " + e.getMessage());
                }
            }
            if (0 == result.retCode) {
                log.debug("send command success!");
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, subFunc, this.operationList, filterErrorCodeList);
            } else {
                log.debug("send command fail!The errorCode is :" + result.retCode);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
            }
            if (this.isNeedOperationlog() && null != user) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.info("TEGenCfgQueryBean Exception", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        finally {
            TEConfigurationDataMgr.getInstance().stopMethodBuffer(neid, this.slotIDList);
            TENEConfigurationDataMgr.getInstance().clearBufferSubrack(neid);
        }
        return this.outputData;
    }

    protected List<Operation> getQueryOperationList(Datainterface inputData) {
        String fileName = this.subFunc.getGenCfgAttrDesPath().getContent();
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(this.boardType);
        ArrayList operList = null;
        if (genCfgModel != null && genCfgModel.isContainFunattrFilePath(fileName)) {
            TEGencfgConvertQxFile qxfile = genCfgModel.getTEGenCfgFunCmd(fileName);
            TEGenCfgFunCmd convertFunCmd = this.getGenCfgFunCmd(qxfile.getFileName());
            operList = this.getQueryOperationList(convertFunCmd, inputData);
            if (qxfile.isCes()) {
                List portList = (List)TEConfigurationDataMgr.getInstance().getLogicPortList(this.neid, this.slotId).clone();
                List<Integer> cesPortList = TEPortUtil.getCESModePortList(this.neid, this.slotId, portList);
                TEGenCfgDataConvertor.filterOperation(operList, cesPortList);
                TEGenCfgFunCmd funCmd = this.getGenCfgFunCmd(fileName);
                ArrayList lastOperList = this.getQueryOperationList(funCmd, inputData);
                TEGenCfgDataConvertor.filterOperation(lastOperList, portList);
                operList.addAll(lastOperList);
            }
            log.info("boardType(" + this.boardType + ") gencfg file(" + this.subFunc.getGenCfgAttrDesPath().getContent() + ") convert to" + fileName);
        } else {
            TEGenCfgFunCmd funCmd = this.getGenCfgFunCmd(fileName);
            operList = this.getQueryOperationList(funCmd, inputData);
        }
        if (null == operList || operList.isEmpty()) {
            log.info("The operationlist is null!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596479));
        }
        return operList;
    }

    protected TEGenCfgFunCmd getGenCfgFunCmd(String fileName) {
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(fileName);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        return TEGenCfgCmdFactory.getInstance().getFunCmd(path);
    }

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operationList = new ArrayList();
        if (null == funCmd) {
            log.info("Parse atrribute To qx mapping file fail!");
            return operationList;
        }
        Datainterface tmpData = new Datainterface();
        TEPNPGenCfgAttrMgr attrMgr = TEPNPGenCfgAttrMgr.getInstance();
        for (int rowIndex = 0; rowIndex < inputData.getBussinessParams().getRowParamsCount(); ++rowIndex) {
            RowParams rowparams = inputData.getBussinessParams().getRowParams(rowIndex);
            tmpData.setBussinessParams(new BussinessParams());
            tmpData.getBussinessParams().addRowParams(rowparams);
            ArrayList attrList = this.getQueryAttrList(rowparams);
            this.attrIdList.addAll(attrList);
            String attrId = "";
            String groupAttr = "";
            for (int i = attrList.size() - 1; i >= 0; --i) {
                TEPNPGenCfgAttrObj pnpAttr;
                attrId = (String)attrList.get(i);
                TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrId, "query");
                if (null == funAttr && ((pnpAttr = attrMgr.getAttrById(this.neid, attrId)) == null || null == (funAttr = pnpAttr.getFunCmd().getGenCfgFunAttr(attrId, "query")))) continue;
                this.getQueryAttrOperationList(funAttr, operationList, attrId, tmpData);
                int len = funAttr.getGroupAttrList().size();
                for (int index = 0; index < len; ++index) {
                    groupAttr = (String)funAttr.getGroupAttrList().get(index);
                    if (groupAttr.equalsIgnoreCase(attrId) || !attrList.remove(groupAttr)) continue;
                    if (!list.contains(groupAttr)) {
                        this.queryAttrListBuff.append(",").append(this.res.getString(this.convertAttrRes(groupAttr)));
                    }
                    --i;
                }
            }
        }
        return operationList;
    }

    public String convertAttrRes(String groupAttr) {
        return groupAttr;
    }

    public ArrayList getQueryAttrList(RowParams rowparams) {
        ArrayList<String> attrList = new ArrayList<String>();
        String paramName = "";
        for (int i = rowparams.getParamCount() - 1; i >= 0; --i) {
            paramName = rowparams.getParam(i).getName();
            if (!"attrId".equalsIgnoreCase(paramName)) continue;
            attrList.add(rowparams.getParam(i).getValue());
        }
        return attrList;
    }

    public void getQueryAttrOperationList(TEGenCfgFunAttr funAttr, ArrayList operationList, String attrId, Datainterface inputData) {
        if (null == funAttr) {
            return;
        }
        String operationName = funAttr.getPtcode();
        ArrayList<String> operationNameList = new ArrayList<String>();
        operationNameList.add(operationName);
        String additioncmd = funAttr.getAdditionCmd();
        if (null != additioncmd && !"".equals(additioncmd.trim())) {
            operationNameList.add(additioncmd);
        }
        Datainterface convertData = inputData;
        if (this.isNeedExpandOperObj(attrId) && null == (convertData = this.performExpandOperObj(attrId, funAttr, inputData))) {
            return;
        }
        ArrayList subOperationList = TEGenCfgDataConvertor.convertToOperation(funAttr, convertData, this.neid, operationNameList);
        if (null != subOperationList && 0 != subOperationList.size()) {
            operationList.addAll(subOperationList);
            if (!list.contains(attrId) && !this.res.getString(attrId).equals("")) {
                this.queryAttrListBuff.append(",").append(this.res.getString(attrId));
            }
        }
    }

    public Datainterface performExpandOperObj(String attrId, TEGenCfgFunAttr funAttr, Datainterface inputData) {
        String srcObjType = "ID_OBJECT_TYPE_NE";
        Param srcObjTypeParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "srcObjType");
        if (null != srcObjTypeParam) {
            srcObjType = srcObjTypeParam.getValue();
        }
        TEGenCfgObject srcObj = TEGenCfgObjectFactory.getInstance().getGencfgobj(srcObjType);
        String sinkobjType = funAttr.getObjectType();
        TEGenCfgObject sinkObj = TEGenCfgObjectFactory.getInstance().getGencfgobj(sinkobjType);
        if (null == srcObj || null == sinkObj) {
            return null;
        }
        if (!sinkobjType.equalsIgnoreCase(srcObjType) && srcObj.getLevel() <= sinkObj.getLevel()) {
            return this.expandOperObj(srcObjType, sinkobjType, attrId, inputData);
        }
        return inputData;
    }

    public Datainterface expandOperObj(String srcObjType, String sinkObjType, String attrId, Datainterface inputData) {
        log.debug("srcObjType = " + srcObjType + " sinkObjType = " + sinkObjType);
        TEObjTypeMgr objTypeMgr = TEObjTypeMgr.getInstance();
        String methodName = objTypeMgr.getConvertMethod(srcObjType, sinkObjType);
        Class[] type = new Class[]{String.class, Datainterface.class};
        Object[] value = new Object[]{attrId, inputData};
        Datainterface converInputData = null;
        try {
            converInputData = (Datainterface)TEObjTypeMgr.class.getMethod(methodName, type).invoke((Object)objTypeMgr, value);
        }
        catch (Exception e) {
            log.error("expand operation object fail!", (Throwable)e);
            return null;
        }
        return converInputData;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    public ArrayList getFilterErrorCodeList() {
        if (this.subFunc != null && this.subFunc.getFilterErrCodeList() != null && !this.subFunc.getFilterErrCodeList().isEmpty()) {
            return this.subFunc.getFilterErrCodeList();
        }
        return null;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return false;
    }

    @Override
    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            if (outputData == null) {
                return;
            }
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0) {
                loginfo = new TELogInfo();
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length == 0) continue;
                    loginfo = new TELogInfo();
                    loginfo.setResult(errorCode);
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                }
            } else {
                loginfo = new TELogInfo();
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            }
            String queryAttrList = this.getQueryAttrListBuff().toString();
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                String detailDes = operObj;
                Param islogDetailParam = inputData.getBussinessParams().getRowParams(0).getParam("islogDetail");
                if (null != islogDetailParam && "0".equals(islogDetailParam.getValue())) {
                    detailDes = operObj;
                } else if (null != inputData.getBussinessParams().getRowParams(0).getParam("slotid")) {
                    int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
                    String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
                    if (!"".equals(subrackname)) {
                        detailDes = detailDes + "-" + subrackname;
                    }
                    int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    detailDes = detailDes + "-" + TEBoardUtil.getSlotIDFromSlot(neid, slotid) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                }
                if (islogDetailParam != null && "0".equals(islogDetailParam.getValue())) {
                    queryAttrList = loginfo.getOperateName();
                } else if (0 == queryAttrList.indexOf(",")) {
                    queryAttrList = queryAttrList.substring(1);
                }
                if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() && queryAttrList.length() + detailDes.length() > 255) {
                    String temp = detailDes + ":" + queryAttrList;
                    String firstLog = temp.substring(0, 255);
                    int index = firstLog.lastIndexOf(",");
                    loginfo.setOperateDesc(firstLog.substring(0, index));
                    TELogMgr.writeLog(loginfo);
                    TELogInfo cloneLogInfo = new TELogInfo();
                    cloneLogInfo.setResult(loginfo.getResult());
                    cloneLogInfo.setErrCode(loginfo.getErrCode());
                    cloneLogInfo.setErrInfo(loginfo.getErrInfo());
                    cloneLogInfo.setCmdID(loginfo.getCmdID());
                    cloneLogInfo.setLocation(loginfo.getLocation());
                    cloneLogInfo.setUserID(loginfo.getUserID());
                    cloneLogInfo.setUserName(loginfo.getUserName());
                    cloneLogInfo.setOperateName(loginfo.getOperateName());
                    cloneLogInfo.setOperateObject(loginfo.getOperateObject());
                    queryAttrList = temp.substring(index + 1, temp.length());
                    cloneLogInfo.setOperateDesc(queryAttrList);
                    loginfoList.add(cloneLogInfo);
                    continue;
                }
                loginfo.setOperateDesc(detailDes + ":" + queryAttrList);
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    protected StringBuffer getQueryAttrListBuff() {
        return this.queryAttrListBuff;
    }

    public int getTimeOut() {
        return 120;
    }

    public int updateDB() {
        return 0;
    }

    protected void sortErrorByPortOtn(Datainterface outputData) {
        int rowCount = outputData.getBussinessParams().getRowParamsCount();
        if (0 == rowCount) {
            return;
        }
        RowErrors error1 = null;
        RowErrors error2 = null;
        RowParams temp = outputData.getBussinessParams().getRowParams(rowCount - 1);
        if (null == temp) {
            return;
        }
        RowErrors[] errors = temp.getRowErrors();
        if (null == errors) {
            return;
        }
        int size = errors.length;
        for (int out = size - 1; out > 0; --out) {
            for (int in = 0; in < out; ++in) {
                int level2;
                int level1;
                int port2;
                error1 = temp.getRowErrors(in);
                error2 = temp.getRowErrors(in + 1);
                if (null == error1.getParam("port") || null == error2.getParam("port")) continue;
                int port1 = Integer.parseInt(error1.getParam("port").getValue());
                if (port1 < (port2 = Integer.parseInt(error2.getParam("port").getValue()))) {
                    temp.setRowErrors(in, error2);
                    temp.setRowErrors(in + 1, error1);
                    continue;
                }
                if (port1 != port2 || null == error1.getParam("path") || null == error2.getParam("path")) continue;
                int path1 = Integer.parseInt(error1.getParam("path").getValue());
                int path2 = Integer.parseInt(error2.getParam("path").getValue());
                if (path1 == 65537) {
                    path1 = 1;
                }
                if (path2 == 65537) {
                    path2 = 1;
                }
                if (path1 < path2) {
                    temp.setRowErrors(in, error2);
                    temp.setRowErrors(in + 1, error1);
                    continue;
                }
                if (path1 != path2 || null == error1.getParam("level") || null == error2.getParam("level") || (level1 = Integer.parseInt(error1.getParam("level").getValue())) >= (level2 = Integer.parseInt(error2.getParam("level").getValue()))) continue;
                temp.setRowErrors(in, error2);
                temp.setRowErrors(in + 1, error1);
            }
        }
    }

    protected void sortByPortOtn(Datainterface outputData) {
        int size = outputData.getBussinessParams().getRowParamsCount();
        RowParams params1 = null;
        RowParams params2 = null;
        for (int out = size - 1; out > 0; --out) {
            for (int in = 0; in < out; ++in) {
                int level2;
                int level1;
                int port2;
                params1 = outputData.getBussinessParams().getRowParams(in);
                params2 = outputData.getBussinessParams().getRowParams(in + 1);
                if (null == params1.getParam("port") || null == params2.getParam("port")) continue;
                int port1 = Integer.parseInt(params1.getParam("port").getValue());
                if (port1 > (port2 = Integer.parseInt(params2.getParam("port").getValue()))) {
                    this.swap(outputData, params1, params2, in, in + 1);
                    continue;
                }
                if (port1 != port2 || null == params1.getParam("path") || null == params2.getParam("path")) continue;
                int path1 = Integer.parseInt(params1.getParam("path").getValue());
                int path2 = Integer.parseInt(params2.getParam("path").getValue());
                if (path1 == 65537) {
                    path1 = 1;
                }
                if (path2 == 65537) {
                    path2 = 1;
                }
                if (path1 > path2) {
                    this.swap(outputData, params1, params2, in, in + 1);
                    continue;
                }
                if (path1 != path2 || null == params1.getParam("level") || null == params2.getParam("level") || (level1 = Integer.parseInt(params1.getParam("level").getValue())) <= (level2 = Integer.parseInt(params2.getParam("level").getValue()))) continue;
                this.swap(outputData, params1, params2, in, in + 1);
            }
        }
    }

    private void swap(Datainterface outputData, RowParams params1, RowParams params2, int one, int two) {
        outputData.getBussinessParams().setRowParams(one, params2);
        outputData.getBussinessParams().setRowParams(two, params1);
    }

    protected void filterOperationList(List operationList, int slotid, int boardType) {
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        int boardMode = TEGetBoardMode.getBoardMode(this.neid, slotid);
        if (boardMode == 0 && !cpDesc.isCPSupportSYNC(boardType)) {
            return;
        }
        int portId = 0;
        Part part = null;
        Operation oper = null;
        TEPortParaRecord paraRecord = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            oper = (Operation)operationList.get(i);
            part = oper.getInput().getPart("port");
            if (null == part || (portId = Integer.valueOf(part.getValue()).intValue()) <= 0 || null == (paraRecord = cpDesc.getCPPortPara(boardType, portId)) || null == paraRecord.boardModeList || paraRecord.boardModeList.contains(boardMode)) continue;
            operationList.remove(i);
        }
    }

    static {
        list.add("W32PORT_ATTR_WAVETYPE_RANGE");
    }
}

