/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.gencfg.TEGenCfgRowObj;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;

public class TEGenCfgOperation {
    private Operation operation = null;
    private ArrayList operationObject = null;
    private HashMap<TEGenCfgRowObj, Output> rowOutputMap = new HashMap();

    public TEGenCfgOperation(ArrayList _operationObject, Operation _operation) {
        this.operation = _operation;
        this.operationObject = _operationObject;
        this.initOutputMap();
    }

    private void initOutputMap() {
        int len = this.operation.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output tmpOutput = this.operation.getOutput(i);
            ArrayList tmpoperObjPart = TEDataConverter.getOperObjData(this.operationObject, this.operation.getInput(), tmpOutput);
            TEGenCfgRowObj rowObjKey = new TEGenCfgRowObj(tmpoperObjPart);
            Output output = this.rowOutputMap.get(rowObjKey);
            if (output != null) continue;
            this.rowOutputMap.put(rowObjKey, tmpOutput);
        }
    }

    public void joinOperationPart(TEGenCfgRowObj key, Output srcOutput) {
        Output desOutput = this.rowOutputMap.get(key);
        Part partObj = null;
        int faultCode = Integer.parseInt(srcOutput.getFault(0).getCode());
        int partLen = srcOutput.getPartCount();
        for (int part = 0; part < partLen; ++part) {
            partObj = desOutput.getPart(srcOutput.getPart(part).getName());
            if (null == desOutput.getPart(srcOutput.getPart(part).getName())) {
                desOutput.addPart(srcOutput.getPart(part));
                continue;
            }
            if (0 != faultCode) continue;
            partObj.setValue(srcOutput.getPart(part).getValue());
        }
        desOutput.addFault(srcOutput.getFault(0));
    }

    public void clearOutput(TEGenCfgRowObj key) {
        Output desOutput = this.rowOutputMap.get(key);
        this.operation.clearOutput();
        this.operation.addOutput(desOutput);
    }

    public Operation getOperation() {
        return this.operation;
    }
}

