/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.TEGenCfgObject;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEGenCfgObjectFactory {
    private static final String filePath = TEResourceManager.getPath() + File.separator + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "gencfg" + File.separator + "object_definition_lct.xml";
    private static TEGenCfgObjectFactory instance = null;
    private ArrayList gencfgobjlist = null;

    private TEGenCfgObjectFactory() {
        this.parseObjDefinition();
    }

    public static synchronized TEGenCfgObjectFactory getInstance() {
        if (null == instance) {
            instance = new TEGenCfgObjectFactory();
        }
        return instance;
    }

    private void parseObjDefinition() {
        Document doc = TEParseXMLFile.parseFile(filePath);
        if (null == doc) {
            return;
        }
        this.gencfgobjlist = new ArrayList();
        NodeList objNodeList = doc.getElementsByTagName("object_define");
        NodeList paramNodeList = null;
        ArrayList<String> paramlist = null;
        TEGenCfgObject gencfgobject = null;
        Element objEle = null;
        Element objTypeNode = null;
        int size = objNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            gencfgobject = new TEGenCfgObject();
            objEle = (Element)objNodeList.item(i);
            objTypeNode = (Element)objEle.getElementsByTagName("object_type").item(0);
            gencfgobject.setObjName(objTypeNode.getAttribute("name"));
            if (this.gencfgobjlist.contains(gencfgobject)) continue;
            gencfgobject.setLevel(Integer.parseInt(objTypeNode.getAttribute("level")));
            paramNodeList = objEle.getElementsByTagName("param");
            paramlist = new ArrayList<String>();
            int paramlen = paramNodeList.getLength();
            for (int index = 0; index < paramlen; ++index) {
                paramlist.add(((Element)paramNodeList.item(index)).getAttribute("name"));
            }
            gencfgobject.setParamList(paramlist);
            this.gencfgobjlist.add(gencfgobject);
        }
    }

    public ArrayList getGencfgobjlist() {
        return this.gencfgobjlist;
    }

    public TEGenCfgObject getGencfgobj(String objName) {
        TEGenCfgObject gencfgobj = null;
        if (null == this.gencfgobjlist) {
            return null;
        }
        int size = this.gencfgobjlist.size();
        for (int i = 0; i < size; ++i) {
            gencfgobj = (TEGenCfgObject)this.gencfgobjlist.get(i);
            if (!objName.equalsIgnoreCase(gencfgobj.getObjName())) continue;
            return gencfgobj;
        }
        return null;
    }
}

