/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgErrorObj;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunAttrParam;
import com.huawei.nglct.gencfg.TEGenCfgOperation;
import com.huawei.nglct.gencfg.TEGenCfgRowObj;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrMgr;
import com.huawei.nglct.nelist.pnp.gencfg.TEPNPGenCfgAttrObj;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEGenCfgDataConvertor {
    private TEGenCfgDataConvertor() {
    }

    public static ArrayList convertToOperation(TEGenCfgFunAttr funAttr, Datainterface inputData, int neid, ArrayList operationNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation_src = null;
        Input input = null;
        RowParams rowparams = null;
        if (null == operationNameList) {
            return null;
        }
        TEPNPGenCfgAttrMgr attrMgr = TEPNPGenCfgAttrMgr.getInstance();
        String qxFilePath = "";
        TEPNPGenCfgAttrObj attrObj = attrMgr.getAttrById(neid, funAttr.getAttrId());
        if (attrObj != null) {
            qxFilePath = attrObj.getQxFilePath();
        }
        int paramCount = 0;
        int size = operationNameList.size();
        for (int i = 0; i < size; ++i) {
            operation_src = TECreateObjectFactory.getOperation(neid, (String)operationNameList.get(i));
            if (null == operation_src && !"".equals(qxFilePath) && null == (operation_src = TECreateObjectFactory.getOperation(qxFilePath, (String)operationNameList.get(i))) || null == operation_src) continue;
            Operation operation = null;
            int rowlen = businessparams.getRowParamsCount();
            for (int row = 0; row < rowlen; ++row) {
                rowparams = businessparams.getRowParams(row);
                paramCount = rowparams.getParamCount();
                operation = (Operation)operation_src.clone();
                input = operation.getInput();
                TEGenCfgDataConvertor.convertParam(funAttr, operation);
                int partlen = input.getPartCount();
                for (int part = 0; part < partlen; ++part) {
                    for (int param = 0; param < paramCount; ++param) {
                        if (!input.getPart(part).getName().equalsIgnoreCase(rowparams.getParam(param).getName()) || null == rowparams.getParam(param).getValue()) continue;
                        input.getPart(part).setValue(rowparams.getParam(param).getValue());
                        input.getPart(part).setModifyFlag(rowparams.getParam(param).getModifyFlag());
                    }
                }
                operationList.add(operation);
            }
        }
        return operationList;
    }

    public static ArrayList convertToOperation_NoLock(TEGenCfgFunAttr funAttr, Datainterface inputData, int neid, ArrayList operationNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation1 = null;
        Input input1 = null;
        RowParams rowparams1 = null;
        if (null == operationNameList) {
            return null;
        }
        TEPNPGenCfgAttrMgr attrMgr = TEPNPGenCfgAttrMgr.getInstance();
        String qxFilePath = "";
        TEPNPGenCfgAttrObj attrObj = attrMgr.getAttrById(neid, funAttr.getAttrId());
        if (attrObj != null) {
            qxFilePath = attrObj.getQxFilePath();
        }
        int paramCount = 0;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams1 = businessparams.getRowParams(row);
            paramCount = rowparams1.getParamCount();
            int size = operationNameList.size();
            for (int i = 0; i < size; ++i) {
                operation1 = TECreateObjectFactory.getOperation_NoLock(neid, (String)operationNameList.get(i));
                if (null == operation1 && !"".equals(qxFilePath) && null == (operation1 = TECreateObjectFactory.getOperation(qxFilePath, (String)operationNameList.get(i))) || null == operation1) continue;
                input1 = operation1.getInput();
                TEGenCfgDataConvertor.convertParam(funAttr, operation1);
                int partlen = input1.getPartCount();
                for (int part = 0; part < partlen; ++part) {
                    for (int param = 0; param < paramCount; ++param) {
                        if (!input1.getPart(part).getName().equalsIgnoreCase(rowparams1.getParam(param).getName()) || null == rowparams1.getParam(param).getValue()) continue;
                        input1.getPart(part).setValue(rowparams1.getParam(param).getValue());
                        input1.getPart(part).setModifyFlag(rowparams1.getParam(param).getModifyFlag());
                    }
                }
                operationList.add(operation1);
            }
        }
        return operationList;
    }

    private static void convertParam(TEGenCfgFunAttr funAttr, Operation operation) {
        ArrayList paramList = funAttr.getParamList();
        TEGenCfgFunAttrParam param = null;
        Part inputPart = null;
        Part outputPart = null;
        String value = "";
        String convertId = "";
        if (null == paramList) {
            return;
        }
        int len = paramList.size();
        for (int i = 0; i < len; ++i) {
            param = (TEGenCfgFunAttrParam)paramList.get(i);
            inputPart = operation.getInput().getPart(param.getId());
            outputPart = operation.getOutput(0).getPart(param.getId());
            value = param.getValue();
            convertId = param.getConvertId();
            if (null != value && !"".equals(value.trim())) {
                if (null != inputPart) {
                    inputPart.setValue(value);
                }
                if (null != outputPart) {
                    outputPart.setValue(value);
                }
            }
            if (null == convertId || "".equals(convertId.trim())) continue;
            if (null != inputPart) {
                inputPart.setName(convertId);
            }
            if (null == outputPart) continue;
            outputPart.setName(convertId);
        }
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList) {
        return TEGenCfgDataConvertor.convertToDatainterface(neid, subfunc, operationList, null);
    }

    public static Datainterface convertToDatainterface(int neid, int slotID, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList errorData = TEGenCfgDataConvertor.joinOperation(neid, slotID, subfunc, operationList, filterErrorCodeList);
        return TEGenCfgDataConvertor.createOutputData(neid, subfunc, operationList, filterErrorCodeList, errorData);
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList errorData = null;
        errorData = 2180060 == subfunc.getCode() ? TEGenCfgDataConvertor.fastJoinOperation(neid, subfunc, operationList, filterErrorCodeList) : TEGenCfgDataConvertor.joinOperation(neid, -1, subfunc, operationList, filterErrorCodeList);
        return TEGenCfgDataConvertor.createOutputData(neid, subfunc, operationList, filterErrorCodeList, errorData);
    }

    private static Datainterface createOutputData(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList, ArrayList errorData) {
        int i;
        Operation operation = null;
        if (null == operationList || operationList.isEmpty()) {
            return null;
        }
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        RowParams rowparams = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        boolean flag = false;
        int len = operationList.size();
        block0: for (i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr(operation);
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError(output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    TEGenCfgDataConvertor.handleRowData(neid, subfunc, rowparams, output);
                    flag = false;
                } else {
                    TEGenCfgDataConvertor.handleRowData(neid, subfunc, rowparams, output);
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                row_succ = false;
            }
        }
        if (null != errorData && !errorData.isEmpty()) {
            fault = true;
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (!succ && fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    public static ArrayList handleErrorData(int neid, SubFunc subfunc, Input input, Output output, String neName) {
        int len;
        int i;
        String errorCode = "";
        ArrayList operObjct = TEDataConverter.getOperationObject(subfunc);
        operObjct.add("subcardid");
        operObjct.add("subslotid");
        operObjct.add("subcard");
        ArrayList<RowErrors> errorObjList = new ArrayList<RowErrors>();
        ArrayList<String> errorAttrList = new ArrayList<String>();
        errorCode = output.getFault(0).getCode();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        if (!"".equals(errorCode)) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(Integer.parseInt(errorCode)));
        }
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        int len2 = input.getPartCount();
        for (i = 0; i < len2; ++i) {
            if (input.getPart(i).getType().equalsIgnoreCase("var")) continue;
            errorparam = new Param(input.getPart(i).getName(), input.getPart(i).getValue());
            rowError.addParam(errorparam);
            if (!input.getPart(i).getModifyFlag() || operObjct.contains(input.getPart(i).getName().toLowerCase()) || errorAttrList.contains(input.getPart(i).getName())) continue;
            errorAttrList.add(input.getPart(i).getName());
        }
        len2 = output.getPartCount();
        for (i = 0; i < len2; ++i) {
            errorparam = new Param(output.getPart(i).getName(), output.getPart(i).getName());
            if (null == rowError.getParam(output.getPart(i).getName())) {
                rowError.addParam(errorparam);
            }
            if (operObjct.contains(output.getPart(i).getName().toLowerCase()) || errorAttrList.contains(output.getPart(i).getName())) continue;
            errorAttrList.add(output.getPart(i).getName());
        }
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        if (null != rowError.getParam("slotid")) {
            try {
                slotid = Integer.parseInt(rowError.getParam("slotid").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Slotid Fail!", (Throwable)e);
                slotid = -1;
            }
            rowError.getParam("slotid").setValue(TEBoardUtil.getSlotIDFromSlot(neid, slotid) + "");
            if (null != rowError.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowError.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowError.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                errorparam = new Param("boardtype", boardtype + "");
                rowError.addParam(errorparam);
            }
            errorparam = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowError.addParam(errorparam);
        }
        if (null != rowError.getParam("neid")) {
            String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
            if (slotid > 0 && !"".equals(subrackname)) {
                neName = neName + "-" + subrackname;
            }
            errorparam = new Param("nename", neName);
            rowError.addParam(errorparam);
        }
        if (null != rowError.getParam("port")) {
            try {
                port = Integer.parseInt(rowError.getParam("port").getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                if (rowError.getParam("port") != null) {
                    rowError.getParam("port").setValue("-1");
                }
                port = -1;
            }
            if (port != 0 && port != -1) {
                errorparam = new Param("portname", TEGenCfgDataConvertor.getPortName(neid, slotid, boardtype, port, subfunc.getPortType()));
                rowError.addParam(errorparam);
            }
        }
        if (0 == (len = errorAttrList.size())) {
            errorObjList.add(rowError);
        } else {
            for (int i2 = 0; i2 < len; ++i2) {
                errorparam = new Param("attrId", (String)errorAttrList.get(i2));
                RowErrors tmpError = (RowErrors)rowError.clone();
                tmpError.addParam(errorparam);
                errorObjList.add(tmpError);
            }
        }
        return errorObjList;
    }

    public static void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Output output) {
        String paramValue = "";
        String paramName = "";
        String paramType = "";
        Param param = null;
        int partCount = output.getPartCount();
        if (0 == partCount) {
            return;
        }
        rowparams.addParam("neid", String.valueOf(neid));
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        Param nenameParam = new Param("nename", neObj.getNEName());
        rowparams.addParam(nenameParam);
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        int path = 0;
        int size = output.getPartCount();
        for (int tmpCol = 0; tmpCol < size; ++tmpCol) {
            param = new Param();
            paramName = output.getPart(tmpCol).getName();
            paramValue = output.getPart(tmpCol).getValue().trim();
            paramType = output.getPart(tmpCol).getType();
            param.setName(paramName);
            if (null == paramValue || "-1".equals(paramValue) && !paramType.equals("string") && !paramType.equals("var") && !"W32PORT_ATTR_MAINBACKINIT".equals(paramName) && !"W32PORT_ATTR_RATEDPOWER".equals(paramName)) {
                param.setValue("/");
                paramValue = "/";
            } else {
                param.setValue(paramValue);
            }
            rowparams.addParam(param);
            if ("slotid".equalsIgnoreCase(paramName)) {
                try {
                    slotid = Integer.parseInt(paramValue);
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("Get slotid Fail!", (Throwable)e);
                }
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                String nename = neObj.getNEName();
                String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
                if (slotid > 0 && !"".equals(subrackname)) {
                    nename = nename + "-" + subrackname;
                }
                nenameParam.setValue(nename);
                param = new Param();
                param.setName("boardname");
                param.setValue(TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
                rowparams.addParam(param);
                continue;
            }
            if ("port".equalsIgnoreCase(paramName)) {
                try {
                    port = Integer.parseInt(paramValue);
                }
                catch (NumberFormatException e) {
                    TELogFactory.getNormalLogger().error("Get port Fail!", (Throwable)e);
                    port = 0;
                }
                param = new Param();
                param.setName("portname");
                param.setValue(TEGenCfgDataConvertor.getPortName(neid, slotid, boardtype, port, subfunc.getPortType()));
                rowparams.addParam(param);
                continue;
            }
            if (!"path".equalsIgnoreCase(paramName)) continue;
            try {
                path = Integer.parseInt(paramValue);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Get path Fail!", (Throwable)e);
                path = 0;
            }
            param = new Param();
            param.setName("pathname");
            param.setValue(TEGenCfgDataConvertor.getPathName(boardtype, path));
            rowparams.addParam(param);
        }
    }

    private static String getPathName(int boardtype, int path) {
        String pathName = String.valueOf(path);
        if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(boardtype)) {
            pathName = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(path);
        } else if (path <= 0) {
            pathName = "";
        }
        return pathName;
    }

    public static String getPortName(int neid, int slotid, int boardtype, int port, String portType) {
        String portName = "";
        if (portType != null && !portType.isEmpty()) {
            List<Integer> portTypes = TEGenCfgDataConvertor.getPortTypes(portType);
            int len = portTypes.size();
            for (int i = 0; i < len; ++i) {
                portName = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port, portTypes.get(i));
                if ("".equals(portName)) continue;
                portName = port + "(" + portName + ")";
                break;
            }
        }
        if ("".equals(portName)) {
            portName = TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardtype, port);
        }
        return portName;
    }

    private static List<Integer> getPortTypes(String portType) {
        ArrayList<Integer> portTypelist = new ArrayList<Integer>();
        if (portType.equals(String.valueOf(11))) {
            portTypelist.add(2817);
            portTypelist.add(1802);
        }
        return portTypelist;
    }

    public static ArrayList joinOperation(int neid, int slotid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList errorDataList;
        block24: {
            String neName;
            int faultCode;
            Operation tmpOperation;
            Operation descOperation;
            block22: {
                int len;
                Output tmpOutput;
                Output curOutput;
                Operation operation;
                ArrayList tmpoperObjPart;
                ArrayList operObjPart;
                ArrayList operationObject;
                block23: {
                    if (null == filterErrorCodeList) {
                        filterErrorCodeList = new ArrayList();
                    }
                    errorDataList = new ArrayList();
                    operationObject = TEDataConverter.getOperationObject(subfunc);
                    operObjPart = null;
                    tmpoperObjPart = null;
                    descOperation = null;
                    operation = null;
                    tmpOperation = null;
                    curOutput = null;
                    tmpOutput = null;
                    len = 0;
                    faultCode = 0;
                    if (null == operationList || operationList.isEmpty()) {
                        return errorDataList;
                    }
                    TENE neObj = TENEListMgr.getInstance().getNE(neid);
                    neName = neObj.getNEName();
                    len = operationList.size();
                    if (null == operationObject || operationObject.isEmpty()) break block22;
                    if (slotid == -1 || len <= 100) break block23;
                    HashMap<TEGenCfgRowObj, TEGenCfgOperation> rowOprListMap = new HashMap<TEGenCfgRowObj, TEGenCfgOperation>();
                    HashMap errorRowAttrMap = new HashMap();
                    for (int i = 0; i < len; ++i) {
                        operation = (Operation)operationList.get(i);
                        TEDataConverter.copyInDataToOutData(operation);
                        int ouputlen = operation.getOutputCount();
                        for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                            curOutput = operation.getOutput(outputIndex);
                            try {
                                faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                            }
                            catch (Exception e) {
                                TELogFactory.getNormalLogger().error("operation name->" + operation.getName(), (Throwable)e);
                            }
                            if (filterErrorCodeList.contains(faultCode)) continue;
                            operObjPart = TEDataConverter.getOperObjData(operationObject, operation.getInput(), curOutput);
                            TEGenCfgRowObj rowObjKey = new TEGenCfgRowObj(operObjPart);
                            TEGenCfgOperation cfgOperation = new TEGenCfgOperation(operationObject, (Operation)operation.clone());
                            TEGenCfgOperation valueOpertaion = (TEGenCfgOperation)rowOprListMap.get(rowObjKey);
                            if (valueOpertaion == null) {
                                rowOprListMap.put(rowObjKey, cfgOperation);
                                cfgOperation.clearOutput(rowObjKey);
                            } else {
                                valueOpertaion.joinOperationPart(rowObjKey, curOutput);
                            }
                            if (0 == faultCode) continue;
                            RowErrors rowError = new RowErrors();
                            Param errorparam = new Param("neid", String.valueOf(neid));
                            rowError.addParam(errorparam);
                            ArrayList<String> errorAttrList = TEGenCfgDataConvertor.getErrorAttrList(operationObject, operation.getInput(), curOutput, rowError);
                            ArrayList<TEGenCfgErrorObj> errorAttrValue = (ArrayList<TEGenCfgErrorObj>)errorRowAttrMap.get(rowObjKey);
                            if (errorAttrValue == null) {
                                errorAttrValue = new ArrayList<TEGenCfgErrorObj>();
                                errorRowAttrMap.put(rowObjKey, errorAttrValue);
                            }
                            if (errorAttrList.isEmpty()) {
                                TEGenCfgErrorObj errorObj = new TEGenCfgErrorObj("", faultCode, rowError);
                                errorAttrValue.add(errorObj);
                                continue;
                            }
                            for (String str : errorAttrList) {
                                TEGenCfgErrorObj errorObj = new TEGenCfgErrorObj(str, faultCode, rowError);
                                if (errorAttrValue.contains(errorObj)) continue;
                                errorAttrValue.add(errorObj);
                            }
                        }
                    }
                    if (rowOprListMap.size() != 0) {
                        operationList.clear();
                        for (Map.Entry entry : rowOprListMap.entrySet()) {
                            TEGenCfgOperation value = (TEGenCfgOperation)entry.getValue();
                            operationList.add(value.getOperation());
                        }
                    }
                    if (errorRowAttrMap.size() == 0) break block24;
                    errorDataList.addAll(TEGenCfgDataConvertor.handleRowErrorMap(neid, slotid, subfunc, errorRowAttrMap));
                    break block24;
                }
                for (int i = 0; i < len; ++i) {
                    operation = (Operation)operationList.get(i);
                    TEDataConverter.copyInDataToOutData(operation);
                    int ouputlen = operation.getOutputCount();
                    for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                        curOutput = operation.getOutput(outputIndex);
                        try {
                            faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                        }
                        catch (Exception e) {
                            TELogFactory.getNormalLogger().error("operation name->" + operation.getName(), (Throwable)e);
                        }
                        if (filterErrorCodeList.contains(faultCode)) continue;
                        operObjPart = TEDataConverter.getOperObjData(operationObject, operation.getInput(), curOutput);
                        if (0 != faultCode && !filterErrorCodeList.contains(faultCode)) {
                            errorDataList.addAll(TEGenCfgDataConvertor.handleErrorData(neid, subfunc, operation.getInput(), curOutput, neName));
                        }
                        for (int j = i + 1; j < len; ++j) {
                            tmpOperation = (Operation)operationList.get(j);
                            TEDataConverter.copyInDataToOutData(tmpOperation);
                            for (int tmpOutputIndex = tmpOperation.getOutputCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                                tmpOutput = tmpOperation.getOutput(tmpOutputIndex);
                                tmpoperObjPart = TEDataConverter.getOperObjData(operationObject, tmpOperation.getInput(), tmpOutput);
                                if (!TEDataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                                TEGenCfgDataConvertor.joinOperationPart(neid, subfunc, curOutput, tmpOutput, tmpOperation.getInput(), errorDataList, filterErrorCodeList, neName);
                                tmpOperation.removeOutput(tmpOutput);
                            }
                            if (0 != tmpOperation.getOutputCount()) continue;
                            operationList.remove(tmpOperation);
                            --len;
                            --j;
                        }
                    }
                }
                break block24;
            }
            descOperation = (Operation)operationList.get(0);
            for (int output = 0; output < descOperation.getOutputCount(); ++output) {
                Output desOutput = descOperation.getOutput(output);
                faultCode = Integer.parseInt(desOutput.getFault(0).getCode());
                if (0 == faultCode || filterErrorCodeList.contains(faultCode)) continue;
                errorDataList.addAll(TEGenCfgDataConvertor.handleErrorData(neid, subfunc, descOperation.getInput(), desOutput, neName));
            }
            for (int i = operationList.size() - 1; i > 0; --i) {
                tmpOperation = (Operation)operationList.get(i);
                TEGenCfgDataConvertor.joinOperationOutput(neid, subfunc, descOperation, tmpOperation, errorDataList, filterErrorCodeList, neName);
                operationList.remove(tmpOperation);
            }
        }
        return errorDataList;
    }

    private static ArrayList handleRowErrorMap(int neid, int slotid, SubFunc subfunc, HashMap errorRowAttrMap) {
        HashMap<Integer, String> portNameCacheMap = new HashMap<Integer, String>();
        ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String neName = neObj.getNEName();
        String subrackname = TEBoardUtil.getSubrackNameFromSlot(neid, slotid);
        if (!"".equals(subrackname)) {
            neName = neName + "-" + subrackname;
        }
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        int shelfSlot = TEBoardUtil.getSlotIDFromSlot(neid, slotid);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        for (Map.Entry entry : errorRowAttrMap.entrySet()) {
            ArrayList value = (ArrayList)entry.getValue();
            for (TEGenCfgErrorObj obj : value) {
                int port = -1;
                int errorCode = obj.getFaultCode();
                RowErrors rowError = obj.getRowError();
                ErrorMessage errorMessage = new ErrorMessage();
                Param errorparam = null;
                errorMessage.setErrorcode(String.valueOf(errorCode));
                if (errorCode != -1) {
                    errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                }
                rowError.setErrorMessage(errorMessage);
                if (null != rowError.getParam("slotid")) {
                    rowError.getParam("slotid").setValue(String.valueOf(shelfSlot));
                } else {
                    errorparam = new Param("slotid", String.valueOf(shelfSlot));
                    rowError.addParam(errorparam);
                }
                if (null == rowError.getParam("boardtype")) {
                    errorparam = new Param("boardtype", String.valueOf(boardtype));
                    rowError.addParam(errorparam);
                }
                errorparam = new Param("boardname", boardName);
                rowError.addParam(errorparam);
                errorparam = new Param("nename", neName);
                rowError.addParam(errorparam);
                if (null != rowError.getParam("port")) {
                    try {
                        port = Integer.parseInt(rowError.getParam("port").getValue());
                    }
                    catch (NumberFormatException e) {
                        TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                        if (rowError.getParam("port") != null) {
                            rowError.getParam("port").setValue("-1");
                        }
                        port = -1;
                    }
                    if (port != 0 && port != -1) {
                        String portName = (String)portNameCacheMap.get(port);
                        if (null == portName) {
                            portName = TEGenCfgDataConvertor.getPortName(neid, slotid, boardtype, port, subfunc.getPortType());
                            portNameCacheMap.put(port, portName);
                        }
                        errorparam = new Param("portname", portName);
                        rowError.addParam(errorparam);
                    }
                }
                errorparam = new Param("attrId", obj.getAttrID());
                rowError.addParam(errorparam);
                rowErrorList.add(rowError);
            }
        }
        return rowErrorList;
    }

    private static ArrayList<String> getErrorAttrList(ArrayList operObjct, Input input, Output output, RowErrors rowError) {
        int i;
        ArrayList<String> errorAttrList = new ArrayList<String>();
        Param errorparam = null;
        int len = input.getPartCount();
        for (i = 0; i < len; ++i) {
            if (input.getPart(i).getType().equalsIgnoreCase("var")) continue;
            errorparam = new Param(input.getPart(i).getName(), input.getPart(i).getValue());
            rowError.addParam(errorparam);
            if (!input.getPart(i).getModifyFlag() || operObjct.contains(input.getPart(i).getName().toLowerCase()) || errorAttrList.contains(input.getPart(i).getName())) continue;
            errorAttrList.add(input.getPart(i).getName());
        }
        len = output.getPartCount();
        for (i = 0; i < len; ++i) {
            errorparam = new Param(output.getPart(i).getName(), output.getPart(i).getName());
            if (null == rowError.getParam(output.getPart(i).getName())) {
                rowError.addParam(errorparam);
            }
            if (operObjct.contains(output.getPart(i).getName().toLowerCase()) || errorAttrList.contains(output.getPart(i).getName())) continue;
            errorAttrList.add(output.getPart(i).getName());
        }
        return errorAttrList;
    }

    public static ArrayList fastJoinOperation(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList1) {
        if (null == filterErrorCodeList1) {
            filterErrorCodeList1 = new ArrayList();
        }
        ArrayList errorDataList1 = new ArrayList();
        ArrayList operationObject1 = TEDataConverter.getOperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        Operation descOperation = null;
        Operation operation1 = null;
        Operation tmpOperation = null;
        Output curOutput = null;
        Output tmpOutput = null;
        int len = 0;
        int faultCode = 0;
        if (null == operationList || operationList.isEmpty()) {
            return errorDataList1;
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String neName = neObj.getNEName();
        len = operationList.size();
        if (null != operationObject1 && !operationObject1.isEmpty()) {
            for (int i = 0; i < len; ++i) {
                operation1 = (Operation)operationList.get(i);
                TEDataConverter.copyInDataToOutData(operation1);
                int flag = 0;
                int ouputlen = operation1.getOutputCount();
                block3: for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = operation1.getOutput(outputIndex);
                    try {
                        faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("operation name->" + operation1.getName(), (Throwable)e);
                    }
                    if (filterErrorCodeList1.contains(faultCode)) continue;
                    if (0 != faultCode && !filterErrorCodeList1.contains(faultCode)) {
                        errorDataList1.addAll(TEGenCfgDataConvertor.handleErrorData(neid, subfunc, operation1.getInput(), curOutput, neName));
                    }
                    operObjPart = TEDataConverter.getOperObjData(operationObject1, operation1.getInput(), curOutput);
                    for (int j = i + 1; j < len; ++j) {
                        tmpOperation = (Operation)operationList.get(j);
                        TEDataConverter.copyInDataToOutData(tmpOperation);
                        for (int tmpOutputIndex = tmpOperation.getOutputCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpOperation.getOutput(tmpOutputIndex);
                            tmpoperObjPart = TEDataConverter.getOperObjData(operationObject1, tmpOperation.getInput(), tmpOutput);
                            if (TEDataConverter.compareOperObj(operObjPart, tmpoperObjPart)) {
                                TEGenCfgDataConvertor.joinOperationPart(neid, subfunc, curOutput, tmpOutput, tmpOperation.getInput(), errorDataList1, filterErrorCodeList1, neName);
                                tmpOperation.removeOutput(tmpOutput);
                                flag = 1;
                                continue;
                            }
                            if (flag != 1) continue;
                            flag = 2;
                        }
                        if (0 == tmpOperation.getOutputCount()) {
                            operationList.remove(tmpOperation);
                            --len;
                            --j;
                        }
                        if (flag == 2) continue block3;
                    }
                }
            }
        } else {
            descOperation = (Operation)operationList.get(0);
            for (int output = 0; output < descOperation.getOutputCount(); ++output) {
                Output desOutput = descOperation.getOutput(output);
                faultCode = Integer.parseInt(desOutput.getFault(0).getCode());
                if (0 == faultCode || filterErrorCodeList1.contains(faultCode)) continue;
                errorDataList1.addAll(TEGenCfgDataConvertor.handleErrorData(neid, subfunc, descOperation.getInput(), desOutput, neName));
            }
            for (int i = operationList.size() - 1; i > 0; --i) {
                tmpOperation = (Operation)operationList.get(i);
                TEGenCfgDataConvertor.joinOperationOutput(neid, subfunc, descOperation, tmpOperation, errorDataList1, filterErrorCodeList1, neName);
                operationList.remove(tmpOperation);
            }
        }
        return errorDataList1;
    }

    public static void joinOperationPart(int neid, SubFunc subfunc, Output desOutput, Output srcOutput, Input srcInput, ArrayList errorDataList, ArrayList filterErrorCodeList, String neName) {
        Part partObj = null;
        int faultCode = Integer.parseInt(srcOutput.getFault(0).getCode());
        if (filterErrorCodeList.contains(faultCode)) {
            return;
        }
        int partLen = srcOutput.getPartCount();
        for (int part = 0; part < partLen; ++part) {
            partObj = desOutput.getPart(srcOutput.getPart(part).getName());
            if (null == desOutput.getPart(srcOutput.getPart(part).getName())) {
                desOutput.addPart(srcOutput.getPart(part));
                continue;
            }
            if (0 != faultCode) continue;
            partObj.setValue(srcOutput.getPart(part).getValue());
        }
        if (0 != faultCode && !filterErrorCodeList.contains(faultCode)) {
            errorDataList.addAll(TEGenCfgDataConvertor.handleErrorData(neid, subfunc, srcInput, srcOutput, neName));
        }
        desOutput.addFault(srcOutput.getFault(0));
    }

    public static void joinOperationOutput(int neid, SubFunc subfunc, Operation desOpeation, Operation srcOperation, ArrayList errorDataList, ArrayList filterErrorCodeList, String neName) {
        Output desOutput = null;
        Output srcOutput = null;
        Output tmpOutput = null;
        int desOutputCount = desOpeation.getOutputCount();
        int srcOutputCount = srcOperation.getOutputCount();
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        for (int output = 0; output < desOutputCount; ++output) {
            desOutput = desOpeation.getOutput(output);
            tmpOutput = (Output)desOutput.clone();
            for (int tmpoutput = 0; tmpoutput < srcOutputCount; ++tmpoutput) {
                if (0 != tmpoutput) {
                    desOutput = (Output)tmpOutput.clone();
                }
                srcOutput = srcOperation.getOutput(tmpoutput);
                TEGenCfgDataConvertor.joinOperationPart(neid, subfunc, desOutput, srcOutput, srcOperation.getInput(), errorDataList, filterErrorCodeList, neName);
                if (0 == tmpoutput) continue;
                desOpeation.addOutput(desOutput);
            }
        }
    }

    public static void filterOperation(List<Operation> operList, List<Integer> portList) {
        Input input = null;
        for (int i = operList.size() - 1; i >= 0; --i) {
            int portid;
            input = operList.get(i).getInput();
            if (input.getPart("port") == null || input.getPart("port").getValue().isEmpty() || portList.contains(portid = Integer.parseInt(input.getPart("port").getValue()))) continue;
            operList.remove(i);
        }
    }
}

