/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunAttrParam;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGenCfgCmdFactory {
    private static TEGenCfgCmdFactory instance = null;
    private HashMap funCmdMap = null;
    private static Map<String, Integer> uploadAttrMap = new HashMap<String, Integer>();
    private static Map<String, Integer> copyAttrMap = new HashMap<String, Integer>();
    private static Map<String, Integer> consistAttrMap = new HashMap<String, Integer>();
    private static Map<String, Integer> saveAttrMap = new HashMap<String, Integer>();
    private static final String NEED_UPLOAD = "1";
    private static final String NEED_COPY = "1";
    private static final String NEED_CONSISTVERIFY = "1";

    private TEGenCfgCmdFactory() {
    }

    public static synchronized TEGenCfgCmdFactory getInstance() {
        if (null == instance) {
            instance = new TEGenCfgCmdFactory();
        }
        return instance;
    }

    public TEGenCfgFunCmd getFunCmd(String path) {
        TEGenCfgFunCmd funCmd = null;
        if (null == this.funCmdMap) {
            this.funCmdMap = new HashMap();
        }
        if (null == (funCmd = (TEGenCfgFunCmd)this.funCmdMap.get(path)) && null != (funCmd = this.parseGenCfgCmdXML(path))) {
            this.funCmdMap.put(path, funCmd);
        }
        return funCmd;
    }

    private TEGenCfgFunCmd parseGenCfgCmdXML(String path) {
        Document doc = null;
        try {
            File file = TEResourceManager.getFileByName(path);
            doc = TEParseXMLFile.parseFile(file);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGenCfgCmdFactory.parseGenCfgCmdXML() fail!", (Throwable)e);
        }
        if (null == doc) {
            return null;
        }
        NodeList nodelist = doc.getElementsByTagName("group_define");
        HashMap groupMap = new HashMap();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            this.handleGroupNode(nodelist.item(i), groupMap);
        }
        TEGenCfgFunCmd obj = new TEGenCfgFunCmd();
        nodelist = doc.getElementsByTagName("action");
        Element action = null;
        ArrayList qxlist = null;
        String actionName = "";
        int len2 = nodelist.getLength();
        for (int i = 0; i < len2; ++i) {
            action = (Element)nodelist.item(i);
            actionName = action.getAttribute("name");
            qxlist = this.handleActionNode(action, groupMap);
            obj.setNeedUploadArrtMap(uploadAttrMap);
            obj.setNeedCopyArrtMap(copyAttrMap);
            obj.setNeedConsistArrtMap(consistAttrMap);
            obj.setNeedSaveArrtMap(saveAttrMap);
            if (null == qxlist) continue;
            if (actionName.equalsIgnoreCase("QueryFromNE")) {
                obj.setQueryQxList(qxlist);
                continue;
            }
            if (!actionName.equalsIgnoreCase("SET")) continue;
            obj.setSetQxList(qxlist);
        }
        return obj;
    }

    private void handleGroupNode(Node groupNode, HashMap groupMap) {
        NodeList itemNodeList = ((Element)groupNode).getElementsByTagName("item");
        Element itemEle = null;
        Integer groupId = null;
        ArrayList groupAttrList = null;
        int len = itemNodeList.getLength();
        for (int i = 0; i < len; ++i) {
            itemEle = (Element)itemNodeList.item(i);
            groupId = Integer.valueOf(itemEle.getAttribute("groupID"));
            groupAttrList = TEParseXMLFile.splitFromChar(itemEle.getAttribute("attrID"), ',');
            if (null == groupAttrList) continue;
            groupMap.put(groupId, groupAttrList);
        }
    }

    private ArrayList handleActionNode(Element action, HashMap groupMap) {
        ArrayList<TEGenCfgFunAttr> attrList = new ArrayList<TEGenCfgFunAttr>();
        uploadAttrMap.clear();
        copyAttrMap.clear();
        consistAttrMap.clear();
        saveAttrMap.clear();
        NodeList nodelist = action.getElementsByTagName("attr");
        NodeList cmdlist = null;
        NodeList tmp = null;
        Element attrElement = null;
        TEGenCfgFunAttr funAttr = null;
        TEGenCfgFunAttrParam param = null;
        Integer groupId = null;
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            String needSave;
            String needConsistVerify;
            String needCopy;
            attrElement = (Element)nodelist.item(i);
            cmdlist = attrElement.getElementsByTagName("qx5_req_cmd_param");
            if (cmdlist.getLength() <= 0) continue;
            funAttr = new TEGenCfgFunAttr();
            funAttr.setAttrId(attrElement.getAttribute("id"));
            String needUpload = attrElement.getAttribute("IsUpLoad");
            if ("1".equals(needUpload)) {
                uploadAttrMap.put(attrElement.getAttribute("id"), Integer.valueOf(attrElement.getAttribute("macroValue")));
            }
            if ("1".equals(needCopy = attrElement.getAttribute("IsCopy"))) {
                copyAttrMap.put(attrElement.getAttribute("id"), Integer.valueOf(attrElement.getAttribute("macroValue")));
            }
            if ("1".equals(needConsistVerify = attrElement.getAttribute("IsSynCheck"))) {
                consistAttrMap.put(attrElement.getAttribute("id"), Integer.valueOf(attrElement.getAttribute("macroValue")));
            }
            if ("1".equals(needSave = attrElement.getAttribute("saveType"))) {
                saveAttrMap.put(attrElement.getAttribute("id"), Integer.valueOf(attrElement.getAttribute("macroValue")));
            }
            if (null == (tmp = attrElement.getElementsByTagName("object_type")) || tmp.getLength() == 0) {
                funAttr.setObjectType("");
            } else {
                funAttr.setObjectType(((Element)tmp.item(0)).getAttribute("id"));
            }
            tmp = attrElement.getElementsByTagName("ptcode");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setPtcode("");
            } else {
                funAttr.setPtcode(((Element)tmp.item(0)).getAttribute("cmdcode"));
            }
            tmp = attrElement.getElementsByTagName("addition_cmd");
            if (null == tmp || tmp.getLength() == 0) {
                funAttr.setAdditionCmd("");
            } else if (null != (tmp = ((Element)tmp.item(0)).getElementsByTagName("verifycode")) && tmp.getLength() != 0) {
                funAttr.setAdditionCmd(((Element)tmp.item(0)).getAttribute("cmdcode"));
                String neTypeList = ((Element)tmp.item(0)).getAttribute("notSupportNETypeList");
                if (null != neTypeList && !neTypeList.isEmpty()) {
                    funAttr.setNotSupportNETypeList(this.convertStrToList(neTypeList));
                }
            }
            tmp = attrElement.getElementsByTagName("recordGroup");
            if (null != tmp && tmp.getLength() != 0) {
                groupId = Integer.valueOf(((Element)tmp.item(0)).getAttribute("groupID"));
                funAttr.setGroupAttrList((ArrayList)groupMap.get(groupId));
            }
            tmp = attrElement.getElementsByTagName("param");
            int size = tmp.getLength();
            for (int index = 0; index < size; ++index) {
                param = new TEGenCfgFunAttrParam();
                param.setId(((Element)tmp.item(index)).getAttribute("id"));
                param.setValue(((Element)tmp.item(index)).getAttribute("value"));
                param.setConvertId(((Element)tmp.item(index)).getAttribute("convertId"));
                funAttr.addParam(param);
            }
            attrList.add(funAttr);
        }
        return attrList;
    }

    private ArrayList convertStrToList(String str) {
        String[] strArr = str.split(",");
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        int len = strArr.length;
        for (int i = 0; i < len; ++i) {
            tmpList.add(Integer.parseInt(strArr[i]));
        }
        return tmpList;
    }

    public static void main(String[] args) {
        String path = "c:\\test.xml";
        TEGenCfgCmdFactory.getInstance().getFunCmd(path);
    }
}

