/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.List;
import org.slf4j.Logger;

public class TEGenCfgBoardAttr
implements TENEMgrInterface {
    protected int neID;
    protected Datainterface outputData = null;
    protected Logger log = TELogFactory.getNormalLogger();

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        List<TEBoard> boardList = null;
        if (null != neObj) {
            Param attrIDParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "attrID");
            if (attrIDParam != null) {
                String attrId = attrIDParam.getValue();
                boardList = TEGenCfgCommon.getAttrSupportCPs(neid, attrId);
            } else {
                this.log.error("Input attrIDParam is null!");
            }
        } else {
            this.log.error("NE object not exist!");
        }
        if (boardList != null) {
            this.convertToOutPutData(boardList);
        }
        return this.outputData;
    }

    public void convertToOutPutData(List<TEBoard> boardList) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        BussinessParams bussinessParams = new BussinessParams();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            RowParams rowparams = new RowParams();
            int slotid = boardList.get(i).getSlotID();
            String boardName = boardList.get(i).getBoardTypeName();
            rowparams.addParam("slotID", String.valueOf(slotid));
            rowparams.addParam("boradName", boardName);
            bussinessParams.addRowParams(rowparams);
        }
        this.outputData.setBussinessParams(bussinessParams);
    }
}

