/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.genfunctionbean;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.device.TEVersionRelationBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.List;

public class TEGetFuncDesFilePathBean
extends TENEExplorerBean {
    private String funid = null;
    private String funcXMLPath = FUNCTION_XML_PATH + ".xml";
    private static final String FUNCTION_XML_PATH = "functiondes" + File.separator + "conf" + File.separator + "function_";
    private static final String DESCRIPTION_FILE_PATH = "nemgr" + File.separator + "device" + File.separator;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            String name = paramArr[i].getName();
            String value = paramArr[i].getValue();
            if (!name.equalsIgnoreCase("funid")) continue;
            this.funid = value;
            break;
        }
        this.outputData = new Datainterface();
        if (this.funid != null) {
            String bundlename;
            this.funcXMLPath = FUNCTION_XML_PATH + this.funid + ".xml";
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            int neType = ne.getNEType();
            String hostVersion = ne.getHostVersion();
            String domain = TEGetNEDomainVersion.getInstance().getDomain(neType);
            String funFilePath = this.getFunctionPath(neType, domain, bundlename = TEGetNEDomainVersion.getInstance().getBundleName(neType), hostVersion);
            if (funFilePath == null || funFilePath.equals("")) {
                if (domain.equals("tl1ngwdm")) {
                    funFilePath = TEGetFuncDesFilePathBean.getDevFilePath(domain, this.funcXMLPath);
                    File file = TEResourceManager.getFileByName(bundlename, funFilePath);
                    if (!(null != file && file.exists() || null != (file = TEResourceManager.getFileByName(bundlename, funFilePath = "nemgr" + File.separator + "tl1ngwdm" + File.separator + this.funcXMLPath)) && file.exists())) {
                        funFilePath = "nemgr" + File.separator + "tl1necommon" + File.separator + this.funcXMLPath;
                    }
                } else {
                    funFilePath = TEGetFuncDesFilePathBean.getDevFilePath(domain, FUNCTION_XML_PATH + this.funid + ".xml");
                }
                this.addBussinessParam("../../.." + funFilePath.substring(5).replace('\\', '/'));
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else {
                this.addBussinessParam(funFilePath);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1107427165));
        }
        return this.outputData;
    }

    private void addBussinessParam(String filepath) {
        RowParams rowparams = new RowParams();
        rowparams.addParam("functionXmlFilePath", filepath);
        BussinessParams bussinessParams = new BussinessParams();
        bussinessParams.addRowParams(rowparams);
        this.outputData.setBussinessParams(bussinessParams);
    }

    public String getFunctionPath(int neType, String domain, String bundlename, String hostVersion) {
        String version;
        if (hostVersion == null || hostVersion.equals("")) {
            return null;
        }
        List<String> pVerList = TEVersionRelationBean.getInstance().getParentVersion(neType, hostVersion);
        String filePath = null;
        if (pVerList == null || pVerList.isEmpty()) {
            filePath = this.getDevNeFilePath(neType, domain, hostVersion, this.funcXMLPath);
            File file = TEResourceManager.getFileByName(bundlename, filePath);
            if (null != file && file.exists()) {
                return filePath;
            }
            filePath = null;
        } else {
            File file;
            int len = pVerList.size();
            for (int i = 0; !(i >= len || null != (file = TEResourceManager.getFileByName(bundlename, filePath = this.getDevDomainFilePath(domain, pVerList.get(i), this.funcXMLPath))) && file.exists()); ++i) {
                filePath = null;
            }
        }
        if (filePath == null && !(version = TEVersionRelationBean.getInstance().gerParentVersion(neType, hostVersion)).equals(hostVersion)) {
            filePath = this.getFunctionPath(neType, domain, bundlename, version);
        }
        return filePath;
    }

    private String getDevNeFilePath(int neType, String domain, String version, String fileName) {
        String filePath = "";
        filePath = domain.equals("tl1ngwdm") ? "nemgr" + File.separator + domain + File.separator + "ne_" + neType + File.separator + version + File.separator + fileName : DESCRIPTION_FILE_PATH + domain + File.separator + "ne_" + neType + File.separator + version + File.separator + fileName;
        return filePath;
    }

    private String getDevDomainFilePath(String domain, String version, String filename) {
        return DESCRIPTION_FILE_PATH + domain + File.separator + version + File.separator + filename;
    }

    private static String getDevFilePath(String domain, String filename) {
        return DESCRIPTION_FILE_PATH + domain + File.separator + filename;
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }
}

