/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.genfunctionbean;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TEParseWriteLogFile;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.TEXMLResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGenCommonWriteLogImpl
extends TECommonWriteLogBean {
    private static final String LOG_SOURCE_FILE = "res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";

    @Override
    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<Operation> operationList1 = new ArrayList<Operation>();
        Operation operation1 = null;
        Input input1 = null;
        RowParams rowparams = null;
        Param rowparam = null;
        boolean modifyFlag = true;
        int defaultPartCount = 0;
        ArrayList<String> qxList = new ArrayList<String>();
        int len = this.subfunc.getQxMappingCount();
        for (int i = 0; i < len; ++i) {
            qxList.add(this.subfunc.getQxMapping(i).getContent());
        }
        HashMap<String, Operation> operationCacheMap = new HashMap<String, Operation>();
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = qxList.size();
            for (int i = 0; i < size; ++i) {
                String qxname = (String)qxList.get(i);
                if (operationCacheMap.containsKey(qxname)) {
                    Operation tmpOper = (Operation)operationCacheMap.get(qxname);
                    operation1 = (Operation)tmpOper.clone();
                    this.resetOperation(operation1);
                } else {
                    operation1 = TECreateObjectFactory.getOperation(this.subfunc, neid, qxname);
                    operationCacheMap.put(qxname, operation1);
                }
                if (null == operation1) continue;
                input1 = operation1.getInput();
                int partlen = input1.getPartCount();
                modifyFlag = input1.getPartCount() == 0;
                defaultPartCount = 0;
                for (int part = 0; part < partlen; ++part) {
                    rowparam = rowparams.getParam(input1.getPart(part).getName());
                    if (null == rowparam) {
                        if (!input1.getPart(part).hasDefault()) {
                            modifyFlag = false;
                            break;
                        }
                        ++defaultPartCount;
                        continue;
                    }
                    if (null != rowparam.getValue()) {
                        String value = rowparam.getValue();
                        input1.getPart(part).setValue(value);
                    }
                    if (!rowparam.getModifyFlag()) continue;
                    modifyFlag = true;
                }
                if (!modifyFlag && defaultPartCount != partlen) continue;
                operationList1.add(operation1);
            }
        }
        return operationList1;
    }

    public void resetOperation(Operation operation) {
        Input input = operation.getInput();
        int partlen = input.getPartCount();
        for (int i = 0; i < partlen; ++i) {
            Part part = input.getPart(i);
            if (part.hasDefault()) continue;
            part.setValue(null);
        }
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    @Override
    public String getDetailInfo(RowParams[] rParamsArr) {
        ArrayList<String> fileNames = this.getResArray();
        Node currFuncNode = TEParseWriteLogFile.getInstance().getNodeByFuncCode(this.neid, this.subfunc.getFunID(), this.subfunc.getCode());
        String operationResStr = null;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEResourceUtil res = TEResourceUtil.getInstance(LOG_SOURCE_FILE);
            operationResStr = res.getString("operation");
        }
        if (null == currFuncNode) {
            if (operationResStr != null) {
                return operationResStr + this.subfunc.getSubFuncDes(this.neid);
            }
            return this.subfunc.getSubFuncDes(this.neid);
        }
        NodeList nodeList = currFuncNode.getChildNodes();
        int nodeListLength = nodeList.getLength();
        StringBuffer detailInfo = new StringBuffer();
        if (operationResStr != null) {
            detailInfo.append(operationResStr);
        }
        detailInfo.append(this.subfunc.getSubFuncDes(this.neid)).append(' ');
        for (int i = 0; i < nodeListLength; ++i) {
            Node aNode = nodeList.item(i);
            if (!(aNode instanceof Element) || !"logparam".equalsIgnoreCase(aNode.getNodeName())) continue;
            NamedNodeMap nodeMap = aNode.getAttributes();
            String paramName = nodeMap.getNamedItem("name").getNodeValue();
            String paramDes = TEXMLResourceUtil.getString(fileNames, paramName);
            for (int j = 0; j < rParamsArr.length; ++j) {
                RowParams rowparams = rParamsArr[j];
                Param paramObj = rowparams.getParam(paramName);
                if (paramObj == null) {
                    if (TEStringUtils.isEmpty(paramDes) && nodeMap.getNamedItem("value") == null) continue;
                    if (paramName.equals("parseString") && nodeMap.getNamedItem("value") != null) {
                        String paramDefaultValue = nodeMap.getNamedItem("value").getNodeValue();
                        detailInfo.deleteCharAt(detailInfo.length() - 1);
                        detailInfo.append(paramDefaultValue);
                        continue;
                    }
                    if (nodeMap.getNamedItem("OperType") == null || !nodeMap.getNamedItem("OperType").getNodeValue().equals("operObj")) continue;
                    detailInfo.append(paramDes).append(':');
                    continue;
                }
                String paramValue = paramObj.getValue();
                Node convertNode = nodeMap.getNamedItem("convertTo");
                if (convertNode != null) {
                    String convertTo = convertNode.getNodeValue();
                    if ("SlotToName".equals(convertTo)) {
                        paramValue = TEBoardUtil.getShelfBoardName(this.neid, Integer.parseInt(paramObj.getValue()));
                    } else {
                        paramValue = TEXMLResourceUtil.getString(fileNames, convertTo + "_" + paramValue);
                        if (paramValue.equals(convertTo + "_" + paramObj.getValue())) {
                            paramValue = paramObj.getValue();
                        }
                    }
                }
                if (!paramDes.equals(paramName)) {
                    detailInfo.append(paramDes);
                    if (paramDes.indexOf(":") != paramDes.length() - 1) {
                        detailInfo.append(':');
                    }
                }
                detailInfo.append(paramValue).append(';');
            }
        }
        return detailInfo.toString().substring(0, detailInfo.length() - 1);
    }

    @Override
    public String getSinleDetailInfo(RowParams[] rParamsArr) {
        ArrayList<String> fileNames = this.getResArray();
        Node currFuncNode = TEParseWriteLogFile.getInstance().getNodeByFuncCode(this.neid, this.subfunc.getFunID(), this.subfunc.getCode());
        if (null == currFuncNode) {
            return this.subfunc.getSubFuncDes(this.neid);
        }
        NodeList nodeList = currFuncNode.getChildNodes();
        int nodeListLength = nodeList.getLength();
        HashMap<String, NamedNodeMap> logParamList = new HashMap<String, NamedNodeMap>();
        for (int i = 0; i < nodeListLength; ++i) {
            Node aNode = nodeList.item(i);
            if (!(aNode instanceof Element) || !"logparam".equalsIgnoreCase(aNode.getNodeName())) continue;
            NamedNodeMap nodeMap = aNode.getAttributes();
            String paramName = nodeMap.getNamedItem("name").getNodeValue();
            logParamList.put(paramName, nodeMap);
        }
        StringBuffer detailInfo = new StringBuffer();
        detailInfo.append(this.subfunc.getSubFuncDes(this.neid)).append(' ');
        for (int j = 0; j < rParamsArr.length; ++j) {
            RowParams rowparams = rParamsArr[j];
            int logParamLen = rowparams.getParamCount();
            for (int i = 0; i < logParamLen; ++i) {
                String convertTo;
                Param paramObj = rowparams.getParam(i);
                String paramName = paramObj.getName();
                if (!logParamList.containsKey(paramName)) continue;
                String paramValue = paramObj.getValue();
                String paramDes = TEXMLResourceUtil.getString(fileNames, paramName);
                Node convertNode = ((NamedNodeMap)logParamList.get(paramName)).getNamedItem("convertTo");
                if (convertNode != null && (paramValue = TEXMLResourceUtil.getString(fileNames, (convertTo = convertNode.getNodeValue()) + "_" + paramValue)).equals(convertTo + "_" + paramObj.getValue())) {
                    paramValue = paramObj.getValue();
                }
                if (!paramObj.getModifyFlag()) continue;
                if (!paramDes.equals(paramName)) {
                    detailInfo.append(paramDes).append(':');
                }
                detailInfo.append(paramValue).append(';');
            }
        }
        return detailInfo.toString().substring(0, detailInfo.length() - 1);
    }

    private ArrayList<String> getResArray() {
        ArrayList<String> fileNames = new ArrayList<String>();
        int size = this.subfunc.getResFileList().size();
        for (int i = 0; i < size; ++i) {
            StringBuffer filePath = new StringBuffer();
            String resfile = (String)this.subfunc.getResFileList().get(i);
            if (resfile.startsWith("../")) {
                filePath.append(resfile.substring(3)).append('_').append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
                fileNames.add(filePath.toString());
                continue;
            }
            filePath.append("nemgr").append(File.separator).append(resfile).append('_').append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
            fileNames.add(filePath.toString());
        }
        return fileNames;
    }
}

