/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.dcintegrate;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.dcintegrate.ProcessOutputThread;
import com.huawei.nglct.explorer.dcintegrate.TERefreshDCNeListBean;
import com.huawei.nglct.explorer.dcintegrate.TERefreshDCNeListTimeTask;
import com.huawei.nglct.explorer.dcintegrate.TERefreshLastUserInfo;
import com.huawei.nglct.explorer.dcintegrate.TEUserInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class TEStartDCBean {
    private static final String START_DC_FILE = TEResourceManager.getRealPathByAppName("weblct") + File.separator + "dc" + File.separator + "startdc.bat";
    private static Timer REFRESH_TIMER;
    private static boolean IS_TIMER_RUN;
    private static final long PERIOD = 10000L;

    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        ErrorMessage errorMsg;
        Datainterface outputData;
        block8: {
            this.refreshUserInfo(inputData);
            int errcode = TERefreshDCNeListBean.getInstance().writeNelistToFile();
            outputData = new Datainterface();
            outputData.setBussinessParams(new BussinessParams());
            errorMsg = TEErrorResourceUtil.getErrorMessage(0);
            if (errcode == 0) {
                try {
                    TELogFactory.getNormalLogger().info("Start DC for:" + START_DC_FILE);
                    Process process = Runtime.getRuntime().exec(START_DC_FILE);
                    if (null != process) {
                        ProcessOutputThread outThread = new ProcessOutputThread(process);
                        outThread.start();
                    }
                    if (!IS_TIMER_RUN) {
                        IS_TIMER_RUN = true;
                        TEStartDCBean.createTimer();
                        REFRESH_TIMER.schedule((TimerTask)new TERefreshDCNeListTimeTask(), 0L, 10000L);
                    }
                    break block8;
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("Start DC tool fail!", (Throwable)e);
                    errorMsg = TEErrorResourceUtil.getErrorMessage(36993);
                    errorMsg.setErrorinfo(errorMsg.getErrorinfo() + " (" + START_DC_FILE + ") ");
                    IS_TIMER_RUN = false;
                    if (REFRESH_TIMER != null) {
                        REFRESH_TIMER.cancel();
                    }
                    break block8;
                }
            }
            if (errcode == 1090588703) {
                errorMsg = TEErrorResourceUtil.getErrorMessage(errcode);
                String START_DC_DIR = TEResourceManager.getRealPathByAppName("weblct") + File.separator + "dc";
                errorMsg.setErrorinfo(errorMsg.getErrorinfo() + " (" + START_DC_DIR + ") ");
            } else {
                errorMsg.setErrorinfo(TEErrorResourceUtil.getErrorMessage(errcode).getErrorinfo());
            }
        }
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }

    private void refreshUserInfo(Datainterface inputData) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        int IsNeedUpdateUserInfo = Integer.parseInt(rowParams.getParam("IsNeedUpdateUserInfo").getValue());
        if (IsNeedUpdateUserInfo == 1) {
            TEUserInfo.getInstance().setUserInfo(rowParams);
            TERefreshLastUserInfo.getInstance().writeUserInfoToFile();
        } else {
            TERefreshLastUserInfo.getInstance().SetUserInfoFromFile();
        }
    }

    private static void createTimer() {
        REFRESH_TIMER = new Timer();
    }

    static {
        IS_TIMER_RUN = false;
    }
}

