/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.dcintegrate;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.explorer.dcintegrate.TEGetDCIntegrateStateBean;
import com.huawei.nglct.explorer.dcintegrate.TEUserInfo;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.nglct.util.xml.TEXMLDocumnetUtil;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TERefreshLastUserInfo {
    private static TERefreshLastUserInfo instance = null;
    public static final String DC_CONFIG_DIR = TEResourceManager.getRealPathByAppName("weblct") + File.separator + "dc" + File.separator + "nelist";
    public static final String DC_USER_FILE = DC_CONFIG_DIR + File.separator + "lastuserinfo.xml";
    private static final int DC_USER_FLAG = 0;
    private static final int LICENSE_USER_FLAG = 1;

    private TERefreshLastUserInfo() {
    }

    public static synchronized TERefreshLastUserInfo getInstance() {
        if (instance == null) {
            instance = new TERefreshLastUserInfo();
        }
        return instance;
    }

    public int writeUserInfoToFile() {
        if (!TEGetDCIntegrateStateBean.isDcEnable()) {
            return 1090588703;
        }
        this.createUserXmlFile();
        Document doc = TEXMLDocumnetUtil.buildNewDocumnet();
        Element userListEle = doc.createElement("userlist");
        Element dcUserElem = this.bulidUserElement("dcuser", TEUserInfo.getInstance().getDcUserName(), TEUserInfo.getInstance().getDcPassWord(), doc);
        this.appendDCUserElem(dcUserElem, TEUserInfo.getInstance().getAccessMode(), TEUserInfo.getInstance().getTransProtocol(), TEUserInfo.getInstance().getKeyFilePath(), TEUserInfo.getInstance().getNeConnectionMode());
        Element licUserElem = this.bulidUserElement("licenseuser", TEUserInfo.getInstance().getLicUserName(), TEUserInfo.getInstance().getLicPassWord(), doc);
        userListEle.appendChild(dcUserElem);
        userListEle.appendChild(licUserElem);
        doc.appendChild(userListEle);
        TEResourceManager.writeXmlFile(doc, DC_USER_FILE);
        return 0;
    }

    private void appendDCUserElem(Element dcUserElem, int accessMode, int transProtocol, String keyFile, String neConnectionMode) {
        if (null != dcUserElem) {
            dcUserElem.setAttribute("accessMode", String.valueOf(accessMode));
            dcUserElem.setAttribute("transProtocol", String.valueOf(transProtocol));
            dcUserElem.setAttribute("keyFilePath", keyFile);
            dcUserElem.setAttribute("neConnectionMode", neConnectionMode);
        }
    }

    private Element bulidUserElement(String eleName, String userName, String passWord, Document doc) {
        Element elem = doc.createElement(eleName);
        elem.setAttribute("username", userName);
        elem.setAttribute("password", passWord);
        return elem;
    }

    private void createUserXmlFile() {
        File dir = new File(DC_CONFIG_DIR);
        try {
            if (!dir.exists() && !dir.mkdir()) {
                TELogFactory.getNormalLogger().error("Make directory [" + DC_CONFIG_DIR + "] failed!");
                return;
            }
            File userFile = new File(DC_USER_FILE);
            if (userFile.exists() && !userFile.delete()) {
                TELogFactory.getNormalLogger().error("Delete File [" + DC_USER_FILE + "] failed!");
                return;
            }
            if (!userFile.createNewFile()) {
                TELogFactory.getNormalLogger().error("Create File [" + DC_USER_FILE + "] failed!");
                return;
            }
        }
        catch (SecurityException e) {
            TELogFactory.getNormalLogger().error("Create last user info file failed!", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Create last user info file failed!", (Throwable)e);
        }
    }

    public void SetUserInfoFromFile() {
        File usrersFile = new File(DC_USER_FILE);
        if (!usrersFile.exists()) {
            return;
        }
        try {
            Document root = TEParseXMLFile.parseFile(usrersFile);
            if (!root.hasChildNodes()) {
                return;
            }
            this.SetUserInfo(root, 0);
            this.SetUserInfo(root, 1);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file '" + DC_USER_FILE + "' failed:" + e);
        }
    }

    private void SetUserInfo(Document doc, int userFlag) {
        NodeList nodeList = null;
        Node childTag = null;
        String tagName = "";
        tagName = userFlag == 0 ? "dcuser" : "licenseuser";
        nodeList = doc.getElementsByTagName(tagName);
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.hasAttributes() || !(childTag instanceof Element)) continue;
            Element element = (Element)childTag;
            if (userFlag == 0) {
                String dcToolUserName = element.getAttribute("username");
                String dcToolPassWord = element.getAttribute("password");
                String accessMode = element.getAttribute("accessMode");
                String transProtocol = element.getAttribute("transProtocol");
                String keyFilePath = element.getAttribute("keyFilePath");
                TEUserInfo.getInstance().setDcUserName(dcToolUserName);
                TEUserInfo.getInstance().setDcPassWord(dcToolPassWord);
                if (accessMode != null && !"".equals(accessMode)) {
                    TEUserInfo.getInstance().setAccesstMode(Integer.parseInt(accessMode));
                }
                if (transProtocol != null && !"".equals(transProtocol)) {
                    TEUserInfo.getInstance().setTransProtocol(Integer.parseInt(transProtocol));
                }
                if (keyFilePath == null) continue;
                TEUserInfo.getInstance().setKeyFilePath(keyFilePath);
                continue;
            }
            String licToolUserName = element.getAttribute("username");
            String licToolPassWord = element.getAttribute("password");
            TEUserInfo.getInstance().setLicUserName(licToolUserName);
            TEUserInfo.getInstance().setLicPassWord(licToolPassWord);
        }
    }
}

