/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.dcintegrate;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.explorer.dcintegrate.TEGetDCIntegrateStateBean;
import com.huawei.nglct.explorer.dcintegrate.TEUserInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.nglct.util.xml.TEXMLDocumnetUtil;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TERefreshDCNeListBean {
    private static TERefreshDCNeListBean instance = null;
    private static final String DC_NELIST_DIR = TEResourceManager.getRealPathByAppName("weblct") + File.separator + "dc" + File.separator + "nelist";
    private static final String DC_NELIST_FILE = DC_NELIST_DIR + File.separator + "nelistToDC.xml";
    public static final int CONN_MODE_FLAG_COMMON = 0;
    public static final int CONN_MODE_FLAG_SSL = 1;

    private TERefreshDCNeListBean() {
    }

    public static synchronized TERefreshDCNeListBean getInstance() {
        if (instance == null) {
            instance = new TERefreshDCNeListBean();
        }
        return instance;
    }

    public int writeNelistToFile() {
        if (!TEGetDCIntegrateStateBean.isDcEnable()) {
            return 1090588703;
        }
        this.addDCNeListFile();
        Document doc = TEXMLDocumnetUtil.buildNewDocumnet();
        Element devlistEl = doc.createElement("Devlist");
        TIntArrayList nelist = TENEListMgr.getInstance().getNEIDList();
        for (int i = 0; i < nelist.size(); ++i) {
            TENE tempNe = TENEListMgr.getInstance().getNE(nelist.get(i));
            if (tempNe == null) continue;
            this.addDevInfo(devlistEl, doc, tempNe);
        }
        doc.appendChild(devlistEl);
        TEResourceManager.writeXmlFile(doc, DC_NELIST_FILE);
        return 0;
    }

    private void addDCNeListFile() {
        File dcFile;
        File dcDIR = new File(DC_NELIST_DIR);
        if (!dcDIR.exists() && !dcDIR.mkdir()) {
            TELogFactory.getNormalLogger().error("Make directory [" + DC_NELIST_DIR + "] failed!");
        }
        if (!(dcFile = new File(DC_NELIST_FILE)).exists()) {
            try {
                if (!dcFile.createNewFile()) {
                    TELogFactory.getNormalLogger().error("Create File [" + DC_NELIST_FILE + "] failed!");
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Create DC nelist file failed!", (Throwable)e);
                return;
            }
        }
    }

    private void addDevInfo(Element devlistEl, Document doc, TENE ne) {
        if (ne.getNEType() == -1) {
            return;
        }
        if (TESysManagerConstants.isSerialPort(ne.getNEGWType())) {
            return;
        }
        Element devInfoElem = doc.createElement("DevInfo");
        devlistEl.appendChild(devInfoElem);
        devInfoElem.appendChild(this.buildAttributeNode("DevId", String.valueOf(ne.getNEID()), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DevTypeId", String.valueOf(TEGetNEDomainVersion.getInstance().getDevType(ne.getNEType())), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DevTypeVerId", "0", doc));
        devInfoElem.appendChild(this.buildAttributeNode("NeID", String.valueOf(ne.getRealNEID()), doc));
        devInfoElem.appendChild(this.buildAttributeNode("NeName", ne.getNEName(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DevVersion", ne.getHostVersion(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DevProtocol", ne.getIsTL1OrQX() == 1 ? "1" : "2", doc));
        devInfoElem.appendChild(this.buildAttributeNode("IsGateway", String.valueOf(ne.getNEGateWay() == 1), doc));
        devInfoElem.appendChild(this.buildAttributeNode("GatewayType", String.valueOf(this.getGatewayProtcol(ne)), doc));
        devInfoElem.appendChild(this.buildAttributeNode("ConnectMode", String.valueOf(this.getConnectMode(ne)), doc));
        devInfoElem.appendChild(this.buildAttributeNode("GatewayIP", ne.getNEGWAddress(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("GatewayDevID", "0", doc));
        devInfoElem.appendChild(this.buildAttributeNode("IPPort", ne.getPort(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("TP4Address", ne.getNEGWAddress(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("TP4Port", ne.getPort(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DCUserName", TEUserInfo.getInstance().getDcUserName(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("DCPassword", TEUserInfo.getInstance().getDcPassWord(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("AccessMode", String.valueOf(TEUserInfo.getInstance().getAccessMode()), doc));
        devInfoElem.appendChild(this.buildAttributeNode("TransProtocol", String.valueOf(TEUserInfo.getInstance().getTransProtocol()), doc));
        devInfoElem.appendChild(this.buildAttributeNode("UseStelnet", String.valueOf(TEUserInfo.getInstance().getNeConnectionMode()), doc));
        devInfoElem.appendChild(this.buildAttributeNode("KeyFilePath", TEUserInfo.getInstance().getKeyFilePath(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("LicenseUserName", TEUserInfo.getInstance().getLicUserName(), doc));
        devInfoElem.appendChild(this.buildAttributeNode("LicensePassword", TEUserInfo.getInstance().getLicPassWord(), doc));
    }

    private Element buildAttributeNode(String name, String value, Document doc) {
        Element elem = doc.createElement("Attribute");
        elem.setAttribute("name", name);
        elem.setAttribute("value", value);
        return elem;
    }

    private int getGatewayProtcol(TENE ne) {
        int result = 1;
        if (ne.getNEGWType() == 2) {
            result = 2;
        }
        return result;
    }

    private int getConnectMode(TENE ne) {
        int result = 0;
        if (ne.getNEGWType() == 4) {
            result = 1;
        }
        return result;
    }
}

