/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.dcintegrate;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.dcintegrate.TERefreshLastUserInfo;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEGetUserInfoBean
implements TENEListInterface {
    private static final int DC_USER_FLAG = 0;
    private static final int LICENSE_USER_FLAG = 1;
    private String dcToolUserName = "";
    private String dcToolPassWord = "";
    private String licToolUserName = "";
    private String licToolPassWord = "";
    private String accessMode = "";
    private String transProtocol = "";
    private String keyFilePath = "";
    private String neConnectionMode = "";

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.getUserInfo();
        BussinessParams returnBParams = new BussinessParams();
        RowParams rowParam = new RowParams();
        rowParam.addParam("dcUserName", this.dcToolUserName);
        rowParam.addParam("dcPassWord", this.dcToolPassWord);
        rowParam.addParam("nelicUserName", this.licToolUserName);
        rowParam.addParam("nelicPassWord", this.licToolPassWord);
        rowParam.addParam("accessMode", this.accessMode);
        rowParam.addParam("transProtocol", this.transProtocol);
        rowParam.addParam("keyFilePath", this.keyFilePath);
        rowParam.addParam("neConnectionMode", this.neConnectionMode);
        returnBParams.addRowParams(rowParam);
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(returnBParams);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return outputData;
    }

    private void getUserInfo() {
        File usrersFile = new File(TERefreshLastUserInfo.DC_USER_FILE);
        if (!usrersFile.exists()) {
            return;
        }
        try {
            Document root = TEParseXMLFile.parseFile(usrersFile);
            if (!root.hasChildNodes()) {
                return;
            }
            this.getUserInfo(root, 0);
            this.getUserInfo(root, 1);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse the file '" + TERefreshLastUserInfo.DC_USER_FILE + "' failed:" + e);
        }
    }

    private void getUserInfo(Document doc, int userFlag) {
        NodeList nodeList = null;
        Node childTag = null;
        String tagName = "";
        tagName = userFlag == 0 ? "dcuser" : "licenseuser";
        nodeList = doc.getElementsByTagName(tagName);
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.hasAttributes() || !(childTag instanceof Element)) continue;
            Element element = (Element)childTag;
            if (userFlag == 0) {
                this.dcToolUserName = element.getAttribute("username");
                this.dcToolPassWord = "......";
                this.accessMode = element.getAttribute("accessMode");
                this.transProtocol = element.getAttribute("transProtocol");
                this.keyFilePath = element.getAttribute("keyFilePath");
                this.neConnectionMode = element.getAttribute("neConnectionMode");
                continue;
            }
            this.licToolUserName = element.getAttribute("username");
            this.licToolPassWord = "......";
        }
    }
}

