/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.configmodel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.model.configmodel.TEConfigModelUtil;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TEQueryAttrSupportStateBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams returnBParams = this.getBussinessSupport(inputData);
        outputData.setBussinessParams(returnBParams);
        if (returnBParams.getRowParamsCount() > 0) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return outputData;
    }

    private BussinessParams getBussinessSupport(Datainterface inputData) {
        BussinessParams returnBParams = new BussinessParams();
        BussinessParams inputBussiness = inputData.getBussinessParams();
        int len = inputBussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = inputBussiness.getRowParams(i);
            Param param = row.getParam("neid");
            if (param == null || param.getValue() == null) continue;
            int neid = Integer.parseInt(param.getValue());
            String funid = row.getParam("funid").getValue();
            String attrid = row.getParam("attrid").getValue();
            RowParams rowParam = new RowParams();
            rowParam.addParam("neid", String.valueOf(neid));
            rowParam.addParam("funid", funid);
            rowParam.addParam("attrid", attrid);
            boolean isSupport = this.isSupport(neid, row, funid, attrid);
            rowParam.addParam("support", String.valueOf(isSupport));
            returnBParams.addRowParams(rowParam);
        }
        return returnBParams;
    }

    private boolean isSupport(int neid, RowParams rowParam, String funid, String attrid) {
        Param param = rowParam.getParam("slotid");
        if (TEConfigModelUtil.isParamValid(param)) {
            int slotid = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isCPSupport(neid, slotid, funid, attrid);
        }
        param = rowParam.getParam("boardType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int boardType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, funid, attrid);
        }
        param = rowParam.getParam("neType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int neType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isNESupportByType(neType, funid, attrid);
        }
        return TESpecialAttrMgr.getInstance().isNESupport(neid, funid, attrid);
    }
}

