/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.configmodel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.model.configmodel.TEConfigModelUtil;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TEQueryAttrNotSupportStateBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams returnBParams = this.getBussinessNotSupport(inputData);
        outputData.setBussinessParams(returnBParams);
        if (returnBParams.getRowParamsCount() > 0) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return outputData;
    }

    private BussinessParams getBussinessNotSupport(Datainterface inputData) {
        BussinessParams returnBParams = new BussinessParams();
        BussinessParams inputBussiness = inputData.getBussinessParams();
        int len = inputBussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = inputBussiness.getRowParams(i);
            Param paramTmp = row.getParam("neid");
            if (paramTmp == null || paramTmp.getValue() == null) continue;
            int neid = Integer.parseInt(paramTmp.getValue());
            String funid = row.getParam("funid").getValue();
            String attrid = row.getParam("attrid").getValue();
            boolean isNotSupport = this.isNotSupport(neid, row, funid, attrid);
            RowParams rowParam = new RowParams();
            rowParam.addParam("neid", String.valueOf(neid));
            rowParam.addParam("funid", funid);
            rowParam.addParam("attrid", attrid);
            rowParam.addParam("notsupport", String.valueOf(isNotSupport));
            returnBParams.addRowParams(rowParam);
        }
        return returnBParams;
    }

    private boolean isNotSupport(int neid, RowParams rowParam, String funid, String attrid) {
        Param param = rowParam.getParam("slotid");
        if (TEConfigModelUtil.isParamValid(param)) {
            int slotid = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isCPNotSupport(neid, slotid, funid, attrid);
        }
        param = rowParam.getParam("boardType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int boardType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isCPNotSupportByType(boardType, funid, attrid);
        }
        param = rowParam.getParam("neType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int neType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().isNENotSupportByType(neType, funid, attrid);
        }
        return TESpecialAttrMgr.getInstance().isNENotSupport(neid, funid, attrid);
    }
}

