/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.configmodel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.model.configmodel.TEConfigModelUtil;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrDescrip;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TEQueryAttrDescripBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams returnBParams = this.getBussinessAttrDescrip(inputData);
        outputData.setBussinessParams(returnBParams);
        if (returnBParams.getRowParamsCount() > 0) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return outputData;
    }

    private BussinessParams getBussinessAttrDescrip(Datainterface inputData) {
        BussinessParams returnBParams = new BussinessParams();
        BussinessParams inputBussiness = inputData.getBussinessParams();
        int len = inputBussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String attrid;
            String funid;
            RowParams row = inputBussiness.getRowParams(i);
            Param paramTmp = row.getParam("neid");
            if (paramTmp == null || paramTmp.getValue() == null) continue;
            int neid = Integer.parseInt(paramTmp.getValue());
            TESpecialAttrDescrip attrDescrip = this.getAttrDescrip(neid, row, funid = row.getParam("funid").getValue(), attrid = row.getParam("attrid").getValue());
            if (attrDescrip != null) {
                RowParams rowParam = new RowParams();
                rowParam.addParam("funid", funid);
                rowParam.addParam("attrid", attrid);
                rowParam.addParam("attrdescripid", String.valueOf(attrDescrip.getId()));
                rowParam.addParam("attrdescripname", attrDescrip.getName());
                rowParam.addParam("attrdescriptype", attrDescrip.getType());
                rowParam.addParam("attrdescripvalue", attrDescrip.getValue());
                returnBParams.addRowParams(rowParam);
                continue;
            }
            TELogFactory.getNormalLogger().info("attrDescrip is null!neid=" + neid + ";funid=" + funid + ";attrid=" + attrid);
        }
        return returnBParams;
    }

    private TESpecialAttrDescrip getAttrDescrip(int neid, RowParams rowParam, String funid, String attrid) {
        Param param = rowParam.getParam("slotid");
        if (TEConfigModelUtil.isParamValid(param)) {
            int slotid = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getCPAttrDescrip(neid, slotid, funid, attrid);
        }
        param = rowParam.getParam("boardType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int boardType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getCPAttrDescripByType(boardType, funid, attrid);
        }
        param = rowParam.getParam("neType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int neType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getNEAttrDescripByType(neType, funid, attrid);
        }
        return TESpecialAttrMgr.getInstance().getNEAttrDescrip(neid, funid, attrid);
    }
}

