/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.configmodel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.model.configmodel.TEConfigModelUtil;
import com.huawei.nglct.nelist.model.configmodel.TEFunctionDescrib;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrDescrip;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.Iterator;
import java.util.List;

public class TEQueryAttrByFunctionBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams returnBParams = this.getBussinessAttrInfo(inputData);
        outputData.setBussinessParams(returnBParams);
        if (returnBParams.getRowParamsCount() > 0) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return outputData;
    }

    private BussinessParams getBussinessAttrInfo(Datainterface inputData) {
        BussinessParams returnBParams = null;
        BussinessParams inputBussiness = inputData.getBussinessParams();
        if (inputBussiness.getRowParamsCount() > 0) {
            String funid;
            RowParams row = inputBussiness.getRowParams(0);
            Param param = row.getParam("neid");
            int neid = Integer.parseInt(param.getValue());
            TEFunctionDescrib function = this.getFunctionAttrInfo(neid, row, funid = row.getParam("funid").getValue());
            if (function == null) {
                TELogFactory.getNormalLogger().info("function is null!neid=" + neid + ";funid=" + funid);
            }
            returnBParams = this.construnctFunctionBussiness(function);
        } else {
            returnBParams = new BussinessParams();
        }
        return returnBParams;
    }

    private TEFunctionDescrib getFunctionAttrInfo(int neid, RowParams rowParam, String funid) {
        Param param = rowParam.getParam("slotid");
        if (TEConfigModelUtil.isParamValid(param)) {
            int slotid = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getCPFunctionAttrInfo(neid, slotid, funid);
        }
        param = rowParam.getParam("boardType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int boardType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getCPFunctionAttrInfoByType(boardType, funid);
        }
        param = rowParam.getParam("neType");
        if (TEConfigModelUtil.isParamValid(param)) {
            int neType = Integer.parseInt(param.getValue());
            return TESpecialAttrMgr.getInstance().getNEFunctionAttrInfo(neType, funid);
        }
        return TESpecialAttrMgr.getInstance().getNEFunctionAttrInfo(neid, funid);
    }

    private BussinessParams construnctFunctionBussiness(TEFunctionDescrib function) {
        BussinessParams returnBParams = new BussinessParams();
        if (function != null) {
            RowParams rowParam = new RowParams();
            String support = TEStringUtils.joinListAsComma(function.getSupportAttrList());
            rowParam.addParam("support", support);
            returnBParams.addRowParams(rowParam);
            rowParam = new RowParams();
            String nosupport = TEStringUtils.joinListAsComma(function.getNotSupportAttrList());
            rowParam.addParam("notsupport", nosupport);
            returnBParams.addRowParams(rowParam);
            List<TESpecialAttrDescrip> attrList = function.getAttrDescripList();
            if (attrList != null && !attrList.isEmpty()) {
                Iterator<TESpecialAttrDescrip> iterator = attrList.iterator();
                while (iterator.hasNext()) {
                    rowParam = new RowParams();
                    TESpecialAttrDescrip descrip = iterator.next();
                    rowParam.addParam("attrdescripid", String.valueOf(descrip.getId()));
                    rowParam.addParam("attrdescripname", descrip.getName());
                    rowParam.addParam("attrdescriptype", descrip.getType());
                    rowParam.addParam("attrdescripvalue", descrip.getValue());
                    returnBParams.addRowParams(rowParam);
                }
            }
        }
        return returnBParams;
    }
}

