/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.beanplugin.script;

import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.explorer.beanplugin.script.TEBPScriptHandlerData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class TEBPScriptHandler
implements TEScriptHandler {
    protected TEBPScriptHandlerData data;

    public TEBPScriptHandlerData getData() {
        return this.data;
    }

    public void setData(TEBPScriptHandlerData data) {
        this.data = data;
    }

    @Override
    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    @Override
    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        ArrayList<TEDaoNameValuePair> nvPair = new ArrayList<TEDaoNameValuePair>();
        List<TEScriptCmd> cmdList = this.getCmdListFromDB(neID, item, this.data, nvPair);
        if (null != cmdList && !cmdList.isEmpty()) {
            this.writeCmdListToScript(neID, item, cmdList);
        }
        return 0;
    }

    public void init() {
        this.fillScriptAttrInfo();
    }

    private void writeCmdListToScript(int neID, int item, List<TEScriptCmd> cmdList) {
        if (null == cmdList || cmdList.isEmpty()) {
            return;
        }
        int index = 0;
        for (TEScriptCmd cmd : cmdList) {
            if (index++ == 0) {
                TEScriptOperationMgr.getInstance().writeComment(neID, item, this.getComment());
            }
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
    }

    protected <T> List<TEScriptCmd> getCmdListFromDB(int neID, int item, TEBPScriptHandlerData data, List<TEDaoNameValuePair> nvPair) {
        List<T> moList = this.getMOFromDB(neID, data, nvPair);
        List<TEScriptCmd> cmdList = this.getCmdListFromMOList(neID, item, data, moList);
        return cmdList;
    }

    protected <T> List<T> getMOFromDB(int neID, TEBPScriptHandlerData data, List<TEDaoNameValuePair> nvPair) {
        ArrayList moList = new ArrayList();
        Class<?> classOfMO = data.getMoClass();
        int rootType = data.getRootType();
        TEMODBMgr dbmgr = new TEMODBMgr();
        if (1 == rootType) {
            List<TEBoard> boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
            for (TEBoard board : boardList) {
                moList.addAll(this.getMOFromDB(neID, classOfMO, dbmgr, board.getSlotID(), nvPair));
            }
        } else {
            TECommonResult dbResult = dbmgr.getMOFromDB(neID, classOfMO, nvPair);
            if (null != dbResult.getReturnObject() && !dbResult.getReturnObject().isEmpty()) {
                moList.addAll(dbResult.getReturnObject());
            }
        }
        return moList;
    }

    protected <T> List<TEScriptCmd> getCmdListFromMOList(int neID, int item, TEBPScriptHandlerData data, List<T> moList) {
        List<TEScriptCmd> cmdList = new ArrayList<TEScriptCmd>();
        if (moList != null && !moList.isEmpty()) {
            TECommonResult<TEScriptCmd> tempResult = this.convertToCmdFromMO(neID, (T)moList, item, data);
            cmdList = (List)((Object)tempResult.getReturnObject());
        }
        return cmdList;
    }

    protected <T> List<T> getMOFromDB(int neID, Class<T> classOfMO, TEMODBMgr<T> dbmgr, int slotID, List<TEDaoNameValuePair> nvPair) {
        ArrayList moList = new ArrayList();
        TECommonResult<List<T>> dbResult = dbmgr.getMOFromDB(neID, slotID, classOfMO, nvPair);
        if (null != dbResult.getReturnObject() && !dbResult.getReturnObject().isEmpty()) {
            moList.addAll(dbResult.getReturnObject());
        }
        return moList;
    }

    private <T> TECommonResult<List<TEScriptCmd>> convertToCmdFromMO(int neID, List<T> moList, int item, TEBPScriptHandlerData data) {
        TECommonResult<List<TEScriptCmd>> result = new TECommonResult<List<TEScriptCmd>>();
        TEErrInfoReturn errRet = result.getErrInfoRet();
        ArrayList<TEScriptCmd> cmdList = new ArrayList<TEScriptCmd>();
        for (T mo : moList) {
            TECommonResult<TEScriptCmd> tempResult = this.convertToCmdFromMO(neID, mo, item, data);
            TEErrInfoReturn tempErrRet = tempResult.getErrInfoRet();
            if (0 != tempErrRet.getResult()) {
                errRet.setResult(2);
                errRet.getErrList().addAll(tempErrRet.getErrList());
                continue;
            }
            TEScriptCmd cmd = tempResult.getReturnObject();
            if (null == cmd) continue;
            cmdList.add(cmd);
        }
        result.setResultObject(cmdList);
        return result;
    }

    protected <T> TECommonResult<TEScriptCmd> convertToCmdFromMO(int neID, T mo, int item, TEBPScriptHandlerData data) {
        TECommonResult<TEScriptCmd> result = new TECommonResult<TEScriptCmd>();
        TEErrInfoReturn errRet = result.getErrInfoRet();
        TEScriptCmd scriptCmd = new TEScriptCmd();
        scriptCmd.setCmdCode(item);
        TECommonResult<Map<String, String>> getResult = this.getScriptAttrValueInfo(neID, mo, data);
        TEErrInfoReturn tempErrRet = getResult.getErrInfoRet();
        if (0 != tempErrRet.getResult()) {
            errRet.setResult(2);
            errRet.getErrList().addAll(tempErrRet.getErrList());
            return result;
        }
        Map<String, String> attrNameValueMap = getResult.getReturnObject();
        if (null == attrNameValueMap || attrNameValueMap.isEmpty()) {
            return result;
        }
        for (String attrName : data.getAttrNameList()) {
            String attrValue = attrNameValueMap.get(attrName);
            String attrType = data.getAttrNameTypeMap().get(attrName);
            if ((null == attrValue || attrValue.isEmpty()) && !"ComboObject".equalsIgnoreCase(attrType) || this.isInvalidValue(attrName, attrValue)) continue;
            if ("int".equalsIgnoreCase(attrType)) {
                this.addIntPara(scriptCmd, attrName, attrValue);
                continue;
            }
            if ("String".equalsIgnoreCase(attrType)) {
                this.addStringPara(data, scriptCmd, attrName, attrValue);
                continue;
            }
            if (!"ComboObject".equalsIgnoreCase(attrType)) continue;
            this.addComboObject(mo, attrNameValueMap, neID, item, data, scriptCmd, attrName);
        }
        result.setResultObject(scriptCmd);
        return result;
    }

    protected boolean isInvalidValue(String attrName, String attrValue) {
        return false;
    }

    protected <T> void addComboObject(T mo, Map<String, String> attrNameValueMap, int neID, int item, TEBPScriptHandlerData data, TEScriptCmd scriptCmd, String attrName) {
        TEBPScriptHandlerData comData = data.getAttrNameComboObjectMap().get(attrName);
        if (null != comData) {
            ArrayList<TEScriptCmd> cmdList = new ArrayList<TEScriptCmd>();
            if (comData.getRootType() == 0) {
                ArrayList<TEDaoNameValuePair> nvPair = new ArrayList<TEDaoNameValuePair>();
                cmdList.addAll(this.getCmdListFromDB(neID, item, comData, nvPair));
            } else {
                int slotID = this.getAttrValueInt(attrNameValueMap, comData.getSlotidAttrName());
                TEMODBMgr dbmgr = new TEMODBMgr();
                ArrayList moList = new ArrayList();
                ArrayList<TEDaoNameValuePair> nvPair = new ArrayList<TEDaoNameValuePair>();
                moList.addAll(this.getMOFromDB(neID, comData.getMoClass(), dbmgr, slotID, nvPair));
                cmdList.addAll(this.getCmdListFromMOList(neID, item, comData, moList));
            }
            if (null != cmdList && !cmdList.isEmpty()) {
                scriptCmd.addPara(attrName, cmdList);
            }
        }
    }

    protected void addStringPara(TEBPScriptHandlerData data, TEScriptCmd scriptCmd, String attrName, String attrValue) {
        boolean isQuete = false;
        Boolean isQueteObj = data.getAttrNameIsQueteMap().get(attrName);
        if (null != isQueteObj) {
            isQuete = isQueteObj;
        }
        scriptCmd.addPara(attrName, attrValue, isQuete, false);
    }

    protected void addIntPara(TEScriptCmd scriptCmd, String attrName, String attrValue) {
        scriptCmd.addPara(attrName, Integer.parseInt(attrValue), false, false);
    }

    private <T> TECommonResult<Map<String, String>> getScriptAttrValueInfo(int neID, T mo, TEBPScriptHandlerData scriptHandlerData) {
        TECommonResult<Map<String, String>> result = new TECommonResult<Map<String, String>>();
        Hashtable<String, String> attrNameValueMap = new Hashtable<String, String>();
        for (String attrName : scriptHandlerData.getAttrNameList()) {
            String moAttrName = this.getMOAttrName(scriptHandlerData, attrName);
            String moAttrValue = null;
            String scriptAttrValue = null;
            if (null != moAttrName) {
                moAttrValue = TEMODBMgr.getMOAttrValue(mo, moAttrName);
            }
            if (null == (scriptAttrValue = this.getScriptAttrValueFromMO(neID, mo, attrNameValueMap, attrName, moAttrValue))) continue;
            attrNameValueMap.put(attrName, scriptAttrValue);
        }
        result.setResultObject(attrNameValueMap);
        return result;
    }

    protected String getMOAttrName(TEBPScriptHandlerData scriptHandlerData, String attrName) {
        return scriptHandlerData.getAttrNameMOAttrNameMap().get(attrName);
    }

    protected int getAttrValueInt(Map<String, String> attrNameValueMap, String attrName) {
        int intValue = -1;
        String str = attrNameValueMap.get(attrName);
        if (TEStringUtils.isNumber(str)) {
            intValue = Integer.parseInt(str);
        }
        return intValue;
    }

    protected abstract String getComment();

    protected <T> String getScriptAttrValueFromMO(int neID, T mo, Map<String, String> attrNameValueMap, String attrName, String moAttrValue) {
        if (null == moAttrValue) {
            return null;
        }
        return moAttrValue;
    }

    protected abstract TEErrInfoReturn fillScriptAttrInfo();

    protected String convertScriptAttrValue(String scriptAttrValue, Map<String, String> valueMacroMap) {
        if (null == scriptAttrValue || scriptAttrValue.isEmpty() || valueMacroMap.isEmpty()) {
            return scriptAttrValue;
        }
        String tempStr = valueMacroMap.get(scriptAttrValue);
        return tempStr;
    }
}

