/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.beanplugin.handler;

import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class TEBPOperHandlerImpl<MOCLASS> {
    public static final int MO_TYPE_TENE = 0;
    public static final int MO_TYPE_TECIRCUITPACK = 1;
    protected int neID;
    protected Operation operation;
    protected int moRootType = 0;
    protected String slotIDAttrName = "slotid";
    protected List<String> keyAttrNameList = new ArrayList<String>();
    protected List<String> attrNameList = new ArrayList<String>();
    protected Map<String, String> attrNameTypeMap = new Hashtable<String, String>();
    protected Map<String, String> attrNameMOAttrNameMap = new Hashtable<String, String>();
    protected Map<String, String> attrNameMOAttrTypeMap = new Hashtable<String, String>();
    protected Map<String, String> attrNameErrValueMap = new Hashtable<String, String>();

    public TEBPOperHandlerImpl(int neID, Operation operation, int moRootType) {
        this.neID = neID;
        this.operation = operation;
        this.moRootType = moRootType;
    }

    public abstract void fillAttributeInfo();

    public void setSlotIDName(String slotidName) {
        this.slotIDAttrName = slotidName;
    }

    public void setKeyAttribute(String attrName) {
        this.keyAttrNameList.add(attrName);
    }

    public void addAttribute(String attrName, String attrType, String moAttrName, String moAttrType, String errorValue) {
        this.attrNameList.add(attrName);
        this.attrNameTypeMap.put(attrName, attrType);
        this.attrNameMOAttrNameMap.put(attrName, moAttrName);
        this.attrNameMOAttrTypeMap.put(attrName, moAttrType);
        this.attrNameErrValueMap.put(attrName, errorValue);
    }

    abstract TEErrInfoReturn handle(Class<MOCLASS> var1);

    protected TECommonResult<List<MOCLASS>> getMOFromDB(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, Class<MOCLASS> classOfMO) {
        TECommonResult<List<MOCLASS>> retResult = new TECommonResult();
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        for (String keyAttrName : this.keyAttrNameList) {
            String moAttrName = this.attrNameMOAttrNameMap.get(keyAttrName);
            String keyAtrrValue = attrNameValueMap.get(keyAttrName);
            criteria.add(new TEDaoNameValuePair(moAttrName, keyAtrrValue));
        }
        retResult = this.moRootType == 1 ? this.getMOFromDBOnTECircuitPack(dbmgr, attrNameValueMap, classOfMO, criteria) : this.getMOFromDBOnTENE(dbmgr, attrNameValueMap, classOfMO, criteria);
        return retResult;
    }

    private TECommonResult<List<MOCLASS>> getMOFromDBOnTECircuitPack(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, Class<MOCLASS> classOfMO, List<TEDaoNameValuePair> criteria) {
        int slotid = this.getSlotIDValue(attrNameValueMap);
        return dbmgr.getMOFromDB(this.neID, slotid, classOfMO, criteria);
    }

    protected TECommonResult<MOCLASS> getCurrentMO(Map<String, String> attrNameValueMap, TECommonResult<List<MOCLASS>> dbResult) {
        TECommonResult<MOCLASS> ret = new TECommonResult<MOCLASS>();
        MOCLASS mo = this.getMOFromDBResult(attrNameValueMap, dbResult);
        ret.setResultObject(mo);
        return ret;
    }

    private TECommonResult<List<MOCLASS>> getMOFromDBOnTENE(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, Class<MOCLASS> classOfMO, List<TEDaoNameValuePair> criteria) {
        return dbmgr.getMOFromDB(this.neID, classOfMO, criteria);
    }

    private MOCLASS getMOFromDBResult(Map<String, String> attrNameValueMap, TECommonResult<List<MOCLASS>> dbResult) {
        List<MOCLASS> moList = dbResult.getReturnObject();
        if (null == moList || moList.isEmpty()) {
            return null;
        }
        return moList.get(0);
    }

    protected TEErrInfoReturn delMOFromDB(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        TEErrInfoReturn tempErrRet = this.moRootType == 1 ? this.delMOFromDBOnTECircuitPack(dbmgr, attrNameValueMap, mo) : this.delMOFromDBOnTENE(dbmgr, mo);
        return tempErrRet;
    }

    private TEErrInfoReturn delMOFromDBOnTENE(TEMODBMgr<MOCLASS> dbmgr, MOCLASS mo) {
        TEErrInfoReturn tempErrRet = dbmgr.delMOFromDB(this.neID, mo);
        return tempErrRet;
    }

    private TEErrInfoReturn delMOFromDBOnTECircuitPack(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        int slotID = this.getSlotIDValue(attrNameValueMap);
        TEErrInfoReturn tempErrRet = dbmgr.delMOFromDB(this.neID, slotID, mo);
        return tempErrRet;
    }

    protected TEErrInfoReturn createMOToDB(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        TEErrInfoReturn ret = this.moRootType == 1 ? this.createMOToDBOnTECircuitPack(dbmgr, attrNameValueMap, mo) : this.createMOToDBOnTENE(dbmgr, mo);
        return ret;
    }

    public int[] createErrInfoObjID(Map<String, String> attrNameValueMap) {
        int[] errInfoObjID = this.moRootType == 1 ? this.createErrInfoObjIDOnTECircuitPack(attrNameValueMap) : this.createErrInfoObjIDOnTENE();
        return errInfoObjID;
    }

    private int[] createErrInfoObjIDOnTECircuitPack(Map<String, String> attrNameValueMap) {
        int slotID = this.getSlotIDValue(attrNameValueMap);
        return new int[]{this.neID, slotID};
    }

    private int[] createErrInfoObjIDOnTENE() {
        return new int[]{this.neID};
    }

    protected TEErrInfoReturn updateMOToDB(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        TEErrInfoReturn ret = this.moRootType == 1 ? this.updateMOToDBOnTECircuitPack(dbmgr, attrNameValueMap, mo) : this.updateMOToDBOnTENE(dbmgr, mo);
        return ret;
    }

    private TEErrInfoReturn createMOToDBOnTENE(TEMODBMgr<MOCLASS> dbmgr, MOCLASS mo) {
        return dbmgr.createMOToDB(this.neID, mo);
    }

    private TEErrInfoReturn createMOToDBOnTECircuitPack(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        int slotid = this.getSlotIDValue(attrNameValueMap);
        return dbmgr.createMOToDB(this.neID, slotid, mo);
    }

    private TEErrInfoReturn updateMOToDBOnTENE(TEMODBMgr<MOCLASS> dbmgr, MOCLASS mo) {
        return dbmgr.updateMOToDB(this.neID, mo);
    }

    private TEErrInfoReturn updateMOToDBOnTECircuitPack(TEMODBMgr<MOCLASS> dbmgr, Map<String, String> attrNameValueMap, MOCLASS mo) {
        int slotid = this.getSlotIDValue(attrNameValueMap);
        return dbmgr.updateMOToDB(this.neID, slotid, mo);
    }

    protected MOCLASS getMOFromMOListWithKeyAttr(Map<String, String> attrNameValueMap, List<MOCLASS> moList) {
        for (MOCLASS tempMO : moList) {
            boolean isFound = true;
            for (String keyAttrName : this.keyAttrNameList) {
                String keyAtrrValue = attrNameValueMap.get(keyAttrName);
                if (keyAtrrValue.equals(this.getMOMappingAttrValue(keyAttrName, tempMO))) continue;
                isFound = false;
                break;
            }
            if (!isFound) continue;
            return tempMO;
        }
        return null;
    }

    protected TEErrInfoReturn fillAttrNameValueMap(Output output, Map<String, String> attrNameValueMap) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        for (String attrName : this.attrNameList) {
            String attrValue = TEBeanPluginUtil.getOutputPartValueStr(output, attrName, String.valueOf(this.attrNameErrValueMap.get(attrName)));
            if (this.keyAttrNameList.contains(attrName) && attrValue.equals(this.attrNameErrValueMap.get(attrName))) {
                TEErrInfoReturn temmErrRet = new TEErrInfoReturn();
                temmErrRet.setResult(2);
                return temmErrRet;
            }
            attrValue = this.convertValueBeforeSaveDB(attrName, attrValue);
            attrNameValueMap.put(attrName, attrValue);
        }
        return errRet;
    }

    protected String convertValueBeforeSaveDB(String attrName, String attrValue) {
        return attrValue;
    }

    protected TEErrInfoReturn fillAttrNameValueMap(Input input, Map<String, String> attrNameValueMap) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        for (String attrName : this.attrNameList) {
            String attrValue = TEBeanPluginUtil.getInputPartValueStr(input, attrName, String.valueOf(this.attrNameErrValueMap.get(attrName)));
            attrNameValueMap.put(attrName, attrValue);
        }
        return errRet;
    }

    protected int getAttrValueInt(Map<String, String> attrNameValueMap, String attrName) {
        int intValue = -1;
        String str = attrNameValueMap.get(attrName);
        if (TEStringUtils.isNumber(str)) {
            intValue = Integer.parseInt(str);
        }
        return intValue;
    }

    protected int getSlotIDValue(Map<String, String> attrNameValueMap) {
        return this.getAttrValueInt(attrNameValueMap, this.slotIDAttrName);
    }

    protected TEErrInfoReturn setMOMappingAttrValue(Map<String, String> attrNameValueMap, MOCLASS mo) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        for (String attrName : this.attrNameList) {
            this.setMOMappingAttrValue(attrName, attrNameValueMap.get(attrName), mo);
        }
        return errRet;
    }

    private void setMOMappingAttrValue(String attrName, String attrValue, MOCLASS tempMO) {
        String moAttrName = this.attrNameMOAttrNameMap.get(attrName);
        String moAttrType = this.attrNameMOAttrTypeMap.get(attrName);
        TEMODBMgr.setMOAttrValue(tempMO, moAttrName, moAttrType, attrValue);
    }

    protected String getMOMappingAttrValue(String attrName, MOCLASS tempMO) {
        String moAttrName = this.attrNameMOAttrNameMap.get(attrName);
        return TEMODBMgr.getMOAttrValue(tempMO, moAttrName);
    }
}

