/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMODBMgr<MOCLASS> {
    public static final String UNKNOWN = "UNKNOWN";
    public static final int CREATE = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    private static final Logger logger = TELogFactory.getNormalLogger();

    public TECommonResult<List<MOCLASS>> getMOFromDB(int neID, Class<MOCLASS> moClass) {
        if (neID <= 0) {
            String tipStr = String.format("getMOFromDB fail! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        if (null == moClass) {
            String tipStr = String.format("getMOFromDB fail! moClass is null! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        return this.getMOFromDBImpl(new int[]{neID}, moClass, null);
    }

    public TECommonResult<List<MOCLASS>> getMOFromDB(int neID, Class<MOCLASS> moClass, List<TEDaoNameValuePair> criteria) {
        if (neID <= 0) {
            String tipStr = String.format("getMOFromDB fail! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        if (null == moClass) {
            String tipStr = String.format("getMOFromDB fail! moClass is null! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        return this.getMOFromDBImpl(new int[]{neID}, moClass, criteria);
    }

    public TEErrInfoReturn updateMOToDB(int neID, MOCLASS mo) {
        if (neID <= 0) {
            String tipStr = String.format("updateMOToDB fail! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("updateMOToDB fail! mo is null! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(2, new int[]{neID}, mo);
    }

    public TEErrInfoReturn createMOToDB(int neID, MOCLASS mo) {
        if (neID <= 0) {
            String tipStr = String.format("createMOToDB fail! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("createMOToDB fail! mo is null! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(1, new int[]{neID}, mo);
    }

    public TEErrInfoReturn delMOFromDB(int neID, MOCLASS mo) {
        if (neID <= 0) {
            String tipStr = String.format("delMOFromDB fail! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("delMOFromDB fail! mo is null! neID:%d", neID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(3, new int[]{neID}, mo);
    }

    public TECommonResult<List<MOCLASS>> getMOFromDB(int neID, int slotID, Class<MOCLASS> moClass) {
        if (neID <= 0 || slotID <= 0) {
            String tipStr = String.format("getMOFromDB fail! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        if (null == moClass) {
            String tipStr = String.format("getMOFromDB fail!  moClass is null! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        return this.getMOFromDBImpl(new int[]{neID, slotID}, moClass, null);
    }

    public TECommonResult<List<MOCLASS>> getMOFromDB(int neID, int slotID, Class<MOCLASS> moClass, List<TEDaoNameValuePair> criteria) {
        if (neID <= 0 || slotID <= 0) {
            String tipStr = String.format("getMOFromDB fail! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        if (null == moClass) {
            String tipStr = String.format("getMOFromDB fail!  moClass is null! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TECommonResult<List<MOCLASS>>();
        }
        return this.getMOFromDBImpl(new int[]{neID, slotID}, moClass, criteria);
    }

    public TEErrInfoReturn updateMOToDB(int neID, int slotID, MOCLASS mo) {
        if (neID <= 0 || slotID <= 0) {
            String tipStr = String.format("updateMOToDB fail! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("updateMOToDB fail! mo is null! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(2, new int[]{neID, slotID}, mo);
    }

    public TEErrInfoReturn createMOToDB(int neID, int slotID, MOCLASS mo) {
        if (neID <= 0 || slotID <= 0) {
            String tipStr = String.format("createMOToDB fail! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("createMOToDB fail! mo is null! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(1, new int[]{neID, slotID}, mo);
    }

    public TEErrInfoReturn delMOFromDB(int neID, int slotID, MOCLASS mo) {
        if (neID <= 0 || slotID <= 0) {
            String tipStr = String.format("delMOFromDB fail! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        if (null == mo) {
            String tipStr = String.format("delMOFromDB fail! mo is null! neID:%d, slotID:%d", neID, slotID);
            TELogFactory.getNormalLogger().error(tipStr);
            return new TEErrInfoReturn();
        }
        return this.operateDB(3, new int[]{neID, slotID}, mo);
    }

    private TECommonResult<List<MOCLASS>> getMOFromDBImpl(int[] metadata, Class<MOCLASS> moClass, List<TEDaoNameValuePair> criteria) {
        TECommonResult<List<MOCLASS>> result = new TECommonResult<List<MOCLASS>>();
        ArrayList<Object> moList = new ArrayList<Object>();
        TEErrInfoReturn errRet = result.getErrInfoRet();
        if (0 == metadata.length) {
            return result;
        }
        int neID = metadata[0];
        if (-1 == neID) {
            logger.info("neid is -1!");
            return null;
        }
        if (null == moClass) {
            logger.info("mo is null!");
            return null;
        }
        String beginWith = String.format("%s: metadata:%s, class:%s", "TEMODBMgr.getMOFromDB", metadata, moClass);
        TEBeanPluginLog logBuilder = new TEBeanPluginLog(beginWith);
        logger.info(logBuilder.buildLogStr("func begin"));
        TEDaoOperationResult dbResult = null;
        try {
            if (criteria != null && !criteria.isEmpty()) {
                dbResult = TECommonDaoService.findByID(neID, metadata, moClass, criteria);
            } else {
                TENE ne = TENEListMgr.getInstance().getNE(neID);
                if (null == ne) {
                    logger.info(logBuilder.buildLogStr(String.format("ne is not exist! retCode:%d func end", 1090596385)));
                    TEMODBMgr.setOperFail(neID, errRet, 1090596385);
                    return result;
                }
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll(metadata, moClass) : TECommonDaoService.findAll_NonLock(metadata, moClass);
            }
        }
        catch (Exception e) {
            logger.error(logBuilder.buildLogStr(String.format("get mo from db fail! retCode:%d func end", 1092743443)), (Throwable)e);
            TEMODBMgr.setOperFail(neID, errRet, 1092743443);
            return result;
        }
        if (null == dbResult) {
            logger.error(logBuilder.buildLogStr(String.format("get mo from db fail! dbResult is null! retCode:%d func end", 1092743443)));
            TEMODBMgr.setOperFail(neID, errRet, 1092743443);
            return result;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List<Object> data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add(obj);
                }
                result.setResultObject(moList);
            }
        } else {
            logger.info(logBuilder.buildLogStr(String.format("get mo from db fail! retCode:%d", retCode)));
            TEMODBMgr.setOperFail(neID, errRet, retCode);
        }
        logger.info(logBuilder.buildLogStr("func end"));
        return result;
    }

    private TEErrInfoReturn operateDB(int operType, int[] metadata, MOCLASS mo) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        if (0 == metadata.length) {
            return errRet;
        }
        int neID = metadata[0];
        if (-1 == neID) {
            logger.info("neid is -1!");
            return errRet;
        }
        if (null == mo) {
            logger.info("mo is null!");
            return errRet;
        }
        String beginWith = String.format("%s: metadata:%s, class:%s, operType:%s", "TEMODBMgr.updateMOToDB", metadata, mo.getClass(), this.getOperStr(operType));
        TEBeanPluginLog logBuilder = new TEBeanPluginLog(beginWith);
        logger.info(logBuilder.buildLogStr("func begin"));
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                logger.info(logBuilder.buildLogStr(String.format("ne is not exist! retCode:%d func end", 1090596385)));
                TEMODBMgr.setOperFail(neID, errRet, 1090596385);
            }
            if (2 == operType) {
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update(metadata, mo) : TECommonDaoService.update_NonLock(metadata, mo);
            } else if (1 == operType) {
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create(metadata, mo) : TECommonDaoService.create_NonLock(metadata, mo);
            } else if (3 == operType) {
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete(metadata, mo) : TECommonDaoService.delete_NonLock(metadata, mo);
            }
        }
        catch (Exception e) {
            logger.error(logBuilder.buildLogStr(String.format("oper mo to db fail! retCode:%d func end", 1092743443)), (Throwable)e);
            TEMODBMgr.setOperFail(neID, errRet, 1092743443);
            return errRet;
        }
        if (null == dbResult) {
            logger.error(logBuilder.buildLogStr(String.format("oper mo to db fail! dbResult is null! retCode:%d func end", 1092743443)));
            TEMODBMgr.setOperFail(neID, errRet, 1092743443);
            return errRet;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            logger.info(logBuilder.buildLogStr(String.format("oper mo to db fail! retCode:%d", retCode)));
            TEMODBMgr.setOperFail(neID, errRet, retCode);
        }
        logger.info(logBuilder.buildLogStr("func end"));
        return errRet;
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEMODBMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEMODBMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEMODBMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private String getOperStr(int operType) {
        String operTypeStr = "";
        if (1 == operType) {
            operTypeStr = "create";
        } else if (2 == operType) {
            operTypeStr = "update";
        } else if (3 == operType) {
            operTypeStr = "del";
        }
        return operTypeStr;
    }

    public static <MOCLASS> TEErrInfoReturn setMOAttrValue(MOCLASS tempMO, String moAttrName, String moAttrType, String attrValue) {
        TEErrInfoReturn errRet;
        block7: {
            errRet = new TEErrInfoReturn();
            try {
                Method[] methods;
                if (null == tempMO || null == moAttrName || null == moAttrType || null == attrValue) {
                    return errRet;
                }
                Method method = null;
                if ("int".equalsIgnoreCase(moAttrType)) {
                    method = tempMO.getClass().getMethod("set" + moAttrName, Integer.TYPE);
                    method.invoke(tempMO, Integer.parseInt(attrValue));
                    break block7;
                }
                if ("long".equalsIgnoreCase(moAttrType)) {
                    method = tempMO.getClass().getMethod("set" + moAttrName, Long.TYPE);
                    method.invoke(tempMO, Long.parseLong(attrValue));
                    break block7;
                }
                if ("short".equalsIgnoreCase(moAttrType)) {
                    method = tempMO.getClass().getMethod("set" + moAttrName, Short.TYPE);
                    method.invoke(tempMO, Short.parseShort(attrValue));
                    break block7;
                }
                if (!"String".equalsIgnoreCase(moAttrType)) break block7;
                for (Method tempMethod : methods = tempMO.getClass().getMethods()) {
                    if (!tempMethod.getName().contains("set" + moAttrName)) continue;
                    tempMethod.invoke(tempMO, attrValue);
                    break;
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("", (Throwable)e);
            }
        }
        return errRet;
    }

    public static <MOCLASS> String getMOAttrValue(MOCLASS tempMO, String moAttrName) {
        try {
            if (null == tempMO || null == moAttrName) {
                return null;
            }
            Method method = tempMO.getClass().getMethod("get" + moAttrName, new Class[0]);
            if (null == method) {
                return null;
            }
            Object obj = method.invoke(tempMO, new Object[0]);
            if (null == obj) {
                return null;
            }
            return String.valueOf(obj);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return null;
        }
    }

    public static <MOCLASS> TEErrInfoReturn clearMOTODB(int neID, Class<MOCLASS> moClass) {
        TEErrInfoReturn errResult = new TEErrInfoReturn();
        TEMODBMgr<MOCLASS> dbmgr = new TEMODBMgr<MOCLASS>();
        TECommonResult<List<MOCLASS>> resultList = dbmgr.getMOFromDB(neID, moClass);
        if (resultList.getErrInfoRet().getResult() != 0) {
            errResult = resultList.getErrInfoRet();
        } else if (resultList.getReturnObject() != null && !resultList.getReturnObject().isEmpty()) {
            boolean allFail = true;
            int len = resultList.getReturnObject().size();
            for (int i = 0; i < len; ++i) {
                TEErrInfoReturn tempResult = dbmgr.delMOFromDB(neID, resultList.getReturnObject().get(i));
                if (tempResult.getResult() != 0) {
                    errResult.setResult(1);
                    if (null == tempResult || null == tempResult.getErrList() || tempResult.getErrList().isEmpty()) continue;
                    errResult.getErrList().addAll(tempResult.getErrList());
                    continue;
                }
                allFail = false;
            }
            if (allFail) {
                errResult.setResult(2);
            }
        }
        return errResult;
    }
}

