/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TETL1BoardGraph
implements TENEMgrInterface {
    private static final String NE_NAME_PARAM = "neName";
    private static final String BOARD_UPDATE_FLAG = "boardupgateflag";
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final String BOARD_NAME_PARAM = "boardName";
    private static final String BOARD_LOOP_PARAM = "boardLoop";
    private static final String BOARD_PG_PARAM = "boardPG";
    private static final String BOARD_STATE_PARAM = "boardState";
    private static final String BOARD_OUT = "0";
    private static final String BOARD_OUT_LOGIC = "1";
    private static final String BOARD_IN_RUN = "3";
    private static final String BOARD_IN_PHY = "2";
    private ArrayList usedSlotList = new ArrayList();
    private static final String BOARD_SLOT_LIST_PARAM = "slotList";
    private Datainterface outputData = null;
    private Logger log = TELogFactory.getNormalLogger();
    private static final String SUB_CARD_SUPPORT = "issupportsubcard";
    private static final String SUPPORT_CARD_TYPES = "supportsubtypes";
    private static final String SUB_CARD_ID_PARAM = "subcardid";
    private static final String SUB_CARD_TYPE_PARAM = "subcardtype";
    private static final String SUB_CARD_NAME_PARAM = "subcardname";
    private static final String SUB_CARD_STATE_PARAM = "subcardstate";

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Vector temBoardList = null;
        Vector temPhyBoardList = null;
        ArrayList boardList = new ArrayList();
        ArrayList phyBoardList = new ArrayList();
        RowParams rowparams = null;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        boolean bCorrect = true;
        try {
            RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
            Param tmpParam = null;
            for (int i = inputRowParams.getParamCount() - 1; i >= 0; --i) {
                tmpParam = inputRowParams.getParam(i);
                if (!tmpParam.getName().equals("correct") || !BOARD_OUT.equals(tmpParam.getValue()) && !"false".equals(tmpParam.getValue())) continue;
                bCorrect = false;
            }
            TENE currentNE = TENEListMgr.getInstance().getNE(neid);
            boolean boardupdateflag = TENEListMgr.getInstance().getNE(neid).getBoardUpdateFlag();
            String neName = String.valueOf(neid);
            rowparams = new RowParams();
            rowparams.addParam(NE_NAME_PARAM, neName);
            rowparams.addParam(BOARD_UPDATE_FLAG, String.valueOf(boardupdateflag));
            this.outputData.getBussinessParams().addRowParams(rowparams);
            temBoardList = currentNE.getClonedBoardList();
            temPhyBoardList = currentNE.getClonedPhyBoardList();
            if (null != temBoardList || null != temPhyBoardList) {
                int i;
                TEBoard logicboard = null;
                TEBoard phyboard = null;
                int slotid = -1;
                int physlotid = -1;
                int physize = 0;
                int logsize = 0;
                int j = 0;
                boolean ifinputrow = false;
                String boardState = BOARD_OUT;
                if (null != temBoardList) {
                    for (i = 0; i < temBoardList.size(); ++i) {
                        boardList.add(temBoardList.get(i));
                    }
                    Collections.sort(boardList);
                    logsize = boardList.size();
                    for (i = 0; i < logsize; ++i) {
                        logicboard = (TEBoard)boardList.get(i);
                        this.addUsedSlotList(neid, logicboard, bCorrect);
                    }
                }
                if (null != temPhyBoardList) {
                    for (i = 0; i < temPhyBoardList.size(); ++i) {
                        phyBoardList.add(temPhyBoardList.get(i));
                    }
                    Collections.sort(phyBoardList);
                    physize = phyBoardList.size();
                }
                for (i = 0; i < logsize; ++i) {
                    logicboard = (TEBoard)boardList.get(i);
                    slotid = logicboard.getSlotID();
                    ifinputrow = false;
                    if (0 == slotid) continue;
                    while (j < physize) {
                        phyboard = (TEBoard)phyBoardList.get(j);
                        physlotid = phyboard.getSlotID();
                        if (slotid > physlotid) {
                            if (this.checkSlotIdle(neid, phyboard, bCorrect)) {
                                boardState = BOARD_IN_PHY;
                                this.createOutputData(neid, phyboard, boardState, bCorrect);
                            }
                            ++j;
                            continue;
                        }
                        if (slotid == physlotid) {
                            if (logicboard.compareTo(phyboard) == 0) {
                                boardState = BOARD_IN_RUN;
                                this.createOutputData(neid, logicboard, boardState, bCorrect);
                            } else {
                                boardState = BOARD_OUT_LOGIC;
                                this.createOutputData(neid, logicboard, boardState, bCorrect);
                            }
                            ifinputrow = true;
                            ++j;
                            break;
                        }
                        if (slotid >= physlotid) continue;
                        boardState = BOARD_OUT_LOGIC;
                        this.createOutputData(neid, logicboard, boardState, bCorrect);
                        ifinputrow = true;
                        break;
                    }
                    if (j < physize || ifinputrow) continue;
                    boardState = BOARD_OUT_LOGIC;
                    this.createOutputData(neid, logicboard, boardState, bCorrect);
                }
                while (j < physize) {
                    phyboard = (TEBoard)phyBoardList.get(j);
                    if (this.checkSlotIdle(neid, phyboard, bCorrect)) {
                        boardState = BOARD_IN_PHY;
                        this.createOutputData(neid, phyboard, boardState, bCorrect);
                    }
                    ++j;
                }
            }
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        }
        catch (Exception e) {
            this.log.error("Get boart error\u00a3\u00ba", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            return this.outputData;
        }
        return this.outputData;
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }

    private void createOutputData(int neid, TEBoard board, String boardState, boolean bCorrect) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return;
        }
        Param slotidparam = null;
        Param boardtypeparam = null;
        Param boardnameparam = null;
        Param boardloopparam = null;
        Param boardpgparam = null;
        Param boardstateparam = null;
        Param boardslotlist = null;
        String slotList = "";
        int slotid = -1;
        int boardtype = -1;
        RowParams rowparams = null;
        rowparams = new RowParams();
        slotid = board.getSlotID();
        boardtype = board.getBoardType();
        slotidparam = new Param(SLOT_ID_PARAM, String.valueOf(slotid));
        rowparams.addParam(slotidparam);
        boardtypeparam = new Param(BOARD_TYPE_PARAM, String.valueOf(boardtype));
        rowparams.addParam(boardtypeparam);
        boardnameparam = new Param(BOARD_NAME_PARAM, board.getBoardTypeName());
        rowparams.addParam(boardnameparam);
        boardloopparam = new Param(BOARD_LOOP_PARAM, String.valueOf(board.getBoardLoop()));
        rowparams.addParam(boardloopparam);
        boardpgparam = new Param(BOARD_PG_PARAM, String.valueOf(board.getBoardPG()));
        rowparams.addParam(boardpgparam);
        boardstateparam = new Param(BOARD_STATE_PARAM, boardState);
        rowparams.addParam(boardstateparam);
        int subrackId = 0;
        int offset = 0;
        if (bCorrect) {
            subrackId = slotid / 100;
            offset = subrackId * 100;
            slotid -= offset;
        }
        slotList = null != (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid)) ? slotInfo.toString() : slotid + "";
        boolean isSupport = TEBoardUtil.isSupportSubCard(boardtype);
        Param isSupportSubcard = new Param(SUB_CARD_SUPPORT, String.valueOf(isSupport));
        rowparams.addParam(isSupportSubcard);
        Param supportCardTypes = new Param(SUPPORT_CARD_TYPES, TEBoardUtil.getSupportSubCardTypes(neid, boardtype));
        rowparams.addParam(supportCardTypes);
        if (!board.getSubBoardList().isEmpty()) {
            TESubBoard subboard = (TESubBoard)board.getSubBoardList().get(0);
            Param subcardid = new Param(SUB_CARD_ID_PARAM, String.valueOf(subboard.getSubSlotID()));
            rowparams.addParam(subcardid);
            Param subcardtype = new Param(SUB_CARD_TYPE_PARAM, String.valueOf(subboard.getSubBoardType()));
            rowparams.addParam(subcardtype);
            Param subcardname = new Param(SUB_CARD_NAME_PARAM, TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboard.getSubBoardType()));
            rowparams.addParam(subcardname);
            Param subcardstate = new Param(SUB_CARD_STATE_PARAM, String.valueOf(subboard.getState()));
            rowparams.addParam(subcardstate);
        }
        String[] slotArr = slotList.split(",");
        StringBuffer slotListStr = new StringBuffer();
        for (int i = 0; i < slotArr.length; ++i) {
            slotListStr.append(',').append(Integer.parseInt(slotArr[i]) + offset);
        }
        boardslotlist = new Param(BOARD_SLOT_LIST_PARAM, slotListStr.toString().substring(1));
        rowparams.addParam(boardslotlist);
        this.outputData.getBussinessParams().addRowParams(rowparams);
    }

    public void addUsedSlotList(int neid, TEBoard board1, boolean bCorrect) {
        TEBoardSlotInfo slotInfo;
        if (null == board1) {
            return;
        }
        int boardtype = -1;
        int slotid = -1;
        boardtype = board1.getBoardType();
        slotid = board1.getSlotID();
        int subrackId = 0;
        int offset = 0;
        if (bCorrect) {
            subrackId = slotid / 100;
            offset = subrackId * 100;
            slotid -= offset;
        }
        if (null != (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid))) {
            ArrayList tempusedList1 = null;
            tempusedList1 = slotInfo.getStandbySlotList();
            this.usedSlotList.add(slotInfo.getDirectSlotid() + offset);
            int size = tempusedList1.size();
            for (int i = 0; i < size; ++i) {
                this.usedSlotList.add((Integer)tempusedList1.get(i) + offset);
            }
        } else {
            this.usedSlotList.add(slotid + offset);
        }
    }

    public boolean checkSlotIdle(int neid, TEBoard board, boolean bCorrect) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return true;
        }
        int boardtype = -1;
        int slotid = -1;
        boardtype = board.getBoardType();
        slotid = board.getSlotID();
        int size = this.usedSlotList.size();
        for (int i = 0; i < size; ++i) {
            if (slotid != (Integer)this.usedSlotList.get(i)) continue;
            return false;
        }
        int subrackId = 0;
        int offset = 0;
        if (bCorrect) {
            subrackId = slotid / 100;
            offset = subrackId * 100;
            slotid -= offset;
        }
        if (null == (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid))) {
            return true;
        }
        ArrayList tempusedList = slotInfo.getStandbySlotList();
        int tempsize = tempusedList.size();
        for (int i = 0; i < tempsize; ++i) {
            int tempSlot = (Integer)tempusedList.get(i) + offset;
            int usedsize = this.usedSlotList.size();
            for (int j = 0; j < usedsize; ++j) {
                if (!this.usedSlotList.get(j).equals(tempSlot)) continue;
                return false;
            }
        }
        return true;
    }
}

