/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESnmpCreateObjectFactory;
import com.huawei.nglct.common.TESnmpNEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.snmpfunctions.SnmpFunction;
import com.huawei.nglct.common.snmpfunctions.SnmpFunctions;
import com.huawei.nglct.common.snmpfunctions.SubFun;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpNEInfo;
import com.huawei.nglct.nelist.TESnmpNEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TESnmpNEExplorerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static int GET_DATA_FROM_NE = 1;
    private static int GET_DATA_FROM_MEMORY = 0;
    private static final String NE_NOT_EXIST = "68560014";
    private static Logger log = TELogFactory.getNormalLogger();

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String neid = "";
        int sfid = -1;
        int funcid = -1;
        int flag = -1;
        Datainterface outputData = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter print = response.getWriter();
        StringWriter out = null;
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        TELogFactory.getNormalLogger().debug("The function(neExplorerServlet- doGet) start time is " + format.format(new Date()));
        TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid);
        try {
            flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
        }
        catch (Exception e) {
            flag = GET_DATA_FROM_NE;
        }
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        String ipAddress = request.getRemoteAddr();
        String nmUser = request.getParameter("nmUser");
        Datainterface inputData = null;
        SnmpFunctions functions = null;
        Datainterface allData = null;
        SubFun subFunc = null;
        try {
            TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            inputDataStr = new String(inputDataStr.getBytes("ISO-8859-1"), "UTF-8");
            inputData = TECreateObjectFactory.parseInputData(inputDataStr);
            neid = this.getNEIP(inputData);
            if (neid == "") {
                throw new Exception("Don't write neid!!");
            }
            TESnmpNEInfo ne = TESnmpNEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                out = new StringWriter();
                outputData = new Datainterface();
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(Integer.parseInt(NE_NOT_EXIST)));
                outputData.marshal(out);
                print.println(((Object)out).toString());
                TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + ((Object)out).toString());
                ((Writer)out).close();
                return;
            }
            functions = TESnmpCreateObjectFactory.parseFuncDesFile(neid);
            ArrayList list = this.getSubFunc(functions, sfid);
            funcid = (Integer)list.get(0);
            subFunc = (SubFun)list.get(1);
            list.clear();
            list = null;
            if (null == subFunc) {
                log.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                throw new Exception();
            }
            String classMapping = subFunc.getClassMapping();
            TESnmpNEMgrInterface neMgrBean = null;
            if (flag == GET_DATA_FROM_NE) {
                if (classMapping == null) {
                    log.debug("The Bussiness Process program is com.huawei.nglct.explorer.TENEExplorerBean");
                    neMgrBean = (TESnmpNEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance();
                } else {
                    log.debug("The BussinessProcess program is " + classMapping);
                    neMgrBean = (TESnmpNEMgrInterface)Class.forName(classMapping).newInstance();
                }
                allData = neMgrBean.performBussinessProcess(neid, subFunc, inputData, null, nmUser, ipAddress);
            } else if (flag == GET_DATA_FROM_MEMORY) {
                allData = (Datainterface)request.getSession().getAttribute(neid + "_" + funcid);
                if (null != classMapping) {
                    neMgrBean = (TESnmpNEMgrInterface)Class.forName(classMapping).newInstance();
                    allData = neMgrBean.performBussinessProcess(neid, subFunc, inputData, allData, nmUser, ipAddress);
                }
            }
            if (inputData.getPageParams() == null) {
                log.debug("Don't need split page\u00a3\u00a1");
                outputData = allData;
            }
            if (null == outputData) {
                throw new Exception("The Output Data is null !!!");
            }
            out = new StringWriter();
            outputData.marshal(out);
            print.println(((Object)out).toString());
            TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + ((Object)out).toString());
            ((Writer)out).close();
        }
        catch (Exception e) {
            log.error("program inner error\u00a3\u00ba\n", (Throwable)e);
            outputData = new Datainterface();
            out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            try {
                outputData.marshal(out);
                print.println(((Object)out).toString());
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + ((Object)out).toString());
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
        finally {
            TELogFactory.getNormalLogger().debug(" The function(neExplorerServlet- doGet) end time is " + format.format(new Date()));
            if (null != out) {
                ((Writer)out).close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    private String getNEIP(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        String neid = "";
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid = paramArr[i].getValue();
            }
            catch (NumberFormatException e) {
                log.error("Get neip fail:\n", (Throwable)e);
                return null;
            }
            return neid;
        }
        return null;
    }

    private ArrayList getSubFunc(SnmpFunctions functions, int sfid) {
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        SnmpFunction function = null;
        SubFun subFunc = null;
        int funcid = -1;
        for (int i = functions.getSnmpFunction().length - 1; i >= 0; --i) {
            function = functions.getSnmpFunction(i);
            for (int j = function.getSubFun().length - 1; j >= 0; --j) {
                if (function.getSubFun(j).getNmcode() != sfid) continue;
                subFunc = function.getSubFun(j);
                funcid = function.getId();
                break;
            }
            if (null != subFunc) break;
        }
        list.add(new Integer(funcid));
        list.add(subFunc);
        return list;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

