/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TESnmpCreateObjectFactory;
import com.huawei.nglct.common.TESnmpNEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.common.mibsdef.Index;
import com.huawei.nglct.common.mibsdef.Leaf;
import com.huawei.nglct.common.mibsdef.MibTable;
import com.huawei.nglct.common.snmpfunctions.Operation;
import com.huawei.nglct.common.snmpfunctions.Output;
import com.huawei.nglct.common.snmpfunctions.Sparam;
import com.huawei.nglct.common.snmpfunctions.SubFun;
import com.huawei.nglct.common.snmpfunctions.toperation.Terror;
import com.huawei.nglct.common.snmpfunctions.toperation.Tinput;
import com.huawei.nglct.common.snmpfunctions.toperation.Toperation;
import com.huawei.nglct.common.snmpfunctions.toperation.Toutput;
import com.huawei.nglct.common.snmpfunctions.toperation.Tparam;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpErrorCode;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpSrvMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TESnmpNEExplorerBean
implements TESnmpNEMgrInterface {
    private final int TIME_OUT = 60;
    protected Datainterface outputData = null;
    protected ArrayList operationList = null;
    protected String neIP;
    protected SubFun subfunc = null;
    protected Datainterface inputData = null;

    @Override
    public Datainterface performBussinessProcess(String neid, SubFun subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neIP = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getTOperationList(this.neIP, subFunc);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                return this.outputData;
            }
            TESnmpSrvMgr.getInstance().sendMessage(this.neIP, this.operationList, subFunc, 60);
            this.outputData = this.handleMessage(this.operationList, subFunc);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public Datainterface handleMessage(ArrayList operationList, SubFun subFunc) {
        Datainterface di = new Datainterface();
        BussinessParams bp = new BussinessParams();
        di.setBussinessParams(bp);
        Toperation concatOP = new Toperation();
        if (operationList.size() > 1) {
            Toperation firstOP = (Toperation)operationList.get(0);
            if (firstOP.getRef() == null || firstOP.getRef().equals("")) {
                TELogFactory.getNormalLogger().error("need 'ref' define in operation, function nmcode:" + subFunc.getNmcode());
                return di;
            }
            Terror error = firstOP.getToutput(0).getTerror();
            if (error != null && error.getCode() != 0) {
                this.handleSingleOP(firstOP, bp, subFunc);
                return di;
            }
            int firstOPIndex = this.getIndexPos(firstOP);
            HashMap<Tparam, Toutput> outputMap = new HashMap<Tparam, Toutput>();
            ArrayList<Toutput> outputs = new ArrayList<Toutput>();
            ArrayList<Toutput> errorOputputs = new ArrayList<Toutput>();
            Toutput _foutput = null;
            int oCount = firstOP.getToutputCount();
            for (int oi = 0; oi < oCount; ++oi) {
                _foutput = firstOP.getToutput(oi);
                Toutput foutput = new Toutput();
                if (_foutput.getTerror() == null || _foutput.getTerror().getCode() == 0) {
                    foutput.setTparam(_foutput.getTparam());
                    outputs.add(foutput);
                    Tparam aparam = foutput.getTparam(firstOPIndex);
                    outputMap.put(aparam, foutput);
                    continue;
                }
                foutput.setTerror(_foutput.getTerror());
                errorOputputs.add(_foutput);
            }
            Toperation innerOp = null;
            int iioCount = operationList.size();
            for (int oi = 1; oi < iioCount; ++oi) {
                innerOp = (Toperation)operationList.get(oi);
                int matchOPIndex = this.getIndexPos(innerOp);
                Toutput boutput = null;
                Toutput moutput = null;
                int bcount = 0;
                int mcount = 0;
                int iCount = innerOp.getToutputCount();
                for (int ii = 0; ii < iCount; ++ii) {
                    boutput = innerOp.getToutput(ii);
                    if (boutput.getTerror() != null && boutput.getTerror().getCode() != 0) {
                        errorOputputs.add(boutput);
                        continue;
                    }
                    Tparam bparam = boutput.getTparam(matchOPIndex);
                    bcount = boutput.getTparamCount();
                    moutput = (Toutput)outputMap.get(bparam);
                    mcount = moutput.getTparamCount();
                    Tparam[] temp = new Tparam[bcount + mcount];
                    System.arraycopy(moutput.getTparam(), 0, temp, 0, mcount);
                    System.arraycopy(boutput.getTparam(), 0, temp, mcount, bcount);
                    moutput.setTparam(temp);
                }
            }
            int count = outputs.size();
            for (int i = 0; i < count; ++i) {
                concatOP.addToutput((Toutput)outputs.get(i));
            }
            di.setErrorMessage(this.handleMutilOP(concatOP, bp, subFunc, errorOputputs));
        } else if (operationList.size() == 1) {
            concatOP = (Toperation)operationList.get(0);
            di.setErrorMessage(this.handleSingleOP(concatOP, bp, subFunc));
        }
        return di;
    }

    public ErrorMessage handleSingleOP(Toperation oper, BussinessParams bp, SubFun subFunc) {
        boolean hasSuccess = false;
        boolean hasFailed = false;
        Output outputDef = null;
        if (subFunc.getOutputCount() != 0) {
            outputDef = subFunc.getOutput(0);
        }
        Toutput toutput = null;
        Param param = null;
        RowParams rp = null;
        int tiCount = oper.getToutputCount();
        for (int ti = 0; ti < tiCount; ++ti) {
            rp = new RowParams();
            toutput = oper.getToutput(ti);
            Tparam tparam = null;
            if (toutput.getTerror() != null) {
                hasFailed = true;
                rp.addRowErrors(this.getErrorRow(toutput));
            } else {
                hasSuccess = true;
                int toCount = toutput.getTparamCount();
                block1: for (int toi = 0; toi < toCount; ++toi) {
                    tparam = toutput.getTparam(toi);
                    int siCount = outputDef.getSparamCount();
                    for (int si = 0; si < siCount; ++si) {
                        Sparam sparam = outputDef.getSparam(si);
                        if (!sparam.getName().equals(tparam.getName())) continue;
                        param = new Param();
                        param.setName(tparam.getName());
                        param.setValue(tparam.getValue());
                        rp.addParam(param);
                        continue block1;
                    }
                }
            }
            bp.addRowParams(rp);
        }
        if (hasFailed && hasSuccess) {
            return TESnmpErrorCode.EM_OPERATION_PART_SUCCESS;
        }
        if (hasFailed && !hasSuccess) {
            return TESnmpErrorCode.EM_OPERATION_FAIL;
        }
        return TESnmpErrorCode.EM_OPERATION_SUCCESS;
    }

    public ErrorMessage handleMutilOP(Toperation oper, BussinessParams bp, SubFun subFunc, ArrayList errorOutputs) {
        boolean hasSuccess = false;
        boolean hasFailed = false;
        Output outputDef = null;
        if (subFunc.getOutputCount() != 0) {
            outputDef = subFunc.getOutput(0);
        }
        Toutput toutput1 = null;
        Param param1 = null;
        RowParams rp = null;
        int tiCount = oper.getToutputCount();
        for (int ti = 0; ti < tiCount; ++ti) {
            rp = new RowParams();
            toutput1 = oper.getToutput(ti);
            Tparam tparam = null;
            if (toutput1.getTerror() != null) {
                hasFailed = true;
                rp.addRowErrors(this.getErrorRow(toutput1));
            } else {
                hasSuccess = true;
                int toCount = toutput1.getTparamCount();
                block1: for (int toi = 0; toi < toCount; ++toi) {
                    tparam = toutput1.getTparam(toi);
                    int siCount = outputDef.getSparamCount();
                    for (int si = 0; si < siCount; ++si) {
                        Sparam sparam = outputDef.getSparam(si);
                        if (!sparam.getName().equals(tparam.getName())) continue;
                        param1 = new Param();
                        param1.setName(tparam.getName());
                        param1.setValue(tparam.getValue());
                        rp.addParam(param1);
                        continue block1;
                    }
                }
            }
            bp.addRowParams(rp);
        }
        if (errorOutputs != null) {
            Toutput eOutput = null;
            rp = new RowParams();
            Iterator iter = errorOutputs.iterator();
            while (iter.hasNext()) {
                hasFailed = true;
                eOutput = (Toutput)iter.next();
                rp.addRowErrors(this.getErrorRow(eOutput));
            }
            bp.addRowParams(rp);
        }
        if (hasFailed && hasSuccess) {
            return TESnmpErrorCode.EM_OPERATION_PART_SUCCESS;
        }
        if (hasFailed && !hasSuccess) {
            return TESnmpErrorCode.EM_OPERATION_FAIL;
        }
        return TESnmpErrorCode.EM_OPERATION_SUCCESS;
    }

    public RowErrors getErrorRow(Toutput output) {
        RowErrors rw = new RowErrors();
        int errorCode = output.getTerror().getCode();
        String errorDesc = output.getTerror().getDesc();
        ErrorMessage em = new ErrorMessage();
        em.setErrorcode("" + errorCode);
        em.setErrorinfo(errorDesc);
        rw.setErrorMessage(em);
        Param neParam = new Param("nename", this.neIP);
        rw.addParam(neParam);
        return rw;
    }

    public ArrayList getTOperationList(String neIP, SubFun subFun) {
        Operation op = null;
        String mibName = null;
        String module = null;
        MibTable mt = null;
        Toperation tOp = null;
        ArrayList<Toperation> topertionList = new ArrayList<Toperation>();
        BussinessParams inputParams = this.inputData.getBussinessParams();
        int iiCount = inputParams.getRowParamsCount();
        for (int ii = 0; ii < iiCount; ++ii) {
            int opCount = subFun.getOperationCount();
            for (int opi = 0; opi < opCount; ++opi) {
                op = subFun.getOperation(opi);
                mibName = op.getMibtable();
                module = op.getModule();
                mt = TESnmpCreateObjectFactory.getMibTable(neIP, module + "_" + mibName);
                tOp = this.convert2Toperation(op, mt, inputParams.getRowParams(ii), subFun);
                topertionList.add(tOp);
            }
        }
        return topertionList;
    }

    public Toperation convert2Toperation(Operation op, MibTable mt, RowParams params, SubFun subFun) {
        int ri;
        Toperation toper = new Toperation();
        toper.setMiboper(op.getMiboper());
        toper.setSerialno(op.getSerialno());
        toper.setRef(op.getRef());
        toper.setMibtable(mt.getName());
        Tinput input = new Tinput();
        Tparam tparam = null;
        String NMIndexName = TESnmpNEExplorerBean.getNMIndexName(mt);
        Param param = null;
        StringBuilder indexValue = new StringBuilder(".");
        int rc = params.getParamCount();
        for (ri = 0; ri < rc; ++ri) {
            param = params.getParam(ri);
            if (param.getName().equals("neid") || !param.getName().equals(NMIndexName)) continue;
            indexValue.append(param.getValue());
            break;
        }
        if (indexValue.equals(".")) {
            indexValue = new StringBuilder("");
        }
        rc = params.getParamCount();
        block1: for (ri = 0; ri < rc; ++ri) {
            param = params.getParam(ri);
            if (param.getName().equals("neid")) continue;
            Leaf l = null;
            int mcount = mt.getLeafCount();
            for (int mi = 0; mi < mcount; ++mi) {
                l = mt.getLeaf(mi);
                if (!l.getName().equals(param.getName())) continue;
                tparam = new Tparam();
                tparam.setOid(l.getOid() + indexValue.toString());
                tparam.setValue(param.getValue());
                tparam.setType(l.getSyntax().toString());
                tparam.setName(l.getName());
                input.addTparam(tparam);
                continue block1;
            }
        }
        tparam = new Tparam();
        tparam.setIsIndex(true);
        tparam.setName(NMIndexName);
        input.addTparam(tparam);
        toper.addTinput(input);
        return toper;
    }

    public static String getNMIndexName(MibTable mt) {
        Index[] indexs = mt.getIndex();
        StringBuffer iStr = new StringBuffer("");
        boolean isFirst = true;
        int count = indexs.length;
        for (int i = 0; i < count; ++i) {
            if (!isFirst) {
                iStr.append(".");
            }
            iStr.append(indexs[i].getName());
            isFirst = false;
        }
        String reStr = iStr.toString();
        if (reStr.equals("")) {
            reStr = mt.getName() + ".index";
        }
        return reStr;
    }

    public int sendMessage(int neid) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)this.operationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public int sendMessage(int neid, SubFunc subFunc, ArrayList operationList) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, this.getTimeOut(), subFunc);
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public ArrayList getFilterErrorCodeList() {
        return null;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    @Override
    public boolean isNeedOperationlog() {
        return true;
    }

    public int getTimeOut() {
        return this.TIME_OUT;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            List<TELogInfo> loginfoList = this.convertLogInfoList(false);
            TELogInfo loginfoTemp = null;
            String operObj = this.parseOperObj(neid);
            int userID = this.parseUserID(user);
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfoTemp = loginfoList.get(i);
                loginfoTemp.setCmdID(subfunc.getCode());
                loginfoTemp.setLocation(ipAddress);
                loginfoTemp.setUserID(userID);
                loginfoTemp.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfoTemp.setOperateName(subfunc.getSubFuncDes(neid));
                loginfoTemp.setOperateObject(operObj);
                TELogMgr.writeLog(loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private int parseUserID(String user) {
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (Exception e) {
                userID = 0;
            }
        }
        return userID;
    }

    private String parseOperObj(int neid) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String operObj = "";
        operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
        return operObj;
    }

    private List<TELogInfo> convertLogInfoList(boolean isNoIter) {
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
        TELogInfo loginfoSnmp = null;
        RowParams rowparams = null;
        RowParams errorRowParams = null;
        int tmpErrorCode = 0;
        int len = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String value;
            loginfoSnmp = new TELogInfo();
            rowparams = this.inputData.getBussinessParams().getRowParams(i);
            Param logFlag = rowparams.getParam("isNoLog");
            if (logFlag != null && (value = logFlag.getValue()) != null && value.equals("1")) continue;
            loginfoSnmp.setOperateDesc(this.getDetailStr(rowparams));
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfoSnmp.setResult(2);
                loginfoSnmp.setErrCode(errorCode);
                loginfoSnmp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            } else if (errorCode == 0) {
                loginfoSnmp.setResult(0);
                loginfoSnmp.setErrCode(errorCode);
                loginfoSnmp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            } else {
                int outputRowCount = this.outputData.getBussinessParams().getRowParamsCount();
                errorRowParams = this.outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                if (tmpErrorCode != 0) {
                    loginfoSnmp.setResult(2);
                } else {
                    loginfoSnmp.setResult(0);
                }
                loginfoSnmp.setErrCode(tmpErrorCode);
                loginfoSnmp.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(tmpErrorCode));
            }
            loginfoList.add(loginfoSnmp);
            if (isNoIter) break;
        }
        return loginfoList;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData, boolean isNoIter) {
        try {
            List<TELogInfo> loginfoList = this.convertLogInfoList(isNoIter);
            TELogInfo loginfoInter = null;
            String operObj = this.parseOperObj(neid);
            int userID = this.parseUserID(user);
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfoInter = loginfoList.get(i);
                loginfoInter.setCmdID(subfunc.getCode());
                loginfoInter.setLocation(ipAddress);
                loginfoInter.setUserID(userID);
                loginfoInter.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfoInter.setOperateName(subfunc.getSubFuncDes(neid));
                loginfoInter.setOperateObject(operObj);
                TELogMgr.writeLog(loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public int getIndexPos(Toperation op) {
        int defaultIndex = -1;
        String ref = op.getRef();
        if (ref != null && !ref.equals("") && op.getToutputCount() > 0) {
            Toutput output = op.getToutput(0);
            Tparam param = null;
            int count = output.getTparamCount();
            for (int i = 0; i < count; ++i) {
                param = output.getTparam(i);
                if (!param.getName().equals(op.getRef())) continue;
                return i;
            }
        }
        return defaultIndex;
    }

    public String getDetailStr(RowParams rowparams) {
        return "";
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        return 0;
    }
}

