/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TECharsetConverter;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.InvalidSyntaxException;

public class TEOpenExplorerServlet
extends HttpServlet {
    private static final long serialVersionUID = -926481496914219848L;
    private static final String NEID_PARAM = "neid";
    private static final String FILE_NAME = TEPathManager.PAGE_PROFILE_PATH + "main.html";
    private int neid;
    private int realNEID = -1;
    private String neName;
    private String neState;
    private int neType;
    private String hostVersion;
    transient TESysManagerBean teSysManagerBean;

    public void init() throws ServletException {
        super.init();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.teSysManagerBean = TESysManagerBean.getInstance();
        response.setContentType("text/xml;charset=GB2312");
        try {
            this.neid = Integer.parseInt(request.getParameter(NEID_PARAM));
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Get neid error!", (Throwable)e);
            return;
        }
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        if (null == neObj) {
            TELogFactory.getNormalLogger().info("The NE Not Fount in NEList:" + this.neid);
            return;
        }
        this.realNEID = neObj.getRealNEID();
        this.neName = neObj.getNEName();
        this.neState = neObj.getNEState();
        this.neType = neObj.getNEType();
        this.hostVersion = neObj.getHostVersion();
        String showNEVersion = neObj.getShowNEVersion();
        String neUser = neObj.getCurUser();
        String domain = TEGetNEDomainVersion.getInstance().getDomain(this.neType);
        String globalSign = TECharsetConverter.getChineseLength(neObj.getNeGlobalSign());
        String neBundleName = TEGetFilePath.getNEBundleName(this.neType);
        StringBuffer url = new StringBuffer("/weblct");
        URL relativeURL = null;
        try {
            relativeURL = TEResourceManager.getURL(neBundleName, TEGetFilePath.getFilePath(this.neType, this.hostVersion, FILE_NAME));
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("TEResourceManager.getURL failed!", (Throwable)e);
        }
        if (relativeURL == null) {
            TELogFactory.getNormalLogger().error("relativeURL is null!");
            return;
        }
        url.append(relativeURL.getPath()).append("?neid=").append(this.neid).append("&realNEID=").append(this.realNEID).append("&neName=").append(this.encodeMsg(this.neName)).append("&neType=").append(this.neType).append("&neuser=").append(neUser).append("&neversion=").append(showNEVersion).append("&nestate=").append(this.neState).append("&shelfType=").append(neObj.getShelfType()).append("&domain=").append(domain).append("&codelength=").append(globalSign);
        if (0 != TESysManagerBean.getInstance().getM2000()) {
            url.append("&nmUser=").append(request.getParameter("nmUser"));
        }
        String urlstr = url.toString().replace('\\', '/');
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.sendRedirect(urlstr);
    }

    public String encodeMsg(String msg) {
        String str = null;
        try {
            str = URLEncoder.encode(msg, "UTF-8");
            str = str.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TEOpenExplorerServlet.encodeMsg() fail!", (Throwable)e);
        }
        return str;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }
}

