/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.NEConnectRunnable;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;

public class TENEGatewayMgr
extends TENEExplorerBean {
    private static final String GNG_ADDRESS_PARAM = "gneAddress";
    private static final String GNG_PORT_PARAM = "gnePort";
    private TELogInfo loginfo = null;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rowparams = new RowParams();
        RowErrors rowErrors = new RowErrors();
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.outputData = new Datainterface();
            BussinessParams bussParams = new BussinessParams();
            this.outputData.setBussinessParams(bussParams);
            Param[] param = inputData.getBussinessParams().getRowParams(0).getParam();
            String gwAddress = Datainterface.getParam(param, GNG_ADDRESS_PARAM).getValue();
            String gwPort = Datainterface.getParam(param, GNG_PORT_PARAM).getValue();
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (gwAddress.equals(neObj.getNEGWAddress()) && gwPort.equals(neObj.getPort())) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                return this.outputData;
            }
            this.loginfo = new TELogInfo();
            this.loginfo.setOperateDesc("gateway type:" + neObj.getNEGWType() + " gateway:" + gwAddress + " port:" + gwPort);
            String oldGwAddress = neObj.getNEGWAddress();
            int oldPort = Integer.parseInt(neObj.getPort());
            int oldNEGWType = neObj.getNEGWType();
            String nename = neObj.getNEName();
            rowErrors.addParam(new Param("nename", nename));
            StringBuffer attrIdSbf = new StringBuffer(gwAddress);
            attrIdSbf.append("-").append(gwPort);
            rowErrors.addParam(new Param("attrId", attrIdSbf.toString()));
            rowErrors.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            rowparams.addRowErrors(rowErrors);
            if (neObj.modifyNEGWAddr(oldNEGWType, gwAddress, gwPort)) {
                this.loginfo.setResult(0);
                this.loginfo.setErrCode(0);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(0));
                TELogFactory.getNormalLogger().info("Modify GateWay param success!");
                neObj.setCurTopLevelAlm(-1);
                Thread t = new Thread(new NEConnectRunnable(neObj, oldPort, oldGwAddress, oldNEGWType));
                t.start();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else {
                this.loginfo.setResult(2);
                this.loginfo.setErrCode(2);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(2));
                TELogFactory.getNormalLogger().info("Modify GateWay param success!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Connect Fault!", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            this.outputData.getBussinessParams().addRowParams(rowparams);
            return this.outputData;
        }
        return this.outputData;
    }

    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            if (null != this.loginfo) {
                this.loginfo.setCmdID(subfunc.getCode());
                this.loginfo.setLocation(ipAddress);
                this.loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                this.loginfo.setOperateObject(String.valueOf(neid));
                this.loginfo.setUserID(0);
                this.loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                TELogMgr.writeLog(this.loginfo);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Write Log Fault!", (Throwable)e);
        }
    }
}

