/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginIF;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TENEExplorerBean
implements TENEMgrInterface {
    protected int TIME_OUT = TESysManagerBean.getInstance().getExplorerBeanTimeout();
    protected Datainterface outputData = new Datainterface();
    protected ArrayList operationList = null;
    protected int neid;
    protected SubFunc subfunc = null;
    protected Datainterface inputData = null;
    private TEBeanPluginIF beanPluginIF = null;
    protected Datainterface memeryData;
    protected String user;
    protected String ipAddress;
    protected boolean isNeedAddNeIdParam = false;
    protected boolean isLogFlag = true;

    public TEBeanPluginIF getBeanPluginIF() {
        return this.beanPluginIF;
    }

    public void setBeanPluginIF(TEBeanPluginIF beanPluginIF) {
        this.beanPluginIF = beanPluginIF;
    }

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.decryptParamForInputData(inputData);
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
            }
            this.encryptParamForOutputData();
            this.modifyOutputParams();
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    protected void decryptParamForInputData(Datainterface inputData) {
        RowParams[] rowParamsArr;
        if (null == inputData || null == inputData.getBussinessParams()) {
            return;
        }
        Set<String> paramNameSet = this.inputDataDecryptParamNameSet();
        if (paramNameSet.isEmpty()) {
            return;
        }
        Param param = null;
        for (RowParams rowParams : rowParamsArr = inputData.getBussinessParams().getRowParams()) {
            for (String paramName : paramNameSet) {
                param = rowParams.getParam(paramName);
                if (null == param) continue;
                byte[] value = EncryptUtils.decrypt(param.getValue());
                param.setValue(EncryptUtils.encryptAESByte2Str(value));
                EncryptUtils.clearByte(value);
            }
        }
    }

    protected Set<String> inputDataDecryptParamNameSet() {
        RowParams[] rowParamsArr;
        HashSet<String> paramNameList = new HashSet<String>();
        if (null == this.inputData || null == this.inputData.getBussinessParams()) {
            return paramNameList;
        }
        for (RowParams rowParams : rowParamsArr = this.inputData.getBussinessParams().getRowParams()) {
            Param[] params;
            for (Param param : params = rowParams.getParam()) {
                if (!param.getIsPassword()) continue;
                paramNameList.add(param.getName());
            }
        }
        return paramNameList;
    }

    protected void encryptParamForOutputData() {
        RowParams[] rowParamsArr;
        Set<String> paramNameSet = this.inputDataDecryptParamNameSet();
        if (paramNameSet.isEmpty()) {
            return;
        }
        Param param = null;
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        for (RowParams rowParams : rowParamsArr = this.outputData.getBussinessParams().getRowParams()) {
            for (String paramName : paramNameSet) {
                RowErrors[] rowErrorsArr;
                param = rowParams.getParam(paramName);
                if (null != param) {
                    byte[] valueTmp = EncryptUtils.decryptAESStr2Byte(param.getValue());
                    param.setValue(EncryptUtils.encrypt(valueTmp));
                    EncryptUtils.clearByte(valueTmp);
                }
                for (RowErrors rowErrors : rowErrorsArr = rowParams.getRowErrors()) {
                    param = rowErrors.getParam(paramName);
                    rowErrors.removeParam(param);
                }
            }
        }
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            return TEDataConverter.convertToOperation(subFunc, inputData, neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public int sendMessage(int neid) {
        return this.sendMessage(neid, this.operationList);
    }

    public int sendMessage(int neid, SubFunc subFunc) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, this.operationList, this.getTimeOut(), subFunc);
        if (null != result) {
            retCode = result.retCode;
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("end to call TECommuNEMgr.getInstance().sendCommand! timeOut->" + this.getTimeOut() + " OperationResult: retCode->" + result.retCode);
            }
        }
        this.doAfterSendMessage(retCode, neid, this.subfunc, this.operationList);
        return retCode;
    }

    public int sendMessage(int neid, ArrayList operationList) {
        return this.sendMessage(neid, operationList, this.getTimeOut());
    }

    public int sendMessage(int neid, ArrayList operationList, int timeout) {
        int retCode = 0;
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, timeout, this.subfunc);
        if (null != result) {
            retCode = result.retCode;
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("end to call TECommuNEMgr.getInstance().sendCommand! timeOut->" + this.getTimeOut() + " OperationResult: retCode->" + result.retCode);
            }
        }
        this.doAfterSendMessage(retCode, neid, this.subfunc, operationList);
        return retCode;
    }

    public void doAfterSendMessage(int retCode, int neid, SubFunc subFunc, ArrayList operationList) {
        try {
            if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                return;
            }
            if (0 != retCode) {
                return;
            }
            if (null == operationList || operationList.isEmpty()) {
                TELogFactory.getNormalLogger().error("operationList is null!");
                return;
            }
            TEBeanPluginIF beanPlugin = this.getBeanPluginIF();
            if (null == beanPlugin) {
                return;
            }
            beanPlugin.doAfterSendMessage(neid, subFunc, operationList);
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("doAfterSendMessage fail!", e);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        if (null == this.subfunc) {
            return new ArrayList();
        }
        return this.subfunc.getFilterErrCodeList();
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    @Override
    public boolean isNeedOperationlog() {
        return true;
    }

    public int getTimeOut() {
        return this.TIME_OUT;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int i;
            TENE neObj;
            int errorCode = null != outputData.getErrorMessage() && null != outputData.getErrorMessage().getErrorcode() ? Integer.parseInt(outputData.getErrorMessage().getErrorcode()) : 0;
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    if (null == user || user.isEmpty()) {
                        TELogFactory.getNormalLogger().error("nmsUser ID is Wrong:\n");
                        userID = TESecurityVerify.getSuperUserID();
                    } else {
                        userID = Integer.parseInt(user);
                    }
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("user is:" + user + ",nmsUser ID is Wrong:\n");
                    userID = TESecurityVerify.getSuperUserID();
                }
            }
            String operObj = null == (neObj = TENEListMgr.getInstance().getNE(neid)) ? String.valueOf(neid) : neObj.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (i = 0; i < len; ++i) {
                String value;
                loginfo = new TELogInfo();
                rowparams = inputData.getBussinessParams().getRowParams(i);
                Param logFlag = rowparams.getParam("isNoLog");
                if (logFlag != null && (value = logFlag.getValue()) != null && value.equals("1")) continue;
                loginfo.setOperateDesc(this.getDetailStr(rowparams));
                if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                    loginfo.setResult(2);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else if (errorCode == 0) {
                    loginfo.setResult(0);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else if (errorCode == 1) {
                    int jLen = outputData.getBussinessParams().getRowParamsCount();
                    for (int j = 0; j < jLen; ++j) {
                        int i$ = 0;
                        RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(j).getRowErrors();
                        RowErrors[] arr$ = rowErrors;
                        int len$ = arr$.length;
                        if (i$ >= len$) continue;
                        RowErrors rowError = arr$[i$];
                        loginfo = new TELogInfo();
                        loginfo.setOperateDesc(this.getDetailStr(rowparams));
                        loginfo.setResult(errorCode);
                        loginfo.setErrCode(Integer.parseInt(rowError.getErrorMessage().getErrorcode()));
                        loginfo.setErrInfo(rowError.getErrorMessage().getErrorinfo());
                    }
                } else {
                    int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                    errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                    tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                    if (tmpErrorCode != 0) {
                        loginfo.setResult(2);
                    } else {
                        loginfo.setResult(0);
                    }
                    loginfo.setErrCode(tmpErrorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(tmpErrorCode));
                }
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData, boolean isNoIter) {
        try {
            int i;
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo1 = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("user is:" + user + ",nmsUser ID is Wrong:\n", (Throwable)e);
                    userID = 0;
                }
            }
            TENE neObj1 = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj1 ? String.valueOf(neid) : neObj1.getNEName();
            RowParams rowparams = null;
            RowParams errorRowParams = null;
            int tmpErrorCode = 0;
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (i = 0; i < len; ++i) {
                String value;
                loginfo1 = new TELogInfo();
                rowparams = inputData.getBussinessParams().getRowParams(i);
                Param logFlag = rowparams.getParam("isNoLog");
                if (logFlag != null && (value = logFlag.getValue()) != null && value.equals("1")) continue;
                loginfo1.setOperateDesc(this.getDetailStr(rowparams));
                if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                    loginfo1.setResult(2);
                    loginfo1.setErrCode(errorCode);
                    loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else if (errorCode == 0) {
                    loginfo1.setResult(0);
                    loginfo1.setErrCode(errorCode);
                    loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                } else {
                    int outputRowCount = outputData.getBussinessParams().getRowParamsCount();
                    errorRowParams = outputData.getBussinessParams().getRowParams(outputRowCount - 1);
                    tmpErrorCode = this.getOperResult(rowparams, errorRowParams);
                    if (tmpErrorCode != 0) {
                        loginfo1.setResult(2);
                    } else {
                        loginfo1.setResult(0);
                    }
                    loginfo1.setErrCode(tmpErrorCode);
                    loginfo1.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(tmpErrorCode));
                }
                loginfoList.add(loginfo1);
                if (isNoIter) break;
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo1 = (TELogInfo)loginfoList.get(i);
                loginfo1.setCmdID(subfunc.getCode());
                loginfo1.setLocation(ipAddress);
                loginfo1.setUserID(userID);
                loginfo1.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo1.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo1.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public String getDetailStr(RowParams rowparams) {
        Param opDescParam;
        if (null != rowparams && (opDescParam = rowparams.getParam("opDesc")) != null && !opDescParam.equals("")) {
            return opDescParam.getValue();
        }
        return this.subfunc.getSubFuncDes(this.neid);
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        OperObject operObj = this.subfunc.getOperObject();
        if (null == operObj) {
            operObj = new OperObject();
        }
        RowErrors rowErrors = null;
        Param tmpParam1 = null;
        Param tmpParam2 = null;
        boolean succFlag = false;
        int errorCount = errorRowParams.getRowErrorsCount();
        for (int index = 0; index < errorCount; ++index) {
            rowErrors = errorRowParams.getRowErrors(index);
            succFlag = false;
            int size = operObj.getParamCount();
            for (int i = 0; i < size; ++i) {
                tmpParam1 = rowparams.getParam(operObj.getParam(i).getName());
                tmpParam2 = rowErrors.getParam(operObj.getParam(i).getName());
                if (tmpParam1 == null || tmpParam2 == null || tmpParam1.getValue().equals(tmpParam2.getValue())) continue;
                succFlag = true;
                break;
            }
            if (succFlag) continue;
            return Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
        }
        return 0;
    }

    public static void filterDuplicateError(Datainterface di) {
        BussinessParams bp = di.getBussinessParams();
        RowParams[] rps = bp.getRowParams();
        RowParams rp2 = null;
        ArrayList<String> errorCodeList = new ArrayList<String>();
        for (RowParams rp2 : rps) {
            RowErrors[] res = rp2.getRowErrors();
            RowErrors re2 = null;
            String errorCode = null;
            for (RowErrors re2 : res) {
                errorCode = re2.getErrorMessage().getErrorcode();
                if (!errorCodeList.contains(errorCode)) {
                    errorCodeList.add(errorCode);
                    continue;
                }
                rp2.removeRowErrors(re2);
            }
        }
    }

    public void registerBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.memeryData = memeryData;
        this.user = user;
        this.ipAddress = ipAddress;
        this.isNeedAddNeIdParam = true;
    }

    public Datainterface call() throws Exception {
        return this.performBussinessProcess(this.neid, this.subfunc, this.inputData, this.memeryData, this.user, this.ipAddress);
    }

    protected void setNeIdParams() {
        if (this.isNeedAddNeIdParam && null != this.outputData) {
            RowParams rowparams = new RowParams();
            Param param = new Param("neid", String.valueOf(this.neid));
            rowparams.addParam(param);
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (null == bussinessParams) {
                bussinessParams = new BussinessParams();
                this.outputData.setBussinessParams(bussinessParams);
            }
            this.outputData.getBussinessParams().addRowParams(0, rowparams);
            this.isNeedAddNeIdParam = false;
        }
    }

    protected void modifyInputParams() {
    }

    protected void modifyOutputParams() {
    }

    protected void catchExceptionProcess(String errorInfo, Exception ex) {
        TELogFactory.getNormalLogger().error(errorInfo, (Throwable)ex);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
    }

    protected boolean isOutputSuccess(Output output) {
        return output.getFault(0).getCode().equals(String.valueOf(0));
    }

    public static Part getOutputPart(Operation operation, String partName) throws IndexOutOfBoundsException {
        Output[] outputs = operation.getOutput();
        for (int i = 0; i < outputs.length; ++i) {
            Part part = outputs[i].getPart(partName);
            if (part == null) continue;
            return part;
        }
        return null;
    }
}

